/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.agentNetworkApi.settings.dto.EnvironmentDto;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.common.formatting.HumanMemorySizeKt;
import com.jetbrains.toolbox.common.platform.SystemRequirements;
import com.jetbrains.toolbox.gateway.ui.LowResourceWarning;
import com.jetbrains.toolbox.i18n.LocalizableStringEx;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import java.util.Collection;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nextensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 extensions.kt\ncom/jetbrains/toolbox/ExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1#2:103\n1788#3,4:104\n*S KotlinDebug\n*F\n+ 1 extensions.kt\ncom/jetbrains/toolbox/ExtensionsKt\n*L\n51#1:104,4\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    public static final String accessibleVersion(@NotNull String $this$accessibleVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$accessibleVersion, (String)"<this>");
        return StringsKt.replace$default((String)$this$accessibleVersion, (String)".", (String)" .", (boolean)false, (int)4, null);
    }

    @Nullable
    public static final LocalizableString checkCoreInfo(@NotNull EnvironmentDto.SystemInfo $this$checkCoreInfo, @NotNull SystemRequirements requirements) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$checkCoreInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
        boolean enoughCpu = (long)$this$checkCoreInfo.getCpuCores() >= requirements.getCpuCores();
        Long l = $this$checkCoreInfo.getTotalMemoryBytes();
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl2 = false;
            bl = it >= requirements.getTotalMemoryBytes();
        } else {
            bl = true;
        }
        boolean enoughRam = bl;
        return !enoughCpu && !enoughRam ? (LocalizableString)LocalizableStringExKt.trl("Not enough CPUs and RAM") : (!enoughCpu ? (LocalizableString)LocalizableStringExKt.trl("Not enough CPUs") : (!enoughRam ? (LocalizableString)LocalizableStringExKt.trl("Not enough RAM") : null));
    }

    @Nullable
    public static final LocalizableString checkStorageInfo(@NotNull EnvironmentDto.SystemInfo $this$checkStorageInfo, boolean hasInstalledTools, @NotNull SystemRequirements requirements) {
        Intrinsics.checkNotNullParameter((Object)$this$checkStorageInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
        boolean enoughFreeDiskSpace = $this$checkStorageInfo.getFreeDiskSpaceBytes() >= requirements.getFreeDiskSpaceBytes();
        return hasInstalledTools || enoughFreeDiskSpace ? null : (LocalizableString)LocalizableStringExKt.trl("Not enough disk space");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final LowResourceWarning checkAgainst(@NotNull EnvironmentDto.SystemInfo $this$checkAgainst, boolean hasInstalledTools, @NotNull SystemRequirements requirements) {
        LowResourceWarning lowResourceWarning;
        int n;
        void $this$count$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$checkAgainst, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
        boolean enoughCpu = (long)$this$checkAgainst.getCpuCores() >= requirements.getCpuCores();
        Long l = $this$checkAgainst.getTotalMemoryBytes();
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl2 = false;
            bl = it >= requirements.getTotalMemoryBytes();
        } else {
            bl = true;
        }
        boolean enoughRam = bl;
        boolean enoughFreeDiskSpace = hasInstalledTools || $this$checkAgainst.getFreeDiskSpaceBytes() >= requirements.getFreeDiskSpaceBytes();
        Object[] objectArray = new Boolean[]{!enoughCpu, !enoughRam, !enoughFreeDiskSpace};
        objectArray = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                boolean it = (Boolean)element$iv;
                boolean bl3 = false;
                if (!it || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int missingReqs = n;
        if (missingReqs > 1) {
            objectArray = new LocalizableStringEx[4];
            objectArray[0] = LocalizableStringExKt.trl("Minimum requirements:");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"req", (Object)String.valueOf(requirements.getCpuCores()))};
            objectArray[1] = LocalizableStringExKt.trl("\u2022 {{req}} vCPUs", pairArray);
            pairArray = new Pair[]{TuplesKt.to((Object)"req", (Object)HumanMemorySizeKt.humanFileSize$default(requirements.getTotalMemoryBytes(), 0, 2, null))};
            objectArray[2] = LocalizableStringExKt.trl("\u2022 {{req}} RAM", pairArray);
            pairArray = new Pair[]{TuplesKt.to((Object)"req", (Object)HumanMemorySizeKt.humanFileSize$default(requirements.getFreeDiskSpaceBytes(), 0, 2, null))};
            objectArray[3] = LocalizableStringExKt.trl("\u2022 around {{req}} free disk space", pairArray);
            LowResourceWarning lowResourceWarning2 = new LowResourceWarning(LocalizableStringExKt.trl("Low resources on host"), CollectionsKt.listOf((Object[])objectArray), null, 4, null);
            lowResourceWarning = lowResourceWarning2;
        } else if (!enoughCpu) {
            objectArray = new Pair[]{TuplesKt.to((Object)"count", (Object)String.valueOf(requirements.getCpuCores()))};
            LocalizableStringEx localizableStringEx = LocalizableStringExKt.trn("At least {{count}} vCPU is required. ", "At least {{count}} vCPUs are required. ", (int)requirements.getCpuCores(), objectArray);
            objectArray = new Pair[]{TuplesKt.to((Object)"count", (Object)String.valueOf($this$checkAgainst.getCpuCores()))};
            LowResourceWarning lowResourceWarning3 = new LowResourceWarning(LocalizableStringExKt.trl("Not enough CPUs"), CollectionsKt.listOf((Object)LocalizableStringExKt.plus(localizableStringEx, LocalizableStringExKt.trn("Only {{count}} is available on the host.", "Only {{count}} are available on the host.", $this$checkAgainst.getCpuCores(), objectArray))), null, 4, null);
            lowResourceWarning = lowResourceWarning3;
        } else if (!enoughRam) {
            objectArray = new Pair[2];
            objectArray[0] = TuplesKt.to((Object)"req", (Object)HumanMemorySizeKt.humanFileSize$default(requirements.getTotalMemoryBytes(), 0, 2, null));
            Long l2 = $this$checkAgainst.getTotalMemoryBytes();
            objectArray[1] = TuplesKt.to((Object)"provided", (Object)HumanMemorySizeKt.humanFileSize(l2 != null ? l2 : 0L, 2));
            LowResourceWarning lowResourceWarning4 = new LowResourceWarning(LocalizableStringExKt.trl("Not enough RAM"), CollectionsKt.listOf((Object)LocalizableStringExKt.trl("At least {{req}} RAM is required, but only {{provided}} is available on the host.", objectArray)), null, 4, null);
            lowResourceWarning = lowResourceWarning4;
        } else if (!enoughFreeDiskSpace) {
            objectArray = new Pair[]{TuplesKt.to((Object)"req", (Object)HumanMemorySizeKt.humanFileSize$default(requirements.getFreeDiskSpaceBytes(), 0, 2, null)), TuplesKt.to((Object)"provided", (Object)HumanMemorySizeKt.humanFileSize($this$checkAgainst.getFreeDiskSpaceBytes(), 2))};
            LowResourceWarning lowResourceWarning5 = new LowResourceWarning(LocalizableStringExKt.trl("Not enough disk space"), CollectionsKt.listOf((Object)LocalizableStringExKt.trl("At least {{req}} free disk space is required, but only {{provided}} is available on the host.", objectArray)), null, 4, null);
            lowResourceWarning = lowResourceWarning5;
        } else {
            lowResourceWarning = null;
        }
        return lowResourceWarning;
    }
}

