/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.ApplicationStartInfo;
import com.jetbrains.toolbox.ApplicationStartType;
import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.CommandLine;
import com.jetbrains.toolbox.common.extensions.StringExtensionsKt;
import com.jetbrains.toolbox.enterprise.EnterpriseIntelliJAuthRequest;
import com.jetbrains.toolbox.settings.GraphicsApi;
import java.util.Arrays;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nCommandLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandLine.kt\ncom/jetbrains/toolbox/CommandLine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1#2:147\n295#3,2:148\n1869#3,2:150\n*S KotlinDebug\n*F\n+ 1 CommandLine.kt\ncom/jetbrains/toolbox/CommandLine\n*L\n68#1:148,2\n73#1:150,2\n*E\n"})
public final class CommandLine
implements ApplicationStartInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] arguments;
    @NotNull
    private final Lazy commandOrigin$delegate;
    @NotNull
    private final Lazy type$delegate;
    private final boolean isHeadlessLaunch;

    public CommandLine(@NotNull String[] arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        this.arguments = arguments;
        this.commandOrigin$delegate = LazyKt.lazy(() -> CommandLine.commandOrigin_delegate$lambda$0(this));
        this.type$delegate = LazyKt.lazy(() -> CommandLine.type_delegate$lambda$0(this));
        this.isHeadlessLaunch = this.getType() == ApplicationStartType.AGENT || this.getType() == ApplicationStartType.DAEMON;
    }

    @Override
    @NotNull
    public String[] getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isTrace() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--trace");
    }

    public boolean isDebug() {
        return this.isTrace() || ArraysKt.contains((Object[])this.getArguments(), (Object)"--debug");
    }

    public final boolean isMinimize() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--minimize") || this.getEnterpriseAuthRequest() != null;
    }

    public final boolean isUpdateFailed() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--update-failed");
    }

    public final boolean isForceAutostartIntegration() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--force-autostart-integration");
    }

    public final boolean isUninstallMode() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--uninstall");
    }

    public final boolean isInstallMode() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--install");
    }

    public final boolean isIntegrateIntoSystem() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--integrate-into-system");
    }

    public final boolean isSelfCheck() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--self-check");
    }

    public final boolean isOnboardingFinished() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--onboarding-finished");
    }

    public final boolean getCopySettingsToDev() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--copy-settings-to-dev");
    }

    public final boolean isStatisticsAllowed() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--statistics-allowed");
    }

    public final boolean getDisableStdioLogging() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--disable-stdio-logging");
    }

    @Nullable
    public final Path getInstallTarget() {
        String string = this.getArgumentValue(this.getArguments(), "--install-target");
        return string != null && (string = StringExtensionsKt.getNullIfBlank(string)) != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null) : null;
    }

    @Nullable
    public final Path getInstallSource() {
        String string = this.getArgumentValue(this.getArguments(), "--install-source");
        return string != null && (string = StringExtensionsKt.getNullIfBlank(string)) != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null) : null;
    }

    public final long getWaitForPid() {
        Long l = (Long)this.getArgumentValue(this.getArguments(), "--wait-for-pid", CommandLine::_get_waitForPid_$lambda$0);
        return l != null ? l : 0L;
    }

    @Nullable
    public final String getInstallCommand() {
        return this.getArgumentValue(this.getArguments(), "--install-command");
    }

    @Nullable
    public final String getEuaVersionAccepted-12qw-PM() {
        BuildNumber buildNumber = (BuildNumber)this.getArgumentValue(this.getArguments(), "--eua-version-accepted", euaVersionAccepted.1.INSTANCE);
        return buildNumber != null ? buildNumber.unbox-impl() : null;
    }

    @Nullable
    public final Boolean getAutoUpdate() {
        return (Boolean)this.getArgumentValue(this.getArguments(), "--auto-update", CommandLine::_get_autoUpdate_$lambda$0);
    }

    @Nullable
    public final Long getIdeDaemonPid() {
        return (Long)this.getArgumentValue(this.getArguments(), "--daemon-for-ide", CommandLine::_get_ideDaemonPid_$lambda$0);
    }

    public final boolean getOfflineMode() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--offline-mode");
    }

    @Nullable
    public final ApplicationStartType getInstallType() {
        ApplicationStartType applicationStartType;
        String string;
        String string2 = this.getArgumentValue(this.getArguments(), "--install-type");
        if (string2 != null && (string = StringExtensionsKt.getNullIfBlank(string2)) != null) {
            String it = string;
            boolean bl = false;
            applicationStartType = this.parseApplicationStartType(it);
        } else {
            applicationStartType = null;
        }
        return applicationStartType;
    }

    @Nullable
    public final ApplicationStartType getCommandOrigin() {
        Lazy lazy = this.commandOrigin$delegate;
        return (ApplicationStartType)((Object)lazy.getValue());
    }

    private final ApplicationStartType parseApplicationStartType(String value2) {
        ApplicationStartType applicationStartType;
        try {
            applicationStartType = ApplicationStartType.valueOf(value2);
        }
        catch (Exception exception) {
            applicationStartType = ApplicationStartType.UNKNOWN;
        }
        return applicationStartType;
    }

    @Nullable
    public final EnterpriseIntelliJAuthRequest getEnterpriseAuthRequest() {
        String string = this.getArgumentValue(this.getArguments(), "--enterprise-auth-token");
        if (string == null) {
            return null;
        }
        String token2 = string;
        String string2 = this.getArgumentValue(this.getArguments(), "--enterprise-auth-callback");
        if (string2 == null) {
            return null;
        }
        String callbackUrl = string2;
        String string3 = this.getArgumentValue(this.getArguments(), "--enterprise-auth-callback-token");
        if (string3 == null) {
            return null;
        }
        String callbackToken = string3;
        boolean requireNew = ArraysKt.contains((Object[])this.getArguments(), (Object)"--enterprise-require-new-token");
        return new EnterpriseIntelliJAuthRequest(token2, callbackUrl, callbackToken, requireNew);
    }

    public final boolean getGateway() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--enable-gateway");
    }

    @Nullable
    public final GraphicsApi getGraphicsApi() {
        return (GraphicsApi)((Object)this.getArgumentValue(this.getArguments(), "--graphics-api", CommandLine::_get_graphicsApi_$lambda$0));
    }

    private final String getArgumentValue(String[] arguments, String key) {
        return (String)this.getArgumentValue(arguments, key, CommandLine::getArgumentValue$lambda$0);
    }

    private final <T> T getArgumentValue(String[] arguments, String key, Function1<? super String, ? extends T> convert2) {
        int n = arguments.length;
        for (int j = 0; j < n; ++j) {
            char[] cArray;
            List split;
            int idx = j;
            String argument = arguments[j];
            if (Intrinsics.areEqual((Object)argument, (Object)key)) {
                return (T)(idx >= ArraysKt.getLastIndex((Object[])arguments) ? null : convert2.invoke((Object)arguments[idx + 1]));
            }
            if (!StringsKt.startsWith$default((String)argument, (String)key, (boolean)false, (int)2, null) || (split = StringsKt.split$default((CharSequence)argument, (char[])(cArray = new char[]{'='}), (boolean)false, (int)2, (int)2, null)).size() < 2 || !Intrinsics.areEqual(split.get(0), (Object)key)) continue;
            return (T)convert2.invoke(split.get(1));
        }
        return null;
    }

    @Override
    @NotNull
    public ApplicationStartType getType() {
        Lazy lazy = this.type$delegate;
        return (ApplicationStartType)((Object)lazy.getValue());
    }

    private final ApplicationStartType detectApplicationType() {
        boolean isDaemonCommand;
        if (this.getCommandOrigin() == ApplicationStartType.DAEMON || this.getCommandOrigin() == ApplicationStartType.AGENT) {
            ApplicationStartType applicationStartType = this.getCommandOrigin();
            Intrinsics.checkNotNull((Object)((Object)applicationStartType));
            return applicationStartType;
        }
        boolean bl = isDaemonCommand = this.getIdeDaemonPid() != null || this.getEnterpriseAuthRequest() != null;
        if (isDaemonCommand) {
            return ApplicationStartType.DAEMON;
        }
        if (this.getCommandOrigin() == ApplicationStartType.APP) {
            return ApplicationStartType.APP;
        }
        String string = System.getProperty("toolbox.is.daemon.mode", "false");
        boolean bl2 = string != null ? Boolean.parseBoolean(string) : false;
        if (bl2) {
            return ApplicationStartType.DAEMON;
        }
        return ApplicationStartType.APP;
    }

    public final boolean isHeadlessLaunch() {
        return this.isHeadlessLaunch;
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.getArguments());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Long _get_waitForPid_$lambda$0(String it) {
        String string = it;
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    private static final Boolean _get_autoUpdate_$lambda$0(String it) {
        String string = it;
        return string != null ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
    }

    private static final Long _get_ideDaemonPid_$lambda$0(String it) {
        String string = it;
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    private static final ApplicationStartType commandOrigin_delegate$lambda$0(CommandLine this$0) {
        ApplicationStartType applicationStartType;
        String string = this$0.getArgumentValue(this$0.getArguments(), "--command-origin");
        if (string != null) {
            String it = string;
            boolean bl = false;
            applicationStartType = this$0.parseApplicationStartType(it);
        } else {
            applicationStartType = null;
        }
        return applicationStartType;
    }

    private static final GraphicsApi _get_graphicsApi_$lambda$0(String name2) {
        Object v0;
        GraphicsApi it;
        block3: {
            Iterable $this$firstOrNull$iv = GraphicsApi.Companion.getAVAILABLE();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (GraphicsApi)((Object)element$iv);
                boolean bl = false;
                if (!StringsKt.equals((String)it.name(), (String)name2, (boolean)true)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        GraphicsApi res2 = v0;
        if (name2 != null && res2 == null) {
            System.out.println((Object)("Ignoring invalid --graphics-api value: " + name2));
            System.out.println((Object)"Valid values are:");
            Iterable $this$forEach$iv = GraphicsApi.Companion.getAVAILABLE();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (GraphicsApi)((Object)element$iv);
                boolean bl = false;
                System.out.println((Object)("  " + it.name()));
            }
        }
        return res2;
    }

    private static final String getArgumentValue$lambda$0(String it) {
        return it;
    }

    private static final ApplicationStartType type_delegate$lambda$0(CommandLine this$0) {
        return this$0.detectApplicationType();
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

