/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.PatchesKt;
import com.jetbrains.toolbox.environment.EnvironmentDescriptorProvider;
import com.jetbrains.toolbox.environment.EnvironmentDescriptorProviderKt;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.feed.BuildMapper;
import com.jetbrains.toolbox.feed.SupersededApplication;
import com.jetbrains.toolbox.tools.WellKnownApplications;
import com.jetbrains.toolbox.tools.model.AvailableBuild;
import com.jetbrains.toolbox.tools.model.AvailableVersion;
import com.jetbrains.toolbox.tools.model.ChangeOptions;
import com.jetbrains.toolbox.tools.model.Channel;
import com.jetbrains.toolbox.tools.model.ChannelUtilsKt;
import com.jetbrains.toolbox.tools.model.FailedUpdate;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.PatchSequence;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolPatch;
import com.jetbrains.toolbox.tools.model.ToolUpdate;
import com.jetbrains.toolbox.tools.model.ToolWithVersions;
import com.jetbrains.toolbox.tools.model.UpdateFilter;
import com.jetbrains.toolbox.tools.model.VersionWithBuilds;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nChangeOptionsCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeOptionsCalculator.kt\ncom/jetbrains/toolbox/ChangeOptionsCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n295#2,2:159\n774#2:162\n865#2:163\n1761#2,3:164\n866#2:167\n1374#2:168\n1460#2,2:169\n774#2:171\n865#2,2:172\n1374#2:174\n1460#2,2:175\n774#2:177\n865#2,2:178\n1563#2:180\n1634#2,3:181\n1462#2,3:184\n1462#2,3:187\n774#2:190\n865#2,2:191\n1#3:161\n*S KotlinDebug\n*F\n+ 1 ChangeOptionsCalculator.kt\ncom/jetbrains/toolbox/ChangeOptionsCalculator\n*L\n53#1:159,2\n83#1:162\n83#1:163\n83#1:164,3\n83#1:167\n84#1:168\n84#1:169,2\n86#1:171\n86#1:172,2\n87#1:174\n87#1:175,2\n89#1:177\n89#1:178,2\n89#1:180\n89#1:181,3\n87#1:184,3\n84#1:187,3\n119#1:190\n119#1:191,2\n*E\n"})
public final class ChangeOptionsCalculator {
    @NotNull
    private final StateFlow<Map<ApplicationType, ToolWithVersions>> available;
    @NotNull
    private final EnvironmentDescriptorProvider environmentDescriptorProvider;
    @NotNull
    private final StateFlow<Boolean> allowPatches;
    @NotNull
    private final Clock clock;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final BuildMapper buildMapper;

    public ChangeOptionsCalculator(@NotNull StateFlow<? extends Map<ApplicationType, ToolWithVersions>> available2, @NotNull EnvironmentDescriptorProvider environmentDescriptorProvider, @NotNull StateFlow<Boolean> allowPatches, @NotNull Clock clock, @NotNull FileSystem fileSystem, @NotNull BuildMapper buildMapper) {
        Intrinsics.checkNotNullParameter(available2, (String)"available");
        Intrinsics.checkNotNullParameter((Object)environmentDescriptorProvider, (String)"environmentDescriptorProvider");
        Intrinsics.checkNotNullParameter(allowPatches, (String)"allowPatches");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)buildMapper, (String)"buildMapper");
        this.available = available2;
        this.environmentDescriptorProvider = environmentDescriptorProvider;
        this.allowPatches = allowPatches;
        this.clock = clock;
        this.fileSystem = fileSystem;
        this.buildMapper = buildMapper;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChangeOptions calculateOptions(@NotNull ToolInstance toolInstance) {
        ToolUpdate.Full full;
        ToolUpdate.Full full2;
        ToolUpdate toolUpdate;
        ToolUpdate toolUpdate2;
        ChangeOptions.Status status2;
        block4: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
            if (!EnvironmentDescriptorProviderKt.isToolUpdateAllowed(this.environmentDescriptorProvider) || ApplicationType.equals-impl0(toolInstance.getTool().getToolId-UtVBrGo(), WellKnownApplications.INSTANCE.getJetBrainsClient-UtVBrGo())) {
                return ChangeOptions.Companion.getNoChanges();
            }
            Map available2 = (Map)this.available.getValue();
            boolean allowPatches = (Boolean)this.allowPatches.getValue();
            Channel channel = toolInstance.getChannel();
            ToolUpdate defaultUpdate2 = this.getUpdate(available2, allowPatches, toolInstance, (Function1<? super AvailableBuild, Boolean>)((Function1)new Function1<AvailableBuild, Boolean>((Object)channel.getUpdateFilter()){

                public final Boolean invoke(AvailableBuild p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((UpdateFilter)this.receiver).defaultBuildFilter(p0);
                }
            }), channel.getUpdateFilter().getFailedUpdate());
            status2 = this.getStatus(channel, toolInstance.getTool(), defaultUpdate2);
            Iterable iterable = CollectionsKt.drop((Iterable)channel.getHistory().getToolBuilds(), (int)1);
            toolUpdate2 = ChangeOptionsCalculator.getUpdate$default(this, available2, allowPatches, toolInstance, (Function1)new Function1<AvailableBuild, Boolean>((Object)channel.getUpdateFilter()){

                public final Boolean invoke(AvailableBuild p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((UpdateFilter)this.receiver).skippedBuildFilter(p0);
                }
            }, null, 16, null);
            toolUpdate = defaultUpdate2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ToolBuild it = (ToolBuild)element$iv;
                boolean bl = false;
                LocalDateTime expires = it.getBuild().getExpires();
                if (!(expires == null || TimeZoneKt.toInstant((LocalDateTime)expires, (TimeZone)TimeZone.Companion.currentSystemDefault()).compareTo(this.clock.now()) > 0)) continue;
                full2 = (ToolUpdate.Full)element$iv;
                break block4;
            }
            full2 = null;
        }
        ToolUpdate.Full full3 = full2;
        ToolUpdate toolUpdate3 = toolUpdate;
        ToolUpdate toolUpdate4 = toolUpdate2;
        ToolBuild toolBuild2 = (ToolBuild)((Object)full3);
        if (toolBuild2 != null) {
            void it;
            ToolBuild $i$f$firstOrNull = toolBuild2;
            toolUpdate2 = toolUpdate4;
            toolUpdate = toolUpdate3;
            boolean bl = false;
            full3 = new ToolUpdate.Full((ToolBuild)it, null, 2, null);
            toolUpdate3 = toolUpdate;
            toolUpdate4 = toolUpdate2;
            full = full3;
        } else {
            full = null;
        }
        ChangeOptions.Status status3 = status2;
        ToolUpdate.Full full4 = full;
        ToolUpdate toolUpdate5 = toolUpdate4;
        ToolUpdate toolUpdate6 = toolUpdate3;
        return new ChangeOptions(toolUpdate6, toolUpdate5, full4, status3);
    }

    private final ChangeOptions.Status getStatus(Channel channel, InstalledTool tool, ToolUpdate defaultUpdate2) {
        ChangeOptions.Status status2;
        if (!ChannelUtilsKt.canOverwriteInstallationDirectory(channel, this.fileSystem)) {
            Path dir = channel.getInstallationDirectory();
            if (!ApplicationType.equals-impl0(tool.getToolId-UtVBrGo(), WellKnownApplications.INSTANCE.getToolbox-UtVBrGo())) {
                Logger.INSTANCE.info("Updates for tool " + ApplicationType.toString-impl(tool.getToolId-UtVBrGo()) + "('" + dir + "') will not be available because the parent directory '" + dir.parent() + "' is not writable.");
            }
            status2 = ChangeOptions.Status.DirectoryIsNotWritable;
        } else if (!channel.getAutoUpdate()) {
            status2 = ChangeOptions.Status.Ok;
        } else {
            Instant postponeUntil;
            FailedUpdate previousFailedUpdate;
            FailedUpdate failedUpdate = channel.getUpdateFilter().getFailedUpdate();
            if (failedUpdate != null) {
                FailedUpdate failedUpdate2;
                FailedUpdate it = failedUpdate2 = failedUpdate;
                boolean bl = false;
                String string = it.getBuildNumber-Y_E1uuk();
                Object object = defaultUpdate2;
                String string2 = object != null && (object = object.getBuild()) != null && (object = ((ToolBuild)object).getBuild()) != null ? ((AvailableBuild)object).getId-Y_E1uuk() : null;
                v4 = (string2 == null ? false : BuildNumber.equals-impl0(string, string2)) ? failedUpdate2 : null;
            } else {
                v4 = previousFailedUpdate = null;
            }
            status2 = previousFailedUpdate == null ? ChangeOptions.Status.Ok : ((postponeUntil = previousFailedUpdate.getShouldPostponeUntil()) != null && postponeUntil.compareTo(this.clock.now()) <= 0 ? ChangeOptions.Status.Ok : ChangeOptions.Status.Postponed);
        }
        return status2;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Set<ToolBuild> filter-YC8iDpo(@NotNull Map<ApplicationType, ToolWithVersions> $this$filter_u2dYC8iDpo, @NotNull String $v$c$com-jetbrains-toolbox-feed-ApplicationType$-toolId$0, @NotNull Function1<? super AvailableVersion, Boolean> versionFilter, @NotNull Function1<? super AvailableBuild, Boolean> buildFilter) {
        Intrinsics.checkNotNullParameter($this$filter_u2dYC8iDpo, (String)"$this$filter");
        Intrinsics.checkNotNullParameter((Object)$v$c$com-jetbrains-toolbox-feed-ApplicationType$-toolId$0, (String)"$v$c$com-jetbrains-toolbox-feed-ApplicationType$-toolId$0");
        Intrinsics.checkNotNullParameter(versionFilter, (String)"versionFilter");
        Intrinsics.checkNotNullParameter(buildFilter, (String)"buildFilter");
        $this$filter$iv = $this$filter_u2dYC8iDpo.values();
        $i$f$filter = false;
        var8_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block11: {
                it = (ToolWithVersions)element$iv$iv;
                $i$a$-filter-ChangeOptionsCalculator$filter$matchingTools$1 = false;
                if (ApplicationType.equals-impl0(it.getTool().getApplicationType-UtVBrGo(), $v$c$com-jetbrains-toolbox-feed-ApplicationType$-toolId$0)) ** GOTO lbl-1000
                $this$any$iv = it.getTool().getSupersedes();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (SupersededApplication)element$iv;
                        $i$a$-any-ChangeOptionsCalculator$filter$matchingTools$1$1 = false;
                        if (!ApplicationType.equals-impl0(it.getId-UtVBrGo(), $v$c$com-jetbrains-toolbox-feed-ApplicationType$-toolId$0)) continue;
                        v0 = true;
                        break block11;
                    }
                    v0 = false;
                }
            }
            if (v0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        matchingTools = (List)destination$iv$iv;
        $this$flatMap$iv = matchingTools;
        $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            toolWithVersions = (ToolWithVersions)element$iv$iv;
            $i$a$-flatMap-ChangeOptionsCalculator$filter$1 = false;
            $this$filter$iv = toolWithVersions.getVersions();
            $i$f$filter = false;
            var17_16 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (VersionWithBuilds)element$iv$iv;
                $i$a$-filter-ChangeOptionsCalculator$filter$1$matchingVersions$1 = false;
                if (!((Boolean)versionFilter.invoke((Object)it.getVersion())).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            matchingVersions = (List)destination$iv$iv;
            $this$flatMap$iv = matchingVersions;
            $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$flatMapTo = false;
            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                versionWithBuilds = (VersionWithBuilds)element$iv$iv;
                $i$a$-flatMap-ChangeOptionsCalculator$filter$1$1 = false;
                $this$filter$iv = versionWithBuilds.getBuilds();
                $i$f$filter = false;
                var27_29 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    if (!((Boolean)buildFilter.invoke(element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var32_34 = (AvailableBuild)item$iv$iv;
                    var33_35 = destination$iv$iv;
                    $i$a$-map-ChangeOptionsCalculator$filter$1$1$1 = false;
                    var33_35.add(new ToolBuild(toolWithVersions.getTool(), versionWithBuilds.getVersion(), (AvailableBuild)availableBuild));
                }
                list$iv$iv = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * Unable to fully structure code
     */
    private final ToolUpdate getUpdate(Map<ApplicationType, ToolWithVersions> availableTools, boolean allowPatches, ToolInstance toolInstance, Function1<? super AvailableBuild, Boolean> buildFilter, FailedUpdate failedUpdate) {
        block11: {
            block9: {
                block10: {
                    tool = toolInstance.getTool();
                    channel = toolInstance.getChannel();
                    var10_8 = this.filter-YC8iDpo(availableTools, tool.getToolId-UtVBrGo(), (Function1<? super AvailableVersion, Boolean>)((Function1)new Function1<AvailableVersion, Boolean>((Object)channel.getUpdateFilter()){

                        public final Boolean invoke(AvailableVersion p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return ((UpdateFilter)this.receiver).versionFilter(p0);
                        }
                    }), buildFilter);
                    $i$f$filter = false;
                    var12_11 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    var15_16 = $this$filterTo$iv$iv.iterator();
                    while (var15_16.hasNext()) {
                        element$iv$iv = var15_16.next();
                        it = (ToolBuild)element$iv$iv;
                        $i$a$-filter-ChangeOptionsCalculator$getUpdate$build$2 = false;
                        if (!this.succeedsTheBuildOf(it, tool)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    v0 = (ToolBuild)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
                    if (v0 == null) {
                        return null;
                    }
                    build = v0;
                    if (!allowPatches) break block9;
                    v1 = availableTools.get(ApplicationType.box-impl(build.getTool().getApplicationType-UtVBrGo()));
                    patches = v1 != null ? v1.getPatchesGroupedByFrom() : null;
                    v2 = patches;
                    if (v2 == null) break block10;
                    it = v2;
                    $i$a$-let-ChangeOptionsCalculator$getUpdate$patchSequence$1 = false;
                    v3 = PatchesKt.findPatchSequence-Q-PBdcg(tool.getBuildNumber-Y_E1uuk(), build.getBuild().getId-Y_E1uuk(), it);
                    v2 = v3;
                    if (v3 == null) break block10;
                    it = $this$filterTo$iv$iv = v2;
                    $i$a$-takeIf-ChangeOptionsCalculator$getUpdate$patchSequence$2 = false;
                    if (!CollectionsKt.any((Iterable)((Iterable)it))) ** GOTO lbl-1000
                    var15_16 = (Iterable)it;
                    var16_18 = 0L;
                    var18_21 = var15_16.iterator();
                    while (var18_21.hasNext()) {
                        var19_23 = var18_21.next();
                        var20_24 = (ToolPatch)var19_23;
                        var21_25 = var16_18;
                        $i$a$-sumOfLong-ChangeOptionsCalculator$getUpdate$patchSequence$2$1 = false;
                        var24_27 = p0.getDownloadSize();
                        var16_18 = var21_25 + var24_27;
                    }
                    if ((double)var16_18 < (double)build.getBuild().getDownloadSize() * (1.0 - 0.25 * (double)it.size())) {
                        v4 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = false;
                    }
                    v5 = v4 ? $this$filterTo$iv$iv : null;
                    break block11;
                }
                v5 = null;
                break block11;
            }
            v5 = null;
        }
        patchSequence = v5;
        v6 = failedUpdate;
        if (v6 != null) {
            it = var11_10 = v6;
            $i$a$-takeIf-ChangeOptionsCalculator$getUpdate$previousFailedUpdate$1 = false;
            v7 = BuildNumber.equals-impl0(it.getBuildNumber-Y_E1uuk(), build.getBuild().getId-Y_E1uuk()) ? var11_10 : null;
        } else {
            v7 = null;
        }
        previousFailedUpdate = v7;
        v8 = patchSequence;
        if (v8 != null) {
            it = v8;
            $i$a$-let-ChangeOptionsCalculator$getUpdate$1 = false;
            v9 = new ToolUpdate.Patches(build, new PatchSequence(toolInstance, (List<ToolPatch>)it), previousFailedUpdate);
        } else {
            v9 = new ToolUpdate.Full(build, previousFailedUpdate);
        }
        return v9;
    }

    static /* synthetic */ ToolUpdate getUpdate$default(ChangeOptionsCalculator changeOptionsCalculator, Map map2, boolean bl, ToolInstance toolInstance, Function1 function1, FailedUpdate failedUpdate, int n, Object object) {
        if ((n & 0x10) != 0) {
            failedUpdate = null;
        }
        return changeOptionsCalculator.getUpdate(map2, bl, toolInstance, (Function1<? super AvailableBuild, Boolean>)function1, failedUpdate);
    }

    private final boolean succeedsTheBuildOf(ToolBuild $this$succeedsTheBuildOf, InstalledTool tool) {
        boolean bl;
        String appType = $this$succeedsTheBuildOf.getTool().getApplicationType-UtVBrGo();
        String buildNumber = $this$succeedsTheBuildOf.getBuild().getId-Y_E1uuk();
        String candidateOrdinalBuild = this.buildMapper.getOrdinalBuildNumber-AmUyaqY(appType, buildNumber);
        String currentOrdinalBuild = tool.getOrdinalBuildNumber-12qw-PM();
        if (candidateOrdinalBuild != null && currentOrdinalBuild != null) {
            Logger.INSTANCE.debug(() -> ChangeOptionsCalculator.succeedsTheBuildOf$lambda$0(tool, candidateOrdinalBuild, currentOrdinalBuild));
            bl = BuildNumber.compareTo-Szkhn3Q(candidateOrdinalBuild, currentOrdinalBuild) > 0;
        } else {
            Logger.INSTANCE.debug(() -> ChangeOptionsCalculator.succeedsTheBuildOf$lambda$1(tool, buildNumber));
            bl = BuildNumber.compareTo-Szkhn3Q(buildNumber, tool.getBuildNumber-Y_E1uuk()) > 0;
        }
        return bl;
    }

    @Nullable
    public final Object waitForAvailableToolsUpdate(@NotNull Continuation<? super Unit> $completion) {
        Object object = FlowKt.first((Flow)FlowKt.drop((Flow)((Flow)this.available), (int)1), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final String succeedsTheBuildOf$lambda$0(InstalledTool $tool, String $candidateOrdinalBuild, String $currentOrdinalBuild) {
        return "Calculating update for " + ApplicationType.toString-impl($tool.getToolId-UtVBrGo()) + " comparing ordinal builds: " + BuildNumber.toString-impl($candidateOrdinalBuild) + " and " + BuildNumber.toString-impl($currentOrdinalBuild);
    }

    private static final String succeedsTheBuildOf$lambda$1(InstalledTool $tool, String $buildNumber) {
        return "Calculating update for " + ApplicationType.toString-impl($tool.getToolId-UtVBrGo()) + " comparing builds: " + BuildNumber.toString-impl($buildNumber) + " and " + BuildNumber.toString-impl($tool.getBuildNumber-Y_E1uuk());
    }
}

