/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.schema;

import com.jetbrains.fus.reporting.schema.BaseEventId;
import com.jetbrains.fus.reporting.schema.BaseObjectEventField;
import com.jetbrains.fus.reporting.schema.BaseObjectListEventField;
import com.jetbrains.fus.reporting.schema.EventField;
import com.jetbrains.fus.reporting.schema.EventLogGroup;
import com.jetbrains.fus.reporting.schema.ListEventField;
import com.jetbrains.fus.reporting.schema.PrimitiveEventField;
import com.jetbrains.fus.reporting.schema.StringEventField;
import com.jetbrains.fus.reporting.schema.StringListEventField;
import com.jetbrains.fus.reporting.schema.generation.EventDescriptor;
import com.jetbrains.fus.reporting.schema.generation.EventsScheme;
import com.jetbrains.fus.reporting.schema.generation.FieldDataType;
import com.jetbrains.fus.reporting.schema.generation.FieldDescriptor;
import com.jetbrains.fus.reporting.schema.generation.GroupDescriptor;
import com.jetbrains.fus.reporting.schema.generation.GroupType;
import com.jetbrains.fus.reporting.schema.generation.SchemeValidator;
import com.jetbrains.fus.reporting.schema.generation.ValidationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nEventsSchemeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventsSchemeBuilder.kt\ncom/jetbrains/fus/reporting/schema/EventsSchemeBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,127:1\n1620#2,3:128\n1549#2:132\n1620#2,3:133\n1446#2,5:140\n1620#2,3:145\n1#3:131\n125#4:136\n152#4,3:137\n*S KotlinDebug\n*F\n+ 1 EventsSchemeBuilder.kt\ncom/jetbrains/fus/reporting/schema/EventsSchemeBuilder\n*L\n11#1:128,3\n14#1:132\n14#1:133,3\n121#1:140,5\n122#1:145,3\n38#1:136\n38#1:137,3\n*E\n"})
public final class EventsSchemeBuilder {
    @NotNull
    public static final EventsSchemeBuilder INSTANCE = new EventsSchemeBuilder();

    private EventsSchemeBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EventsScheme buildEventsScheme(@NotNull Collection<EventLogGroup> groups, @Nullable String buildNumber) {
        Object eventsDescriptors;
        Iterator<Object> iterator2;
        boolean $i$f$mapTo;
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        List result2 = new ArrayList();
        for (EventLogGroup eventLogGroup : groups) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean $this$mapTo$iv22;
            Collection collection;
            void $this$mapTo$iv22;
            Iterable iterable = eventLogGroup.getEvents();
            Collection destination$iv = new HashSet();
            $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv22) {
                void it;
                BaseEventId entry = (BaseEventId)item$iv;
                collection = destination$iv;
                boolean bl = false;
                collection.add(it.getEventId());
            }
            HashSet distinctEvents = (HashSet)destination$iv;
            boolean bl = $this$mapTo$iv22 = distinctEvents.size() == eventLogGroup.getEvents().size();
            if (_Assertions.ENABLED && !$this$mapTo$iv22) {
                boolean $i$a$-assert-EventsSchemeBuilder$buildEventsScheme$232 = false;
                String $i$a$-assert-EventsSchemeBuilder$buildEventsScheme$232 = "Duplicated events in group " + eventLogGroup.getId();
                throw new AssertionError((Object)$i$a$-assert-EventsSchemeBuilder$buildEventsScheme$232);
            }
            Iterable $i$a$-assert-EventsSchemeBuilder$buildEventsScheme$232 = eventLogGroup.getEvents();
            boolean $i$f$map = false;
            iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void event;
                BaseEventId baseEventId = (BaseEventId)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new EventDescriptor(event.getEventId(), INSTANCE.buildFields((BaseEventId)event, eventLogGroup.getId()), event.getDescription(), null, null, 24, null));
            }
            eventsDescriptors = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            GroupDescriptor groupDescriptor = new GroupDescriptor(eventLogGroup.getId(), this.toGroupType(eventLogGroup.getType()), eventLogGroup.getVersion(), (Set)eventsDescriptors, eventLogGroup.getDescription(), null, null, eventLogGroup.getPlugin());
            result2.add(groupDescriptor);
        }
        ValidationResult validationResult = SchemeValidator.INSTANCE.validateEventScheme(result2);
        if (!validationResult.getErrors().isEmpty()) {
            void $this$mapTo$iv$iv;
            Map<String, Set<String>> map2 = validationResult.getErrors();
            StringBuilder stringBuilder = new StringBuilder().append("Event scheme is not correct.\n");
            boolean $i$f$map = false;
            eventsDescriptors = map2;
            Collection destination$iv$iv = new ArrayList(map2.size());
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String group2 = (String)entry.getKey();
                Set errors = (Set)entry.getValue();
                collection.add("groupId=" + group2 + ":\n " + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
            String string = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString();
            throw new IllegalStateException(string);
        }
        return new EventsScheme(buildNumber, result2, null, 4, null);
    }

    public static /* synthetic */ EventsScheme buildEventsScheme$default(EventsSchemeBuilder eventsSchemeBuilder, Collection collection, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return eventsSchemeBuilder.buildEventsScheme(collection, string);
    }

    private final GroupType toGroupType(EventLogGroup.Type type2) {
        GroupType groupType;
        switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                groupType = GroupType.state;
                break;
            }
            case 2: {
                groupType = GroupType.counter;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return groupType;
    }

    private final Set<FieldDescriptor> fieldSchema(EventField<?> field, String fieldName, String eventName, String groupId) {
        Set set2;
        if (StringsKt.contains$default((CharSequence)field.getName(), (CharSequence)".", (boolean)false, (int)2, null)) {
            throw new IllegalStateException("Field name should not contains dots, because dots are used to express hierarchy. Group=" + groupId + ", event=" + eventName + ", field=" + field.getName());
        }
        EventField<?> eventField = field;
        if (eventField instanceof BaseObjectEventField) {
            set2 = this.buildObjectEvenScheme(fieldName, (Collection)((BaseObjectEventField)field).getObjectFields(), eventName, groupId);
        } else if (eventField instanceof BaseObjectListEventField) {
            set2 = this.buildObjectEvenScheme(fieldName, (Collection)((BaseObjectListEventField)field).getObjectFields(), eventName, groupId);
        } else if (eventField instanceof ListEventField) {
            if (field instanceof StringListEventField.ValidatedByInlineRegexp) {
                this.validateRegexp(((StringListEventField.ValidatedByInlineRegexp)field).getRegexp());
            }
            Object[] objectArray = new FieldDescriptor[]{new FieldDescriptor(fieldName, CollectionsKt.toHashSet((Iterable)((ListEventField)field).getValidationRule()), FieldDataType.ARRAY, field.getShouldBeAnonymized(), field.getDescription())};
            set2 = SetsKt.hashSetOf((Object[])objectArray);
        } else if (eventField instanceof PrimitiveEventField) {
            if (field instanceof StringEventField.ValidatedByInlineRegexp) {
                this.validateRegexp(((StringEventField.ValidatedByInlineRegexp)field).getRegexp());
            }
            Object[] objectArray = new FieldDescriptor[]{new FieldDescriptor(fieldName, CollectionsKt.toHashSet((Iterable)((PrimitiveEventField)field).getValidationRule()), FieldDataType.PRIMITIVE, field.getShouldBeAnonymized(), field.getDescription())};
            set2 = SetsKt.hashSetOf((Object[])objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return set2;
    }

    private final void validateRegexp(String regexp) {
        if (Intrinsics.areEqual((Object)regexp, (Object)".*")) {
            throw new IllegalStateException("Regexp should be more strict to prevent accidentally reporting sensitive data.");
        }
        Pattern.compile(regexp);
    }

    private final Set<FieldDescriptor> buildObjectEvenScheme(String fieldName, Collection<? extends EventField<?>> fields2, String eventName, String groupId) {
        HashSet fieldsDescriptors = new HashSet();
        for (EventField<?> eventField : fields2) {
            fieldsDescriptors.addAll(this.fieldSchema(eventField, fieldName + '.' + eventField.getName(), eventName, groupId));
        }
        return fieldsDescriptors;
    }

    /*
     * WARNING - void declaration
     */
    private final HashSet<FieldDescriptor> buildFields(BaseEventId event, String groupId) {
        boolean bl;
        void $this$mapTo$iv;
        void $this$flatMapTo$iv;
        String eventName = event.getEventId();
        Iterable iterable = event.getFields();
        Iterable destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            EventField field = (EventField)element$iv;
            boolean bl2 = false;
            Iterable list$iv = INSTANCE.fieldSchema(field, field.getName(), eventName, groupId);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet fieldDescriptors = (HashSet)destination$iv;
        destination$iv = fieldDescriptors;
        Collection destination$iv2 = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            FieldDescriptor bl2 = (FieldDescriptor)item$iv;
            Collection collection = destination$iv2;
            boolean bl3 = false;
            collection.add(it.getPath());
        }
        HashSet distinctFields = (HashSet)destination$iv2;
        boolean bl4 = bl = distinctFields.size() == fieldDescriptors.size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Duplicated fields in event " + event.getEventId() + ", group " + groupId;
            throw new AssertionError((Object)string);
        }
        return fieldDescriptors;
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventLogGroup.Type.values().length];
            try {
                nArray[EventLogGroup.Type.STATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventLogGroup.Type.COUNTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

