/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.schema;

import com.jetbrains.fus.reporting.schema.FieldValue;
import com.jetbrains.fus.reporting.schema.PrimitiveEventField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nEventField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventField.kt\ncom/jetbrains/fus/reporting/schema/EnumEventField\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,279:1\n11065#2:280\n11400#2,3:281\n*S KotlinDebug\n*F\n+ 1 EventField.kt\ncom/jetbrains/fus/reporting/schema/EnumEventField\n*L\n137#1:280\n137#1:281,3\n*E\n"})
public final class EnumEventField<T extends Enum<?>>
extends PrimitiveEventField<T> {
    @NotNull
    private final String name;
    @Nullable
    private final String description;
    @NotNull
    private final Class<T> enumClass;
    @NotNull
    private final Function1<T, String> transform;

    public EnumEventField(@NotNull String name2, @Nullable String description2, @NotNull Class<T> enumClass, @NotNull Function1<? super T, String> transform2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(enumClass, (String)"enumClass");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        this.name = name2;
        this.description = description2;
        this.enumClass = enumClass;
        this.transform = transform2;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public FieldValue getValue(@NotNull T value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return FieldValue.Companion.of((String)this.transform.invoke(value2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getValidationRule() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        StringBuilder stringBuilder = new StringBuilder().append("{enum:");
        T[] TArray = this.enumClass.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(TArray, (String)"enumClass.enumConstants");
        T[] TArray2 = TArray;
        Function1<T, String> function1 = this.transform;
        StringBuilder stringBuilder2 = stringBuilder;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void transform$iv;
            destination$iv$iv.add(transform$iv.invoke((Object)item$iv$iv));
        }
        return CollectionsKt.listOf((Object)stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null)).append('}').toString());
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @Nullable
    public final String component2() {
        return this.description;
    }

    private final Class<T> component3() {
        return this.enumClass;
    }

    private final Function1<T, String> component4() {
        return this.transform;
    }

    @NotNull
    public final EnumEventField<T> copy(@NotNull String name2, @Nullable String description2, @NotNull Class<T> enumClass, @NotNull Function1<? super T, String> transform2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(enumClass, (String)"enumClass");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        return new EnumEventField<T>(name2, description2, enumClass, transform2);
    }

    public static /* synthetic */ EnumEventField copy$default(EnumEventField enumEventField, String string, String string2, Class clazz, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = enumEventField.name;
        }
        if ((n & 2) != 0) {
            string2 = enumEventField.description;
        }
        if ((n & 4) != 0) {
            clazz = enumEventField.enumClass;
        }
        if ((n & 8) != 0) {
            function1 = enumEventField.transform;
        }
        return enumEventField.copy(string, string2, clazz, function1);
    }

    @NotNull
    public String toString() {
        return "EnumEventField(name=" + this.name + ", description=" + this.description + ", enumClass=" + this.enumClass + ", transform=" + this.transform + ')';
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + (this.description == null ? 0 : this.description.hashCode());
        result2 = result2 * 31 + this.enumClass.hashCode();
        result2 = result2 * 31 + this.transform.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EnumEventField)) {
            return false;
        }
        EnumEventField enumEventField = (EnumEventField)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)enumEventField.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)enumEventField.description)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.enumClass, enumEventField.enumClass)) {
            return false;
        }
        return Intrinsics.areEqual(this.transform, enumEventField.transform);
    }
}

