/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringsKmp;
import com.intellij.util.text.CharArrayExternalizable;
import com.intellij.util.text.CharArrayUtilKmp;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharSequenceSubSequence
implements CharSequenceWithStringHash,
CharArrayExternalizable,
CharSequence {
    @NotNull
    private final CharSequence baseSequence;
    private final int start;
    private final int end;
    private transient int hash;

    public CharSequenceSubSequence(@NotNull CharSequence baseSequence, int start2, int end) {
        Intrinsics.checkNotNullParameter((Object)baseSequence, (String)"baseSequence");
        this.baseSequence = baseSequence;
        this.start = start2;
        this.end = end;
        if (this.start < 0 || this.end > this.baseSequence.length() || this.start > this.end) {
            throw new IndexOutOfBoundsException("chars sequence.length:" + this.baseSequence.length() + ", start:" + this.start + ", end:" + this.end);
        }
    }

    public int getLength() {
        return this.end - this.start;
    }

    public char get(int index) {
        return this.baseSequence.charAt(index + this.start);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        if (startIndex == this.start && endIndex == this.end) {
            return this;
        }
        return new CharSequenceSubSequence(this.baseSequence, this.start + startIndex, this.start + endIndex);
    }

    @Override
    @NotNull
    public String toString() {
        if (this.baseSequence instanceof String) {
            String string = ((String)this.baseSequence).substring(this.start, this.end);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return StringsKt.concatToString((char[])CharArrayUtilKmp.fromSequence(this.baseSequence, this.start, this.end));
    }

    @Override
    public void getChars(int start2, int end, @NotNull char[] dest, int destPos) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!(end - start2 <= this.end - this.start)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        CharArrayUtilKmp.getChars(this.baseSequence, dest, start2 + this.start, destPos, end - start2);
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = StringsKmp.stringHashCode$default(this.baseSequence, this.start, this.end, 0, 4, null);
        }
        return h;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        return other instanceof CharSequence && StringsKt.contentEquals((CharSequence)this, (CharSequence)((CharSequence)other));
    }
}

