/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.jvm.PurelyImplements;
import org.jetbrains.annotations.NotNull;

@PurelyImplements(value="kotlin.collections.MutableList")
public final class FList<E>
extends AbstractList<E> {
    private static final FList<?> EMPTY_LIST = new FList<Object>(null, null, 0);
    private final E myHead;
    private final FList<E> myTail;
    private final int mySize;

    private FList(E head, FList<E> tail, int size) {
        this.myHead = head;
        this.myTail = tail;
        this.mySize = size;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("index = " + index + ", size = " + this.mySize);
        }
        FList<E> current = this;
        while (index > 0) {
            current = current.myTail;
            --index;
        }
        return current.myHead;
    }

    public E getHead() {
        return this.myHead;
    }

    public FList<E> prepend(E elem) {
        return new FList<E>(elem, this, this.mySize + 1);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private FList<E> list;
            {
                this.list = FList.this;
            }

            @Override
            public boolean hasNext() {
                return this.list.size() > 0;
            }

            @Override
            public E next() {
                if (this.list.size() == 0) {
                    throw new NoSuchElementException();
                }
                Object res2 = this.list.myHead;
                this.list = this.list.getTail();
                assert (this.list != null);
                return res2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public FList<E> getTail() {
        return this.myTail;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FList) {
            FList<E> list1 = this;
            FList<E> list2 = (FList<E>)o;
            if (this.mySize != list2.mySize) {
                return false;
            }
            while (list1 != null) {
                if (!Comparing.equal(list1.myHead, list2.myHead)) {
                    return false;
                }
                if ((list1 = list1.getTail()) != (list2 = list2.getTail())) continue;
                return true;
            }
            return true;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int result2 = 1;
        for (FList<E> each2 = this; each2 != null; each2 = each2.getTail()) {
            result2 = result2 * 31 + (each2.myHead != null ? each2.myHead.hashCode() : 0);
        }
        return result2;
    }

    public static <E> FList<E> emptyList() {
        return EMPTY_LIST;
    }

    public static <E> FList<E> singleton(@NotNull E elem) {
        if (elem == null) {
            FList.$$$reportNull$$$0(0);
        }
        return FList.emptyList().prepend(elem);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/util/containers/FList", "singleton"));
    }
}

