/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.HashingStrategy;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class CollectionFactory {
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeyWeakValueMap() {
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.canonical());
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet() {
        return new ObjectOpenCustomHashSet(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet(int initialSize) {
        return new ObjectOpenCustomHashSet(initialSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap() {
        return new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap(int expectedSize) {
        return new Object2ObjectOpenCustomHashMap(expectedSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }
}

