/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.textmate.joni;

import com.intellij.textmate.joni.JoniRegexFacade;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.regex.NotMatchingRegexFacade;
import org.jetbrains.plugins.textmate.regex.RegexFacade;
import org.jetbrains.plugins.textmate.regex.RegexFactory;
import org.jetbrains.plugins.textmate.regex.TextMateString;
import org.jetbrains.plugins.textmate.regex.TextMateStringImpl;
import org.joni.Regex;
import org.joni.WarnCallback;
import org.joni.exception.JOniException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JoniRegexFactory
implements RegexFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOGGER;

    @Override
    @NotNull
    public RegexFacade regex(@NotNull CharSequence pattern) {
        RegexFacade regexFacade;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String patternString = ((Object)pattern).toString();
        byte[] bytes2 = StringsKt.encodeToByteArray((String)patternString);
        try {
            Regex regex = new Regex(bytes2, 0, bytes2.length, 256, (Encoding)UTF8Encoding.INSTANCE, WarnCallback.NONE);
            regexFacade = new JoniRegexFacade(regex);
        }
        catch (JOniException e) {
            Object[] objectArray = new Object[]{patternString, ((Object)((Object)e)).getClass().getName(), e.getMessage()};
            LOGGER.info("Failed to parse textmate regex '{}' with {}: {}", objectArray);
            regexFacade = NotMatchingRegexFacade.INSTANCE;
        }
        return regexFacade;
    }

    @Override
    @NotNull
    public TextMateString string(@NotNull CharSequence string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return TextMateStringImpl.Companion.fromString(((Object)string).toString());
    }

    static {
        Logger logger = LoggerFactory.getLogger(JoniRegexFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

