/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.utils;

import java.net.UnixDomainSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@SourceDebugExtension(value={"SMAP\nStationConstants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StationConstants.kt\ncom/intellij/station/comms/common/utils/StationConstants\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class StationConstants {
    @NotNull
    public static final StationConstants INSTANCE = new StationConstants();
    @NotNull
    private static final String ideIdHeader = "X-Ide-Id";
    @NotNull
    private static final String idePidHeader = "X-Ide-Pid";
    @NotNull
    private static final String ideInstallPathHeader = "X-Ide-Install-Path";
    @NotNull
    private static final String ideFullVersionHeader = "X-Ide-Full-Version";
    @NotNull
    private static final String stationFailureHeader = "X-Station-Failure";
    @NotNull
    private static final String unknownEndpointValue = "no-endpoint";
    private static final boolean isLinux;
    private static final boolean isMac;

    private StationConstants() {
    }

    @NotNull
    public final String getIdeIdHeader() {
        return ideIdHeader;
    }

    @NotNull
    public final String getStationFailureHeader() {
        return stationFailureHeader;
    }

    @NotNull
    public final String getUnknownEndpointValue() {
        return unknownEndpointValue;
    }

    public final boolean isLinux() {
        return isLinux;
    }

    @NotNull
    public final UnixDomainSocketAddress getStationAddress() {
        UnixDomainSocketAddress unixDomainSocketAddress = this.getStationAddressLinuxPreferred();
        if (unixDomainSocketAddress != null) {
            UnixDomainSocketAddress it = unixDomainSocketAddress;
            boolean bl = false;
            return it;
        }
        return this.getStationAddressCommonTempdir();
    }

    @Nullable
    public final UnixDomainSocketAddress getAdditionalLinkAddress() {
        if (this.getStationAddressLinuxPreferred() == null) {
            return null;
        }
        return this.getStationAddressCommonTempdir();
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final Pair<String, String> getBaseDirectoryAndUserName() {
        String string;
        String it = System.getProperty("user.name");
        boolean bl = false;
        CharSequence charSequence = it;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)it, (Object)"?")) {
            string = System.getenv("USER");
            if (string == null) {
                string = "user";
            }
        } else {
            void var3_1;
            string = var3_1;
        }
        String userName = string;
        String tempDirectory = System.getProperty("java.io.tmpdir");
        return TuplesKt.to((Object)tempDirectory, (Object)userName);
    }

    private final String getLinuxXdgRuntimeDir() {
        if (!isLinux) {
            return null;
        }
        String xdgRuntimeDir = System.getenv("XDG_RUNTIME_DIR");
        CharSequence charSequence = xdgRuntimeDir;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && Files.exists(Path.of(xdgRuntimeDir, new String[0]), new LinkOption[0])) {
            return xdgRuntimeDir;
        }
        return null;
    }

    private final UnixDomainSocketAddress getStationAddressCommonTempdir() {
        Pair<String, String> pair = this.getBaseDirectoryAndUserName();
        String tempDirectory = (String)pair.component1();
        String userName = (String)pair.component2();
        String[] stringArray = new String[]{"jb.station." + userName + ".sock"};
        UnixDomainSocketAddress unixDomainSocketAddress = UnixDomainSocketAddress.of(Path.of(tempDirectory, stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)unixDomainSocketAddress, (String)"of(...)");
        return unixDomainSocketAddress;
    }

    private final UnixDomainSocketAddress getStationAddressLinuxPreferred() {
        UnixDomainSocketAddress unixDomainSocketAddress;
        String string = this.getLinuxXdgRuntimeDir();
        if (string != null) {
            String it = string;
            boolean bl = false;
            String[] stringArray = new String[]{"jb.station.sock"};
            unixDomainSocketAddress = UnixDomainSocketAddress.of(Path.of(it, stringArray));
        } else {
            unixDomainSocketAddress = null;
        }
        return unixDomainSocketAddress;
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        isLinux = StringsKt.startsWith((String)string, (String)"linux", (boolean)true);
        String string2 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        isMac = StringsKt.startsWith((String)string2, (String)"mac", (boolean)true);
    }
}

