/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.netty.client;

import com.intellij.station.comms.common.StationHttpException;
import com.intellij.station.comms.common.StationUnknownEndpointException;
import com.intellij.station.comms.common.api.ServiceMetaInfo;
import com.intellij.station.comms.common.api.StationServicesClient;
import com.intellij.station.comms.common.netty.client.StationServicesClientBase;
import com.intellij.station.comms.common.netty.util.ExtensionsKt;
import com.intellij.station.comms.common.netty.util.SingleMessageFutureChannelInboundHandler;
import com.intellij.station.comms.common.utils.Logging;
import com.intellij.station.comms.common.utils.StationConstants;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioDomainSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import java.net.URI;
import java.net.UnixDomainSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SourceDebugExtension(value={"SMAP\nStationServicesClientBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StationServicesClientBase.kt\ncom/intellij/station/comms/common/netty/client/StationServicesClientBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 SingleMessageFutureChannelInboundHandler.kt\ncom/intellij/station/comms/common/netty/util/SingleMessageFutureChannelInboundHandlerKt\n+ 5 Logging.kt\ncom/intellij/station/comms/common/utils/Logging\n*L\n1#1,209:1\n1761#2,3:210\n216#3,2:213\n216#3,2:216\n7#4:215\n7#4:218\n7#5:219\n*S KotlinDebug\n*F\n+ 1 StationServicesClientBase.kt\ncom/intellij/station/comms/common/netty/client/StationServicesClientBase\n*L\n68#1:210,3\n103#1:213,2\n146#1:216,2\n107#1:215\n154#1:218\n44#1:219\n*E\n"})
public abstract class StationServicesClientBase
implements StationServicesClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UnixDomainSocketAddress remoteEndpointMain;
    @NotNull
    private final EventLoopGroup group;
    @Nullable
    private final UnixDomainSocketAddress additionalEndpoint;
    @NotNull
    private static final Logger logger;
    private static final int maximumBodySize;

    public StationServicesClientBase(@NotNull UnixDomainSocketAddress remoteEndpointMain, @NotNull EventLoopGroup group, @Nullable UnixDomainSocketAddress additionalEndpoint) {
        Intrinsics.checkNotNullParameter((Object)remoteEndpointMain, (String)"remoteEndpointMain");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.remoteEndpointMain = remoteEndpointMain;
        this.group = group;
        this.additionalEndpoint = additionalEndpoint;
    }

    public /* synthetic */ StationServicesClientBase(UnixDomainSocketAddress unixDomainSocketAddress, EventLoopGroup eventLoopGroup, UnixDomainSocketAddress unixDomainSocketAddress2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            unixDomainSocketAddress2 = null;
        }
        this(unixDomainSocketAddress, eventLoopGroup, unixDomainSocketAddress2);
    }

    @NotNull
    public abstract Map<String, String> getExtraHeaders();

    private final URI buildUri(ServiceMetaInfo<?, ?> metaInfo, String protocol) {
        URI uRI = URI.create(protocol + "://remote" + metaInfo.getEndpoint());
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        return uRI;
    }

    private final UnixDomainSocketAddress getEndpointToUse() {
        if (Files.exists(this.remoteEndpointMain.getPath(), new LinkOption[0])) {
            return this.remoteEndpointMain;
        }
        if (this.additionalEndpoint != null && Files.exists(this.additionalEndpoint.getPath(), new LinkOption[0])) {
            return this.additionalEndpoint;
        }
        return this.remoteEndpointMain;
    }

    private final void checkSocketPermissions(UnixDomainSocketAddress endpoint) {
        if (!StationConstants.INSTANCE.isLinux()) {
            return;
        }
        try {
            boolean bl;
            block7: {
                Set<PosixFilePermission> set2 = Files.getPosixFilePermissions(endpoint.getPath(), new LinkOption[0]);
                Intrinsics.checkNotNullExpressionValue(set2, (String)"getPosixFilePermissions(...)");
                Iterable $this$any$iv = set2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PosixFilePermission permission = (PosixFilePermission)((Object)element$iv);
                        boolean bl2 = false;
                        if (!(permission == PosixFilePermission.OTHERS_WRITE || permission == PosixFilePermission.GROUP_WRITE)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new IllegalStateException("Unexpected too-wide permissions on station socket, will not proceed".toString());
            }
        }
        catch (UnsupportedOperationException ex) {
            logger.trace("POSIX permissions not supported for station socket", (Throwable)ex);
        }
    }

    @Override
    @Nullable
    public <Request, Response> Object request(@NotNull ServiceMetaInfo<Request, Response> metaInfo, @NotNull Request request2, @NotNull Continuation<? super Response> $completion) {
        return StationServicesClientBase.request$suspendImpl(this, metaInfo, request2, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static /* synthetic */ <Request, Response> Object request$suspendImpl(StationServicesClientBase $this, ServiceMetaInfo<Request, Response> metaInfo, Request request, Continuation<? super Response> $completion) {
        if (!($completion instanceof request.1)) ** GOTO lbl-1000
        var16_4 = $completion;
        if ((var16_4.label & -2147483648) != 0) {
            var16_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                /* synthetic */ Object result;
                final /* synthetic */ StationServicesClientBase this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StationServicesClientBase.request$suspendImpl(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var17_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                remoteEndpoint = $this.getEndpointToUse();
                $this.checkSocketPermissions(remoteEndpoint);
                data = metaInfo.getCodec().encodeRequest(request /* !! */ );
                bootstrap = new Bootstrap();
                ((Bootstrap)bootstrap.group($this.group)).channel(NioDomainSocketChannel.class);
                uri = $this.buildUri(metaInfo, "http");
                request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, uri.toString(), Unpooled.wrappedBuffer(data));
                $this$request_u24lambda_u240 = request.headers();
                $i$a$-run-StationServicesClientBase$request$2 = false;
                $this$request_u24lambda_u240.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)Boxing.boxInt((int)request.content().readableBytes()));
                $this$request_u24lambda_u240.set((CharSequence)HttpHeaderNames.HOST, (Object)"localhost");
                $this$forEach$iv = $this.getExtraHeaders();
                $i$f$forEach = false;
                $i$a$-run-StationServicesClientBase$request$2 = $this$forEach$iv.entrySet().iterator();
                while ($i$a$-run-StationServicesClientBase$request$2.hasNext()) {
                    it = element$iv = $i$a$-run-StationServicesClientBase$request$2.next();
                    $i$a$-forEach-StationServicesClientBase$request$3 = false;
                    request.headers().add(it.getKey(), (Object)it.getValue());
                }
                $i$f$SingleMessageFutureChannelInboundHandler = false;
                responseFutureHandler = new SingleMessageFutureChannelInboundHandler<FullHttpResponse>(FullHttpResponse.class);
                bootstrap.handler(new ChannelInitializer<NioDomainSocketChannel>(responseFutureHandler){
                    final /* synthetic */ SingleMessageFutureChannelInboundHandler<FullHttpResponse> $responseFutureHandler;
                    {
                        this.$responseFutureHandler = $responseFutureHandler;
                    }

                    protected void initChannel(NioDomainSocketChannel ch) {
                        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                        ChannelPipeline p = ch.pipeline();
                        ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(StationServicesClientBase.access$getMaximumBodySize$cp()), this.$responseFutureHandler};
                        p.addLast(channelHandlerArray);
                    }
                });
                v0 = bootstrap.connect(remoteEndpoint);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"connect(...)");
                $continuation.L$0 = $this;
                $continuation.L$1 = metaInfo;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable(request /* !! */ );
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)remoteEndpoint);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)data);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)bootstrap);
                $continuation.L$6 = uri;
                $continuation.L$7 = request;
                $continuation.L$8 = responseFutureHandler;
                $continuation.label = 1;
                v1 = ExtensionsKt.awaitSuspend(v0, $continuation);
                if (v1 == var17_6) {
                    return var17_6;
                }
                ** GOTO lbl68
            }
            case 1: {
                responseFutureHandler = (SingleMessageFutureChannelInboundHandler<FullHttpResponse>)$continuation.L$8;
                request = (DefaultFullHttpRequest)$continuation.L$7;
                uri = (URI)$continuation.L$6;
                bootstrap = (Bootstrap)$continuation.L$5;
                data = (byte[])$continuation.L$4;
                remoteEndpoint = (UnixDomainSocketAddress)$continuation.L$3;
                request /* !! */  = $continuation.L$2;
                metaInfo = (ServiceMetaInfo)$continuation.L$1;
                $this = (StationServicesClientBase)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl68:
                // 2 sources

                channel = (Channel)v1;
                v2 = channel.writeAndFlush(request);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"writeAndFlush(...)");
                $continuation.L$0 = $this;
                $continuation.L$1 = metaInfo;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable(request /* !! */ );
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)remoteEndpoint);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)data);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)bootstrap);
                $continuation.L$6 = uri;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$8 = responseFutureHandler;
                $continuation.L$9 = channel;
                $continuation.label = 2;
                v3 = ExtensionsKt.awaitSuspend(v2, $continuation);
                ** if (v3 != var17_6) goto lbl87
lbl86:
                // 1 sources

                return var17_6;
lbl87:
                // 1 sources

                ** GOTO lbl103
            }
            case 2: {
                channel = (Channel)$continuation.L$9;
                responseFutureHandler = (SingleMessageFutureChannelInboundHandler)$continuation.L$8;
                request = (DefaultFullHttpRequest)$continuation.L$7;
                uri = (URI)$continuation.L$6;
                bootstrap = (Bootstrap)$continuation.L$5;
                data = (byte[])$continuation.L$4;
                remoteEndpoint = (UnixDomainSocketAddress)$continuation.L$3;
                request /* !! */  = $continuation.L$2;
                metaInfo = (ServiceMetaInfo)$continuation.L$1;
                $this = (StationServicesClientBase)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl103:
                // 2 sources

                $continuation.L$0 = $this;
                $continuation.L$1 = metaInfo;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable(request /* !! */ );
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)remoteEndpoint);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)data);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)bootstrap);
                $continuation.L$6 = uri;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$8 = responseFutureHandler;
                $continuation.L$9 = channel;
                $continuation.label = 3;
                v4 = FutureKt.await((CompletionStage)responseFutureHandler.getFuture(), $continuation);
                ** if (v4 != var17_6) goto lbl117
lbl116:
                // 1 sources

                return var17_6;
lbl117:
                // 1 sources

                ** GOTO lbl133
            }
            case 3: {
                channel = (Channel)$continuation.L$9;
                responseFutureHandler = (SingleMessageFutureChannelInboundHandler)$continuation.L$8;
                request = (DefaultFullHttpRequest)$continuation.L$7;
                uri = (URI)$continuation.L$6;
                bootstrap = (Bootstrap)$continuation.L$5;
                data = (byte[])$continuation.L$4;
                remoteEndpoint = (UnixDomainSocketAddress)$continuation.L$3;
                request /* !! */  = $continuation.L$2;
                metaInfo = (ServiceMetaInfo)$continuation.L$1;
                $this = (StationServicesClientBase)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl133:
                // 2 sources

                response = (FullHttpResponse)v4;
                Intrinsics.checkNotNull((Object)response);
                $this.throwOnBadResponse(uri, response);
                v5 = metaInfo.getCodec();
                v6 = response.content();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"content(...)");
                var12_31 = v5.decodeResponse(ExtensionsKt.readAllToArray(v6));
                v7 = channel.close();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"close(...)");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)metaInfo);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable(request /* !! */ );
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)remoteEndpoint);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)data);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)bootstrap);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)uri);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$8 = responseFutureHandler;
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)channel);
                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)response);
                $continuation.L$11 = var12_31;
                $continuation.label = 4;
                v8 = ExtensionsKt.awaitSuspend(v7, $continuation);
                if (v8 == var17_6) {
                    return var17_6;
                }
                ** GOTO lbl174
            }
            case 4: {
                var12_31 = $continuation.L$11;
                response = (FullHttpResponse)$continuation.L$10;
                channel = (Channel)$continuation.L$9;
                responseFutureHandler = (SingleMessageFutureChannelInboundHandler)$continuation.L$8;
                request = (DefaultFullHttpRequest)$continuation.L$7;
                uri = (URI)$continuation.L$6;
                bootstrap = (Bootstrap)$continuation.L$5;
                data = (byte[])$continuation.L$4;
                remoteEndpoint = (UnixDomainSocketAddress)$continuation.L$3;
                request /* !! */  = $continuation.L$2;
                metaInfo = (ServiceMetaInfo)$continuation.L$1;
                $this = (StationServicesClientBase)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl174:
                // 2 sources

                responseFutureHandler.close();
                return var12_31;
            }
        }
        catch (Throwable var12_32) {
            v9 = channel.close();
            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"close(...)");
            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)metaInfo);
            $continuation.L$2 = SpillingKt.nullOutSpilledVariable(request /* !! */ );
            $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)remoteEndpoint);
            $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)data);
            $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)bootstrap);
            $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)uri);
            $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)request);
            $continuation.L$8 = responseFutureHandler;
            $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)channel);
            $continuation.L$10 = var12_32;
            $continuation.label = 5;
            v10 = ExtensionsKt.awaitSuspend(v9, $continuation);
            if (v10 == var17_6) {
                return var17_6;
            }
            ** GOTO lbl209
        }
        {
            case 5: {
                var12_33 = (Throwable)$continuation.L$10;
                channel = (Channel)$continuation.L$9;
                responseFutureHandler = (SingleMessageFutureChannelInboundHandler)$continuation.L$8;
                request = (DefaultFullHttpRequest)$continuation.L$7;
                uri = (URI)$continuation.L$6;
                bootstrap = (Bootstrap)$continuation.L$5;
                data = (byte[])$continuation.L$4;
                remoteEndpoint = (UnixDomainSocketAddress)$continuation.L$3;
                request /* !! */  = $continuation.L$2;
                metaInfo = (ServiceMetaInfo)$continuation.L$1;
                $this = (StationServicesClientBase)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v10 = $result;
lbl209:
                // 2 sources

                responseFutureHandler.close();
                throw var12_33;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void throwOnBadResponse(URI requestURI, HttpResponse response2) {
        int code = response2.status().code();
        switch (code) {
            case 100: 
            case 101: 
            case 200: {
                return;
            }
        }
        if (code == 404 && Intrinsics.areEqual((Object)response2.headers().get(StationConstants.INSTANCE.getStationFailureHeader()), (Object)StationConstants.INSTANCE.getUnknownEndpointValue())) {
            throw new StationUnknownEndpointException("Endpoint for " + requestURI + " not found", null, 2, null);
        }
        throw new StationHttpException(code, "HTTP error on " + requestURI + ": " + code + " " + response2.status().reasonPhrase(), null, 4, null);
    }

    public static final /* synthetic */ int access$getMaximumBodySize$cp() {
        return maximumBodySize;
    }

    static {
        Logging logging = Logging.INSTANCE;
        Companion $this$myLogger$iv = Companion;
        boolean $i$f$myLogger = false;
        Logger logger = LoggerFactory.getLogger(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        StationServicesClientBase.logger = logger;
        maximumBodySize = 0xA00000;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

