/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.text.CharArrayUtil;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class TrigramBuilder {
    private static final int ASCII_END = 128;
    private static final boolean[] idPartAscii = new boolean[128];

    private TrigramBuilder() {
    }

    public static boolean processTrigrams(@NotNull CharSequence text2, @NotNull TrigramProcessor consumer) {
        IntSet trigrams;
        if (text2 == null) {
            TrigramBuilder.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            TrigramBuilder.$$$reportNull$$$0(1);
        }
        if (!consumer.consumeTrigramsCount((trigrams = TrigramBuilder.getTrigrams(text2)).size())) {
            return false;
        }
        IntIterator iterator2 = trigrams.iterator();
        while (iterator2.hasNext()) {
            int trigram = iterator2.nextInt();
            if (consumer.test(trigram)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Map<Integer, Void> getTrigramsAsMap(final @NotNull CharSequence text2) {
        if (text2 == null) {
            TrigramBuilder.$$$reportNull$$$0(2);
        }
        return new AbstractMap<Integer, Void>(){
            final IntSet trigrams;
            {
                this.trigrams = TrigramBuilder.getTrigrams(text2);
            }

            @Override
            public int size() {
                return this.trigrams.size();
            }

            @Override
            public boolean containsKey(Object k) {
                return this.trigrams.contains(k);
            }

            @Override
            public boolean containsValue(Object v) {
                return v == null && !this.isEmpty();
            }

            @Override
            public void forEach(BiConsumer<? super Integer, ? super Void> consumer) {
                this.trigrams.forEach(integer -> consumer.accept(integer, null));
            }

            public IntSet keySet() {
                return this.trigrams;
            }

            @Override
            public Collection<Void> values() {
                return Collections.nCopies(this.trigrams.size(), null);
            }

            @Override
            @NotNull
            public Set<Map.Entry<Integer, Void>> entrySet() {
                return new AbstractSet<Map.Entry<Integer, Void>>(){

                    @Override
                    public Iterator<Map.Entry<Integer, Void>> iterator() {
                        final IntIterator iterator2 = trigrams.iterator();
                        return new Iterator<Map.Entry<Integer, Void>>(){

                            @Override
                            public boolean hasNext() {
                                return iterator2.hasNext();
                            }

                            @Override
                            public Map.Entry<Integer, Void> next() {
                                int key = iterator2.nextInt();
                                return new AbstractMap.SimpleImmutableEntry<Integer, Object>(key, null);
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return trigrams.size();
                    }
                };
            }

            @Override
            public Void get(Object key) {
                return null;
            }
        };
    }

    @NotNull
    public static IntSet getTrigrams(@NotNull CharSequence text2) {
        if (text2 == null) {
            TrigramBuilder.$$$reportNull$$$0(3);
        }
        State state2 = new State(new AddonlyIntSet(1 + text2.length() / 8));
        char[] array = CharArrayUtil.fromSequenceWithoutCopying(text2);
        AddonlyIntSet addonlyIntSet = array != null ? state2.processArray(array) : state2.processSequence(text2);
        if (addonlyIntSet == null) {
            TrigramBuilder.$$$reportNull$$$0(4);
        }
        return addonlyIntSet;
    }

    static {
        for (char c = '\u0000'; c < idPartAscii.length; c = (char)(c + '\u0001')) {
            TrigramBuilder.idPartAscii[c] = Character.isJavaIdentifierPart(c);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/TrigramBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/TrigramBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrigrams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processTrigrams";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTrigramsAsMap";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTrigrams";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class TrigramProcessor
    implements IntPredicate {
        public boolean consumeTrigramsCount(int count) {
            return true;
        }
    }

    private static class State {
        private int tc1;
        private int tc2;
        private int idChars;
        private final AddonlyIntSet set;

        private State(AddonlyIntSet set2) {
            this.set = set2;
        }

        void process(char c) {
            if (c < '\u0080' ? idPartAscii[c] : Character.isJavaIdentifierPart(c)) {
                c = StringUtilRt.toLowerCase(c);
                if (this.idChars == 0) {
                    char c2 = c;
                    this.tc2 = c2;
                    this.tc1 = c2;
                    this.idChars = 1;
                } else {
                    if (++this.idChars >= 3) {
                        this.set.add((this.tc2 << 8) + c);
                    }
                    this.tc2 = (this.tc1 << 8) + c;
                    this.tc1 = c;
                }
            } else {
                this.idChars = 0;
            }
        }

        AddonlyIntSet processSequence(CharSequence text2) {
            int length = text2.length();
            for (int i2 = 0; i2 < length; ++i2) {
                this.process(text2.charAt(i2));
            }
            return this.set;
        }

        AddonlyIntSet processArray(char[] text2) {
            for (char c : text2) {
                this.process(c);
            }
            return this.set;
        }
    }

    @VisibleForTesting
    public static final class AddonlyIntSet
    extends AbstractIntSet {
        private int size;
        private int[] data;
        private int mask;
        private boolean hasZeroKey;

        public AddonlyIntSet() {
            this(21);
        }

        AddonlyIntSet(int expectedSize) {
            int powerOfTwo = Integer.highestOneBit(3 * expectedSize / 2) << 1;
            this.mask = powerOfTwo - 1;
            this.data = new int[powerOfTwo];
        }

        public int[] toArray(int[] arr) {
            int size = this.size;
            if (arr == null) {
                arr = new int[size];
            } else if (arr.length < size) {
                arr = Arrays.copyOf(arr, size);
            }
            int idx = 0;
            if (this.hasZeroKey) {
                arr[idx++] = 0;
            }
            for (int val : this.data) {
                if (val == 0) continue;
                arr[idx++] = val;
            }
            assert (idx == size);
            return arr;
        }

        public void forEach(IntConsumer action) {
            if (this.hasZeroKey) {
                action.accept(0);
            }
            for (int val : this.data) {
                if (val == 0) continue;
                action.accept(val);
            }
        }

        @NotNull
        public IntIterator iterator() {
            return new AbstractIntIterator(){
                private int pos = -1;

                public int nextInt() {
                    if (this.pos == -1 && hasZeroKey) {
                        this.pos = 0;
                        return 0;
                    }
                    for (int i2 = Math.max(0, this.pos); i2 < data.length; ++i2) {
                        if (data[i2] == 0) continue;
                        this.pos = i2 + 1;
                        return data[i2];
                    }
                    throw new NoSuchElementException();
                }

                public boolean hasNext() {
                    if (this.pos == -1 && hasZeroKey) {
                        return true;
                    }
                    for (int i2 = Math.max(0, this.pos); i2 < data.length; ++i2) {
                        if (data[i2] == 0) continue;
                        this.pos = i2;
                        return true;
                    }
                    return false;
                }
            };
        }

        public int size() {
            return this.size;
        }

        private int hash(int h) {
            h ^= h >>> 20 ^ h >>> 12;
            return (h ^ h >>> 7 ^ h >>> 4) & this.mask;
        }

        public boolean add(int key) {
            boolean updated;
            if (key == 0) {
                if (!this.hasZeroKey) {
                    this.hasZeroKey = true;
                    ++this.size;
                    return true;
                }
                return false;
            }
            if (this.size >= 2 * this.data.length / 3) {
                this.rehash();
            }
            if (updated = this.doPut(this.data, key)) {
                ++this.size;
            }
            return updated;
        }

        private boolean doPut(int[] a, int o) {
            int obj;
            int index = this.hash(o);
            while ((obj = a[index]) != 0 && obj != o) {
                if (index == 0) {
                    index = a.length;
                }
                --index;
            }
            a[index] = o;
            return obj == 0;
        }

        private void rehash() {
            int[] b = new int[this.data.length << 1];
            this.mask = b.length - 1;
            int i2 = this.data.length;
            while (--i2 >= 0) {
                int ns = this.data[i2];
                if (ns == 0) continue;
                this.doPut(b, ns);
            }
            this.data = b;
        }

        public boolean contains(int key) {
            int v;
            if (key == 0) {
                return this.hasZeroKey;
            }
            int index = this.hash(key);
            while ((v = this.data[index]) != 0) {
                if (v == key) {
                    return true;
                }
                if (index == 0) {
                    index = this.data.length;
                }
                --index;
            }
            return false;
        }

        public boolean forEach(@NotNull IntPredicate consumer) {
            if (consumer == null) {
                AddonlyIntSet.$$$reportNull$$$0(0);
            }
            if (this.hasZeroKey && !consumer.test(0)) {
                return false;
            }
            for (int o : this.data) {
                if (o == 0 || consumer.test(o)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("AddonlyIntSet[");
            int[] items2 = this.toIntArray();
            Arrays.sort(items2);
            for (int item2 : items2) {
                sb.append(item2).append(", ");
            }
            sb.append(']');
            return sb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/util/text/TrigramBuilder$AddonlyIntSet", "forEach"));
        }
    }
}

