/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.util.text.CharSequenceSubSequence;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
@JvmName(name="StringsKmp")
public final class StringsKmp {
    @Contract(pure=true)
    public static final int stringHashCode(@NotNull CharSequence $this$stringHashCode) {
        Intrinsics.checkNotNullParameter((Object)$this$stringHashCode, (String)"<this>");
        if ($this$stringHashCode instanceof String || $this$stringHashCode instanceof CharSequenceWithStringHash) {
            return $this$stringHashCode.hashCode();
        }
        return StringsKmp.stringHashCode$default($this$stringHashCode, 0, $this$stringHashCode.length(), 0, 4, null);
    }

    @JvmOverloads
    @Contract(pure=true)
    public static final int stringHashCode(@NotNull CharSequence $this$stringHashCode, int from, int to, int prefixHash) {
        Intrinsics.checkNotNullParameter((Object)$this$stringHashCode, (String)"<this>");
        int h = prefixHash;
        for (int off = from; off < to; ++off) {
            h = 31 * h + $this$stringHashCode.charAt(off);
        }
        return h;
    }

    public static /* synthetic */ int stringHashCode$default(CharSequence charSequence, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        return StringsKmp.stringHashCode(charSequence, n, n2, n3);
    }

    @Contract(pure=true)
    public static final int stringHashCode(@NotNull char[] $this$stringHashCode, int from, int to) {
        Intrinsics.checkNotNullParameter((Object)$this$stringHashCode, (String)"<this>");
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + $this$stringHashCode[off];
        }
        return h;
    }

    @Contract(pure=true)
    public static final int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence $this$stringHashCodeIgnoreWhitespaces) {
        Intrinsics.checkNotNullParameter((Object)$this$stringHashCodeIgnoreWhitespaces, (String)"<this>");
        int h = 0;
        int n = $this$stringHashCodeIgnoreWhitespaces.length();
        for (int off = 0; off < n; ++off) {
            char c = $this$stringHashCodeIgnoreWhitespaces.charAt(off);
            if (StringsKmp.isSpaceEnterOrTab(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    @Contract(pure=true)
    public static final boolean equalsIgnoreWhitespaces(@NotNull CharSequence $this$equalsIgnoreWhitespaces, @NotNull CharSequence other) {
        Intrinsics.checkNotNullParameter((Object)$this$equalsIgnoreWhitespaces, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int len1 = $this$equalsIgnoreWhitespaces.length();
        int len2 = other.length();
        int index1 = 0;
        int index2 = 0;
        while (index1 < len1 && index2 < len2) {
            if ($this$equalsIgnoreWhitespaces.charAt(index1) == other.charAt(index2)) {
                ++index1;
                ++index2;
                continue;
            }
            boolean skipped = false;
            while (index1 != len1 && StringsKmp.isSpaceEnterOrTab($this$equalsIgnoreWhitespaces.charAt(index1))) {
                skipped = true;
                ++index1;
            }
            while (index2 != len2 && StringsKmp.isSpaceEnterOrTab(other.charAt(index2))) {
                skipped = true;
                ++index2;
            }
            if (skipped) continue;
            return false;
        }
        while (index1 != len1) {
            if (!StringsKmp.isSpaceEnterOrTab($this$equalsIgnoreWhitespaces.charAt(index1))) {
                return false;
            }
            ++index1;
        }
        while (index2 != len2) {
            if (!StringsKmp.isSpaceEnterOrTab(other.charAt(index2))) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    @Contract(pure=true)
    public static final boolean equalsTrimWhitespaces(@NotNull CharSequence $this$equalsTrimWhitespaces, @NotNull CharSequence other) {
        Intrinsics.checkNotNullParameter((Object)$this$equalsTrimWhitespaces, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return StringsKmp.equalsByContents(StringsKmp.trimWhitespace($this$equalsTrimWhitespaces), StringsKmp.trimWhitespace(other));
    }

    private static final CharSequence trimWhitespace(CharSequence $this$trimWhitespace) {
        char c;
        int start2;
        int end = $this$trimWhitespace.length();
        for (start2 = 0; start2 < end && StringsKmp.isSpaceEnterOrTab(c = $this$trimWhitespace.charAt(start2)); ++start2) {
        }
        while (start2 < end && StringsKmp.isSpaceEnterOrTab(c = $this$trimWhitespace.charAt(end - 1))) {
            --end;
        }
        return new CharSequenceSubSequence($this$trimWhitespace, start2, end);
    }

    private static final boolean isSpaceEnterOrTab(char $this$isSpaceEnterOrTab) {
        return $this$isSpaceEnterOrTab == '\n' || $this$isSpaceEnterOrTab == '\t' || $this$isSpaceEnterOrTab == ' ';
    }

    private static final boolean equalsByContents(CharSequence $this$equalsByContents, CharSequence other) {
        if ($this$equalsByContents == other) {
            return true;
        }
        if ($this$equalsByContents == null || other == null) {
            return false;
        }
        if ($this$equalsByContents.length() != other.length()) {
            return false;
        }
        int n = $this$equalsByContents.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if ($this$equalsByContents.charAt(i2) == other.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    @JvmOverloads
    @Contract(pure=true)
    public static final int stringHashCode(@NotNull CharSequence $this$stringHashCode, int from, int to) {
        Intrinsics.checkNotNullParameter((Object)$this$stringHashCode, (String)"<this>");
        return StringsKmp.stringHashCode$default($this$stringHashCode, from, to, 0, 4, null);
    }
}

