/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@JvmName(name="StringUtilKmp")
@ApiStatus.Experimental
public final class StringUtilKmp {
    @Contract(pure=true)
    public static final boolean containsLineBreak(@NotNull CharSequence $this$containsLineBreak) {
        Intrinsics.checkNotNullParameter((Object)$this$containsLineBreak, (String)"<this>");
        int n = $this$containsLineBreak.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = $this$containsLineBreak.charAt(i2);
            if (!StringUtilKmp.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static final boolean isLineBreak(char $this$isLineBreak) {
        return $this$isLineBreak == '\n' || $this$isLineBreak == '\r';
    }

    @Contract(pure=true)
    public static final int getLineBreakCount(@NotNull CharSequence $this$getLineBreakCount) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineBreakCount, (String)"<this>");
        int count = 0;
        block4: for (int i2 = 0; i2 < $this$getLineBreakCount.length(); ++i2) {
            char c = $this$getLineBreakCount.charAt(i2);
            switch (c) {
                case '\n': {
                    ++count;
                    continue block4;
                }
                case '\r': {
                    if (i2 + 1 < $this$getLineBreakCount.length() && $this$getLineBreakCount.charAt(i2 + 1) == '\n') {
                        ++i2;
                    }
                    ++count;
                }
            }
        }
        return count;
    }
}

