/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage;

import com.intellij.internal.statistic.eventLog.validator.rules.impl.EnumValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RegexpValidationRule;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GlobalRulesHolder {
    @Nullable
    private final Map<String, Set<String>> myGlobalEnums;
    @Nullable
    private final Map<String, String> myGlobalRegexps;
    @NotNull
    private final Map<String, RegexpValidationRule> myGlobalRegexpsCache;
    @NotNull
    private final Map<String, EnumValidationRule> myGlobalEnumsCache;

    public GlobalRulesHolder(@Nullable Map<String, ? extends Set<String>> myGlobalEnums, @Nullable Map<String, String> myGlobalRegexps) {
        this.myGlobalEnums = myGlobalEnums;
        this.myGlobalRegexps = myGlobalRegexps;
        this.myGlobalRegexpsCache = new HashMap();
        this.myGlobalEnumsCache = new HashMap();
    }

    public GlobalRulesHolder(@Nullable EventGroupRemoteDescriptors.GroupRemoteRule globalRules) {
        EventGroupRemoteDescriptors.GroupRemoteRule groupRemoteRule = globalRules;
        EventGroupRemoteDescriptors.GroupRemoteRule groupRemoteRule2 = globalRules;
        this(groupRemoteRule != null ? groupRemoteRule.enums : null, groupRemoteRule2 != null ? groupRemoteRule2.regexps : null);
    }

    @Nullable
    public final EnumValidationRule getEnumValidationRules(@NotNull String enumRef) {
        Set<String> globalEnum;
        Intrinsics.checkNotNullParameter((Object)enumRef, (String)"enumRef");
        EnumValidationRule cachedValue = this.myGlobalEnumsCache.get(enumRef);
        if (cachedValue != null) {
            return cachedValue;
        }
        Map<String, Set<String>> map2 = this.myGlobalEnums;
        Set<String> set2 = globalEnum = map2 != null ? map2.get(enumRef) : null;
        if (globalEnum != null) {
            EnumValidationRule rule = new EnumValidationRule((Collection<String>)globalEnum);
            this.myGlobalEnumsCache.put(enumRef, rule);
            return rule;
        }
        return null;
    }

    @Nullable
    public final RegexpValidationRule getRegexpValidationRules(@NotNull String regexpRef) {
        String globalRegexp;
        Intrinsics.checkNotNullParameter((Object)regexpRef, (String)"regexpRef");
        RegexpValidationRule cachedValue = this.myGlobalRegexpsCache.get(regexpRef);
        if (cachedValue != null) {
            return cachedValue;
        }
        Map<String, String> map2 = this.myGlobalRegexps;
        String string = globalRegexp = map2 != null ? map2.get(regexpRef) : null;
        if (globalRegexp != null) {
            RegexpValidationRule rule = new RegexpValidationRule(globalRegexp);
            this.myGlobalRegexpsCache.put(regexpRef, rule);
            return rule;
        }
        return null;
    }
}

