/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nStatisticsEventEscaper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsEventEscaper.kt\ncom/intellij/internal/statistic/eventLog/StatisticsEventEscaper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,256:1\n1549#2:257\n1620#2,3:258\n1179#2,2:261\n1253#2,4:263\n11065#3:267\n11400#3,3:268\n*S KotlinDebug\n*F\n+ 1 StatisticsEventEscaper.kt\ncom/intellij/internal/statistic/eventLog/StatisticsEventEscaper\n*L\n88#1:257\n88#1:258,3\n90#1:261,2\n90#1:263,4\n16#1:267\n16#1:268,3\n*E\n"})
public final class StatisticsEventEscaper {
    @NotNull
    public static final StatisticsEventEscaper INSTANCE;
    @NotNull
    private static final Set<String> VALIDATION_RESULT_TYPES;

    private StatisticsEventEscaper() {
    }

    @JvmStatic
    @NotNull
    public static final String escapeEventIdOrFieldValue(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.escapeInternal(str, null, true);
    }

    @JvmStatic
    @Nullable
    public static final String cleanupForLegacyRulesIfNeeded(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.containsSystemSymbols(str, ":;, ") ? INSTANCE.replace(str, ":;, ", false) : null;
    }

    private final String escapeInternal(String str, String toReplace, boolean allowSpaces) {
        return this.containsSystemSymbols(str, toReplace) ? this.replace(str, toReplace, allowSpaces) : str;
    }

    private final String replace(String value2, String toReplace, boolean allowSpaces) {
        StringBuilder out = new StringBuilder();
        int n = value2.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = value2.charAt(i2);
            if (!this.isAscii(c)) {
                out.append("?");
                continue;
            }
            if (this.isWhiteSpaceToReplace(c)) {
                out.append(allowSpaces ? " " : "_");
                continue;
            }
            if (this.isSymbolToReplace(c, toReplace)) {
                out.append("_");
                continue;
            }
            if (this.isProhibitedSymbol(c)) continue;
            out.append(c);
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"out.toString()");
        return string;
    }

    private final boolean containsSystemSymbols(String value2, String toReplace) {
        int n = value2.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = value2.charAt(i2);
            if (!this.isAscii(c)) {
                return true;
            }
            if (this.isWhiteSpaceToReplace(c)) {
                return true;
            }
            if (this.isSymbolToReplace(c, toReplace)) {
                return true;
            }
            if (!this.isProhibitedSymbol(c)) continue;
            return true;
        }
        return false;
    }

    private final boolean isAscii(char c) {
        return c <= '\u007f';
    }

    private final boolean isSymbolToReplace(char c, String toReplace) {
        return toReplace != null && this.containsChar(toReplace, c) ? true : this.isAsciiControl(c);
    }

    public final boolean isWhiteSpaceToReplace(char c) {
        return c == '\n' || c == '\r' || c == '\t';
    }

    private final boolean isAsciiControl(char c) {
        return c < ' ' || c == '\u007f';
    }

    private final boolean isProhibitedSymbol(char c) {
        return c == '\'' || c == '\"';
    }

    private final boolean containsChar(String str, char c) {
        int n = str.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (str.charAt(i2) != c) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        INSTANCE = new StatisticsEventEscaper();
        ValidationResultType[] $this$map$iv = ValidationResultType.values();
        boolean $i$f$map = false;
        ValidationResultType[] validationResultTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var8_8 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDescription());
        }
        VALIDATION_RESULT_TYPES = CollectionsKt.toSet((Iterable)((List)var3_3));
    }
}

