/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.debug.internal.DebugCoroutineInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JobTree {
    @NotNull
    private final Job job;
    @Nullable
    private final DebugCoroutineInfo debugInfo;
    @NotNull
    private final List<JobTree> children;

    public JobTree(@NotNull Job job2, @Nullable DebugCoroutineInfo debugInfo, @NotNull List<JobTree> children) {
        Intrinsics.checkNotNullParameter((Object)job2, (String)"job");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.job = job2;
        this.debugInfo = debugInfo;
        this.children = children;
    }

    @NotNull
    public final Job getJob() {
        return this.job;
    }

    @Nullable
    public final DebugCoroutineInfo getDebugInfo() {
        return this.debugInfo;
    }

    @NotNull
    public final List<JobTree> getChildren() {
        return this.children;
    }

    @NotNull
    public String toString() {
        return "JobTree(job=" + this.job + ", debugInfo=" + this.debugInfo + ", children=" + this.children + ')';
    }

    public int hashCode() {
        int result2 = this.job.hashCode();
        result2 = result2 * 31 + (this.debugInfo == null ? 0 : this.debugInfo.hashCode());
        result2 = result2 * 31 + ((Object)this.children).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JobTree)) {
            return false;
        }
        JobTree jobTree = (JobTree)other;
        if (!Intrinsics.areEqual((Object)this.job, (Object)jobTree.job)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.debugInfo, (Object)jobTree.debugInfo)) {
            return false;
        }
        return Intrinsics.areEqual(this.children, jobTree.children);
    }
}

