/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.JobRepresentation;
import com.intellij.diagnostic.JobRepresentationTree;
import java.util.Collection;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\ncoroutineDumper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coroutineDumper.kt\ncom/intellij/diagnostic/DeduplicatedJobRepresentationTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,400:1\n1869#2,2:401\n*S KotlinDebug\n*F\n+ 1 coroutineDumper.kt\ncom/intellij/diagnostic/DeduplicatedJobRepresentationTree\n*L\n244#1:401,2\n*E\n"})
final class DeduplicatedJobRepresentationTree
extends JobRepresentationTree {
    private final int count;
    @NotNull
    private final Set<DeduplicatedJobRepresentationTree> children;
    @NotNull
    private final Lazy treeHash$delegate;

    public DeduplicatedJobRepresentationTree(int count, @NotNull JobRepresentation job2, @NotNull Set<DeduplicatedJobRepresentationTree> children) {
        Intrinsics.checkNotNullParameter((Object)job2, (String)"job");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        super(job2, (Collection<? extends JobRepresentationTree>)children);
        this.count = count;
        this.children = children;
        this.treeHash$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> DeduplicatedJobRepresentationTree.treeHash_delegate$lambda$0(this, job2));
    }

    @NotNull
    public Set<DeduplicatedJobRepresentationTree> getChildren() {
        return this.children;
    }

    @Override
    public void write(@NotNull Appendable out, int indentLevel) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        String countInfo = this.count == 1 ? "" : "[x" + this.count + " of]";
        this.getJob().write(out, indentLevel, countInfo);
        Iterable $this$forEach$iv = this.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeduplicatedJobRepresentationTree it = (DeduplicatedJobRepresentationTree)element$iv;
            boolean bl = false;
            it.write(out, indentLevel + 1);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.diagnostic.DeduplicatedJobRepresentationTree");
        DeduplicatedJobRepresentationTree cfr_ignored_0 = (DeduplicatedJobRepresentationTree)object2;
        return this.count == ((DeduplicatedJobRepresentationTree)other).count && Intrinsics.areEqual((Object)this.getJob(), (Object)((DeduplicatedJobRepresentationTree)other).getJob()) && Intrinsics.areEqual((Object)this.getChildren(), (Object)((DeduplicatedJobRepresentationTree)other).getChildren());
    }

    private final int getTreeHash() {
        Lazy lazy = this.treeHash$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public int hashCode() {
        return this.getTreeHash();
    }

    private static final int treeHash_delegate$lambda$0(DeduplicatedJobRepresentationTree this$0, JobRepresentation $job) {
        int hash = this$0.count;
        hash = 31 * hash + $job.hashCode();
        hash = 31 * hash + ((Object)this$0.getChildren()).hashCode();
        return hash;
    }
}

