/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Internal;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.SingleFieldBuilderV3;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public class RepeatedFieldBuilderV3<MType extends AbstractMessage, BType extends AbstractMessage.Builder, IType extends MessageOrBuilder>
implements AbstractMessage.BuilderParent {
    private AbstractMessage.BuilderParent parent;
    private List<MType> messages;
    private boolean isMessagesListMutable;
    private List<SingleFieldBuilderV3<MType, BType, IType>> builders;
    private boolean isClean;
    private MessageExternalList<MType, BType, IType> externalMessageList;
    private BuilderExternalList<MType, BType, IType> externalBuilderList;
    private MessageOrBuilderExternalList<MType, BType, IType> externalMessageOrBuilderList;

    public RepeatedFieldBuilderV3(List<MType> messages2, boolean isMessagesListMutable, AbstractMessage.BuilderParent parent, boolean isClean) {
        this.messages = messages2;
        this.isMessagesListMutable = isMessagesListMutable;
        this.parent = parent;
        this.isClean = isClean;
    }

    public void dispose() {
        this.parent = null;
    }

    private void ensureMutableMessageList() {
        if (!this.isMessagesListMutable) {
            this.messages = new ArrayList<MType>(this.messages);
            this.isMessagesListMutable = true;
        }
    }

    private void ensureBuilders() {
        if (this.builders == null) {
            this.builders = new ArrayList<SingleFieldBuilderV3<MType, BType, IType>>(this.messages.size());
            for (int i2 = 0; i2 < this.messages.size(); ++i2) {
                this.builders.add(null);
            }
        }
    }

    public int getCount() {
        return this.messages.size();
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public MType getMessage(int index) {
        return this.getMessage(index, false);
    }

    private MType getMessage(int index, boolean forBuild) {
        if (this.builders == null) {
            return (MType)((AbstractMessage)this.messages.get(index));
        }
        SingleFieldBuilderV3<MType, BType, IType> builder = this.builders.get(index);
        if (builder == null) {
            return (MType)((AbstractMessage)this.messages.get(index));
        }
        return forBuild ? builder.build() : builder.getMessage();
    }

    public BType getBuilder(int index) {
        this.ensureBuilders();
        SingleFieldBuilderV3<Object, BType, IType> builder = this.builders.get(index);
        if (builder == null) {
            AbstractMessage message2 = (AbstractMessage)this.messages.get(index);
            builder = new SingleFieldBuilderV3(message2, this, this.isClean);
            this.builders.set(index, builder);
        }
        return builder.getBuilder();
    }

    public IType getMessageOrBuilder(int index) {
        if (this.builders == null) {
            return (IType)((MessageOrBuilder)this.messages.get(index));
        }
        SingleFieldBuilderV3<MType, BType, IType> builder = this.builders.get(index);
        if (builder == null) {
            return (IType)((MessageOrBuilder)this.messages.get(index));
        }
        return builder.getMessageOrBuilder();
    }

    public RepeatedFieldBuilderV3<MType, BType, IType> addMessage(MType message2) {
        Internal.checkNotNull(message2);
        this.ensureMutableMessageList();
        this.messages.add(message2);
        if (this.builders != null) {
            this.builders.add(null);
        }
        this.onChanged();
        this.incrementModCounts();
        return this;
    }

    public RepeatedFieldBuilderV3<MType, BType, IType> addAllMessages(Iterable<? extends MType> values) {
        for (AbstractMessage value2 : values) {
            Internal.checkNotNull(value2);
        }
        int size = -1;
        if (values instanceof Collection) {
            Collection collection = (Collection)values;
            if (collection.isEmpty()) {
                return this;
            }
            size = collection.size();
        }
        this.ensureMutableMessageList();
        if (size >= 0 && this.messages instanceof ArrayList) {
            ((ArrayList)this.messages).ensureCapacity(this.messages.size() + size);
        }
        for (AbstractMessage value3 : values) {
            this.addMessage(value3);
        }
        this.onChanged();
        this.incrementModCounts();
        return this;
    }

    public List<MType> build() {
        int i2;
        this.isClean = true;
        if (!this.isMessagesListMutable && this.builders == null) {
            return this.messages;
        }
        boolean allMessagesInSync = true;
        if (!this.isMessagesListMutable) {
            for (i2 = 0; i2 < this.messages.size(); ++i2) {
                Message message2 = (Message)this.messages.get(i2);
                SingleFieldBuilderV3<MType, BType, IType> builder = this.builders.get(i2);
                if (builder == null || builder.build() == message2) continue;
                allMessagesInSync = false;
                break;
            }
            if (allMessagesInSync) {
                return this.messages;
            }
        }
        this.ensureMutableMessageList();
        for (i2 = 0; i2 < this.messages.size(); ++i2) {
            this.messages.set(i2, this.getMessage(i2, true));
        }
        this.messages = Collections.unmodifiableList(this.messages);
        this.isMessagesListMutable = false;
        return this.messages;
    }

    private void onChanged() {
        if (this.isClean && this.parent != null) {
            this.parent.markDirty();
            this.isClean = false;
        }
    }

    @Override
    public void markDirty() {
        this.onChanged();
    }

    private void incrementModCounts() {
        if (this.externalMessageList != null) {
            this.externalMessageList.incrementModCount();
        }
        if (this.externalBuilderList != null) {
            this.externalBuilderList.incrementModCount();
        }
        if (this.externalMessageOrBuilderList != null) {
            this.externalMessageOrBuilderList.incrementModCount();
        }
    }

    private static class MessageOrBuilderExternalList<MType extends AbstractMessage, BType extends AbstractMessage.Builder, IType extends MessageOrBuilder>
    extends AbstractList<IType>
    implements List<IType>,
    RandomAccess {
        RepeatedFieldBuilderV3<MType, BType, IType> builder;

        @Override
        public int size() {
            return this.builder.getCount();
        }

        @Override
        public IType get(int index) {
            return this.builder.getMessageOrBuilder(index);
        }

        void incrementModCount() {
            ++this.modCount;
        }
    }

    private static class BuilderExternalList<MType extends AbstractMessage, BType extends AbstractMessage.Builder, IType extends MessageOrBuilder>
    extends AbstractList<BType>
    implements List<BType>,
    RandomAccess {
        RepeatedFieldBuilderV3<MType, BType, IType> builder;

        @Override
        public int size() {
            return this.builder.getCount();
        }

        @Override
        public BType get(int index) {
            return this.builder.getBuilder(index);
        }

        void incrementModCount() {
            ++this.modCount;
        }
    }

    private static class MessageExternalList<MType extends AbstractMessage, BType extends AbstractMessage.Builder, IType extends MessageOrBuilder>
    extends AbstractList<MType>
    implements List<MType>,
    RandomAccess {
        RepeatedFieldBuilderV3<MType, BType, IType> builder;

        @Override
        public int size() {
            return this.builder.getCount();
        }

        @Override
        public MType get(int index) {
            return this.builder.getMessage(index);
        }

        void incrementModCount() {
            ++this.modCount;
        }
    }
}

