/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.platform.DesktopFont_desktopKt;
import androidx.compose.ui.text.platform.FileFont;
import androidx.compose.ui.text.platform.LoadedFont;
import androidx.compose.ui.text.platform.Platform;
import androidx.compose.ui.text.platform.PlatformFont;
import androidx.compose.ui.text.platform.PlatformFont_skikoKt;
import androidx.compose.ui.text.platform.ResourceFont;
import androidx.compose.ui.text.platform.SystemFont;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.FontMgr;
import org.jetbrains.skia.FontSlant;
import org.jetbrains.skia.Typeface;

@SourceDebugExtension(value={"SMAP\nDesktopFont.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopFont.desktop.kt\nandroidx/compose/ui/text/platform/DesktopFont_desktopKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1#2:240\n*E\n"})
public final class DesktopFont_desktopKt {
    @NotNull
    public static final Typeface loadTypeface(@NotNull Font font) {
        Typeface typeface2;
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        if (!(font instanceof PlatformFont)) {
            throw new IllegalArgumentException("Unsupported font type: " + font);
        }
        PlatformFont platformFont = (PlatformFont)font;
        if (platformFont instanceof ResourceFont) {
            typeface2 = DesktopFont_desktopKt.typefaceResource(((ResourceFont)font).getName());
        } else if (platformFont instanceof FileFont) {
            FontMgr fontMgr = FontMgr.Companion.getDefault();
            String string = ((FileFont)font).getFile().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            typeface2 = FontMgr.makeFromFile$default((FontMgr)fontMgr, (String)string, (int)0, (int)2, null);
        } else if (platformFont instanceof LoadedFont) {
            typeface2 = FontMgr.makeFromData$default((FontMgr)FontMgr.Companion.getDefault(), (Data)Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])((byte[])((LoadedFont)font).getGetData$ui_text().invoke()), (int)0, (int)0, (int)6, null), (int)0, (int)2, null);
        } else if (platformFont instanceof SystemFont) {
            typeface2 = FontMgr.Companion.getDefault().matchFamilyStyle(((SystemFont)font).getIdentity(), DesktopFont_desktopKt.getSkFontStyle(font));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Typeface typeface3 = typeface2;
        if (typeface2 == null && (typeface3 = FontMgr.Companion.getDefault().legacyMakeTypeface(((PlatformFont)font).getIdentity(), DesktopFont_desktopKt.getSkFontStyle(font))) == null) {
            throw new IllegalStateException("loadTypeface legacyMakeTypeface failed".toString());
        }
        Typeface typeface4 = typeface3;
        return PlatformFont_skikoKt.cloneWithVariationSettings(typeface4, ((PlatformFont)font).getVariationSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Typeface typefaceResource(String resourceName) {
        byte[] byArray;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Intrinsics.checkNotNull((Object)classLoader);
        ClassLoader contextClassLoader = classLoader;
        InputStream inputStream = contextClassLoader.getResourceAsStream(resourceName);
        if (inputStream == null && (inputStream = ((Object)((Object)typefaceResource.resource.1.INSTANCE)).getClass().getResourceAsStream(resourceName)) == null) {
            throw new IllegalStateException(("Can't load font from " + resourceName).toString());
        }
        InputStream resource2 = inputStream;
        Closeable closeable = resource2;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            byArray = it.readAllBytes();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] bytes2 = byArray;
        FontMgr fontMgr = FontMgr.Companion.getDefault();
        Intrinsics.checkNotNull((Object)bytes2);
        Typeface typeface2 = FontMgr.makeFromData$default((FontMgr)fontMgr, (Data)Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])bytes2, (int)0, (int)0, (int)6, null), (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)typeface2);
        return typeface2;
    }

    private static final org.jetbrains.skia.FontStyle getSkFontStyle(Font $this$skFontStyle) {
        return new org.jetbrains.skia.FontStyle($this$skFontStyle.getWeight().getWeight(), 5, FontStyle.equals-impl0($this$skFontStyle.getStyle-_-LCdwA(), FontStyle.Companion.getItalic-_-LCdwA()) ? FontSlant.ITALIC : FontSlant.UPRIGHT);
    }

    @NotNull
    public static final Platform currentPlatform() {
        String name2 = System.getProperty("os.name");
        Intrinsics.checkNotNull((Object)name2);
        return StringsKt.startsWith$default((String)name2, (String)"Linux", (boolean)false, (int)2, null) ? Platform.Linux : (StringsKt.startsWith$default((String)name2, (String)"Win", (boolean)false, (int)2, null) ? Platform.Windows : (Intrinsics.areEqual((Object)name2, (Object)"Mac OS X") ? Platform.MacOS : Platform.Unknown));
    }

    public static final /* synthetic */ Typeface access$typefaceResource(String resourceName) {
        return DesktopFont_desktopKt.typefaceResource(resourceName);
    }
}

