/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.PlatformSpanStyle;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextDecorationLineStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontSynthesis;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.intl.LocaleList;
import androidx.compose.ui.text.platform.FontLoadResult;
import androidx.compose.ui.text.platform.SkiaParagraph_skikoKt;
import androidx.compose.ui.text.platform.SkiaParagraph_skikoKt__ParagraphBuilder_skikoKt;
import androidx.compose.ui.text.platform.SkiaTextPaint;
import androidx.compose.ui.text.style.BaselineShift;
import androidx.compose.ui.text.style.LineHeightStyle;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.text.style.TextForegroundStyle;
import androidx.compose.ui.text.style.TextGeometricTransform;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.TextUnit;
import java.util.Collection;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.FontFeature;
import org.jetbrains.skia.FontMetrics;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.PaintMode;
import org.jetbrains.skia.paragraph.TextStyle;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nParagraphBuilder.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParagraphBuilder.skiko.kt\nandroidx/compose/ui/text/platform/ComputedStyle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TextUnit.kt\nandroidx/compose/ui/unit/TextUnitKt\n+ 4 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,750:1\n1#2:751\n242#3,6:752\n242#3,6:758\n247#3:769\n635#4:764\n635#4:770\n37#5:765\n36#5,3:766\n*S KotlinDebug\n*F\n+ 1 ParagraphBuilder.skiko.kt\nandroidx/compose/ui/text/platform/ComputedStyle\n*L\n135#1:752,6\n147#1:758,6\n236#1:769\n169#1:764\n242#1:770\n211#1:765\n211#1:766,3\n*E\n"})
final class ComputedStyle {
    @NotNull
    private TextForegroundStyle textForegroundStyle;
    private long brushSize;
    private float fontSize;
    @Nullable
    private FontWeight fontWeight;
    @Nullable
    private FontStyle fontStyle;
    @Nullable
    private FontSynthesis fontSynthesis;
    @Nullable
    private FontFamily fontFamily;
    @Nullable
    private String fontFeatureSettings;
    @Nullable
    private Float letterSpacing;
    @Nullable
    private BaselineShift baselineShift;
    @Nullable
    private TextGeometricTransform textGeometricTransform;
    @Nullable
    private LocaleList localeList;
    private long background;
    @Nullable
    private TextDecoration textDecoration;
    @Nullable
    private TextDecorationLineStyle textDecorationLineStyle;
    @Nullable
    private Shadow shadow;
    @Nullable
    private DrawStyle drawStyle;
    private int blendMode;
    @Nullable
    private Float lineHeight;
    private float topRatio;
    @NotNull
    private final SkiaTextPaint _foregroundPaint;

    private ComputedStyle(TextForegroundStyle textForegroundStyle, long brushSize, float fontSize, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, FontFamily fontFamily, String fontFeatureSettings, Float letterSpacing, BaselineShift baselineShift, TextGeometricTransform textGeometricTransform, LocaleList localeList, long background, TextDecoration textDecoration, TextDecorationLineStyle textDecorationLineStyle, Shadow shadow, DrawStyle drawStyle, int blendMode, Float lineHeight, float topRatio) {
        Intrinsics.checkNotNullParameter((Object)textForegroundStyle, (String)"textForegroundStyle");
        this.textForegroundStyle = textForegroundStyle;
        this.brushSize = brushSize;
        this.fontSize = fontSize;
        this.fontWeight = fontWeight;
        this.fontStyle = fontStyle;
        this.fontSynthesis = fontSynthesis;
        this.fontFamily = fontFamily;
        this.fontFeatureSettings = fontFeatureSettings;
        this.letterSpacing = letterSpacing;
        this.baselineShift = baselineShift;
        this.textGeometricTransform = textGeometricTransform;
        this.localeList = localeList;
        this.background = background;
        this.textDecoration = textDecoration;
        this.textDecorationLineStyle = textDecorationLineStyle;
        this.shadow = shadow;
        this.drawStyle = drawStyle;
        this.blendMode = blendMode;
        this.lineHeight = lineHeight;
        this.topRatio = topRatio;
        this._foregroundPaint = new SkiaTextPaint();
    }

    public /* synthetic */ ComputedStyle(TextForegroundStyle textForegroundStyle, long l, float f, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, FontFamily fontFamily, String string, Float f2, BaselineShift baselineShift, TextGeometricTransform textGeometricTransform, LocaleList localeList, long l2, TextDecoration textDecoration, TextDecorationLineStyle textDecorationLineStyle, Shadow shadow, DrawStyle drawStyle, int n, Float f3, float f4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            textForegroundStyle = TextForegroundStyle.Unspecified.INSTANCE;
        }
        if ((n2 & 2) != 0) {
            l = Size.Companion.getUnspecified-NH-jbRc();
        }
        if ((n2 & 4) != 0) {
            f = Float.NaN;
        }
        if ((n2 & 8) != 0) {
            fontWeight = null;
        }
        if ((n2 & 0x10) != 0) {
            fontStyle = null;
        }
        if ((n2 & 0x20) != 0) {
            fontSynthesis = null;
        }
        if ((n2 & 0x40) != 0) {
            fontFamily = null;
        }
        if ((n2 & 0x80) != 0) {
            string = null;
        }
        if ((n2 & 0x100) != 0) {
            f2 = null;
        }
        if ((n2 & 0x200) != 0) {
            baselineShift = null;
        }
        if ((n2 & 0x400) != 0) {
            textGeometricTransform = null;
        }
        if ((n2 & 0x800) != 0) {
            localeList = null;
        }
        if ((n2 & 0x1000) != 0) {
            l2 = Color.Companion.getUnspecified-0d7_KjU();
        }
        if ((n2 & 0x2000) != 0) {
            textDecoration = null;
        }
        if ((n2 & 0x4000) != 0) {
            textDecorationLineStyle = null;
        }
        if ((n2 & 0x8000) != 0) {
            shadow = null;
        }
        if ((n2 & 0x10000) != 0) {
            drawStyle = null;
        }
        if ((n2 & 0x20000) != 0) {
            n = DrawScope.Companion.getDefaultBlendMode-0nO6VwU();
        }
        if ((n2 & 0x40000) != 0) {
            f3 = null;
        }
        if ((n2 & 0x80000) != 0) {
            f4 = -1.0f;
        }
        this(textForegroundStyle, l, f, fontWeight, fontStyle, fontSynthesis, fontFamily, string, f2, baselineShift, textGeometricTransform, localeList, l2, textDecoration, textDecorationLineStyle, shadow, drawStyle, n, f3, f4, null);
    }

    public final float getFontSize() {
        return this.fontSize;
    }

    @Nullable
    public final FontWeight getFontWeight() {
        return this.fontWeight;
    }

    @Nullable
    public final FontStyle getFontStyle-4Lr2A7w() {
        return this.fontStyle;
    }

    @Nullable
    public final FontSynthesis getFontSynthesis-ZQGJjVo() {
        return this.fontSynthesis;
    }

    @Nullable
    public final FontFamily getFontFamily() {
        return this.fontFamily;
    }

    @Nullable
    public final Float getLineHeight() {
        return this.lineHeight;
    }

    public final float getTopRatio() {
        return this.topRatio;
    }

    private ComputedStyle(Density density, SpanStyle spanStyle, long brushSize, int blendMode, long lineHeight, LineHeightStyle lineHeightStyle) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)spanStyle, (String)"spanStyle");
        this(null, 0L, 0.0f, null, null, null, null, null, null, null, null, null, 0L, null, null, null, null, 0, null, 0.0f, 1048575, null);
        this.set-qIERHQ8(density, spanStyle, brushSize, blendMode, lineHeight, lineHeightStyle);
    }

    /*
     * WARNING - void declaration
     */
    public final void set-qIERHQ8(@NotNull Density density, @NotNull SpanStyle spanStyle, long brushSize, int blendMode, long lineHeight, @Nullable LineHeightStyle lineHeightStyle) {
        float alignment;
        Float f;
        void $this$set_qIERHQ8_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)spanStyle, (String)"spanStyle");
        this.textForegroundStyle = spanStyle.getTextForegroundStyle$ui_text();
        this.brushSize = brushSize;
        Density density2 = density;
        ComputedStyle computedStyle = this;
        boolean bl = false;
        computedStyle.fontSize = ((Number)Float.valueOf($this$set_qIERHQ8_u24lambda_u240.toPx--R2X_6o(spanStyle.getFontSize-XSAIIZE()))).floatValue();
        this.fontWeight = spanStyle.getFontWeight();
        this.fontStyle = spanStyle.getFontStyle-4Lr2A7w();
        this.fontSynthesis = spanStyle.getFontSynthesis-ZQGJjVo();
        this.fontFamily = spanStyle.getFontFamily();
        this.fontFeatureSettings = spanStyle.getFontFeatureSettings();
        ComputedStyle computedStyle2 = this;
        long $this$isSpecified$iv2 = spanStyle.getLetterSpacing-XSAIIZE();
        boolean bl2 = false;
        long $this$isUnspecified$iv$iv = $this$isSpecified$iv2;
        boolean bl3 = false;
        if (!(TextUnit.getRawType-impl($this$isUnspecified$iv$iv) == 0L)) {
            void $this$set_qIERHQ8_u24lambda_u241;
            Density $this$isSpecified$iv2 = density;
            computedStyle = computedStyle2;
            boolean bl4 = false;
            f = Float.valueOf($this$set_qIERHQ8_u24lambda_u241.toPx--R2X_6o(spanStyle.getLetterSpacing-XSAIIZE()));
            computedStyle2 = computedStyle;
        } else {
            f = null;
        }
        computedStyle2.letterSpacing = f;
        this.baselineShift = spanStyle.getBaselineShift-5SSeXJ0();
        this.textGeometricTransform = spanStyle.getTextGeometricTransform();
        this.localeList = spanStyle.getLocaleList();
        this.background = spanStyle.getBackground-0d7_KjU();
        this.textDecoration = spanStyle.getTextDecoration();
        PlatformSpanStyle platformSpanStyle = spanStyle.getPlatformStyle();
        this.textDecorationLineStyle = platformSpanStyle != null ? platformSpanStyle.getTextDecorationLineStyle-Gch4ia8() : null;
        this.shadow = spanStyle.getShadow();
        this.drawStyle = spanStyle.getDrawStyle();
        this.blendMode = blendMode;
        long $this$isSpecified$iv3 = lineHeight;
        bl2 = false;
        $this$isUnspecified$iv$iv = $this$isSpecified$iv3;
        bl3 = false;
        this.lineHeight = !(TextUnit.getRawType-impl($this$isUnspecified$iv$iv) == 0L) ? Float.valueOf(SkiaParagraph_skikoKt__ParagraphBuilder_skikoKt.access$toPx-PoKjXmU(lineHeight, density, spanStyle.getFontSize-XSAIIZE())) : null;
        LineHeightStyle lineHeightStyle2 = lineHeightStyle;
        this.topRatio = alignment = lineHeightStyle2 != null ? lineHeightStyle2.getAlignment-PIaL0Z0() : LineHeightStyle.Alignment.Companion.getProportional-PIaL0Z0();
    }

    @NotNull
    public final Paint getForegroundPaint() {
        Paint paint = this._foregroundPaint.asFrameworkPaint();
        paint.reset();
        this._foregroundPaint.setColor-8_81llA(this.textForegroundStyle.getColor-0d7_KjU());
        this._foregroundPaint.setBrush-12SF9DM(this.textForegroundStyle.getBrush(), this.brushSize, this.textForegroundStyle.getAlpha());
        this._foregroundPaint.setDrawStyle(this.drawStyle);
        this._foregroundPaint.setBlendMode-s9anfk8(this.blendMode);
        return paint;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TextStyle toSkTextStyle(@NotNull FontFamily.Resolver fontFamilyResolver) {
        String string;
        Paint foreground;
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        TextStyle res2 = new TextStyle();
        long $this$isSpecified$iv = this.textForegroundStyle.getColor-0d7_KjU();
        boolean bl4 = false;
        if ($this$isSpecified$iv != 16L) {
            res2.setColor(ColorKt.toArgb-8_81llA(this.textForegroundStyle.getColor-0d7_KjU()));
        }
        if ((foreground = this.getForegroundPaint()).getShader() != null || foreground.getMode() != PaintMode.FILL || !foreground.isSrcOver()) {
            res2.setForeground(foreground);
        }
        FontStyle fontStyle = this.fontStyle;
        if (fontStyle != null) {
            int it = fontStyle.unbox-impl();
            boolean bl2 = false;
            res2.setFontStyle(SkiaParagraph_skikoKt.toSkFontStyle-nzbMABs(it));
        }
        TextDecoration textDecoration = this.textDecoration;
        if (textDecoration != null) {
            TextDecoration it = textDecoration;
            boolean bl3 = false;
            res2.setDecorationStyle(SkiaParagraph_skikoKt__ParagraphBuilder_skikoKt.access$toSkDecorationStyle-zoh9Kos(it, this.textForegroundStyle.getColor-0d7_KjU(), this.textDecorationLineStyle));
        }
        if (!Color.equals-impl0(this.background, Color.Companion.getUnspecified-0d7_KjU())) {
            void it;
            Paint paint;
            Paint bl4 = paint = new Paint();
            TextStyle textStyle = res2;
            boolean bl5 = false;
            it.setColor(ColorKt.toArgb-8_81llA(this.background));
            textStyle.setBackground(paint);
        }
        FontWeight fontWeight = this.fontWeight;
        if (fontWeight != null) {
            FontWeight it = fontWeight;
            boolean bl6 = false;
            res2.setFontStyle(res2.getFontStyle().withWeight(it.getWeight()));
        }
        Shadow shadow = this.shadow;
        if (shadow != null) {
            Shadow it = shadow;
            boolean bl7 = false;
            res2.addShadow(SkiaParagraph_skikoKt.toSkShadow(it));
        }
        Float f = this.letterSpacing;
        if (f != null) {
            float it = ((Number)f).floatValue();
            boolean bl8 = false;
            res2.setLetterSpacing(it);
        }
        if ((string = this.fontFeatureSettings) == null) {
            string = "";
        }
        res2.addFontFeatures(FontFeature.Companion.parseW3(string));
        res2.setFontSize(this.fontSize);
        FontFamily fontFamily = this.fontFamily;
        if (fontFamily != null) {
            FontFamily it = fontFamily;
            boolean bl9 = false;
            FontWeight fontWeight2 = this.fontWeight;
            if (fontWeight2 == null) {
                fontWeight2 = FontWeight.Companion.getNormal();
            }
            FontStyle fontStyle2 = this.fontStyle;
            FontSynthesis fontSynthesis = this.fontSynthesis;
            Object object = fontFamilyResolver.resolve-DPcqOEQ(it, fontWeight2, fontStyle2 != null ? fontStyle2.unbox-impl() : FontStyle.Companion.getNormal-_-LCdwA(), fontSynthesis != null ? fontSynthesis.unbox-impl() : FontSynthesis.Companion.getNone-GVVA2EU()).getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type androidx.compose.ui.text.platform.FontLoadResult");
            FontLoadResult resolved = (FontLoadResult)object;
            Collection $this$toTypedArray$iv = resolved.getAliases();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            res2.setFontFamilies(thisCollection$iv.toArray(new String[0]));
            res2.setTypeface(resolved.getTypeface());
        }
        BaselineShift baselineShift = this.baselineShift;
        if (baselineShift != null) {
            float it = baselineShift.unbox-impl();
            boolean bl10 = false;
            FontMetrics fontMetrics = res2.getFontMetrics();
            res2.setBaselineShift(it * fontMetrics.getAscent());
        }
        Float f2 = this.lineHeight;
        if (f2 != null) {
            float it = ((Number)f2).floatValue();
            boolean bl11 = false;
            res2.setHeight(Float.valueOf(it / this.fontSize));
        }
        res2.setTopRatio(this.topRatio);
        return res2;
    }

    public final void merge(@NotNull Density density, @NotNull SpanStyle other) {
        block14: {
            Object it;
            Intrinsics.checkNotNullParameter((Object)density, (String)"density");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            float fontSize = SkiaParagraph_skikoKt__ParagraphBuilder_skikoKt.access$toPx-o2QH7mI(other.getFontSize-XSAIIZE(), density, this.fontSize);
            this.textForegroundStyle = this.textForegroundStyle.merge(other.getTextForegroundStyle$ui_text());
            FontFamily fontFamily = other.getFontFamily();
            if (fontFamily != null) {
                it = fontFamily;
                boolean bl = false;
                this.fontFamily = it;
            }
            this.fontSize = fontSize;
            FontWeight fontWeight = other.getFontWeight();
            if (fontWeight != null) {
                it = fontWeight;
                boolean bl = false;
                this.fontWeight = it;
            }
            FontStyle fontStyle = other.getFontStyle-4Lr2A7w();
            if (fontStyle != null) {
                int it2 = fontStyle.unbox-impl();
                boolean bl = false;
                this.fontStyle = FontStyle.box-impl(it2);
            }
            FontSynthesis fontSynthesis = other.getFontSynthesis-ZQGJjVo();
            if (fontSynthesis != null) {
                int it3 = fontSynthesis.unbox-impl();
                boolean bl = false;
                this.fontSynthesis = FontSynthesis.box-impl(it3);
            }
            String string = other.getFontFeatureSettings();
            if (string != null) {
                String it4 = string;
                boolean bl = false;
                this.fontFeatureSettings = it4;
            }
            long $this$isUnspecified$iv = other.getLetterSpacing-XSAIIZE();
            boolean bl = false;
            if (!(TextUnit.getRawType-impl($this$isUnspecified$iv) == 0L)) {
                this.letterSpacing = Float.valueOf(SkiaParagraph_skikoKt__ParagraphBuilder_skikoKt.access$toPx-o2QH7mI(other.getLetterSpacing-XSAIIZE(), density, fontSize));
            }
            BaselineShift baselineShift = other.getBaselineShift-5SSeXJ0();
            if (baselineShift != null) {
                float it5 = baselineShift.unbox-impl();
                boolean bl2 = false;
                this.baselineShift = BaselineShift.box-impl(it5);
            }
            TextGeometricTransform textGeometricTransform = other.getTextGeometricTransform();
            if (textGeometricTransform != null) {
                TextGeometricTransform it6 = textGeometricTransform;
                boolean bl3 = false;
                this.textGeometricTransform = it6;
            }
            LocaleList localeList = other.getLocaleList();
            if (localeList != null) {
                LocaleList it7 = localeList;
                boolean bl4 = false;
                this.localeList = it7;
            }
            long $this$isSpecified$iv = other.getBackground-0d7_KjU();
            boolean bl5 = false;
            if ($this$isSpecified$iv != 16L) {
                this.background = other.getBackground-0d7_KjU();
            }
            TextDecoration textDecoration = other.getTextDecoration();
            if (textDecoration != null) {
                TextDecoration it8 = textDecoration;
                boolean bl6 = false;
                this.textDecoration = it8;
            }
            Shadow shadow = other.getShadow();
            if (shadow != null) {
                Shadow it9 = shadow;
                boolean bl7 = false;
                this.shadow = it9;
            }
            DrawStyle drawStyle = other.getDrawStyle();
            if (drawStyle != null) {
                DrawStyle it10 = drawStyle;
                boolean bl8 = false;
                this.drawStyle = it10;
            }
            PlatformSpanStyle platformSpanStyle = other.getPlatformStyle();
            if (platformSpanStyle == null) break block14;
            PlatformSpanStyle platformStyle = platformSpanStyle;
            boolean bl9 = false;
            TextDecorationLineStyle textDecorationLineStyle = platformStyle.getTextDecorationLineStyle-Gch4ia8();
            if (textDecorationLineStyle != null) {
                int it11 = textDecorationLineStyle.unbox-impl();
                boolean bl10 = false;
                this.textDecorationLineStyle = TextDecorationLineStyle.box-impl(it11);
            }
        }
    }

    @NotNull
    public String toString() {
        return "ComputedStyle(textForegroundStyle=" + this.textForegroundStyle + ", brushSize=" + Size.toString-impl(this.brushSize) + ", fontSize=" + this.fontSize + ", fontWeight=" + this.fontWeight + ", fontStyle=" + this.fontStyle + ", fontSynthesis=" + this.fontSynthesis + ", fontFamily=" + this.fontFamily + ", fontFeatureSettings=" + this.fontFeatureSettings + ", letterSpacing=" + this.letterSpacing + ", baselineShift=" + this.baselineShift + ", textGeometricTransform=" + this.textGeometricTransform + ", localeList=" + this.localeList + ", background=" + Color.toString-impl(this.background) + ", textDecoration=" + this.textDecoration + ", textDecorationLineStyle=" + this.textDecorationLineStyle + ", shadow=" + this.shadow + ", drawStyle=" + this.drawStyle + ", blendMode=" + BlendMode.toString-impl(this.blendMode) + ", lineHeight=" + this.lineHeight + ", topRatio=" + this.topRatio + ")";
    }

    public int hashCode() {
        int result2 = this.textForegroundStyle.hashCode();
        result2 = result2 * 31 + Size.hashCode-impl(this.brushSize);
        result2 = result2 * 31 + Float.hashCode(this.fontSize);
        result2 = result2 * 31 + (this.fontWeight == null ? 0 : this.fontWeight.hashCode());
        result2 = result2 * 31 + (this.fontStyle == null ? 0 : FontStyle.hashCode-impl(this.fontStyle.unbox-impl()));
        result2 = result2 * 31 + (this.fontSynthesis == null ? 0 : FontSynthesis.hashCode-impl(this.fontSynthesis.unbox-impl()));
        result2 = result2 * 31 + (this.fontFamily == null ? 0 : this.fontFamily.hashCode());
        result2 = result2 * 31 + (this.fontFeatureSettings == null ? 0 : this.fontFeatureSettings.hashCode());
        result2 = result2 * 31 + (this.letterSpacing == null ? 0 : ((Object)this.letterSpacing).hashCode());
        result2 = result2 * 31 + (this.baselineShift == null ? 0 : BaselineShift.hashCode-impl(this.baselineShift.unbox-impl()));
        result2 = result2 * 31 + (this.textGeometricTransform == null ? 0 : this.textGeometricTransform.hashCode());
        result2 = result2 * 31 + (this.localeList == null ? 0 : this.localeList.hashCode());
        result2 = result2 * 31 + Color.hashCode-impl(this.background);
        result2 = result2 * 31 + (this.textDecoration == null ? 0 : this.textDecoration.hashCode());
        result2 = result2 * 31 + (this.textDecorationLineStyle == null ? 0 : TextDecorationLineStyle.hashCode-impl(this.textDecorationLineStyle.unbox-impl()));
        result2 = result2 * 31 + (this.shadow == null ? 0 : this.shadow.hashCode());
        result2 = result2 * 31 + (this.drawStyle == null ? 0 : this.drawStyle.hashCode());
        result2 = result2 * 31 + BlendMode.hashCode-impl(this.blendMode);
        result2 = result2 * 31 + (this.lineHeight == null ? 0 : ((Object)this.lineHeight).hashCode());
        result2 = result2 * 31 + Float.hashCode(this.topRatio);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ComputedStyle)) {
            return false;
        }
        ComputedStyle computedStyle = (ComputedStyle)other;
        if (!Intrinsics.areEqual((Object)this.textForegroundStyle, (Object)computedStyle.textForegroundStyle)) {
            return false;
        }
        if (!Size.equals-impl0(this.brushSize, computedStyle.brushSize)) {
            return false;
        }
        if (Float.compare(this.fontSize, computedStyle.fontSize) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fontWeight, (Object)computedStyle.fontWeight)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fontStyle, (Object)computedStyle.fontStyle)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fontSynthesis, (Object)computedStyle.fontSynthesis)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fontFamily, (Object)computedStyle.fontFamily)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fontFeatureSettings, (Object)computedStyle.fontFeatureSettings)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.letterSpacing, (Object)computedStyle.letterSpacing)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.baselineShift, (Object)computedStyle.baselineShift)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.textGeometricTransform, (Object)computedStyle.textGeometricTransform)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.localeList, (Object)computedStyle.localeList)) {
            return false;
        }
        if (!Color.equals-impl0(this.background, computedStyle.background)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.textDecoration, (Object)computedStyle.textDecoration)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.textDecorationLineStyle, (Object)computedStyle.textDecorationLineStyle)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shadow, (Object)computedStyle.shadow)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.drawStyle, (Object)computedStyle.drawStyle)) {
            return false;
        }
        if (!BlendMode.equals-impl0(this.blendMode, computedStyle.blendMode)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lineHeight, (Object)computedStyle.lineHeight)) {
            return false;
        }
        return Float.compare(this.topRatio, computedStyle.topRatio) == 0;
    }

    public /* synthetic */ ComputedStyle(TextForegroundStyle textForegroundStyle, long brushSize, float fontSize, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, FontFamily fontFamily, String fontFeatureSettings, Float letterSpacing, BaselineShift baselineShift, TextGeometricTransform textGeometricTransform, LocaleList localeList, long background, TextDecoration textDecoration, TextDecorationLineStyle textDecorationLineStyle, Shadow shadow, DrawStyle drawStyle, int blendMode, Float lineHeight, float topRatio, DefaultConstructorMarker $constructor_marker) {
        this(textForegroundStyle, brushSize, fontSize, fontWeight, fontStyle, fontSynthesis, fontFamily, fontFeatureSettings, letterSpacing, baselineShift, textGeometricTransform, localeList, background, textDecoration, textDecorationLineStyle, shadow, drawStyle, blendMode, lineHeight, topRatio);
    }

    public /* synthetic */ ComputedStyle(Density density, SpanStyle spanStyle, long brushSize, int blendMode, long lineHeight, LineHeightStyle lineHeightStyle, DefaultConstructorMarker $constructor_marker) {
        this(density, spanStyle, brushSize, blendMode, lineHeight, lineHeightStyle);
    }
}

