/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.intl;

import androidx.compose.ui.text.intl.Locale;
import androidx.compose.ui.text.intl.PlatformLocaleKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nLocaleList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocaleList.kt\nandroidx/compose/ui/text/intl/LocaleList\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,87:1\n151#2,2:88\n35#2,5:90\n153#2:95\n35#2,5:96\n153#2:101\n*S KotlinDebug\n*F\n+ 1 LocaleList.kt\nandroidx/compose/ui/text/intl/LocaleList\n*L\n53#1:88,2\n53#1:90,5\n53#1:95\n53#1:96,5\n53#1:101\n*E\n"})
public final class LocaleList
implements Collection<Locale>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Locale> localeList;
    private final int size;
    @NotNull
    private static final LocaleList Empty = new LocaleList(CollectionsKt.emptyList());

    public LocaleList(@NotNull List<Locale> localeList) {
        Intrinsics.checkNotNullParameter(localeList, (String)"localeList");
        this.localeList = localeList;
        this.size = this.localeList.size();
    }

    @NotNull
    public final List<Locale> getLocaleList() {
        return this.localeList;
    }

    @NotNull
    public final Locale get(int i2) {
        return this.localeList.get(i2);
    }

    public int getSize() {
        return this.size;
    }

    public boolean contains(@NotNull Locale element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.localeList.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.localeList.containsAll(elements);
    }

    @Override
    public boolean isEmpty() {
        return this.localeList.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<Locale> iterator() {
        return this.localeList.iterator();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LocaleList)) {
            return false;
        }
        return Intrinsics.areEqual(this.localeList, ((LocaleList)other).localeList);
    }

    @Override
    public int hashCode() {
        return ((Object)this.localeList).hashCode();
    }

    @NotNull
    public String toString() {
        return "LocaleList(localeList=" + this.localeList + ")";
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends Locale> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeIf(Predicate<? super Locale> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocaleList getEmpty() {
            return Empty;
        }

        @NotNull
        public final LocaleList getCurrent() {
            return PlatformLocaleKt.getPlatformLocaleDelegate().getCurrent();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

