/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.annotation.RestrictTo;
import androidx.compose.ui.text.AtomicReference;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.PlatformTextInputService;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextInputSession;
import java.util.List;
import kotlin.Deprecated;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextInputService {
    @NotNull
    private final PlatformTextInputService platformTextInputService;
    @NotNull
    private final AtomicReference<TextInputSession> _currentInputSession;
    public static final int $stable = 8;

    public TextInputService(@NotNull PlatformTextInputService platformTextInputService) {
        Intrinsics.checkNotNullParameter((Object)platformTextInputService, (String)"platformTextInputService");
        this.platformTextInputService = platformTextInputService;
        this._currentInputSession = new AtomicReference<Object>(null);
    }

    @Nullable
    public final TextInputSession getCurrentInputSession$ui_text() {
        return this._currentInputSession.get();
    }

    @NotNull
    public TextInputSession startInput(@NotNull TextFieldValue value2, @NotNull ImeOptions imeOptions, @NotNull Function1<? super List<? extends EditCommand>, Unit> onEditCommand, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter(onEditCommand, (String)"onEditCommand");
        Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
        this.platformTextInputService.startInput(value2, imeOptions, onEditCommand, onImeActionPerformed);
        TextInputSession nextSession = new TextInputSession(this, this.platformTextInputService);
        this._currentInputSession.set(nextSession);
        return nextSession;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void startInput() {
        this.platformTextInputService.startInput();
        TextInputSession nextSession = new TextInputSession(this, this.platformTextInputService);
        this._currentInputSession.set(nextSession);
    }

    public void stopInput(@NotNull TextInputSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (this._currentInputSession.compareAndSet(session2, null)) {
            this.platformTextInputService.stopInput();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void stopInput() {
        this._currentInputSession.set(null);
        this.platformTextInputService.stopInput();
    }

    @Deprecated(message="Use SoftwareKeyboardController.show or TextInputSession.showSoftwareKeyboard instead.", replaceWith=@ReplaceWith(expression="textInputSession.showSoftwareKeyboard()", imports={}))
    public final void showSoftwareKeyboard() {
        if (this.getCurrentInputSession$ui_text() != null) {
            this.platformTextInputService.showSoftwareKeyboard();
        }
    }

    @Deprecated(message="Use SoftwareKeyboardController.hide or TextInputSession.hideSoftwareKeyboard instead.", replaceWith=@ReplaceWith(expression="textInputSession.hideSoftwareKeyboard()", imports={}))
    public final void hideSoftwareKeyboard() {
        this.platformTextInputService.hideSoftwareKeyboard();
    }
}

