/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TextFieldValue;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PlatformTextInputService {
    public void startInput(@NotNull TextFieldValue var1, @NotNull ImeOptions var2, @NotNull Function1<? super List<? extends EditCommand>, Unit> var3, @NotNull Function1<? super ImeAction, Unit> var4);

    default public void startInput() {
    }

    public void stopInput();

    public void showSoftwareKeyboard();

    public void hideSoftwareKeyboard();

    public void updateState(@Nullable TextFieldValue var1, @NotNull TextFieldValue var2);

    default public void notifyFocusedRect(@NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
    }

    default public void updateTextLayoutResult(@NotNull TextFieldValue textFieldValue, @NotNull OffsetMapping offsetMapping, @NotNull TextLayoutResult textLayoutResult, @NotNull Function1<? super Matrix, Unit> textFieldToRootTransform, @NotNull Rect innerTextFieldBounds, @NotNull Rect decorationBoxBounds) {
        Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"textFieldValue");
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"offsetMapping");
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        Intrinsics.checkNotNullParameter(textFieldToRootTransform, (String)"textFieldToRootTransform");
        Intrinsics.checkNotNullParameter((Object)innerTextFieldBounds, (String)"innerTextFieldBounds");
        Intrinsics.checkNotNullParameter((Object)decorationBoxBounds, (String)"decorationBoxBounds");
    }
}

