/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommitTextCommand
implements EditCommand {
    @NotNull
    private final AnnotatedString annotatedString;
    private final int newCursorPosition;

    public CommitTextCommand(@NotNull AnnotatedString annotatedString, int newCursorPosition) {
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"annotatedString");
        this.annotatedString = annotatedString;
        this.newCursorPosition = newCursorPosition;
    }

    public final int getNewCursorPosition() {
        return this.newCursorPosition;
    }

    public CommitTextCommand(@NotNull String text2, int newCursorPosition) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this(new AnnotatedString(text2, null, 2, null), newCursorPosition);
    }

    @NotNull
    public final String getText() {
        return this.annotatedString.getText();
    }

    @Override
    public void applyTo(@NotNull EditingBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (buffer.hasComposition$ui_text()) {
            buffer.replace$ui_text(buffer.getCompositionStart$ui_text(), buffer.getCompositionEnd$ui_text(), this.getText());
        } else {
            buffer.replace$ui_text(buffer.getSelectionStart$ui_text(), buffer.getSelectionEnd$ui_text(), this.getText());
        }
        int newCursor = buffer.getCursor$ui_text();
        int newCursorInBuffer = this.newCursorPosition > 0 ? newCursor + this.newCursorPosition - 1 : newCursor + this.newCursorPosition - this.getText().length();
        buffer.setCursor$ui_text(RangesKt.coerceIn((int)newCursorInBuffer, (int)0, (int)buffer.getLength$ui_text()));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CommitTextCommand)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getText(), (Object)((CommitTextCommand)other).getText())) {
            return false;
        }
        return this.newCursorPosition == ((CommitTextCommand)other).newCursorPosition;
    }

    public int hashCode() {
        int result2 = this.getText().hashCode();
        result2 = 31 * result2 + this.newCursorPosition;
        return result2;
    }

    @NotNull
    public String toString() {
        return "CommitTextCommand(text='" + this.getText() + "', newCursorPosition=" + this.newCursorPosition + ")";
    }
}

