/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.unit.IntSize;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nTextLayoutResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextLayoutResult.kt\nandroidx/compose/ui/text/TextLayoutResult\n+ 2 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,584:1\n59#2:585\n54#2:587\n90#3:586\n85#3:588\n*S KotlinDebug\n*F\n+ 1 TextLayoutResult.kt\nandroidx/compose/ui/text/TextLayoutResult\n*L\n317#1:585\n321#1:587\n317#1:586\n321#1:588\n*E\n"})
public final class TextLayoutResult {
    @NotNull
    private final TextLayoutInput layoutInput;
    @NotNull
    private final MultiParagraph multiParagraph;
    private final long size;
    private final float firstBaseline;
    private final float lastBaseline;
    @NotNull
    private final List<Rect> placeholderRects;
    public static final int $stable = 8;

    private TextLayoutResult(TextLayoutInput layoutInput, MultiParagraph multiParagraph, long size) {
        Intrinsics.checkNotNullParameter((Object)layoutInput, (String)"layoutInput");
        Intrinsics.checkNotNullParameter((Object)multiParagraph, (String)"multiParagraph");
        this.layoutInput = layoutInput;
        this.multiParagraph = multiParagraph;
        this.size = size;
        this.firstBaseline = this.multiParagraph.getFirstBaseline();
        this.lastBaseline = this.multiParagraph.getLastBaseline();
        this.placeholderRects = this.multiParagraph.getPlaceholderRects();
    }

    @NotNull
    public final TextLayoutInput getLayoutInput() {
        return this.layoutInput;
    }

    @NotNull
    public final MultiParagraph getMultiParagraph() {
        return this.multiParagraph;
    }

    public final long getSize-YbymL2g() {
        return this.size;
    }

    public final float getFirstBaseline() {
        return this.firstBaseline;
    }

    public final float getLastBaseline() {
        return this.lastBaseline;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getDidOverflowHeight() {
        if (this.multiParagraph.getDidExceedMaxLines()) return true;
        long arg0$iv = this.size;
        boolean bl = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackInt2 = false;
        if (!((float)((int)(value$iv$iv & 0xFFFFFFFFL)) < this.multiParagraph.getHeight())) return false;
        return true;
    }

    public final boolean getDidOverflowWidth() {
        long arg0$iv = this.size;
        boolean bl = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackInt1 = false;
        return (float)((int)(value$iv$iv >> 32)) < this.multiParagraph.getWidth();
    }

    public final boolean getHasVisualOverflow() {
        return this.getDidOverflowWidth() || this.getDidOverflowHeight();
    }

    @NotNull
    public final List<Rect> getPlaceholderRects() {
        return this.placeholderRects;
    }

    public final int getLineCount() {
        return this.multiParagraph.getLineCount();
    }

    public final int getLineStart(int lineIndex) {
        return this.multiParagraph.getLineStart(lineIndex);
    }

    public final int getLineEnd(int lineIndex, boolean visibleEnd) {
        return this.multiParagraph.getLineEnd(lineIndex, visibleEnd);
    }

    public static /* synthetic */ int getLineEnd$default(TextLayoutResult textLayoutResult, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return textLayoutResult.getLineEnd(n, bl);
    }

    public final float getLineTop(int lineIndex) {
        return this.multiParagraph.getLineTop(lineIndex);
    }

    public final float getLineBottom(int lineIndex) {
        return this.multiParagraph.getLineBottom(lineIndex);
    }

    public final float getLineLeft(int lineIndex) {
        return this.multiParagraph.getLineLeft(lineIndex);
    }

    public final float getLineRight(int lineIndex) {
        return this.multiParagraph.getLineRight(lineIndex);
    }

    public final int getLineForOffset(int offset) {
        return this.multiParagraph.getLineForOffset(offset);
    }

    public final int getLineForVerticalPosition(float vertical) {
        return this.multiParagraph.getLineForVerticalPosition(vertical);
    }

    public final float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        return this.multiParagraph.getHorizontalPosition(offset, usePrimaryDirection);
    }

    @NotNull
    public final ResolvedTextDirection getParagraphDirection(int offset) {
        return this.multiParagraph.getParagraphDirection(offset);
    }

    @NotNull
    public final ResolvedTextDirection getBidiRunDirection(int offset) {
        return this.multiParagraph.getBidiRunDirection(offset);
    }

    public final int getOffsetForPosition-k-4lQ0M(long position) {
        return this.multiParagraph.getOffsetForPosition-k-4lQ0M(position);
    }

    @NotNull
    public final Rect getBoundingBox(int offset) {
        return this.multiParagraph.getBoundingBox(offset);
    }

    public final long getWordBoundary--jx7JFs(int offset) {
        return this.multiParagraph.getWordBoundary--jx7JFs(offset);
    }

    @NotNull
    public final Rect getCursorRect(int offset) {
        return this.multiParagraph.getCursorRect(offset);
    }

    @NotNull
    public final Path getPathForRange(int start2, int end) {
        return this.multiParagraph.getPathForRange(start2, end);
    }

    @NotNull
    public final TextLayoutResult copy-O0kMr_c(@NotNull TextLayoutInput layoutInput, long size) {
        Intrinsics.checkNotNullParameter((Object)layoutInput, (String)"layoutInput");
        return new TextLayoutResult(layoutInput, this.multiParagraph, size, null);
    }

    public static /* synthetic */ TextLayoutResult copy-O0kMr_c$default(TextLayoutResult textLayoutResult, TextLayoutInput textLayoutInput, long l, int n, Object object) {
        if ((n & 1) != 0) {
            textLayoutInput = textLayoutResult.layoutInput;
        }
        if ((n & 2) != 0) {
            l = textLayoutResult.size;
        }
        return textLayoutResult.copy-O0kMr_c(textLayoutInput, l);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextLayoutResult)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.layoutInput, (Object)((TextLayoutResult)other).layoutInput)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.multiParagraph, (Object)((TextLayoutResult)other).multiParagraph)) {
            return false;
        }
        if (!IntSize.equals-impl0(this.size, ((TextLayoutResult)other).size)) {
            return false;
        }
        if (!(this.firstBaseline == ((TextLayoutResult)other).firstBaseline)) {
            return false;
        }
        if (!(this.lastBaseline == ((TextLayoutResult)other).lastBaseline)) {
            return false;
        }
        return Intrinsics.areEqual(this.placeholderRects, ((TextLayoutResult)other).placeholderRects);
    }

    public int hashCode() {
        int result2 = this.layoutInput.hashCode();
        result2 = 31 * result2 + this.multiParagraph.hashCode();
        result2 = 31 * result2 + IntSize.hashCode-impl(this.size);
        result2 = 31 * result2 + Float.hashCode(this.firstBaseline);
        result2 = 31 * result2 + Float.hashCode(this.lastBaseline);
        result2 = 31 * result2 + ((Object)this.placeholderRects).hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return "TextLayoutResult(layoutInput=" + this.layoutInput + ", multiParagraph=" + this.multiParagraph + ", size=" + IntSize.toString-impl(this.size) + ", firstBaseline=" + this.firstBaseline + ", lastBaseline=" + this.lastBaseline + ", placeholderRects=" + this.placeholderRects + ")";
    }

    public /* synthetic */ TextLayoutResult(TextLayoutInput layoutInput, MultiParagraph multiParagraph, long size, DefaultConstructorMarker $constructor_marker) {
        this(layoutInput, multiParagraph, size);
    }
}

