/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.text.ParagraphInfo;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import androidx.compose.ui.util.ListUtilsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nMultiParagraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiParagraph.kt\nandroidx/compose/ui/text/MultiParagraphKt\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,1227:1\n1092#1,11:1232\n1092#1,11:1247\n1092#1,11:1258\n118#2,4:1228\n118#2,4:1243\n*S KotlinDebug\n*F\n+ 1 MultiParagraph.kt\nandroidx/compose/ui/text/MultiParagraphKt\n*L\n1022#1:1232,11\n1048#1:1247,11\n1082#1:1258,11\n1018#1:1228,4\n1029#1:1243,4\n*E\n"})
public final class MultiParagraphKt {
    public static final int findParagraphByIndex(@NotNull List<ParagraphInfo> paragraphInfoList, int index) {
        int paragraphIndex;
        block5: {
            int n;
            Intrinsics.checkNotNullParameter(paragraphInfoList, (String)"paragraphInfoList");
            int lastLineEnd = ((ParagraphInfo)CollectionsKt.last(paragraphInfoList)).getEndIndex();
            boolean value$iv = index <= ((ParagraphInfo)CollectionsKt.last(paragraphInfoList)).getEndIndex();
            boolean $i$f$requirePrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalArgumentException("Index " + index + " should be less or equal than last line's end " + lastLineEnd);
            }
            List<ParagraphInfo> $this$fastBinarySearch$iv = paragraphInfoList;
            boolean $i$f$fastBinarySearch = false;
            int low$iv = 0;
            int high$iv = $this$fastBinarySearch$iv.size() - 1;
            while (low$iv <= high$iv) {
                ParagraphInfo midVal$iv;
                int mid$iv = low$iv + high$iv >>> 1;
                ParagraphInfo paragraphInfo = midVal$iv = $this$fastBinarySearch$iv.get(mid$iv);
                boolean bl = false;
                int cmp$iv = paragraphInfo.getStartIndex() > index ? 1 : (paragraphInfo.getEndIndex() <= index ? -1 : 0);
                if (cmp$iv < 0) {
                    low$iv = mid$iv + 1;
                    continue;
                }
                if (cmp$iv > 0) {
                    high$iv = mid$iv - 1;
                    continue;
                }
                n = mid$iv;
                break block5;
            }
            n = paragraphIndex = -(low$iv + 1);
        }
        boolean value$iv = 0 <= paragraphIndex ? paragraphIndex < ((Collection)paragraphInfoList).size() : false;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Found paragraph index " + paragraphIndex + " should be in range [0, " + paragraphInfoList.size() + ").\nDebug info: index=" + index + ", paragraphs=[" + ListUtilsKt.fastJoinToString$default(paragraphInfoList, null, null, null, 0, null, MultiParagraphKt::findParagraphByIndex$lambda$3$lambda$2, 31, null) + "]");
        }
        return paragraphIndex;
    }

    public static final int findParagraphByY(@NotNull List<ParagraphInfo> paragraphInfoList, float y) {
        int n;
        block5: {
            Intrinsics.checkNotNullParameter(paragraphInfoList, (String)"paragraphInfoList");
            if (y <= 0.0f) {
                return 0;
            }
            if (y >= ((ParagraphInfo)CollectionsKt.last(paragraphInfoList)).getBottom()) {
                return CollectionsKt.getLastIndex(paragraphInfoList);
            }
            List<ParagraphInfo> $this$fastBinarySearch$iv = paragraphInfoList;
            boolean $i$f$fastBinarySearch = false;
            int low$iv = 0;
            int high$iv = $this$fastBinarySearch$iv.size() - 1;
            while (low$iv <= high$iv) {
                ParagraphInfo midVal$iv;
                int mid$iv = low$iv + high$iv >>> 1;
                ParagraphInfo paragraphInfo = midVal$iv = $this$fastBinarySearch$iv.get(mid$iv);
                boolean bl = false;
                int cmp$iv = paragraphInfo.getTop() > y ? 1 : (paragraphInfo.getBottom() <= y ? -1 : 0);
                if (cmp$iv < 0) {
                    low$iv = mid$iv + 1;
                    continue;
                }
                if (cmp$iv > 0) {
                    high$iv = mid$iv - 1;
                    continue;
                }
                n = mid$iv;
                break block5;
            }
            n = -(low$iv + 1);
        }
        return n;
    }

    public static final void findParagraphsByRange-Sb-Bc2M(@NotNull List<ParagraphInfo> paragraphInfoList, long range, @NotNull Function1<? super ParagraphInfo, Unit> action) {
        int paragraphIndex;
        ParagraphInfo paragraph;
        Intrinsics.checkNotNullParameter(paragraphInfoList, (String)"paragraphInfoList");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        int n = paragraphInfoList.size();
        for (int i2 = paragraphIndex = MultiParagraphKt.findParagraphByIndex(paragraphInfoList, TextRange.getMin-impl(range)); i2 < n && (paragraph = paragraphInfoList.get(i2)).getStartIndex() < TextRange.getMax-impl(range); ++i2) {
            if (paragraph.getStartIndex() == paragraph.getEndIndex()) continue;
            action.invoke((Object)paragraph);
        }
    }

    public static final int findParagraphByLineIndex(@NotNull List<ParagraphInfo> paragraphInfoList, int lineIndex) {
        int n;
        block3: {
            Intrinsics.checkNotNullParameter(paragraphInfoList, (String)"paragraphInfoList");
            List<ParagraphInfo> $this$fastBinarySearch$iv = paragraphInfoList;
            boolean $i$f$fastBinarySearch = false;
            int low$iv = 0;
            int high$iv = $this$fastBinarySearch$iv.size() - 1;
            while (low$iv <= high$iv) {
                ParagraphInfo midVal$iv;
                int mid$iv = low$iv + high$iv >>> 1;
                ParagraphInfo paragraphInfo = midVal$iv = $this$fastBinarySearch$iv.get(mid$iv);
                boolean bl = false;
                int cmp$iv = paragraphInfo.getStartLineIndex() > lineIndex ? 1 : (paragraphInfo.getEndLineIndex() <= lineIndex ? -1 : 0);
                if (cmp$iv < 0) {
                    low$iv = mid$iv + 1;
                    continue;
                }
                if (cmp$iv > 0) {
                    high$iv = mid$iv - 1;
                    continue;
                }
                n = mid$iv;
                break block3;
            }
            n = -(low$iv + 1);
        }
        return n;
    }

    private static final CharSequence findParagraphByIndex$lambda$3$lambda$2(ParagraphInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "[" + it.getStartIndex() + ", " + it.getEndIndex() + ")";
    }
}

