/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.text.FontHinting;
import androidx.compose.ui.text.FontSmoothing;
import androidx.compose.ui.text.platform.DesktopFont_desktopKt;
import androidx.compose.ui.text.platform.Platform;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FontRasterizationSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FontSmoothing smoothing;
    @NotNull
    private final FontHinting hinting;
    private final boolean subpixelPositioning;
    private final boolean autoHintingForced;
    @NotNull
    private static final Lazy<FontRasterizationSettings> PlatformDefault$delegate = LazyKt.lazy(FontRasterizationSettings::PlatformDefault_delegate$lambda$0);

    public FontRasterizationSettings(@NotNull FontSmoothing smoothing, @NotNull FontHinting hinting, boolean subpixelPositioning, boolean autoHintingForced) {
        Intrinsics.checkNotNullParameter((Object)((Object)smoothing), (String)"smoothing");
        Intrinsics.checkNotNullParameter((Object)((Object)hinting), (String)"hinting");
        this.smoothing = smoothing;
        this.hinting = hinting;
        this.subpixelPositioning = subpixelPositioning;
        this.autoHintingForced = autoHintingForced;
    }

    @NotNull
    public final FontSmoothing getSmoothing() {
        return this.smoothing;
    }

    @NotNull
    public final FontHinting getHinting() {
        return this.hinting;
    }

    public final boolean getSubpixelPositioning() {
        return this.subpixelPositioning;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FontRasterizationSettings cfr_ignored_0 = (FontRasterizationSettings)other;
        if (this.smoothing != ((FontRasterizationSettings)other).smoothing) {
            return false;
        }
        if (this.hinting != ((FontRasterizationSettings)other).hinting) {
            return false;
        }
        if (this.subpixelPositioning != ((FontRasterizationSettings)other).subpixelPositioning) {
            return false;
        }
        return this.autoHintingForced == ((FontRasterizationSettings)other).autoHintingForced;
    }

    public int hashCode() {
        int result2 = this.smoothing.hashCode();
        result2 = 31 * result2 + this.hinting.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.subpixelPositioning);
        result2 = 31 * result2 + Boolean.hashCode(this.autoHintingForced);
        return result2;
    }

    @NotNull
    public String toString() {
        return "FontRasterizationSettings(smoothing=" + this.smoothing + ", hinting=" + this.hinting + ", subpixelPositioning=" + this.subpixelPositioning + ", autoHintingForced=" + this.autoHintingForced + ")";
    }

    private static final FontRasterizationSettings PlatformDefault_delegate$lambda$0() {
        FontRasterizationSettings fontRasterizationSettings;
        switch (WhenMappings.$EnumSwitchMapping$0[DesktopFont_desktopKt.currentPlatform().ordinal()]) {
            case 1: {
                FontSmoothing fontSmoothing = FontSmoothing.AntiAlias;
                FontHinting fontHinting = FontHinting.Normal;
                fontRasterizationSettings = new FontRasterizationSettings(fontSmoothing, fontHinting, true, false);
                break;
            }
            case 2: 
            case 3: {
                FontSmoothing fontSmoothing = FontSmoothing.AntiAlias;
                FontHinting fontHinting = FontHinting.Slight;
                fontRasterizationSettings = new FontRasterizationSettings(fontSmoothing, fontHinting, true, false);
                break;
            }
            case 4: {
                FontSmoothing fontSmoothing = FontSmoothing.AntiAlias;
                FontHinting fontHinting = FontHinting.Slight;
                fontRasterizationSettings = new FontRasterizationSettings(fontSmoothing, fontHinting, true, false);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                FontSmoothing fontSmoothing = FontSmoothing.AntiAlias;
                FontHinting fontHinting = FontHinting.Normal;
                fontRasterizationSettings = new FontRasterizationSettings(fontSmoothing, fontHinting, true, false);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fontRasterizationSettings;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FontRasterizationSettings getPlatformDefault() {
            Lazy lazy = PlatformDefault$delegate;
            return (FontRasterizationSettings)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Platform.values().length];
            try {
                nArray[Platform.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.Unknown.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.Android.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.MacOS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.IOS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.TvOS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.WatchOS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

