/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1607:1\n35#2,5:1608\n35#2,5:1613\n35#2,5:1619\n251#2,2:1624\n35#2,3:1626\n39#2:1649\n253#2:1650\n231#2,2:1651\n35#2,5:1653\n233#2:1658\n251#2,2:1659\n35#2,5:1661\n253#2:1666\n151#2,2:1667\n35#2,5:1669\n153#2:1674\n251#2,2:1679\n35#2,5:1681\n253#2:1686\n1053#3:1618\n101#4,10:1629\n101#4,10:1639\n118#5,4:1675\n1#6:1687\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n*L\n1030#1:1608,5\n1031#1:1613,5\n1073#1:1619,5\n1183#1:1624,2\n1183#1:1626,3\n1183#1:1649\n1183#1:1650\n1209#1:1651,2\n1209#1:1653,5\n1209#1:1658\n1212#1:1659,2\n1212#1:1661,5\n1212#1:1666\n1245#1:1667,2\n1245#1:1669,5\n1245#1:1674\n1521#1:1679,2\n1521#1:1681,5\n1521#1:1686\n1066#1:1618\n1186#1:1629,10\n1187#1:1639,10\n1515#1:1675,4\n*E\n"})
public final class AnnotatedStringKt {
    @NotNull
    private static final AnnotatedString EmptyAnnotatedString = new AnnotatedString("", null, 2, null);

    private static final List<AnnotatedString.Range<? extends AnnotatedString.Annotation>> constructAnnotationsFromSpansAndParagraphs(List<AnnotatedString.Range<SpanStyle>> spanStyles, List<AnnotatedString.Range<ParagraphStyle>> paragraphStyles) {
        List list2;
        if (spanStyles.isEmpty() && paragraphStyles.isEmpty()) {
            list2 = null;
        } else if (paragraphStyles.isEmpty()) {
            list2 = spanStyles;
        } else if (spanStyles.isEmpty()) {
            list2 = paragraphStyles;
        } else {
            AnnotatedString.Range<? extends AnnotatedString.Annotation> it;
            AnnotatedString.Range<? extends AnnotatedString.Annotation> item$iv;
            int index$iv;
            ArrayList<AnnotatedString.Range<? extends AnnotatedString.Annotation>> arrayList;
            ArrayList<AnnotatedString.Range<? extends AnnotatedString.Annotation>> array = arrayList = new ArrayList<AnnotatedString.Range<? extends AnnotatedString.Annotation>>(spanStyles.size() + paragraphStyles.size());
            boolean bl = false;
            List $this$fastForEach$iv = spanStyles;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (index$iv = 0; index$iv < n; ++index$iv) {
                it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl2 = false;
                array.add(it);
            }
            $this$fastForEach$iv = paragraphStyles;
            $i$f$fastForEach = false;
            n = ((Collection)$this$fastForEach$iv).size();
            for (index$iv = 0; index$iv < n; ++index$iv) {
                it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl3 = false;
                array.add(it);
            }
            list2 = arrayList;
        }
        return list2;
    }

    @NotNull
    public static final List<AnnotatedString.Range<ParagraphStyle>> normalizedParagraphStyles(@NotNull AnnotatedString $this$normalizedParagraphStyles, @NotNull ParagraphStyle defaultParagraphStyle) {
        List list2;
        block18: {
            block17: {
                Intrinsics.checkNotNullParameter((Object)$this$normalizedParagraphStyles, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)defaultParagraphStyle, (String)"defaultParagraphStyle");
                list2 = $this$normalizedParagraphStyles.getParagraphStylesOrNull$ui_text();
                if (list2 == null) break block17;
                Iterable $this$sortedBy$iv = list2;
                boolean $i$f$sortedBy = false;
                list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        AnnotatedString.Range it = (AnnotatedString.Range)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getStart());
                        it = (AnnotatedString.Range)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
                    }
                });
                if (list2 != null) break block18;
            }
            list2 = CollectionsKt.emptyList();
        }
        List sortedParagraphs = list2;
        List result2 = new ArrayList();
        int lastAdded = 0;
        ArrayDeque stack = new ArrayDeque();
        List $this$fastForEach$iv = sortedParagraphs;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            boolean bl;
            AnnotatedString.Range lastInStack;
            Object item$iv = $this$fastForEach$iv.get(index$iv);
            AnnotatedString.Range it = (AnnotatedString.Range)item$iv;
            boolean bl2 = false;
            AnnotatedString.Range current = AnnotatedString.Range.copy$default(it, defaultParagraphStyle.merge((ParagraphStyle)it.getItem()), 0, 0, null, 14, null);
            while (lastAdded < current.getStart() && !((Collection)stack).isEmpty()) {
                lastInStack = (AnnotatedString.Range)stack.last();
                if (current.getStart() < lastInStack.getEnd()) {
                    result2.add(new AnnotatedString.Range(lastInStack.getItem(), lastAdded, current.getStart()));
                    lastAdded = current.getStart();
                    continue;
                }
                result2.add(new AnnotatedString.Range(lastInStack.getItem(), lastAdded, lastInStack.getEnd()));
                lastAdded = lastInStack.getEnd();
                while (!((Collection)stack).isEmpty() && lastAdded == ((AnnotatedString.Range)stack.last()).getEnd()) {
                    stack.removeLast();
                }
            }
            if (lastAdded < current.getStart()) {
                result2.add(new AnnotatedString.Range<ParagraphStyle>(defaultParagraphStyle, lastAdded, current.getStart()));
                lastAdded = current.getStart();
            }
            if ((lastInStack = (AnnotatedString.Range)stack.lastOrNull()) != null) {
                if (lastInStack.getStart() == current.getStart() && lastInStack.getEnd() == current.getEnd()) {
                    stack.removeLast();
                    bl = stack.add(new AnnotatedString.Range<ParagraphStyle>(((ParagraphStyle)lastInStack.getItem()).merge((ParagraphStyle)current.getItem()), current.getStart(), current.getEnd()));
                    continue;
                }
                if (lastInStack.getStart() == lastInStack.getEnd()) {
                    result2.add(new AnnotatedString.Range(lastInStack.getItem(), lastInStack.getStart(), lastInStack.getEnd()));
                    stack.removeLast();
                    bl = stack.add(new AnnotatedString.Range(current.getItem(), current.getStart(), current.getEnd()));
                    continue;
                }
                if (lastInStack.getEnd() < current.getEnd()) {
                    throw new IllegalArgumentException();
                }
                bl = stack.add(new AnnotatedString.Range<ParagraphStyle>(((ParagraphStyle)lastInStack.getItem()).merge((ParagraphStyle)current.getItem()), current.getStart(), current.getEnd()));
                continue;
            }
            bl = stack.add(new AnnotatedString.Range(current.getItem(), current.getStart(), current.getEnd()));
        }
        while (lastAdded <= $this$normalizedParagraphStyles.getText().length() && !((Collection)stack).isEmpty()) {
            AnnotatedString.Range lastInStack = (AnnotatedString.Range)stack.last();
            result2.add(new AnnotatedString.Range(lastInStack.getItem(), lastAdded, lastInStack.getEnd()));
            lastAdded = lastInStack.getEnd();
            while (!((Collection)stack).isEmpty() && lastAdded == ((AnnotatedString.Range)stack.last()).getEnd()) {
                stack.removeLast();
            }
        }
        if (lastAdded < $this$normalizedParagraphStyles.getText().length()) {
            result2.add(new AnnotatedString.Range<ParagraphStyle>(defaultParagraphStyle, lastAdded, $this$normalizedParagraphStyles.getText().length()));
        }
        if (result2.isEmpty()) {
            result2.add(new AnnotatedString.Range<ParagraphStyle>(defaultParagraphStyle, 0, 0));
        }
        return result2;
    }

    private static final List<AnnotatedString.Range<? extends AnnotatedString.Annotation>> getLocalAnnotations(AnnotatedString $this$getLocalAnnotations, int start2, int end, Function1<? super AnnotatedString.Annotation, Boolean> predicate) {
        if (start2 == end) {
            return null;
        }
        List list2 = $this$getLocalAnnotations.getAnnotations$ui_text();
        if (list2 == null) {
            return null;
        }
        List annotations = list2;
        if (start2 == 0 && end >= $this$getLocalAnnotations.getText().length()) {
            List list3;
            if (predicate == null) {
                list3 = annotations;
            } else {
                List $this$fastFilter$iv = annotations;
                boolean $i$f$fastFilter = false;
                ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
                List $this$fastForEach$iv$iv = $this$fastFilter$iv;
                boolean $i$f$fastForEach = false;
                int n = ((Collection)$this$fastForEach$iv$iv).size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    AnnotatedString.Range<? extends AnnotatedString.Annotation> item$iv$iv;
                    AnnotatedString.Range<? extends AnnotatedString.Annotation> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl = false;
                    AnnotatedString.Range<? extends AnnotatedString.Annotation> it = it$iv;
                    boolean bl2 = false;
                    if (!((Boolean)predicate.invoke((Object)it.getItem())).booleanValue()) continue;
                    ((Collection)target$iv).add(it$iv);
                }
                list3 = target$iv;
            }
            return list3;
        }
        List $this$fastFilteredMap$iv = annotations;
        boolean $i$f$fastFilteredMap = false;
        ArrayList target$iv = new ArrayList($this$fastFilteredMap$iv.size());
        List $this$fastForEach$iv$iv = $this$fastFilteredMap$iv;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv$iv).size();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            AnnotatedString.Range<? extends AnnotatedString.Annotation> item$iv$iv;
            AnnotatedString.Range<? extends AnnotatedString.Annotation> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
            boolean bl = false;
            AnnotatedString.Range<? extends AnnotatedString.Annotation> it = it$iv;
            boolean bl3 = false;
            Function1<? super AnnotatedString.Annotation, Boolean> function1 = predicate;
            if (!((function1 != null ? (Boolean)function1.invoke((Object)it.getItem()) : true) && AnnotatedStringKt.intersect(start2, end, it.getStart(), it.getEnd()))) continue;
            it = it$iv;
            Collection collection = target$iv;
            boolean bl4 = false;
            String string = it.getTag();
            AnnotatedString.Annotation annotation = it.getItem();
            int n2 = RangesKt.coerceIn((int)it.getStart(), (int)start2, (int)end) - start2;
            int n3 = RangesKt.coerceIn((int)it.getEnd(), (int)start2, (int)end) - start2;
            collection.add(new AnnotatedString.Range<AnnotatedString.Annotation>(annotation, n2, n3, string));
        }
        return target$iv;
    }

    static /* synthetic */ List getLocalAnnotations$default(AnnotatedString annotatedString, int n, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 4) != 0) {
            function1 = null;
        }
        return AnnotatedStringKt.getLocalAnnotations(annotatedString, n, n2, (Function1<? super AnnotatedString.Annotation, Boolean>)function1);
    }

    private static final AnnotatedString substringWithoutParagraphStyles(AnnotatedString $this$substringWithoutParagraphStyles, int start2, int end) {
        List list2;
        String string;
        if (start2 != end) {
            String string2 = $this$substringWithoutParagraphStyles.getText().substring(start2, end);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = "";
        }
        if ((list2 = AnnotatedStringKt.getLocalAnnotations($this$substringWithoutParagraphStyles, start2, end, (Function1<? super AnnotatedString.Annotation, Boolean>)((Function1)AnnotatedStringKt::substringWithoutParagraphStyles$lambda$10))) == null) {
            list2 = CollectionsKt.emptyList();
        }
        return new AnnotatedString(string, list2);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> List<AnnotatedString.Range<T>> filterRanges(List<? extends AnnotatedString.Range<? extends T>> ranges, int start2, int end) {
        Collection collection;
        void $this$fastFilteredMap$iv;
        List<AnnotatedString.Range<T>> nonNullRange;
        boolean value$iv = start2 <= end;
        boolean $i$f$requirePrecondition22 = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("start (" + start2 + ") should be less than or equal to end (" + end + ")");
        }
        List<AnnotatedString.Range<T>> list2 = ranges;
        if (list2 == null) {
            return null;
        }
        List<AnnotatedString.Range<T>> $i$f$requirePrecondition22 = nonNullRange = list2;
        boolean $i$f$fastFilteredMap = false;
        ArrayList target$iv = new ArrayList($this$fastFilteredMap$iv.size());
        void $this$fastForEach$iv$iv = $this$fastFilteredMap$iv;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv$iv).size();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            Object item$iv$iv;
            Object it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
            boolean bl = false;
            AnnotatedString.Range it = (AnnotatedString.Range)it$iv;
            boolean bl2 = false;
            if (!AnnotatedStringKt.intersect(start2, end, it.getStart(), it.getEnd())) continue;
            it = (AnnotatedString.Range)it$iv;
            Collection collection2 = target$iv;
            boolean bl3 = false;
            collection2.add(new AnnotatedString.Range(it.getItem(), Math.max(start2, it.getStart()) - start2, Math.min(end, it.getEnd()) - start2, it.getTag()));
        }
        Collection collection3 = target$iv;
        if (collection3.isEmpty()) {
            boolean bl = false;
            collection = null;
        } else {
            collection = collection3;
        }
        return (List)collection;
    }

    public static final boolean intersect(int lStart, int lEnd, int rStart, int rEnd) {
        return (lStart == lEnd | rStart == rEnd) & lStart == rStart | lStart < rEnd & rStart < lEnd;
    }

    @NotNull
    public static final AnnotatedString emptyAnnotatedString() {
        return EmptyAnnotatedString;
    }

    private static final boolean substringWithoutParagraphStyles$lambda$10(AnnotatedString.Annotation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof ParagraphStyle);
    }

    public static final /* synthetic */ List access$constructAnnotationsFromSpansAndParagraphs(List spanStyles, List paragraphStyles) {
        return AnnotatedStringKt.constructAnnotationsFromSpansAndParagraphs(spanStyles, paragraphStyles);
    }

    public static final /* synthetic */ List access$filterRanges(List ranges, int start2, int end) {
        return AnnotatedStringKt.filterRanges(ranges, start2, end);
    }

    public static final /* synthetic */ AnnotatedString access$substringWithoutParagraphStyles(AnnotatedString $receiver, int start2, int end) {
        return AnnotatedStringKt.substringWithoutParagraphStyles($receiver, start2, end);
    }
}

