/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.node.DelegatableNode;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.NodeCoordinator;
import androidx.compose.ui.node.NodeKind;
import androidx.compose.ui.node.SemanticsModifierNode;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNodeKt;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertiesKt;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import androidx.compose.ui.unit.IntSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nSemanticsNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticsNode.kt\nandroidx/compose/ui/semantics/SemanticsNode\n+ 2 SemanticsNode.kt\nandroidx/compose/ui/semantics/SemanticsNodeKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 NodeKind.kt\nandroidx/compose/ui/node/Nodes\n+ 5 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,502:1\n389#1,7:515\n389#1,7:552\n484#2,10:503\n484#2,10:531\n484#2,3:541\n487#2,7:545\n1#3:513\n91#4:514\n91#4:527\n91#4:544\n91#4:559\n424#5,5:522\n429#5,3:528\n*S KotlinDebug\n*F\n+ 1 SemanticsNode.kt\nandroidx/compose/ui/semantics/SemanticsNode\n*L\n235#1:515,7\n369#1:552,7\n101#1:503,10\n351#1:531,10\n357#1:541,3\n357#1:545,7\n188#1:514\n277#1:527\n357#1:544\n406#1:559\n272#1:522,5\n272#1:528,3\n*E\n"})
public final class SemanticsNode {
    @NotNull
    private final Modifier.Node outerSemanticsNode;
    private final boolean mergingEnabled;
    @NotNull
    private final LayoutNode layoutNode;
    @NotNull
    private final SemanticsConfiguration unmergedConfig;
    private boolean isFake;
    @Nullable
    private SemanticsNode fakeNodeParent;
    private final int id;
    public static final int $stable = 8;

    public SemanticsNode(@NotNull Modifier.Node outerSemanticsNode, boolean mergingEnabled, @NotNull LayoutNode layoutNode, @NotNull SemanticsConfiguration unmergedConfig) {
        Intrinsics.checkNotNullParameter((Object)outerSemanticsNode, (String)"outerSemanticsNode");
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        Intrinsics.checkNotNullParameter((Object)unmergedConfig, (String)"unmergedConfig");
        this.outerSemanticsNode = outerSemanticsNode;
        this.mergingEnabled = mergingEnabled;
        this.layoutNode = layoutNode;
        this.unmergedConfig = unmergedConfig;
        this.id = this.layoutNode.getSemanticsId();
    }

    @NotNull
    public final Modifier.Node getOuterSemanticsNode$ui() {
        return this.outerSemanticsNode;
    }

    @NotNull
    public final LayoutNode getLayoutNode$ui() {
        return this.layoutNode;
    }

    @NotNull
    public final SemanticsConfiguration getUnmergedConfig$ui() {
        return this.unmergedConfig;
    }

    public final int getId() {
        return this.id;
    }

    public final long getSize-YbymL2g() {
        NodeCoordinator nodeCoordinator = this.findCoordinatorToGetBounds$ui();
        return nodeCoordinator != null ? nodeCoordinator.getSize-YbymL2g() : IntSize.Companion.getZero-YbymL2g();
    }

    @NotNull
    public final Rect getBoundsInRoot() {
        Object object;
        block3: {
            block2: {
                NodeCoordinator nodeCoordinator;
                object = this.findCoordinatorToGetBounds$ui();
                if (object == null) break block2;
                NodeCoordinator it = nodeCoordinator = object;
                boolean bl = false;
                object = it.isAttached() ? nodeCoordinator : null;
                if (object != null && (object = LayoutCoordinatesKt.boundsInRoot((LayoutCoordinates)object)) != null) break block3;
            }
            object = Rect.Companion.getZero();
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final long getPositionInRoot-F1C5BW0() {
        long l;
        NodeCoordinator nodeCoordinator = this.findCoordinatorToGetBounds$ui();
        if (nodeCoordinator != null) {
            NodeCoordinator nodeCoordinator2;
            NodeCoordinator it = nodeCoordinator2 = nodeCoordinator;
            boolean bl = false;
            nodeCoordinator = it.isAttached() ? nodeCoordinator2 : null;
            if (nodeCoordinator != null) {
                l = LayoutCoordinatesKt.positionInRoot(nodeCoordinator);
                return l;
            }
        }
        l = Offset.Companion.getZero-F1C5BW0();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final long getPositionOnScreen-F1C5BW0() {
        long l;
        NodeCoordinator nodeCoordinator = this.findCoordinatorToGetBounds$ui();
        if (nodeCoordinator != null) {
            NodeCoordinator nodeCoordinator2;
            NodeCoordinator it = nodeCoordinator2 = nodeCoordinator;
            boolean bl = false;
            nodeCoordinator = it.isAttached() ? nodeCoordinator2 : null;
            if (nodeCoordinator != null) {
                l = LayoutCoordinatesKt.positionOnScreen(nodeCoordinator);
                return l;
            }
        }
        l = Offset.Companion.getZero-F1C5BW0();
        return l;
    }

    @NotNull
    public final SemanticsConfiguration getConfig() {
        if (this.isMergingSemanticsOfDescendants()) {
            SemanticsConfiguration mergedConfig = this.unmergedConfig.copy();
            this.mergeConfig(new ArrayList(), mergedConfig);
            return mergedConfig;
        }
        return this.unmergedConfig;
    }

    /*
     * WARNING - void declaration
     */
    private final void mergeConfig(List<SemanticsNode> unmergedChildren, SemanticsConfiguration mergedConfig) {
        if (!this.unmergedConfig.isClearingSemantics()) {
            void this_$iv;
            SemanticsNode semanticsNode = this;
            List<SemanticsNode> $this$forEachUnmergedChild$iv = unmergedChildren;
            boolean $i$f$forEachUnmergedChild = false;
            int start$iv = $this$forEachUnmergedChild$iv.size();
            SemanticsNode.unmergedChildren$ui$default((SemanticsNode)this_$iv, $this$forEachUnmergedChild$iv, false, false, 6, null);
            int end$iv = $this$forEachUnmergedChild$iv.size();
            for (int i$iv = start$iv; i$iv < end$iv; ++i$iv) {
                SemanticsNode child2 = $this$forEachUnmergedChild$iv.get(i$iv);
                boolean bl = false;
                if (child2.isMergingSemanticsOfDescendants()) continue;
                mergedConfig.mergeChild$ui(child2.unmergedConfig);
                child2.mergeConfig(unmergedChildren, mergedConfig);
            }
        }
    }

    private final boolean isMergingSemanticsOfDescendants() {
        return this.mergingEnabled && this.unmergedConfig.isMergingSemanticsOfDescendants();
    }

    @NotNull
    public final List<SemanticsNode> unmergedChildren$ui(@NotNull List<SemanticsNode> unmergedChildren, boolean includeFakeNodes, boolean includeDeactivatedNodes) {
        Intrinsics.checkNotNullParameter(unmergedChildren, (String)"unmergedChildren");
        if (this.isFake) {
            return CollectionsKt.emptyList();
        }
        this.fillOneLayerOfSemanticsWrappers(this.layoutNode, unmergedChildren, includeDeactivatedNodes);
        if (includeFakeNodes) {
            this.emitFakeNodes(unmergedChildren);
        }
        return unmergedChildren;
    }

    public static /* synthetic */ List unmergedChildren$ui$default(SemanticsNode semanticsNode, List list2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = new ArrayList();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return semanticsNode.unmergedChildren$ui(list2, bl, bl2);
    }

    private final void fillOneLayerOfSemanticsWrappers(LayoutNode $this$fillOneLayerOfSemanticsWrappers, List<SemanticsNode> list2, boolean includeDeactivatedNodes) {
        MutableVector<LayoutNode> this_$iv = $this$fillOneLayerOfSemanticsWrappers.getZSortedChildren();
        boolean $i$f$forEach = false;
        T[] content$iv = this_$iv.content;
        int size$iv = this_$iv.getSize();
        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
            LayoutNode child2 = (LayoutNode)content$iv[i$iv];
            boolean bl = false;
            if (!child2.isAttached() || !includeDeactivatedNodes && child2.isDeactivated()) continue;
            boolean bl2 = false;
            if (child2.getNodes$ui().has-H91voCI$ui(NodeKind.constructor-impl(8))) {
                list2.add(SemanticsNodeKt.SemanticsNode(child2, this.mergingEnabled));
                continue;
            }
            this.fillOneLayerOfSemanticsWrappers(child2, list2, includeDeactivatedNodes);
        }
    }

    @NotNull
    public final List<SemanticsNode> getReplacedChildren$ui() {
        return SemanticsNode.getChildren$ui$default(this, false, true, false, 4, null);
    }

    @NotNull
    public final List<SemanticsNode> getChildren$ui(boolean includeReplacedSemantics, boolean includeFakeNodes, boolean includeDeactivatedNodes) {
        if (!includeReplacedSemantics && this.unmergedConfig.isClearingSemantics()) {
            return CollectionsKt.emptyList();
        }
        List unmergedChildren = new ArrayList();
        if (this.isMergingSemanticsOfDescendants()) {
            return SemanticsNode.findOneLayerOfMergingSemanticsNodes$default(this, unmergedChildren, null, 2, null);
        }
        return this.unmergedChildren$ui(unmergedChildren, includeFakeNodes, includeDeactivatedNodes);
    }

    public static /* synthetic */ List getChildren$ui$default(SemanticsNode semanticsNode, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            boolean bl4 = bl = !semanticsNode.mergingEnabled;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        return semanticsNode.getChildren$ui(bl, bl2, bl3);
    }

    @Nullable
    public final SemanticsNode getParent() {
        LayoutNode node2;
        block7: {
            LayoutNode it;
            LayoutNode currentParent$iv;
            boolean $i$f$findClosestParentNode;
            LayoutNode $this$findClosestParentNode$iv;
            block6: {
                if (this.fakeNodeParent != null) {
                    return this.fakeNodeParent;
                }
                node2 = null;
                if (this.mergingEnabled) {
                    LayoutNode layoutNode;
                    $this$findClosestParentNode$iv = this.layoutNode;
                    $i$f$findClosestParentNode = false;
                    for (currentParent$iv = $this$findClosestParentNode$iv.getParent$ui(); currentParent$iv != null; currentParent$iv = currentParent$iv.getParent$ui()) {
                        it = currentParent$iv;
                        boolean bl = false;
                        SemanticsConfiguration semanticsConfiguration = it.getSemanticsConfiguration();
                        boolean bl2 = semanticsConfiguration != null ? semanticsConfiguration.isMergingSemanticsOfDescendants() : false;
                        if (!bl2) continue;
                        layoutNode = currentParent$iv;
                        break block6;
                    }
                    layoutNode = node2 = null;
                }
            }
            if (node2 == null) {
                LayoutNode layoutNode;
                $this$findClosestParentNode$iv = this.layoutNode;
                $i$f$findClosestParentNode = false;
                for (currentParent$iv = $this$findClosestParentNode$iv.getParent$ui(); currentParent$iv != null; currentParent$iv = currentParent$iv.getParent$ui()) {
                    it = currentParent$iv;
                    boolean bl = false;
                    boolean bl3 = false;
                    if (!it.getNodes$ui().has-H91voCI$ui(NodeKind.constructor-impl(8))) continue;
                    layoutNode = currentParent$iv;
                    break block7;
                }
                layoutNode = node2 = null;
            }
        }
        if (node2 == null) {
            return null;
        }
        return SemanticsNodeKt.SemanticsNode(node2, this.mergingEnabled);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SemanticsNode> findOneLayerOfMergingSemanticsNodes(List<SemanticsNode> unmergedChildren, List<SemanticsNode> list2) {
        void this_$iv;
        SemanticsNode semanticsNode = this;
        List<SemanticsNode> $this$forEachUnmergedChild$iv = unmergedChildren;
        boolean $i$f$forEachUnmergedChild = false;
        int start$iv = $this$forEachUnmergedChild$iv.size();
        SemanticsNode.unmergedChildren$ui$default((SemanticsNode)this_$iv, $this$forEachUnmergedChild$iv, false, false, 6, null);
        int end$iv = $this$forEachUnmergedChild$iv.size();
        for (int i$iv = start$iv; i$iv < end$iv; ++i$iv) {
            SemanticsNode child2 = $this$forEachUnmergedChild$iv.get(i$iv);
            boolean bl = false;
            if (child2.isMergingSemanticsOfDescendants()) {
                list2.add(child2);
                continue;
            }
            if (child2.unmergedConfig.isClearingSemantics()) continue;
            child2.findOneLayerOfMergingSemanticsNodes(unmergedChildren, list2);
        }
        return list2;
    }

    static /* synthetic */ List findOneLayerOfMergingSemanticsNodes$default(SemanticsNode semanticsNode, List list2, List list3, int n, Object object) {
        if ((n & 2) != 0) {
            list3 = new ArrayList();
        }
        return semanticsNode.findOneLayerOfMergingSemanticsNodes(list2, list3);
    }

    @Nullable
    public final NodeCoordinator findCoordinatorToGetBounds$ui() {
        if (this.isFake) {
            SemanticsNode semanticsNode = this.getParent();
            return semanticsNode != null ? semanticsNode.findCoordinatorToGetBounds$ui() : null;
        }
        SemanticsModifierNode semanticsModifierNode = SemanticsNodeKt.getOuterMergingSemantics(this.layoutNode);
        DelegatableNode semanticsModifierNode2 = semanticsModifierNode != null ? (DelegatableNode)semanticsModifierNode : (DelegatableNode)this.outerSemanticsNode;
        boolean bl = false;
        return DelegatableNodeKt.requireCoordinator-64DMado(semanticsModifierNode2, NodeKind.constructor-impl(8));
    }

    private final void emitFakeNodes(List<SemanticsNode> unmergedChildren) {
        Role nodeRole = SemanticsNodeKt.access$getRole(this);
        if (nodeRole != null && this.unmergedConfig.isMergingSemanticsOfDescendants() && !((Collection)unmergedChildren).isEmpty()) {
            SemanticsNode fakeNode2 = this.fakeSemanticsNode-ypyhhiA(nodeRole, (Function1<? super SemanticsPropertyReceiver, Unit>)((Function1)arg_0 -> SemanticsNode.emitFakeNodes$lambda$12(nodeRole, arg_0)));
            unmergedChildren.add(fakeNode2);
        }
        if (this.unmergedConfig.contains(SemanticsProperties.INSTANCE.getContentDescription()) && !((Collection)unmergedChildren).isEmpty() && this.unmergedConfig.isMergingSemanticsOfDescendants()) {
            String contentDescription;
            List<String> list2 = SemanticsConfigurationKt.getOrNull(this.unmergedConfig, SemanticsProperties.INSTANCE.getContentDescription());
            String string = contentDescription = list2 != null ? (String)CollectionsKt.firstOrNull(list2) : null;
            if (contentDescription != null) {
                SemanticsNode fakeNode3 = this.fakeSemanticsNode-ypyhhiA(null, (Function1<? super SemanticsPropertyReceiver, Unit>)((Function1)arg_0 -> SemanticsNode.emitFakeNodes$lambda$13(contentDescription, arg_0)));
                unmergedChildren.add(0, fakeNode3);
            }
        }
    }

    private final SemanticsNode fakeSemanticsNode-ypyhhiA(Role role, Function1<? super SemanticsPropertyReceiver, Unit> properties2) {
        SemanticsConfiguration semanticsConfiguration;
        SemanticsConfiguration it = semanticsConfiguration = new SemanticsConfiguration();
        boolean bl = false;
        it.setMergingSemanticsOfDescendants(false);
        it.setClearingSemantics(false);
        properties2.invoke((Object)it);
        SemanticsConfiguration configuration = semanticsConfiguration;
        SemanticsNode fakeNode2 = new SemanticsNode((Modifier.Node)((Object)new SemanticsModifierNode(properties2){
            final /* synthetic */ Function1<SemanticsPropertyReceiver, Unit> $properties;
            {
                this.$properties = $properties;
            }

            public void applySemantics(SemanticsPropertyReceiver $this$applySemantics) {
                Intrinsics.checkNotNullParameter((Object)$this$applySemantics, (String)"<this>");
                this.$properties.invoke((Object)$this$applySemantics);
            }
        }), false, new LayoutNode(true, role != null ? SemanticsNodeKt.access$roleFakeNodeId(this) : SemanticsNodeKt.access$contentDescriptionFakeNodeId(this)), configuration);
        fakeNode2.isFake = true;
        fakeNode2.fakeNodeParent = this;
        return fakeNode2;
    }

    private static final Unit emitFakeNodes$lambda$12(Role $nodeRole, SemanticsPropertyReceiver $this$fakeSemanticsNode) {
        Intrinsics.checkNotNullParameter((Object)$this$fakeSemanticsNode, (String)"$this$fakeSemanticsNode");
        SemanticsPropertiesKt.setRole-kuIjeqM($this$fakeSemanticsNode, $nodeRole.unbox-impl());
        return Unit.INSTANCE;
    }

    private static final Unit emitFakeNodes$lambda$13(String $contentDescription, SemanticsPropertyReceiver $this$fakeSemanticsNode) {
        Intrinsics.checkNotNullParameter((Object)$this$fakeSemanticsNode, (String)"$this$fakeSemanticsNode");
        SemanticsPropertiesKt.setContentDescription($this$fakeSemanticsNode, $contentDescription);
        return Unit.INSTANCE;
    }
}

