/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSemanticsProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticsProperties.kt\nandroidx/compose/ui/semantics/ProgressBarRangeInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1500:1\n1#2:1501\n*E\n"})
public final class ProgressBarRangeInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float current;
    @NotNull
    private final ClosedFloatingPointRange<Float> range;
    private final int steps;
    @NotNull
    private static final ProgressBarRangeInfo Indeterminate = new ProgressBarRangeInfo(0.0f, RangesKt.rangeTo((float)0.0f, (float)0.0f), 0, 4, null);

    public ProgressBarRangeInfo(float current, @NotNull ClosedFloatingPointRange<Float> range, int steps) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        this.current = current;
        this.range = range;
        this.steps = steps;
        if (!(!Float.isNaN(this.current))) {
            boolean bl = false;
            String string = "current must not be NaN";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ ProgressBarRangeInfo(float f, ClosedFloatingPointRange closedFloatingPointRange, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(f, (ClosedFloatingPointRange<Float>)closedFloatingPointRange, n);
    }

    public final float getCurrent() {
        return this.current;
    }

    @NotNull
    public final ClosedFloatingPointRange<Float> getRange() {
        return this.range;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProgressBarRangeInfo)) {
            return false;
        }
        if (!(this.current == ((ProgressBarRangeInfo)other).current)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.range, ((ProgressBarRangeInfo)other).range)) {
            return false;
        }
        return this.steps == ((ProgressBarRangeInfo)other).steps;
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.current);
        result2 = 31 * result2 + this.range.hashCode();
        result2 = 31 * result2 + this.steps;
        return result2;
    }

    @NotNull
    public String toString() {
        return "ProgressBarRangeInfo(current=" + this.current + ", range=" + this.range + ", steps=" + this.steps + ")";
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProgressBarRangeInfo getIndeterminate() {
            return Indeterminate;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

