/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.scene;

import androidx.annotation.CallSuper;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.CompositionLocalContext;
import androidx.compose.ui.awt.AwtEventFilter;
import androidx.compose.ui.awt.AwtEventListener;
import androidx.compose.ui.awt.AwtEventListeners;
import androidx.compose.ui.awt.Utils_desktopKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.input.pointer.PointerButton;
import androidx.compose.ui.input.pointer.PointerEventType;
import androidx.compose.ui.scene.ComposeContainer;
import androidx.compose.ui.scene.ComposeSceneLayer;
import androidx.compose.ui.scene.ComposeSceneMediator;
import androidx.compose.ui.scene.ComposeSceneMediator_desktopKt;
import androidx.compose.ui.scene.DesktopComposeSceneLayer;
import androidx.compose.ui.scene.DesktopComposeSceneLayer_desktopKt;
import androidx.compose.ui.skiko.RecordDrawRectRenderDecorator;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntRect;
import androidx.compose.ui.unit.IntRectKt;
import androidx.compose.ui.unit.LayoutDirection;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skiko.SkikoRenderDelegate;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class DesktopComposeSceneLayer
implements ComposeSceneLayer {
    @NotNull
    private final ComposeContainer composeContainer;
    @NotNull
    private final BoundsEventFilter boundsEventFilter;
    @NotNull
    private IntRect drawBounds;
    @NotNull
    private IntRect maxDrawInflate;
    @Nullable
    private Function2<? super PointerEventType, ? super PointerButton, Unit> outsidePointerCallback;
    private boolean isClosed;
    @NotNull
    private Density density;
    @NotNull
    private LayoutDirection layoutDirection;
    @NotNull
    private IntRect boundsInWindow;
    public static final int $stable = 8;

    public DesktopComposeSceneLayer(@NotNull ComposeContainer composeContainer, @NotNull Density density, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)composeContainer, (String)"composeContainer");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        this.composeContainer = composeContainer;
        this.boundsEventFilter = new BoundsEventFilter(new Rectangle(this.getWindowContainer().getSize()));
        this.drawBounds = IntRect.Companion.getZero();
        this.maxDrawInflate = IntRect.Companion.getZero();
        this.density = density;
        this.layoutDirection = layoutDirection;
        this.boundsInWindow = IntRect.Companion.getZero();
    }

    @NotNull
    protected final ComposeContainer getComposeContainer() {
        return this.composeContainer;
    }

    @NotNull
    protected final JLayeredPane getWindowContainer() {
        return this.composeContainer.getWindowContainer();
    }

    @NotNull
    protected final Sequence<DesktopComposeSceneLayer> getLayersAbove() {
        return this.composeContainer.layersAbove(this);
    }

    @NotNull
    protected final AwtEventListeners getEventListener() {
        AwtEventListener[] awtEventListenerArray = new AwtEventListener[]{new DetectEventOutsideLayer(), this.boundsEventFilter, new FocusableLayerEventFilter()};
        return new AwtEventListeners(awtEventListenerArray);
    }

    @Nullable
    protected abstract ComposeSceneMediator getMediator();

    @NotNull
    protected final IntRect getDrawBounds() {
        return this.drawBounds;
    }

    protected final void setDrawBounds(@NotNull IntRect intRect) {
        Intrinsics.checkNotNullParameter((Object)intRect, (String)"<set-?>");
        this.drawBounds = intRect;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    @Override
    public final void setDensity(@NotNull Density value2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.density = value2;
            ComposeSceneMediator composeSceneMediator = this.getMediator();
            if (composeSceneMediator == null) break block0;
            composeSceneMediator.onChangeDensity(value2);
        }
    }

    @NotNull
    public final LayoutDirection getLayoutDirection() {
        return this.layoutDirection;
    }

    @Override
    public final void setLayoutDirection(@NotNull LayoutDirection value2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            this.layoutDirection = value2;
            ComposeSceneMediator composeSceneMediator = this.getMediator();
            if (composeSceneMediator == null) break block0;
            composeSceneMediator.onLayoutDirectionChanged(value2);
        }
    }

    @NotNull
    public IntRect getBoundsInWindow() {
        return this.boundsInWindow;
    }

    @Override
    public void setBoundsInWindow(@NotNull IntRect value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.boundsInWindow = value2;
        this.boundsEventFilter.setBounds(Utils_desktopKt.toAwtRectangle(value2, this.density));
    }

    @Override
    public final void setCompositionLocalContext(@Nullable CompositionLocalContext value2) {
        block0: {
            ComposeSceneMediator composeSceneMediator = this.getMediator();
            if (composeSceneMediator == null) break block0;
            composeSceneMediator.setCompositionLocalContext(value2);
        }
    }

    @Override
    @CallSuper
    public void close() {
        this.isClosed = true;
    }

    @Override
    public final void setContent(@NotNull Function2<? super Composer, ? super Integer, Unit> content2) {
        block0: {
            Intrinsics.checkNotNullParameter(content2, (String)"content");
            ComposeSceneMediator composeSceneMediator = this.getMediator();
            if (composeSceneMediator == null) break block0;
            composeSceneMediator.setContent(content2);
        }
    }

    @Override
    public final void setKeyEventListener(@Nullable Function1<? super androidx.compose.ui.input.key.KeyEvent, Boolean> onPreviewKeyEvent2, @Nullable Function1<? super androidx.compose.ui.input.key.KeyEvent, Boolean> onKeyEvent2) {
        block2: {
            Function1 function1;
            ComposeSceneMediator composeSceneMediator = this.getMediator();
            if (composeSceneMediator == null) break block2;
            Function1 function12 = onPreviewKeyEvent2;
            if (function12 == null) {
                function12 = setKeyEventListener.1.INSTANCE;
            }
            if ((function1 = onKeyEvent2) == null) {
                function1 = setKeyEventListener.2.INSTANCE;
            }
            composeSceneMediator.setKeyEventListeners((Function1<? super androidx.compose.ui.input.key.KeyEvent, Boolean>)function12, function1);
        }
    }

    @Override
    public final void setOutsidePointerEventListener(@Nullable Function2<? super PointerEventType, ? super PointerButton, Unit> onOutsidePointerEvent) {
        this.outsidePointerCallback = onOutsidePointerEvent;
    }

    @Override
    public long calculateLocalPosition-qkQi6aY(long positionInWindow) {
        return positionInWindow;
    }

    @NotNull
    protected final RecordDrawRectRenderDecorator recordDrawBounds(@NotNull SkikoRenderDelegate renderDelegate2) {
        Intrinsics.checkNotNullParameter((Object)renderDelegate2, (String)"renderDelegate");
        return new RecordDrawRectRenderDecorator(renderDelegate2, (Function1<? super Rect, Unit>)((Function1)arg_0 -> DesktopComposeSceneLayer.recordDrawBounds$lambda$0(this, arg_0)));
    }

    public void onWindowFocusChanged() {
    }

    public void onWindowContainerPositionChanged() {
    }

    public void onWindowContainerSizeChanged() {
    }

    public void onLayersChange() {
    }

    public void onUpdateBounds() {
    }

    public void onRenderOverlay(@NotNull Canvas canvas, int width, int height, boolean transparent) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
    }

    public final void onMouseEventOutside(@NotNull MouseEvent event) {
        block5: {
            int n;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (this.isClosed) {
                return;
            }
            switch (event.getID()) {
                case 501: {
                    n = PointerEventType.Companion.getPress-7fucELk();
                    break;
                }
                case 502: {
                    n = PointerEventType.Companion.getRelease-7fucELk();
                    break;
                }
                default: {
                    return;
                }
            }
            int eventType = n;
            Function2<? super PointerEventType, ? super PointerButton, Unit> function2 = this.outsidePointerCallback;
            if (function2 == null) break block5;
            function2.invoke((Object)PointerEventType.box-impl(eventType), (Object)ComposeSceneMediator_desktopKt.getComposePointerButton(event));
        }
    }

    private final boolean inBounds(MouseEvent event) {
        Point point = !Intrinsics.areEqual((Object)event.getComponent(), (Object)this.getWindowContainer()) ? SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), this.getWindowContainer()) : event.getPoint();
        return Utils_desktopKt.toAwtRectangle(this.getBoundsInWindow(), this.density).contains(point);
    }

    private static final Unit recordDrawBounds$lambda$0(DesktopComposeSceneLayer this$0, Rect canvasBoundsInPx) {
        Intrinsics.checkNotNullParameter((Object)canvasBoundsInPx, (String)"canvasBoundsInPx");
        long currentCanvasOffset = this$0.drawBounds.getTopLeft-nOcc-ac();
        IntRect drawBoundsInWindow = IntRectKt.roundToIntRect(canvasBoundsInPx).translate--gyyYBs(currentCanvasOffset);
        this$0.maxDrawInflate = DesktopComposeSceneLayer_desktopKt.access$maxInflate(this$0.getBoundsInWindow(), drawBoundsInWindow, this$0.maxDrawInflate);
        this$0.drawBounds = new IntRect(this$0.getBoundsInWindow().getLeft() - this$0.maxDrawInflate.getLeft(), this$0.getBoundsInWindow().getTop() - this$0.maxDrawInflate.getTop(), this$0.getBoundsInWindow().getRight() + this$0.maxDrawInflate.getRight(), this$0.getBoundsInWindow().getBottom() + this$0.maxDrawInflate.getBottom());
        this$0.onUpdateBounds();
        return Unit.INSTANCE;
    }

    private final class BoundsEventFilter
    extends AwtEventFilter {
        @NotNull
        private Rectangle bounds;

        public BoundsEventFilter(Rectangle bounds) {
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            this.bounds = bounds;
        }

        public final void setBounds(@NotNull Rectangle rectangle) {
            Intrinsics.checkNotNullParameter((Object)rectangle, (String)"<set-?>");
            this.bounds = rectangle;
        }

        private final boolean isInBounds(MouseEvent $this$isInBounds) {
            Point localPoint = !Intrinsics.areEqual((Object)$this$isInBounds.getComponent(), (Object)DesktopComposeSceneLayer.this.getWindowContainer()) ? SwingUtilities.convertPoint($this$isInBounds.getComponent(), $this$isInBounds.getPoint(), DesktopComposeSceneLayer.this.getWindowContainer()) : $this$isInBounds.getPoint();
            return this.bounds.contains(localPoint);
        }

        @Override
        public boolean shouldSendMouseEvent(@NotNull MouseEvent event) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            switch (event.getID()) {
                case 503: 
                case 504: 
                case 505: 
                case 506: {
                    return true;
                }
            }
            if (this.isInBounds(event)) {
                bl = true;
            } else {
                DesktopComposeSceneLayer.this.onMouseEventOutside(event);
                bl = false;
            }
            return bl;
        }
    }

    @SourceDebugExtension(value={"SMAP\nDesktopComposeSceneLayer.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopComposeSceneLayer.desktop.kt\nandroidx/compose/ui/scene/DesktopComposeSceneLayer$DetectEventOutsideLayer\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,278:1\n53#2,5:279\n*S KotlinDebug\n*F\n+ 1 DesktopComposeSceneLayer.desktop.kt\nandroidx/compose/ui/scene/DesktopComposeSceneLayer$DetectEventOutsideLayer\n*L\n221#1:279,5\n*E\n"})
    private final class DetectEventOutsideLayer
    implements AwtEventListener {
        /*
         * WARNING - void declaration
         */
        @Override
        public boolean onMouseEvent(@NotNull MouseEvent event) {
            void $this$fastForEachReversed$iv;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            List list2 = SequencesKt.toList(DesktopComposeSceneLayer.this.getLayersAbove());
            DesktopComposeSceneLayer desktopComposeSceneLayer = DesktopComposeSceneLayer.this;
            boolean $i$f$fastForEachReversed = false;
            int n = ((Collection)$this$fastForEachReversed$iv).size() + -1;
            if (0 <= n) {
                do {
                    int index$iv = n--;
                    Object item$iv = $this$fastForEachReversed$iv.get(index$iv);
                    DesktopComposeSceneLayer it = (DesktopComposeSceneLayer)item$iv;
                    boolean bl = false;
                    if (!desktopComposeSceneLayer.inBounds(event)) {
                        it.onMouseEventOutside(event);
                    }
                    if (!it.getFocusable()) continue;
                    return false;
                } while (0 <= n);
            }
            return false;
        }
    }

    @SourceDebugExtension(value={"SMAP\nDesktopComposeSceneLayer.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopComposeSceneLayer.desktop.kt\nandroidx/compose/ui/scene/DesktopComposeSceneLayer$FocusableLayerEventFilter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,278:1\n1228#2,2:279\n*S KotlinDebug\n*F\n+ 1 DesktopComposeSceneLayer.desktop.kt\nandroidx/compose/ui/scene/DesktopComposeSceneLayer$FocusableLayerEventFilter\n*L\n235#1:279,2\n*E\n"})
    private final class FocusableLayerEventFilter
    extends AwtEventFilter {
        private final boolean getNoFocusableLayersAbove() {
            boolean bl;
            block1: {
                Sequence<DesktopComposeSceneLayer> $this$all$iv = DesktopComposeSceneLayer.this.getLayersAbove();
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    DesktopComposeSceneLayer it = (DesktopComposeSceneLayer)element$iv;
                    boolean bl2 = false;
                    if (!it.getFocusable()) continue;
                    bl = false;
                    break block1;
                }
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean shouldSendMouseEvent(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return this.getNoFocusableLayersAbove();
        }

        @Override
        public boolean shouldSendKeyEvent(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return DesktopComposeSceneLayer.this.getFocusable() && this.getNoFocusableLayersAbove();
        }
    }
}

