/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.ui.geometry.MutableRect;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CompositingStrategy;
import androidx.compose.ui.graphics.GraphicsContext;
import androidx.compose.ui.graphics.Matrices_skikoKt;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.MatrixKt;
import androidx.compose.ui.graphics.Outline;
import androidx.compose.ui.graphics.ReusableGraphicsLayerScope;
import androidx.compose.ui.graphics.TransformOrigin;
import androidx.compose.ui.graphics.drawscope.CanvasDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.layer.GraphicsLayer;
import androidx.compose.ui.graphics.layer.GraphicsLayerKt;
import androidx.compose.ui.node.OwnedLayer;
import androidx.compose.ui.platform.InvertMatrixKt;
import androidx.compose.ui.platform.OwnedLayerManager;
import androidx.compose.ui.platform.ShapeContainingUtilKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.DensityKt;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nGraphicsLayerOwnerLayer.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphicsLayerOwnerLayer.skiko.kt\nandroidx/compose/ui/platform/GraphicsLayerOwnerLayer\n+ 2 IntSize.kt\nandroidx/compose/ui/unit/IntSizeKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 5 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 6 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 7 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 8 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n+ 9 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 10 Matrix.kt\nandroidx/compose/ui/graphics/Matrix\n+ 11 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n*L\n1#1,405:1\n30#2:406\n30#2:439\n80#3:407\n85#3:409\n90#3:411\n53#3,3:413\n60#3:417\n70#3:420\n85#3:423\n90#3:425\n53#3,3:427\n80#3:440\n85#3:447\n90#3:449\n60#3:451\n70#3:454\n54#4:408\n59#4:410\n54#4:422\n59#4:424\n54#4:446\n59#4:448\n30#5:412\n30#5:426\n278#5:445\n65#6:416\n69#6:419\n65#6:450\n69#6:453\n22#7:418\n22#7:421\n22#7:452\n22#7:455\n78#8,5:430\n103#8,4:435\n1#9:441\n49#10:442\n52#10,2:443\n233#11:456\n*S KotlinDebug\n*F\n+ 1 GraphicsLayerOwnerLayer.skiko.kt\nandroidx/compose/ui/platform/GraphicsLayerOwnerLayer\n*L\n61#1:406\n300#1:439\n61#1:407\n133#1:409\n134#1:411\n132#1:413,3\n178#1:417\n179#1:420\n214#1:423\n215#1:425\n213#1:427,3\n300#1:440\n350#1:447\n351#1:449\n353#1:451\n354#1:454\n133#1:408\n134#1:410\n214#1:422\n215#1:424\n350#1:446\n351#1:448\n132#1:412\n213#1:426\n349#1:445\n178#1:416\n179#1:419\n353#1:450\n354#1:453\n178#1:418\n179#1:421\n353#1:452\n354#1:455\n278#1:430,5\n281#1:435,4\n327#1:442\n339#1:443,2\n224#1:456\n*E\n"})
public final class GraphicsLayerOwnerLayer
implements OwnedLayer {
    @Nullable
    private final GraphicsContext context;
    @NotNull
    private final OwnedLayerManager layerManager;
    @NotNull
    private GraphicsLayer graphicsLayer;
    @Nullable
    private Function2<? super Canvas, ? super GraphicsLayer, Unit> drawBlock;
    @Nullable
    private Function0<Unit> invalidateParentLayer;
    private long size;
    @NotNull
    private Density density;
    @NotNull
    private LayoutDirection layoutDirection;
    @NotNull
    private final CanvasDrawScope scope;
    private int mutatedFields;
    private long transformOrigin;
    @Nullable
    private Outline outline;
    @NotNull
    private final float[] matrixCache;
    @Nullable
    private float[] inverseMatrixCache;
    private boolean isDestroyed;
    private boolean isDirty;
    private boolean isMatrixDirty;
    private boolean isInverseMatrixDirty;
    private boolean isIdentity;
    @NotNull
    private final Function1<DrawScope, Unit> recordLambda;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public GraphicsLayerOwnerLayer(@NotNull GraphicsLayer graphicsLayer, @Nullable GraphicsContext context2, @NotNull OwnedLayerManager layerManager, @NotNull Function2<? super Canvas, ? super GraphicsLayer, Unit> drawBlock, @NotNull Function0<Unit> invalidateParentLayer) {
        void width$iv;
        Intrinsics.checkNotNullParameter((Object)graphicsLayer, (String)"graphicsLayer");
        Intrinsics.checkNotNullParameter((Object)layerManager, (String)"layerManager");
        Intrinsics.checkNotNullParameter(drawBlock, (String)"drawBlock");
        Intrinsics.checkNotNullParameter(invalidateParentLayer, (String)"invalidateParentLayer");
        this.context = context2;
        this.layerManager = layerManager;
        this.graphicsLayer = graphicsLayer;
        this.drawBlock = drawBlock;
        this.invalidateParentLayer = invalidateParentLayer;
        int n = Integer.MAX_VALUE;
        int height$iv = Integer.MAX_VALUE;
        boolean $i$f$IntSize = false;
        boolean $i$f$packInts = false;
        this.size = IntSize.constructor-impl((long)width$iv << 32 | (long)height$iv & 0xFFFFFFFFL);
        this.density = DensityKt.Density$default(1.0f, 0.0f, 2, null);
        this.layoutDirection = LayoutDirection.Ltr;
        this.scope = new CanvasDrawScope();
        this.transformOrigin = TransformOrigin.Companion.getCenter-SzJe1aQ();
        this.matrixCache = Matrix.constructor-impl$default(null, 1, null);
        this.isDirty = true;
        this.isIdentity = true;
        this.recordLambda = arg_0 -> GraphicsLayerOwnerLayer.recordLambda$lambda$3(this, arg_0);
    }

    private final void setDirty(boolean value2) {
        if (value2 != this.isDirty) {
            this.isDirty = value2;
            this.layerManager.notifyLayerIsDirty(this, value2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateLayerProperties(@NotNull ReusableGraphicsLayerScope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        int maybeChangedFields = scope2.getMutatedFields$ui() | this.mutatedFields;
        this.layoutDirection = scope2.getLayoutDirection$ui();
        this.density = scope2.getGraphicsDensity$ui();
        if ((maybeChangedFields & 0x1000) != 0) {
            this.transformOrigin = scope2.getTransformOrigin-SzJe1aQ();
        }
        if ((maybeChangedFields & 1) != 0) {
            this.graphicsLayer.setScaleX(scope2.getScaleX());
        }
        if ((maybeChangedFields & 2) != 0) {
            this.graphicsLayer.setScaleY(scope2.getScaleY());
        }
        if ((maybeChangedFields & 4) != 0) {
            this.graphicsLayer.setAlpha(scope2.getAlpha());
        }
        if ((maybeChangedFields & 8) != 0) {
            this.graphicsLayer.setTranslationX(scope2.getTranslationX());
        }
        if ((maybeChangedFields & 0x10) != 0) {
            this.graphicsLayer.setTranslationY(scope2.getTranslationY());
        }
        if ((maybeChangedFields & 0x20) != 0) {
            this.graphicsLayer.setShadowElevation(scope2.getShadowElevation());
        }
        if ((maybeChangedFields & 0x40) != 0) {
            this.graphicsLayer.setAmbientShadowColor-8_81llA(scope2.getAmbientShadowColor-0d7_KjU());
        }
        if ((maybeChangedFields & 0x80) != 0) {
            this.graphicsLayer.setSpotShadowColor-8_81llA(scope2.getSpotShadowColor-0d7_KjU());
        }
        if ((maybeChangedFields & 0x400) != 0) {
            this.graphicsLayer.setRotationZ(scope2.getRotationZ());
        }
        if ((maybeChangedFields & 0x100) != 0) {
            this.graphicsLayer.setRotationX(scope2.getRotationX());
        }
        if ((maybeChangedFields & 0x200) != 0) {
            this.graphicsLayer.setRotationY(scope2.getRotationY());
        }
        if ((maybeChangedFields & 0x800) != 0) {
            this.graphicsLayer.setCameraDistance(scope2.getCameraDistance());
        }
        if ((maybeChangedFields & 0x1000) != 0) {
            if (TransformOrigin.equals-impl0(this.transformOrigin, TransformOrigin.Companion.getCenter-SzJe1aQ())) {
                this.graphicsLayer.setPivotOffset-k-4lQ0M(Offset.Companion.getUnspecified-F1C5BW0());
            } else {
                void y$iv;
                void x$iv;
                long arg0$iv22 = this.size;
                boolean bl = false;
                long value$iv$iv = arg0$iv22;
                boolean $i$f$unpackInt1 = false;
                float arg0$iv22 = TransformOrigin.getPivotFractionX-impl(this.transformOrigin) * (float)((int)(value$iv$iv >> 32));
                long arg0$iv32 = this.size;
                boolean bl2 = false;
                long value$iv$iv2 = arg0$iv32;
                boolean $i$f$unpackInt2 = false;
                float arg0$iv32 = TransformOrigin.getPivotFractionY-impl(this.transformOrigin) * (float)((int)(value$iv$iv2 & 0xFFFFFFFFL));
                boolean $i$f$Offset = false;
                boolean $i$f$packFloats = false;
                long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
                long v2$iv$iv = Float.floatToRawIntBits((float)y$iv);
                this.graphicsLayer.setPivotOffset-k-4lQ0M(Offset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
            }
        }
        if ((maybeChangedFields & 0x4000) != 0) {
            this.graphicsLayer.setClip(scope2.getClip());
        }
        if ((maybeChangedFields & 0x20000) != 0) {
            this.graphicsLayer.setRenderEffect(scope2.getRenderEffect());
        }
        if ((maybeChangedFields & 0x8000) != 0) {
            int n;
            int x$iv = scope2.getCompositingStrategy--NrFUSI();
            if (CompositingStrategy.equals-impl0(x$iv, CompositingStrategy.Companion.getAuto--NrFUSI())) {
                n = androidx.compose.ui.graphics.layer.CompositingStrategy.Companion.getAuto-ke2Ky5w();
            } else if (CompositingStrategy.equals-impl0(x$iv, CompositingStrategy.Companion.getOffscreen--NrFUSI())) {
                n = androidx.compose.ui.graphics.layer.CompositingStrategy.Companion.getOffscreen-ke2Ky5w();
            } else if (CompositingStrategy.equals-impl0(x$iv, CompositingStrategy.Companion.getModulateAlpha--NrFUSI())) {
                n = androidx.compose.ui.graphics.layer.CompositingStrategy.Companion.getModulateAlpha-ke2Ky5w();
            } else {
                throw new IllegalStateException("Not supported composition strategy");
            }
            this.graphicsLayer.setCompositingStrategy-Wpw9cng(n);
        }
        if ((maybeChangedFields & 0x1F1B) != 0) {
            this.isMatrixDirty = true;
            this.isInverseMatrixDirty = true;
        }
        boolean outlineChanged = false;
        if (!Intrinsics.areEqual((Object)this.outline, (Object)scope2.getOutline$ui())) {
            outlineChanged = true;
            this.outline = scope2.getOutline$ui();
            this.updateOutline();
        }
        this.mutatedFields = scope2.getMutatedFields$ui();
        if (maybeChangedFields != 0 || outlineChanged) {
            this.invalidate();
        }
    }

    private final void updateOutline() {
        Outline outline = this.outline;
        if (outline == null) {
            return;
        }
        Outline outline2 = outline;
        GraphicsLayerKt.setOutline(this.graphicsLayer, outline2);
    }

    @Override
    public boolean isInLayer-k-4lQ0M(long position) {
        boolean bl = false;
        long value$iv$iv = position;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float x = Float.intBitsToFloat(bits$iv$iv$iv);
        boolean bl2 = false;
        long value$iv$iv2 = position;
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits2 = false;
        float y = Float.intBitsToFloat(bits$iv$iv$iv2);
        if (this.graphicsLayer.getClip()) {
            return ShapeContainingUtilKt.isInOutline$default(this.graphicsLayer.getOutline(), x, y, null, null, 24, null);
        }
        return true;
    }

    @Override
    public void move--gyyYBs(long position) {
        this.graphicsLayer.setTopLeft--gyyYBs(position);
        this.invalidate();
    }

    @Override
    public void resize-ozmzZPI(long size) {
        if (!IntSize.equals-impl0(size, this.size)) {
            this.size = size;
            this.invalidate();
        }
    }

    @Override
    public void drawLayer(@NotNull Canvas canvas, @Nullable GraphicsLayer parentLayer) {
        DrawContext drawContext2;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.updateDisplayList();
        DrawContext it = drawContext2 = this.scope.getDrawContext();
        boolean bl = false;
        it.setCanvas(canvas);
        it.setGraphicsLayer(parentLayer);
        GraphicsLayerKt.drawLayer(this.scope, this.graphicsLayer);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateDisplayList() {
        if (this.isDirty) {
            if (!TransformOrigin.equals-impl0(this.transformOrigin, TransformOrigin.Companion.getCenter-SzJe1aQ()) && !IntSize.equals-impl0(this.graphicsLayer.getSize-YbymL2g(), this.size)) {
                void x$iv;
                long arg0$iv22 = this.size;
                boolean bl = false;
                long value$iv$iv = arg0$iv22;
                boolean $i$f$unpackInt1 = false;
                float arg0$iv22 = TransformOrigin.getPivotFractionX-impl(this.transformOrigin) * (float)((int)(value$iv$iv >> 32));
                long arg0$iv = this.size;
                boolean bl2 = false;
                long value$iv$iv2 = arg0$iv;
                boolean $i$f$unpackInt2 = false;
                float y$iv = TransformOrigin.getPivotFractionY-impl(this.transformOrigin) * (float)((int)(value$iv$iv2 & 0xFFFFFFFFL));
                boolean $i$f$Offset = false;
                boolean $i$f$packFloats = false;
                long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
                long v2$iv$iv = Float.floatToRawIntBits(y$iv);
                this.graphicsLayer.setPivotOffset-k-4lQ0M(Offset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
            }
            this.graphicsLayer.record-mL-hObY(this.density, this.layoutDirection, this.size, this.recordLambda);
            this.setDirty(false);
        }
    }

    @Override
    public void invalidate() {
        if (this.isDestroyed) {
            return;
        }
        this.setDirty(true);
        this.layerManager.invalidate();
    }

    @Override
    public void destroy() {
        this.drawBlock = null;
        this.invalidateParentLayer = null;
        this.isDestroyed = true;
        this.setDirty(false);
        if (this.context != null) {
            this.context.releaseGraphicsLayer(this.graphicsLayer);
            this.layerManager.recycle(this);
        }
    }

    @Override
    public long mapOffset-8S9VItk(long point, boolean inverse) {
        float[] fArray;
        if (inverse) {
            fArray = this.getInverseMatrix-3i98HWw();
            if (fArray == null) {
                return Offset.Companion.getInfinite-F1C5BW0();
            }
        } else {
            fArray = this.getMatrix-sQKQjiQ();
        }
        float[] matrix = fArray;
        return this.isIdentity ? point : Matrix.map-MK-Hz9U(matrix, point);
    }

    @Override
    public void mapBounds(@NotNull MutableRect rect, boolean inverse) {
        float[] matrix;
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        float[] fArray = matrix = inverse ? this.getInverseMatrix-3i98HWw() : this.getMatrix-sQKQjiQ();
        if (!this.isIdentity) {
            if (matrix == null) {
                rect.set(0.0f, 0.0f, 0.0f, 0.0f);
            } else {
                Matrix.map-impl(matrix, rect);
            }
        }
    }

    @Override
    public void transform-58bKbWc(@NotNull float[] matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Matrix.timesAssign-58bKbWc(matrix, this.getMatrix-sQKQjiQ());
    }

    @Override
    @NotNull
    public float[] getUnderlyingMatrix-sQKQjiQ() {
        return this.getMatrix-sQKQjiQ();
    }

    @Override
    public void inverseTransform-58bKbWc(@NotNull float[] matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] inverse = this.getInverseMatrix-3i98HWw();
        if (inverse != null) {
            Matrix.timesAssign-58bKbWc(matrix, inverse);
        }
    }

    private final float[] getMatrix-sQKQjiQ() {
        this.updateMatrix();
        return this.matrixCache;
    }

    /*
     * WARNING - void declaration
     */
    private final float[] getInverseMatrix-3i98HWw() {
        float[] fArray;
        float[] inverseMatrix;
        float[] fArray2 = this.inverseMatrixCache;
        if (this.inverseMatrixCache == null) {
            float[] fArray3;
            float[] it = fArray3 = Matrix.constructor-impl$default(null, 1, null);
            boolean bl = false;
            this.inverseMatrixCache = it;
            fArray2 = inverseMatrix = fArray3;
        }
        if (!this.isInverseMatrixDirty) {
            void row$iv;
            boolean bl = false;
            boolean column$iv = false;
            boolean bl2 = false;
            if (Float.isNaN(inverseMatrix[row$iv * 4 + column$iv])) {
                return null;
            }
            return inverseMatrix;
        }
        this.isInverseMatrixDirty = false;
        float[] matrix = this.getMatrix-sQKQjiQ();
        if (this.isIdentity) {
            fArray = matrix;
        } else if (InvertMatrixKt.invertTo-JiSxe2E(matrix, inverseMatrix)) {
            fArray = inverseMatrix;
        } else {
            boolean column$iv = false;
            boolean bl2 = false;
            float v$iv = Float.NaN;
            boolean bl = false;
            inverseMatrix[row$iv * 4 + column$iv] = v$iv;
            fArray = null;
        }
        return fArray;
    }

    private final void updateMatrix() {
        long arg0$iv;
        if (!this.isMatrixDirty) {
            return;
        }
        GraphicsLayer $this$updateMatrix_u24lambda_u247 = this.graphicsLayer;
        boolean bl = false;
        float pivotX = 0.0f;
        float pivotY = 0.0f;
        long $this$isUnspecified$iv = $this$updateMatrix_u24lambda_u247.getPivotOffset-F1C5BW0();
        boolean bl2 = false;
        if (($this$isUnspecified$iv & 0x7FFFFFFF7FFFFFFFL) == 9205357640488583168L) {
            arg0$iv = this.size;
            boolean bl3 = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt1 = false;
            pivotX = (float)((int)(value$iv$iv >> 32)) / 2.0f;
            arg0$iv = this.size;
            boolean bl4 = false;
            value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt2 = false;
            pivotY = (float)((int)(value$iv$iv & 0xFFFFFFFFL)) / 2.0f;
        } else {
            arg0$iv = $this$updateMatrix_u24lambda_u247.getPivotOffset-F1C5BW0();
            boolean bl5 = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            pivotX = Float.intBitsToFloat(bits$iv$iv$iv);
            arg0$iv = $this$updateMatrix_u24lambda_u247.getPivotOffset-F1C5BW0();
            boolean bl6 = false;
            value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat2 = false;
            bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            pivotY = Float.intBitsToFloat(bits$iv$iv$iv);
        }
        Matrices_skikoKt.prepareTransformationMatrix-ao2toNE(this.matrixCache, pivotX, pivotY, $this$updateMatrix_u24lambda_u247.getTranslationX(), $this$updateMatrix_u24lambda_u247.getTranslationY(), $this$updateMatrix_u24lambda_u247.getRotationX(), $this$updateMatrix_u24lambda_u247.getRotationY(), $this$updateMatrix_u24lambda_u247.getRotationZ(), $this$updateMatrix_u24lambda_u247.getScaleX(), $this$updateMatrix_u24lambda_u247.getScaleY(), $this$updateMatrix_u24lambda_u247.getCameraDistance());
        this.isMatrixDirty = false;
        this.isIdentity = MatrixKt.isIdentity-58bKbWc(this.matrixCache);
    }

    private static final Unit recordLambda$lambda$3(GraphicsLayerOwnerLayer this$0, DrawScope drawScope) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)drawScope, (String)"<this>");
            DrawScope $this$drawIntoCanvas$iv = drawScope;
            boolean $i$f$drawIntoCanvas = false;
            Canvas canvas = $this$drawIntoCanvas$iv.getDrawContext().getCanvas();
            boolean bl = false;
            Function2<? super Canvas, ? super GraphicsLayer, Unit> function2 = this$0.drawBlock;
            if (function2 == null) break block0;
            Function2<? super Canvas, ? super GraphicsLayer, Unit> it = function2;
            boolean bl2 = false;
            it.invoke((Object)canvas, (Object)drawScope.getDrawContext().getGraphicsLayer());
        }
        return Unit.INSTANCE;
    }
}

