/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.platform.InputMethodRequestsImpl;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.TextEditingScope;
import androidx.compose.ui.text.input.TextEditorState;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DesktopTextInputService2 {
    @NotNull
    private final PlatformComponent component;
    @Nullable
    private InputMethodRequestsImpl currentInputMethodRequests;
    public static final int $stable = 8;

    public DesktopTextInputService2(@NotNull PlatformComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.component = component;
    }

    /*
     * WARNING - void declaration
     */
    public void startInput(@NotNull TextEditorState state2, @NotNull ImeOptions imeOptions, @NotNull Function1<? super Function1<? super TextEditingScope, Unit>, Unit> editText) {
        void it;
        InputMethodRequestsImpl inputMethodRequestsImpl;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter(editText, (String)"editText");
        InputMethodRequestsImpl inputMethodRequestsImpl2 = inputMethodRequestsImpl = new InputMethodRequestsImpl(this.component, state2, editText);
        PlatformComponent platformComponent = this.component;
        boolean bl = false;
        this.currentInputMethodRequests = it;
        platformComponent.enableInput(inputMethodRequestsImpl);
    }

    public void stopInput() {
        this.component.disableInput();
        this.currentInputMethodRequests = null;
    }

    public void focusedRectChanged(@NotNull Rect rect) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            InputMethodRequestsImpl inputMethodRequestsImpl = this.currentInputMethodRequests;
            if (inputMethodRequestsImpl == null) break block0;
            inputMethodRequestsImpl.setFocusedRect(rect);
        }
    }

    public final void onKeyEvent(@NotNull KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
        switch (keyEvent.getID()) {
            case 400: {
                InputMethodRequestsImpl inputMethodRequestsImpl = this.currentInputMethodRequests;
                if (inputMethodRequestsImpl != null) {
                    inputMethodRequestsImpl.setCharKeyPressed(true);
                }
                break;
            }
            case 402: {
                InputMethodRequestsImpl inputMethodRequestsImpl = this.currentInputMethodRequests;
                if (inputMethodRequestsImpl == null) break;
                inputMethodRequestsImpl.setCharKeyPressed(false);
                break;
            }
        }
    }

    public final void inputMethodTextChanged(@NotNull InputMethodEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InputMethodRequestsImpl inputMethodRequestsImpl = this.currentInputMethodRequests;
        if (inputMethodRequestsImpl == null) {
            return;
        }
        InputMethodRequestsImpl inputMethodRequests = inputMethodRequestsImpl;
        if (!event.isConsumed()) {
            inputMethodRequests.replaceInputMethodText(event);
            event.consume();
        }
    }
}

