/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.platform.DesktopPlatformInput_desktopKt;
import androidx.compose.ui.platform.DesktopTextInputService;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextInCodePointsCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.PlatformTextInputService;
import androidx.compose.ui.text.input.SetComposingTextCommand;
import androidx.compose.ui.text.input.TextFieldValue;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

public final class DesktopTextInputService
implements PlatformTextInputService {
    @NotNull
    private final PlatformComponent component;
    @Nullable
    private CurrentInput currentInput;
    private boolean charKeyPressed;
    private boolean needToDeletePreviousChar;
    public static final int $stable = 8;

    public DesktopTextInputService(@NotNull PlatformComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.component = component;
    }

    public final boolean getCharKeyPressed() {
        return this.charKeyPressed;
    }

    public final void setNeedToDeletePreviousChar(boolean bl) {
        this.needToDeletePreviousChar = bl;
    }

    @Override
    public void startInput(@NotNull TextFieldValue value2, @NotNull ImeOptions imeOptions, @NotNull Function1<? super List<? extends EditCommand>, Unit> onEditCommand, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed) {
        CurrentInput input;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter(onEditCommand, (String)"onEditCommand");
        Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
        this.currentInput = input = new CurrentInput(value2, onEditCommand, onImeActionPerformed, imeOptions.getImeAction-eUduSuo(), null, 16, null);
        this.component.enableInput(this.methodRequestsForInput(input));
    }

    @Override
    public void stopInput() {
        this.component.disableInput();
        this.currentInput = null;
    }

    @Override
    public void showSoftwareKeyboard() {
    }

    @Override
    public void hideSoftwareKeyboard() {
    }

    @Override
    public void updateState(@Nullable TextFieldValue oldValue, @NotNull TextFieldValue newValue) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
            CurrentInput currentInput = this.currentInput;
            if (currentInput == null) break block0;
            currentInput.setValue(newValue);
        }
    }

    @Override
    public void notifyFocusedRect(@NotNull Rect rect) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            CurrentInput currentInput = this.currentInput;
            if (currentInput == null) break block0;
            currentInput.setFocusedRect(rect);
        }
    }

    public final void onKeyEvent(@NotNull KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
        switch (keyEvent.getID()) {
            case 400: {
                this.charKeyPressed = true;
                break;
            }
            case 402: {
                this.charKeyPressed = false;
            }
        }
    }

    public final void inputMethodTextChanged(@NotNull InputMethodEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.currentInput != null && !event.isConsumed()) {
            this.replaceInputMethodText(event);
            event.consume();
        }
    }

    private final void replaceInputMethodText(InputMethodEvent event) {
        CurrentInput currentInput = this.currentInput;
        if (currentInput == null) {
            return;
        }
        CurrentInput input = currentInput;
        AttributedCharacterIterator attributedCharacterIterator = event.getText();
        String string = attributedCharacterIterator != null ? DesktopPlatformInput_desktopKt.access$toStringUntil(attributedCharacterIterator, event.getCommittedCharacterCount()) : null;
        if (string == null) {
            string = "";
        }
        String committed = string;
        AttributedCharacterIterator attributedCharacterIterator2 = event.getText();
        String string2 = attributedCharacterIterator2 != null ? DesktopPlatformInput_desktopKt.access$toStringFrom(attributedCharacterIterator2, event.getCommittedCharacterCount()) : null;
        if (string2 == null) {
            string2 = "";
        }
        String composing = string2;
        List ops = new ArrayList();
        if (this.needToDeletePreviousChar && TextRange.getMin-impl(input.getValue().getSelection-d9O1mEE()) > 0 && ((CharSequence)composing).length() == 0) {
            this.needToDeletePreviousChar = false;
            ops.add(new DeleteSurroundingTextInCodePointsCommand(1, 0));
        }
        ops.add(new CommitTextCommand(committed, 1));
        if (((CharSequence)composing).length() > 0) {
            ops.add(new SetComposingTextCommand(composing, 1));
        }
        input.getOnEditCommand().invoke((Object)ops);
    }

    private final methodRequestsForInput.1 methodRequestsForInput(CurrentInput input) {
        return new InputMethodRequests(input, this){
            final /* synthetic */ CurrentInput $input;
            final /* synthetic */ DesktopTextInputService this$0;
            {
                this.$input = $input;
                this.this$0 = $receiver;
            }

            public TextHitInfo getLocationOffset(int x, int y) {
                if (this.$input.getValue().getComposition-MzsxiRA() != null) {
                    return TextHitInfo.leading(0);
                }
                return null;
            }

            public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
                return null;
            }

            public int getInsertPositionOffset() {
                TextRange textRange = this.$input.getValue().getComposition-MzsxiRA();
                int composedStartIndex = textRange != null ? TextRange.getStart-impl(textRange.unbox-impl()) : 0;
                TextRange textRange2 = this.$input.getValue().getComposition-MzsxiRA();
                int composedEndIndex = textRange2 != null ? TextRange.getEnd-impl(textRange2.unbox-impl()) : 0;
                int caretIndex = TextRange.getStart-impl(this.$input.getValue().getSelection-d9O1mEE());
                if (caretIndex < composedStartIndex) {
                    return caretIndex;
                }
                if (caretIndex < composedEndIndex) {
                    return composedStartIndex;
                }
                return caretIndex - (composedEndIndex - composedStartIndex);
            }

            public int getCommittedTextLength() {
                TextRange textRange = this.$input.getValue().getComposition-MzsxiRA();
                return this.$input.getValue().getText().length() - (textRange != null ? TextRange.getLength-impl(textRange.unbox-impl()) : 0);
            }

            public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
                if (this.this$0.getCharKeyPressed() && OsArch_jvmKt.getHostOs() == OS.MacOS) {
                    this.this$0.setNeedToDeletePreviousChar(true);
                }
                String str = TextRangeKt.substring-FDrldGo(this.$input.getValue().getText(), this.$input.getValue().getSelection-d9O1mEE());
                AttributedCharacterIterator attributedCharacterIterator = new AttributedString(str).getIterator();
                Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
                return attributedCharacterIterator;
            }

            public Rectangle getTextLocation(TextHitInfo offset) {
                Rectangle rectangle;
                Rect rect = this.$input.getFocusedRect();
                if (rect != null) {
                    Rect rect2 = rect;
                    DesktopTextInputService desktopTextInputService = this.this$0;
                    Rect it = rect2;
                    boolean bl = false;
                    int x = (int)(it.getRight() / DesktopTextInputService.access$getComponent$p(desktopTextInputService).getDensity().getDensity()) + DesktopTextInputService.access$getComponent$p((DesktopTextInputService)desktopTextInputService).getLocationOnScreen().x;
                    int y = (int)(it.getTop() / DesktopTextInputService.access$getComponent$p(desktopTextInputService).getDensity().getDensity()) + DesktopTextInputService.access$getComponent$p((DesktopTextInputService)desktopTextInputService).getLocationOnScreen().y;
                    Rect this_$iv = it;
                    boolean $i$f$getWidth = false;
                    int n = (int)(this_$iv.getRight() - this_$iv.getLeft());
                    this_$iv = it;
                    boolean $i$f$getHeight = false;
                    Rectangle rectangle2 = new Rectangle(x, y, n, (int)(this_$iv.getBottom() - this_$iv.getTop()));
                    rectangle = rectangle2;
                } else {
                    rectangle = null;
                }
                return rectangle;
            }

            public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
                TextRange comp = this.$input.getValue().getComposition-MzsxiRA();
                String text2 = this.$input.getValue().getText();
                long range = TextRangeKt.TextRange(RangesKt.coerceAtMost((int)beginIndex, (int)text2.length()), RangesKt.coerceAtMost((int)endIndex, (int)text2.length()));
                if (comp == null) {
                    String res2 = TextRangeKt.substring-FDrldGo(text2, range);
                    AttributedCharacterIterator attributedCharacterIterator = new AttributedString(res2).getIterator();
                    Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
                    return attributedCharacterIterator;
                }
                String committed = TextRangeKt.substring-FDrldGo(text2, TextRangeKt.TextRange(RangesKt.coerceAtMost((int)Math.min(TextRange.getMin-impl(range), TextRange.getMin-impl(comp.unbox-impl())), (int)text2.length()), RangesKt.coerceAtMost((int)Math.max(TextRange.getMax-impl(range), TextRange.getMax-impl(comp.unbox-impl())), (int)text2.length())));
                AttributedCharacterIterator attributedCharacterIterator = new AttributedString(committed).getIterator();
                Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
                return attributedCharacterIterator;
            }
        };
    }

    public static final /* synthetic */ PlatformComponent access$getComponent$p(DesktopTextInputService $this) {
        return $this.component;
    }

    public static final class CurrentInput {
        @NotNull
        private TextFieldValue value;
        @NotNull
        private final Function1<List<? extends EditCommand>, Unit> onEditCommand;
        @NotNull
        private final Function1<ImeAction, Unit> onImeActionPerformed;
        private final int imeAction;
        @Nullable
        private Rect focusedRect;
        public static final int $stable = 8;

        private CurrentInput(TextFieldValue value2, Function1<? super List<? extends EditCommand>, Unit> onEditCommand, Function1<? super ImeAction, Unit> onImeActionPerformed, int imeAction, Rect focusedRect) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter(onEditCommand, (String)"onEditCommand");
            Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
            this.value = value2;
            this.onEditCommand = onEditCommand;
            this.onImeActionPerformed = onImeActionPerformed;
            this.imeAction = imeAction;
            this.focusedRect = focusedRect;
        }

        public /* synthetic */ CurrentInput(TextFieldValue textFieldValue, Function1 function1, Function1 function12, int n, Rect rect, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x10) != 0) {
                rect = null;
            }
            this(textFieldValue, function1, function12, n, rect, null);
        }

        @NotNull
        public final TextFieldValue getValue() {
            return this.value;
        }

        public final void setValue(@NotNull TextFieldValue textFieldValue) {
            Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"<set-?>");
            this.value = textFieldValue;
        }

        @NotNull
        public final Function1<List<? extends EditCommand>, Unit> getOnEditCommand() {
            return this.onEditCommand;
        }

        @Nullable
        public final Rect getFocusedRect() {
            return this.focusedRect;
        }

        public final void setFocusedRect(@Nullable Rect rect) {
            this.focusedRect = rect;
        }

        @NotNull
        public String toString() {
            return "CurrentInput(value=" + this.value + ", onEditCommand=" + this.onEditCommand + ", onImeActionPerformed=" + this.onImeActionPerformed + ", imeAction=" + ImeAction.toString-impl(this.imeAction) + ", focusedRect=" + this.focusedRect + ")";
        }

        public int hashCode() {
            int result2 = this.value.hashCode();
            result2 = result2 * 31 + this.onEditCommand.hashCode();
            result2 = result2 * 31 + this.onImeActionPerformed.hashCode();
            result2 = result2 * 31 + ImeAction.hashCode-impl(this.imeAction);
            result2 = result2 * 31 + (this.focusedRect == null ? 0 : this.focusedRect.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CurrentInput)) {
                return false;
            }
            CurrentInput currentInput = (CurrentInput)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)currentInput.value)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onEditCommand, currentInput.onEditCommand)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onImeActionPerformed, currentInput.onImeActionPerformed)) {
                return false;
            }
            if (!ImeAction.equals-impl0(this.imeAction, currentInput.imeAction)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.focusedRect, (Object)currentInput.focusedRect);
        }

        public /* synthetic */ CurrentInput(TextFieldValue value2, Function1 onEditCommand, Function1 onImeActionPerformed, int imeAction, Rect focusedRect, DefaultConstructorMarker $constructor_marker) {
            this(value2, (Function1<? super List<? extends EditCommand>, Unit>)onEditCommand, (Function1<? super ImeAction, Unit>)onImeActionPerformed, imeAction, focusedRect);
        }
    }
}

