/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.runtime.snapshots.Snapshot;
import androidx.compose.ui.internal.Threading_desktopKt;
import androidx.compose.ui.node.CommandList;
import androidx.compose.ui.node.OwnerSnapshotObserver;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class SnapshotInvalidationTracker {
    @NotNull
    private final Function0<Unit> invalidate;
    @NotNull
    private final CommandList snapshotChanges;
    private boolean needMeasureAndLayout;
    private boolean needDraw;
    private volatile /* synthetic */ Object renderingThreadId$volatile;
    public static final int $stable = 8;

    public SnapshotInvalidationTracker(@NotNull Function0<Unit> invalidate) {
        Intrinsics.checkNotNullParameter(invalidate, (String)"invalidate");
        this.invalidate = invalidate;
        this.snapshotChanges = new CommandList(this.invalidate);
        this.needMeasureAndLayout = true;
        this.needDraw = true;
    }

    public /* synthetic */ SnapshotInvalidationTracker(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = SnapshotInvalidationTracker::_init_$lambda$0;
        }
        this((Function0<Unit>)function0);
    }

    private final Long getRenderingThreadId() {
        return (Long)this.renderingThreadId$volatile;
    }

    private final void setRenderingThreadId(Long l) {
        this.renderingThreadId$volatile = l;
    }

    public final boolean getHasInvalidations() {
        return this.needMeasureAndLayout || this.needDraw || this.snapshotChanges.getHasCommands();
    }

    public final void requestMeasureAndLayout() {
        this.needMeasureAndLayout = true;
        this.invalidate.invoke();
    }

    public final void onMeasureAndLayout() {
        this.needMeasureAndLayout = false;
    }

    public final void requestDraw() {
        this.needDraw = true;
        this.invalidate.invoke();
    }

    public final void onDraw() {
        this.needDraw = false;
    }

    @NotNull
    public final OwnerSnapshotObserver snapshotObserver() {
        return new OwnerSnapshotObserver((Function1<? super Function0<Unit>, Unit>)((Function1)arg_0 -> SnapshotInvalidationTracker.snapshotObserver$lambda$1(this, arg_0)));
    }

    public final void sendAndPerformSnapshotChanges() {
        Snapshot.Companion.sendApplyNotifications();
        this.snapshotChanges.perform();
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit snapshotObserver$lambda$1(SnapshotInvalidationTracker this$0, Function0 command2) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        Long l = this$0.getRenderingThreadId();
        long l2 = Threading_desktopKt.getCurrentThreadId();
        if (l != null && l == l2) {
            command2.invoke();
        } else {
            this$0.snapshotChanges.add((Function0<Unit>)command2);
        }
        return Unit.INSTANCE;
    }

    public SnapshotInvalidationTracker() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$setRenderingThreadId(SnapshotInvalidationTracker $this, Long l) {
        $this.setRenderingThreadId(l);
    }
}

