/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.collection.MutableObjectIntMap;
import androidx.collection.ObjectIntMap;
import androidx.collection.ObjectIntMapKt;
import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.node.DepthSortedSetKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.SortedSet;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nDepthSortedSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DepthSortedSet.kt\nandroidx/compose/ui/node/DepthSortedSet\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n+ 3 ObjectIntMap.kt\nandroidx/collection/ObjectIntMap\n*L\n1#1,203:1\n107#1:225\n57#2,4:204\n57#2,4:208\n57#2,4:212\n57#2,4:216\n57#2,4:221\n438#3:220\n*S KotlinDebug\n*F\n+ 1 DepthSortedSet.kt\nandroidx/compose/ui/node/DepthSortedSet\n*L\n99#1:225\n55#1:204,4\n63#1:208,4\n70#1:212,4\n77#1:216,4\n84#1:221,4\n81#1:220\n*E\n"})
public final class DepthSortedSet {
    private final boolean extraAssertions;
    @Nullable
    private MutableObjectIntMap<LayoutNode> mapOfOriginalDepth;
    @NotNull
    private final SortedSet<LayoutNode> set;
    public static final int $stable = 8;

    public DepthSortedSet(boolean extraAssertions) {
        this.extraAssertions = extraAssertions;
        this.set = new SortedSet(DepthSortedSetKt.access$getDepthComparator$p());
    }

    public final boolean contains(@NotNull LayoutNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        boolean contains = this.set.contains(node2);
        if (this.extraAssertions) {
            boolean value$iv = contains == this.safeMapOfOriginalDepth().containsKey((Object)node2);
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("inconsistency in TreeSet");
            }
        }
        return contains;
    }

    public final void add(@NotNull LayoutNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        boolean value$iv = node2.isAttached();
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("DepthSortedSet.add called on an unattached node");
        }
        if (this.extraAssertions) {
            MutableObjectIntMap<LayoutNode> map2 = this.safeMapOfOriginalDepth();
            int usedDepth = map2.getOrDefault((Object)node2, Integer.MAX_VALUE);
            if (usedDepth == Integer.MAX_VALUE) {
                map2.set((Object)node2, node2.getDepth$ui());
            } else {
                boolean value$iv2 = usedDepth == node2.getDepth$ui();
                boolean $i$f$checkPrecondition2 = false;
                if (!value$iv2) {
                    boolean bl = false;
                    InlineClassHelperKt.throwIllegalStateException("invalid node depth");
                }
            }
        }
        this.set.add(node2);
    }

    public final boolean remove(@NotNull LayoutNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        boolean value$iv = node2.isAttached();
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("DepthSortedSet.remove called on an unattached node");
        }
        boolean contains = this.set.remove(node2);
        if (this.extraAssertions) {
            MutableObjectIntMap<LayoutNode> map2 = this.safeMapOfOriginalDepth();
            ObjectIntMap this_$iv = (ObjectIntMap)map2;
            boolean $i$f$contains = false;
            if (this_$iv.containsKey((Object)node2)) {
                int usedDepth = map2.get((Object)node2);
                map2.remove((Object)node2);
                boolean value$iv2 = usedDepth == (contains ? node2.getDepth$ui() : Integer.MAX_VALUE);
                boolean $i$f$checkPrecondition2 = false;
                if (!value$iv2) {
                    boolean bl = false;
                    InlineClassHelperKt.throwIllegalStateException("invalid node depth");
                }
            }
        }
        return contains;
    }

    @NotNull
    public final LayoutNode pop() {
        LayoutNode node2 = (LayoutNode)this.set.first();
        this.remove(node2);
        return node2;
    }

    public final boolean isEmpty() {
        return this.set.isEmpty();
    }

    private final MutableObjectIntMap<LayoutNode> safeMapOfOriginalDepth() {
        if (this.mapOfOriginalDepth == null) {
            this.mapOfOriginalDepth = ObjectIntMapKt.mutableObjectIntMapOf();
        }
        MutableObjectIntMap<LayoutNode> mutableObjectIntMap = this.mapOfOriginalDepth;
        Intrinsics.checkNotNull(mutableObjectIntMap);
        return mutableObjectIntMap;
    }

    @NotNull
    public String toString() {
        return this.set.toString();
    }
}

