/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer;

import androidx.collection.LongSparseArray;
import androidx.compose.ui.input.pointer.InternalPointerEvent;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.PointerInputEvent;
import androidx.compose.ui.input.pointer.PointerInputEventData;
import androidx.compose.ui.input.pointer.PositionCalculator;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nPointerInputEventProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointerInputEventProcessor.kt\nandroidx/compose/ui/input/pointer/PointerInputChangeEventProducer\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,264:1\n35#2,5:265\n*S KotlinDebug\n*F\n+ 1 PointerInputEventProcessor.kt\nandroidx/compose/ui/input/pointer/PointerInputChangeEventProducer\n*L\n178#1:265,5\n*E\n"})
final class PointerInputChangeEventProducer {
    @NotNull
    private final LongSparseArray<PointerInputData> previousPointerInputData = new LongSparseArray(0, 1, null);

    @NotNull
    public final InternalPointerEvent produce(@NotNull PointerInputEvent pointerInputEvent, @NotNull PositionCalculator positionCalculator) {
        Intrinsics.checkNotNullParameter((Object)pointerInputEvent, (String)"pointerInputEvent");
        Intrinsics.checkNotNullParameter((Object)positionCalculator, (String)"positionCalculator");
        LongSparseArray changes = new LongSparseArray(pointerInputEvent.getPointers().size());
        List<PointerInputEventData> $this$fastForEach$iv = pointerInputEvent.getPointers();
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            PointerInputEventData item$iv;
            PointerInputEventData it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            long previousTime = 0L;
            long previousPosition = 0L;
            boolean previousDown = false;
            PointerInputData previousData = (PointerInputData)this.previousPointerInputData.get(it.getId-J3iCeTQ());
            if (previousData == null) {
                previousTime = it.getUptime();
                previousPosition = it.getPosition-F1C5BW0();
                previousDown = false;
            } else {
                previousTime = previousData.getUptime();
                previousDown = previousData.getDown();
                previousPosition = positionCalculator.screenToLocal-MK-Hz9U(previousData.getPositionOnScreen-F1C5BW0());
            }
            changes.put(it.getId-J3iCeTQ(), (Object)new PointerInputChange(it.getId-J3iCeTQ(), it.getUptime(), it.getPosition-F1C5BW0(), it.getDown(), it.getPressure(), previousTime, previousPosition, previousDown, false, it.getType-T8wyACA(), it.getHistorical(), it.getScrollDelta-F1C5BW0(), it.getOriginalEventPosition-F1C5BW0(), null));
            if (it.getDown()) {
                this.previousPointerInputData.put(it.getId-J3iCeTQ(), (Object)new PointerInputData(it.getUptime(), it.getPositionOnScreen-F1C5BW0(), it.getDown(), null));
                continue;
            }
            this.previousPointerInputData.remove(it.getId-J3iCeTQ());
        }
        return new InternalPointerEvent((LongSparseArray<PointerInputChange>)changes, pointerInputEvent);
    }

    public final void clear() {
        this.previousPointerInputData.clear();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class PointerInputData {
        private final long uptime;
        private final long positionOnScreen;
        private final boolean down;

        private PointerInputData(long uptime, long positionOnScreen, boolean down) {
            this.uptime = uptime;
            this.positionOnScreen = positionOnScreen;
            this.down = down;
        }

        public final long getUptime() {
            return this.uptime;
        }

        public final long getPositionOnScreen-F1C5BW0() {
            return this.positionOnScreen;
        }

        public final boolean getDown() {
            return this.down;
        }

        public /* synthetic */ PointerInputData(long uptime, long positionOnScreen, boolean down, DefaultConstructorMarker $constructor_marker) {
            this(uptime, positionOnScreen, down);
        }
    }
}

