/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer;

import androidx.collection.LongSparseArray;
import androidx.collection.MutableObjectList;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.input.pointer.InternalPointerEvent;
import androidx.compose.ui.input.pointer.Node;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.layout.LayoutCoordinates;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nHitPathTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HitPathTracker.kt\nandroidx/compose/ui/input/pointer/NodeParent\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,647:1\n1101#2:648\n1083#2,2:649\n424#3,8:651\n424#3,8:659\n424#3,8:667\n424#3,8:675\n472#3:683\n424#3,8:684\n44#3:692\n472#3:693\n424#3,8:694\n*S KotlinDebug\n*F\n+ 1 HitPathTracker.kt\nandroidx/compose/ui/input/pointer/NodeParent\n*L\n190#1:648\n190#1:649,2\n202#1:651,8\n229#1:659,8\n249#1:667,8\n259#1:675,8\n276#1:683\n300#1:684,8\n304#1:692\n305#1:693\n313#1:694,8\n*E\n"})
public class NodeParent {
    @NotNull
    private final MutableVector<Node> children;
    @NotNull
    private final MutableObjectList<NodeParent> removeMatchingPointerInputModifierNodeList;
    public static final int $stable = 8;

    public NodeParent() {
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.children = new MutableVector<Node>(new Node[capacity$iv$iv], 0);
        this.removeMatchingPointerInputModifierNodeList = new MutableObjectList(10);
    }

    @NotNull
    public final MutableVector<Node> getChildren() {
        return this.children;
    }

    public boolean buildCache(@NotNull LongSparseArray<PointerInputChange> changes, @NotNull LayoutCoordinates parentCoordinates, @NotNull InternalPointerEvent internalPointerEvent, boolean isInBounds) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)parentCoordinates, (String)"parentCoordinates");
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        boolean changed = false;
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        T[] content$iv = this_$iv.content;
        int size$iv = this_$iv.getSize();
        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
            Node it = (Node)content$iv[i$iv];
            boolean bl = false;
            changed = it.buildCache(changes, parentCoordinates, internalPointerEvent, isInBounds) || changed;
        }
        return changed;
    }

    public boolean dispatchMainEventPass(@NotNull LongSparseArray<PointerInputChange> changes, @NotNull LayoutCoordinates parentCoordinates, @NotNull InternalPointerEvent internalPointerEvent, boolean isInBounds) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)parentCoordinates, (String)"parentCoordinates");
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        boolean dispatched = false;
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        T[] content$iv = this_$iv.content;
        int size$iv = this_$iv.getSize();
        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
            Node it = (Node)content$iv[i$iv];
            boolean bl = false;
            dispatched = it.dispatchMainEventPass(changes, parentCoordinates, internalPointerEvent, isInBounds) || dispatched;
        }
        return dispatched;
    }

    public boolean dispatchFinalEventPass(@NotNull InternalPointerEvent internalPointerEvent) {
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        boolean dispatched = false;
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        T[] content$iv = this_$iv.content;
        int size$iv = this_$iv.getSize();
        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
            Node it = (Node)content$iv[i$iv];
            boolean bl = false;
            dispatched = it.dispatchFinalEventPass(internalPointerEvent) || dispatched;
        }
        this.cleanUpHits(internalPointerEvent);
        this.cleanUpHover();
        return dispatched;
    }

    public void dispatchCancel() {
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        T[] content$iv = this_$iv.content;
        int size$iv = this_$iv.getSize();
        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
            Node it = (Node)content$iv[i$iv];
            boolean bl = false;
            it.dispatchCancel();
        }
    }

    public void removePointerInputModifierNode(@NotNull Modifier.Node pointerInputModifierNode) {
        Intrinsics.checkNotNullParameter((Object)pointerInputModifierNode, (String)"pointerInputModifierNode");
        this.removeMatchingPointerInputModifierNodeList.clear();
        this.removeMatchingPointerInputModifierNodeList.add((Object)this);
        while (this.removeMatchingPointerInputModifierNodeList.isNotEmpty()) {
            NodeParent parent = (NodeParent)this.removeMatchingPointerInputModifierNodeList.removeAt(this.removeMatchingPointerInputModifierNodeList.getSize() - 1);
            int index = 0;
            while (index < parent.children.getSize()) {
                MutableVector<Node> this_$iv = parent.children;
                boolean $i$f$get = false;
                Node child2 = (Node)this_$iv.content[index];
                if (Intrinsics.areEqual((Object)child2.getModifierNode(), (Object)pointerInputModifierNode)) {
                    parent.children.remove(child2);
                    child2.dispatchCancel();
                    continue;
                }
                this.removeMatchingPointerInputModifierNodeList.add((Object)child2);
                ++index;
            }
        }
    }

    public final void clear() {
        this.children.clear();
    }

    public void removeInvalidPointerIdsAndChanges(long pointerIdValue, @NotNull MutableObjectList<Node> hitNodes) {
        Intrinsics.checkNotNullParameter(hitNodes, (String)"hitNodes");
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        T[] content$iv = this_$iv.content;
        int size$iv = this_$iv.getSize();
        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
            Node it = (Node)content$iv[i$iv];
            boolean bl = false;
            it.removeInvalidPointerIdsAndChanges(pointerIdValue, hitNodes);
        }
    }

    public void cleanUpHits(@NotNull InternalPointerEvent internalPointerEvent) {
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$getLastIndex = false;
        for (int i2 = this_$iv.getSize() - 1; -1 < i2; --i2) {
            MutableVector<Node> this_$iv2 = this.children;
            boolean $i$f$get = false;
            Node child2 = (Node)this_$iv2.content[i2];
            if (!child2.getPointerIds().isEmpty()) continue;
            this.children.removeAt(i2);
        }
    }

    public void cleanUpHover() {
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        T[] content$iv = this_$iv.content;
        int size$iv = this_$iv.getSize();
        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
            Node it = (Node)content$iv[i$iv];
            boolean bl = false;
            it.cleanUpHover();
        }
    }
}

