/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer;

import androidx.collection.LongSparseArray;
import androidx.collection.MutableObjectList;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.HistoricalChange;
import androidx.compose.ui.input.pointer.InternalPointerEvent;
import androidx.compose.ui.input.pointer.NodeParent;
import androidx.compose.ui.input.pointer.PointerEvent;
import androidx.compose.ui.input.pointer.PointerEventKt;
import androidx.compose.ui.input.pointer.PointerEventPass;
import androidx.compose.ui.input.pointer.PointerEventType;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.util.PointerIdArray;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.DelegatingNode;
import androidx.compose.ui.node.NodeKind;
import androidx.compose.ui.node.PointerInputModifierNode;
import androidx.compose.ui.node.PointerInputModifierNodeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nHitPathTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HitPathTracker.kt\nandroidx/compose/ui/input/pointer/Node\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 3 NodeKind.kt\nandroidx/compose/ui/node/Nodes\n+ 4 DelegatableNode.kt\nandroidx/compose/ui/node/DelegatableNodeKt\n+ 5 Modifier.kt\nandroidx/compose/ui/Modifier$Node\n+ 6 DelegatingNode.kt\nandroidx/compose/ui/node/DelegatingNode\n+ 7 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 8 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 9 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 10 PointerIdArray.kt\nandroidx/compose/ui/input/pointer/util/PointerIdArray\n*L\n1#1,647:1\n592#1,5:656\n599#1:757\n592#1,5:758\n599#1:815\n424#2,8:648\n424#2,8:705\n424#2,8:807\n424#2,8:876\n95#3:661\n95#3:713\n95#3:763\n95#3:816\n95#3:884\n437#4,6:662\n447#4,2:669\n449#4,8:674\n457#4,9:685\n466#4,8:697\n437#4,6:714\n447#4,2:721\n449#4,8:726\n457#4,9:737\n466#4,8:749\n437#4,6:764\n447#4,2:771\n449#4,8:776\n457#4,9:787\n466#4,8:799\n437#4,6:817\n447#4,2:824\n449#4,8:829\n457#4,9:840\n466#4,8:852\n437#4,6:885\n447#4,2:892\n449#4,8:897\n457#4,9:908\n466#4,8:920\n252#5:668\n252#5:720\n252#5:770\n252#5:823\n252#5:891\n240#6,3:671\n243#6,3:694\n240#6,3:723\n243#6,3:746\n240#6,3:773\n243#6,3:796\n240#6,3:826\n243#6,3:849\n240#6,3:894\n243#6,3:917\n1101#7:682\n1083#7,2:683\n1101#7:734\n1083#7,2:735\n1101#7:784\n1083#7,2:785\n1101#7:837\n1083#7,2:838\n1101#7:905\n1083#7,2:906\n111#8,2:860\n111#8,2:865\n35#9,3:862\n39#9:867\n118#9:869\n35#9,5:870\n119#9:875\n35#9,3:928\n39#9:932\n40#10:868\n67#10:931\n*S KotlinDebug\n*F\n+ 1 HitPathTracker.kt\nandroidx/compose/ui/input/pointer/Node\n*L\n373#1:656,5\n373#1:757\n412#1:758,5\n412#1:815\n358#1:648,8\n384#1:705,8\n422#1:807,8\n609#1:876,8\n378#1:661\n398#1:713\n416#1:763\n450#1:816\n610#1:884\n378#1:662,6\n378#1:669,2\n378#1:674,8\n378#1:685,9\n378#1:697,8\n398#1:714,6\n398#1:721,2\n398#1:726,8\n398#1:737,9\n398#1:749,8\n416#1:764,6\n416#1:771,2\n416#1:776,8\n416#1:787,9\n416#1:799,8\n450#1:817,6\n450#1:824,2\n450#1:829,8\n450#1:840,9\n450#1:852,8\n610#1:885,6\n610#1:892,2\n610#1:897,8\n610#1:908,9\n610#1:920,8\n378#1:668\n398#1:720\n416#1:770\n450#1:823\n610#1:891\n378#1:671,3\n378#1:694,3\n398#1:723,3\n398#1:746,3\n416#1:773,3\n416#1:796,3\n450#1:826,3\n450#1:849,3\n610#1:894,3\n610#1:917,3\n378#1:682\n378#1:683,2\n398#1:734\n398#1:735,2\n416#1:784\n416#1:785,2\n450#1:837\n450#1:838,2\n610#1:905\n610#1:906,2\n467#1:860,2\n477#1:865,2\n472#1:862,3\n472#1:867\n526#1:869\n526#1:870,5\n526#1:875\n622#1:928,3\n622#1:932\n512#1:868\n633#1:931\n*E\n"})
public final class Node
extends NodeParent {
    @NotNull
    private final Modifier.Node modifierNode;
    @NotNull
    private final PointerIdArray pointerIds;
    private boolean isIn;
    private boolean hasEntered;
    @NotNull
    private final LongSparseArray<PointerInputChange> relevantChanges;
    @Nullable
    private LayoutCoordinates coordinates;
    @Nullable
    private PointerEvent pointerEvent;
    public static final int $stable = 8;

    public Node(@NotNull Modifier.Node modifierNode) {
        Intrinsics.checkNotNullParameter((Object)modifierNode, (String)"modifierNode");
        this.modifierNode = modifierNode;
        this.pointerIds = new PointerIdArray();
        this.isIn = true;
        this.relevantChanges = new LongSparseArray(2);
    }

    @NotNull
    public final Modifier.Node getModifierNode() {
        return this.modifierNode;
    }

    @NotNull
    public final PointerIdArray getPointerIds() {
        return this.pointerIds;
    }

    @Override
    public void removeInvalidPointerIdsAndChanges(long pointerIdValue, @NotNull MutableObjectList<Node> hitNodes) {
        Intrinsics.checkNotNullParameter(hitNodes, (String)"hitNodes");
        if (this.pointerIds.contains(pointerIdValue) && !hitNodes.contains((Object)this)) {
            this.pointerIds.remove(pointerIdValue);
            this.relevantChanges.remove(pointerIdValue);
        }
        MutableVector<Node> this_$iv = this.getChildren();
        boolean $i$f$forEach = false;
        T[] content$iv = this_$iv.content;
        int size$iv = this_$iv.getSize();
        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
            Node it = (Node)content$iv[i$iv];
            boolean bl = false;
            it.removeInvalidPointerIdsAndChanges(pointerIdValue, hitNodes);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean dispatchMainEventPass(@NotNull LongSparseArray<PointerInputChange> changes, @NotNull LayoutCoordinates parentCoordinates, @NotNull InternalPointerEvent internalPointerEvent, boolean isInBounds) {
        boolean bl;
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)parentCoordinates, (String)"parentCoordinates");
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        Node this_$iv = this;
        boolean $i$f$dispatchIfNeeded = false;
        if (this_$iv.relevantChanges.isEmpty()) {
            bl = false;
        } else if (!this_$iv.modifierNode.isAttached()) {
            bl = false;
        } else {
            Object this_$iv2;
            Modifier.Node theNode$iv;
            boolean $i$f$MutableVector;
            int capacity$iv$iv$iv;
            boolean $i$f$mutableVectorOf;
            Modifier.Node this_$iv$iv;
            boolean bl2;
            Modifier.Node next$iv;
            Modifier.Node node$iv$iv;
            boolean $i$f$forEachImmediateDelegate$ui;
            void kind$iv;
            Object it;
            void $this$dispatchForKind_u2d6rFNWt0$iv;
            boolean bl3 = false;
            PointerEvent pointerEvent = this.pointerEvent;
            Intrinsics.checkNotNull((Object)pointerEvent);
            PointerEvent event = pointerEvent;
            LayoutCoordinates layoutCoordinates = this.coordinates;
            Intrinsics.checkNotNull((Object)layoutCoordinates);
            long size = layoutCoordinates.getSize-YbymL2g();
            Modifier.Node node2 = this.modifierNode;
            int n = 0;
            n = NodeKind.constructor-impl(16);
            boolean bl4 = false;
            MutableVector<Modifier.Node> stack$iv = null;
            Modifier.Node node$iv = null;
            node$iv = $this$dispatchForKind_u2d6rFNWt0$iv;
            while (node$iv != null) {
                if (node$iv instanceof PointerInputModifierNode) {
                    it = (PointerInputModifierNode)((Object)node$iv);
                    boolean bl5 = false;
                    it.onPointerEvent-H0pRuoY(event, PointerEventPass.Initial, size);
                } else {
                    Modifier.Node this_$iv$iv2 = node$iv;
                    boolean bl6 = false;
                    if ((this_$iv$iv2.getKindSet$ui() & kind$iv) != 0 && node$iv instanceof DelegatingNode) {
                        int count$iv = 0;
                        DelegatingNode this_$iv$iv3 = (DelegatingNode)node$iv;
                        $i$f$forEachImmediateDelegate$ui = false;
                        for (node$iv$iv = this_$iv$iv3.getDelegate$ui(); node$iv$iv != null; node$iv$iv = node$iv$iv.getChild$ui()) {
                            next$iv = node$iv$iv;
                            bl2 = false;
                            this_$iv$iv = next$iv;
                            $i$f$isKind-H91voCI$ui = false;
                            if (!((this_$iv$iv.getKindSet$ui() & kind$iv) != 0)) continue;
                            if (++count$iv == 1) {
                                node$iv = next$iv;
                                continue;
                            }
                            MutableVector<Modifier.Node> mutableVector = stack$iv;
                            if (mutableVector == null) {
                                $i$f$mutableVectorOf = false;
                                capacity$iv$iv$iv = 16;
                                $i$f$MutableVector = false;
                                mutableVector = new MutableVector<Modifier.Node>(new Modifier.Node[capacity$iv$iv$iv], 0);
                            }
                            stack$iv = mutableVector;
                            theNode$iv = node$iv;
                            if (theNode$iv != null) {
                                MutableVector<Modifier.Node> mutableVector2 = stack$iv;
                                if (mutableVector2 != null) {
                                    mutableVector2.add(theNode$iv);
                                }
                                node$iv = null;
                            }
                            MutableVector<Modifier.Node> mutableVector3 = stack$iv;
                            if (mutableVector3 == null) continue;
                            mutableVector3.add(next$iv);
                        }
                        if (count$iv == 1) continue;
                    }
                }
                node$iv = DelegatableNodeKt.access$pop(stack$iv);
            }
            if (this.modifierNode.isAttached()) {
                this_$iv2 = this.getChildren();
                boolean $i$f$forEach = false;
                T[] content$iv = ((MutableVector)this_$iv2).content;
                int size$iv = ((MutableVector)this_$iv2).getSize();
                for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                    it = (Node)content$iv[i$iv];
                    boolean bl7 = false;
                    LayoutCoordinates layoutCoordinates2 = this.coordinates;
                    Intrinsics.checkNotNull((Object)layoutCoordinates2);
                    ((Node)it).dispatchMainEventPass(this.relevantChanges, layoutCoordinates2, internalPointerEvent, isInBounds);
                }
            }
            if (this.modifierNode.isAttached()) {
                this_$iv2 = this.modifierNode;
                n = 0;
                n = NodeKind.constructor-impl(16);
                bl4 = false;
                stack$iv = null;
                node$iv = null;
                node$iv = $this$dispatchForKind_u2d6rFNWt0$iv;
                while (node$iv != null) {
                    if (node$iv instanceof PointerInputModifierNode) {
                        it = (PointerInputModifierNode)((Object)node$iv);
                        boolean bl8 = false;
                        it.onPointerEvent-H0pRuoY(event, PointerEventPass.Main, size);
                    } else {
                        Modifier.Node this_$iv$iv4 = node$iv;
                        boolean bl9 = false;
                        if ((this_$iv$iv4.getKindSet$ui() & kind$iv) != 0 && node$iv instanceof DelegatingNode) {
                            int count$iv = 0;
                            DelegatingNode this_$iv$iv5 = (DelegatingNode)node$iv;
                            $i$f$forEachImmediateDelegate$ui = false;
                            for (node$iv$iv = this_$iv$iv5.getDelegate$ui(); node$iv$iv != null; node$iv$iv = node$iv$iv.getChild$ui()) {
                                next$iv = node$iv$iv;
                                bl2 = false;
                                this_$iv$iv = next$iv;
                                $i$f$isKind-H91voCI$ui = false;
                                if (!((this_$iv$iv.getKindSet$ui() & kind$iv) != 0)) continue;
                                if (++count$iv == 1) {
                                    node$iv = next$iv;
                                    continue;
                                }
                                MutableVector<Modifier.Node> mutableVector = stack$iv;
                                if (mutableVector == null) {
                                    $i$f$mutableVectorOf = false;
                                    capacity$iv$iv$iv = 16;
                                    $i$f$MutableVector = false;
                                    mutableVector = new MutableVector<Modifier.Node>(new Modifier.Node[capacity$iv$iv$iv], 0);
                                }
                                stack$iv = mutableVector;
                                theNode$iv = node$iv;
                                if (theNode$iv != null) {
                                    MutableVector<Modifier.Node> mutableVector4 = stack$iv;
                                    if (mutableVector4 != null) {
                                        mutableVector4.add(theNode$iv);
                                    }
                                    node$iv = null;
                                }
                                MutableVector<Modifier.Node> mutableVector5 = stack$iv;
                                if (mutableVector5 == null) continue;
                                mutableVector5.add(next$iv);
                            }
                            if (count$iv == 1) continue;
                        }
                    }
                    node$iv = DelegatableNodeKt.access$pop(stack$iv);
                }
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean dispatchFinalEventPass(@NotNull InternalPointerEvent internalPointerEvent) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        Node this_$iv = this;
        boolean $i$f$dispatchIfNeeded = false;
        if (this_$iv.relevantChanges.isEmpty()) {
            bl = false;
        } else if (!this_$iv.modifierNode.isAttached()) {
            bl = false;
        } else {
            Object it;
            void $this$dispatchForKind_u2d6rFNWt0$iv;
            boolean bl2 = false;
            PointerEvent pointerEvent = this.pointerEvent;
            Intrinsics.checkNotNull((Object)pointerEvent);
            PointerEvent event = pointerEvent;
            LayoutCoordinates layoutCoordinates = this.coordinates;
            Intrinsics.checkNotNull((Object)layoutCoordinates);
            long size = layoutCoordinates.getSize-YbymL2g();
            Modifier.Node node2 = this.modifierNode;
            int n = 0;
            n = NodeKind.constructor-impl(16);
            boolean bl3 = false;
            MutableVector<Modifier.Node> stack$iv = null;
            Modifier.Node node$iv = null;
            node$iv = $this$dispatchForKind_u2d6rFNWt0$iv;
            while (node$iv != null) {
                if (node$iv instanceof PointerInputModifierNode) {
                    it = (PointerInputModifierNode)((Object)node$iv);
                    boolean bl4 = false;
                    it.onPointerEvent-H0pRuoY(event, PointerEventPass.Final, size);
                } else {
                    void kind$iv;
                    Modifier.Node this_$iv$iv = node$iv;
                    boolean bl5 = false;
                    if ((this_$iv$iv.getKindSet$ui() & kind$iv) != 0 && node$iv instanceof DelegatingNode) {
                        int count$iv = 0;
                        DelegatingNode this_$iv$iv2 = (DelegatingNode)node$iv;
                        boolean $i$f$forEachImmediateDelegate$ui = false;
                        for (Modifier.Node node$iv$iv = this_$iv$iv2.getDelegate$ui(); node$iv$iv != null; node$iv$iv = node$iv$iv.getChild$ui()) {
                            Modifier.Node next$iv = node$iv$iv;
                            boolean bl6 = false;
                            Modifier.Node this_$iv$iv3 = next$iv;
                            $i$f$isKind-H91voCI$ui = false;
                            if (!((this_$iv$iv3.getKindSet$ui() & kind$iv) != 0)) continue;
                            if (++count$iv == 1) {
                                node$iv = next$iv;
                                continue;
                            }
                            MutableVector<Modifier.Node> mutableVector = stack$iv;
                            if (mutableVector == null) {
                                boolean $i$f$mutableVectorOf = false;
                                int capacity$iv$iv$iv = 16;
                                boolean $i$f$MutableVector = false;
                                mutableVector = new MutableVector<Modifier.Node>(new Modifier.Node[capacity$iv$iv$iv], 0);
                            }
                            stack$iv = mutableVector;
                            Modifier.Node theNode$iv = node$iv;
                            if (theNode$iv != null) {
                                MutableVector<Modifier.Node> mutableVector2 = stack$iv;
                                if (mutableVector2 != null) {
                                    mutableVector2.add(theNode$iv);
                                }
                                node$iv = null;
                            }
                            MutableVector<Modifier.Node> mutableVector3 = stack$iv;
                            if (mutableVector3 == null) continue;
                            mutableVector3.add(next$iv);
                        }
                        if (count$iv == 1) continue;
                    }
                }
                node$iv = DelegatableNodeKt.access$pop(stack$iv);
            }
            if (this.modifierNode.isAttached()) {
                MutableVector<Node> this_$iv2 = this.getChildren();
                boolean $i$f$forEach = false;
                T[] content$iv = this_$iv2.content;
                int size$iv = this_$iv2.getSize();
                for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                    it = (Node)content$iv[i$iv];
                    boolean bl7 = false;
                    ((Node)it).dispatchFinalEventPass(internalPointerEvent);
                }
            }
            bl = true;
        }
        boolean result2 = bl;
        this.cleanUpHits(internalPointerEvent);
        this.clearCache();
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean buildCache(@NotNull LongSparseArray<PointerInputChange> changes, @NotNull LayoutCoordinates parentCoordinates, @NotNull InternalPointerEvent internalPointerEvent, boolean isInBounds) {
        PointerInputChange pointerInputChange;
        PointerEvent event;
        boolean childChanged;
        block24: {
            int kind$iv;
            void $this$dispatchForKind_u2d6rFNWt0$iv;
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            Intrinsics.checkNotNullParameter((Object)parentCoordinates, (String)"parentCoordinates");
            Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
            childChanged = super.buildCache(changes, parentCoordinates, internalPointerEvent, isInBounds);
            if (!this.modifierNode.isAttached()) {
                return true;
            }
            Modifier.Node node2 = this.modifierNode;
            int n = 0;
            n = NodeKind.constructor-impl(16);
            boolean bl = false;
            MutableVector<Modifier.Node> stack$iv = null;
            Modifier.Node node$iv = null;
            node$iv = $this$dispatchForKind_u2d6rFNWt0$iv;
            while (node$iv != null) {
                if (node$iv instanceof PointerInputModifierNode) {
                    PointerInputModifierNode it = (PointerInputModifierNode)((Object)node$iv);
                    boolean bl2 = false;
                    this.coordinates = PointerInputModifierNodeKt.getLayoutCoordinates(it);
                } else {
                    Modifier.Node this_$iv$iv = node$iv;
                    boolean bl3 = false;
                    if ((this_$iv$iv.getKindSet$ui() & kind$iv) != 0 && node$iv instanceof DelegatingNode) {
                        int count$iv = 0;
                        DelegatingNode this_$iv$iv2 = (DelegatingNode)node$iv;
                        boolean $i$f$forEachImmediateDelegate$ui = false;
                        for (Modifier.Node node$iv$iv = this_$iv$iv2.getDelegate$ui(); node$iv$iv != null; node$iv$iv = node$iv$iv.getChild$ui()) {
                            Modifier.Node next$iv = node$iv$iv;
                            boolean bl4 = false;
                            Modifier.Node this_$iv$iv3 = next$iv;
                            $i$f$isKind-H91voCI$ui = false;
                            if (!((this_$iv$iv3.getKindSet$ui() & kind$iv) != 0)) continue;
                            if (++count$iv == 1) {
                                node$iv = next$iv;
                                continue;
                            }
                            MutableVector<Modifier.Node> mutableVector = stack$iv;
                            if (mutableVector == null) {
                                boolean $i$f$mutableVectorOf = false;
                                int capacity$iv$iv$iv = 16;
                                boolean $i$f$MutableVector = false;
                                mutableVector = new MutableVector<Modifier.Node>(new Modifier.Node[capacity$iv$iv$iv], 0);
                            }
                            stack$iv = mutableVector;
                            Modifier.Node theNode$iv = node$iv;
                            if (theNode$iv != null) {
                                MutableVector<Modifier.Node> mutableVector2 = stack$iv;
                                if (mutableVector2 != null) {
                                    mutableVector2.add(theNode$iv);
                                }
                                node$iv = null;
                            }
                            MutableVector<Modifier.Node> mutableVector3 = stack$iv;
                            if (mutableVector3 == null) continue;
                            mutableVector3.add(next$iv);
                        }
                        if (count$iv == 1) continue;
                    }
                }
                node$iv = DelegatableNodeKt.access$pop(stack$iv);
            }
            if (this.coordinates == null) {
                return true;
            }
            kind$iv = changes.size();
            for (int j = 0; j < kind$iv; ++j) {
                long keyValue = changes.keyAt(j);
                PointerInputChange change2 = (PointerInputChange)changes.valueAt(j);
                if (!this.pointerIds.contains(keyValue)) continue;
                long prevPosition = change2.getPreviousPosition-F1C5BW0();
                long currentPosition = change2.getPosition-F1C5BW0();
                boolean bl5 = false;
                long v$iv = prevPosition & 0x7FFFFFFF7FFFFFFFL;
                if (!((v$iv + 0x7FFFFF007FFFFFL & 0x8000000080000000L) == 0L)) continue;
                bl5 = false;
                v$iv = currentPosition & 0x7FFFFFFF7FFFFFFFL;
                if (!((v$iv + 0x7FFFFF007FFFFFL & 0x8000000080000000L) == 0L)) continue;
                ArrayList<HistoricalChange> historical = new ArrayList<HistoricalChange>(change2.getHistorical().size());
                List<HistoricalChange> $this$fastForEach$iv22 = change2.getHistorical();
                boolean $i$f$fastForEach = false;
                int theNode$iv = ((Collection)$this$fastForEach$iv22).size();
                for (int index$iv = 0; index$iv < theNode$iv; ++index$iv) {
                    HistoricalChange item$iv;
                    HistoricalChange it = item$iv = $this$fastForEach$iv22.get(index$iv);
                    boolean bl6 = false;
                    long historicalPosition = it.getPosition-F1C5BW0();
                    $i$f$isValid-impl = false;
                    long v$iv2 = historicalPosition & 0x7FFFFFFF7FFFFFFFL;
                    if (!((v$iv2 + 0x7FFFFF007FFFFFL & 0x8000000080000000L) == 0L)) continue;
                    long l = it.getUptimeMillis();
                    LayoutCoordinates layoutCoordinates = this.coordinates;
                    Intrinsics.checkNotNull((Object)layoutCoordinates);
                    historical.add(new HistoricalChange(l, layoutCoordinates.localPositionOf-R5De75A(parentCoordinates, historicalPosition), it.getOriginalEventPosition-F1C5BW0$ui(), null));
                }
                LayoutCoordinates layoutCoordinates = this.coordinates;
                Intrinsics.checkNotNull((Object)layoutCoordinates);
                long $this$fastForEach$iv22 = layoutCoordinates.localPositionOf-R5De75A(parentCoordinates, prevPosition);
                LayoutCoordinates layoutCoordinates2 = this.coordinates;
                Intrinsics.checkNotNull((Object)layoutCoordinates2);
                long index$iv = layoutCoordinates2.localPositionOf-R5De75A(parentCoordinates, currentPosition);
                this.relevantChanges.put(keyValue, (Object)PointerInputChange.copy-OHpmEuE$default(change2, 0L, 0L, index$iv, false, 0L, $this$fastForEach$iv22, false, 0, historical, 0L, 731, null));
            }
            if (this.relevantChanges.isEmpty()) {
                this.pointerIds.clear();
                this.getChildren().clear();
                return true;
            }
            PointerIdArray this_$iv = this.pointerIds;
            int $i$f$getLastIndex = 0;
            for (int i2 = this_$iv.getSize() - 1; -1 < i2; --i2) {
                long pointerId = this.pointerIds.get-_I2yYro(i2);
                if (changes.containsKey(pointerId)) continue;
                this.pointerIds.removeAt(i2);
            }
            ArrayList<Object> changesList = new ArrayList<Object>(this.relevantChanges.size());
            $i$f$getLastIndex = this.relevantChanges.size();
            for (int i3 = 0; i3 < $i$f$getLastIndex; ++i3) {
                changesList.add(this.relevantChanges.valueAt(i3));
            }
            event = new PointerEvent((List<PointerInputChange>)changesList, internalPointerEvent);
            List<PointerInputChange> $this$fastFirstOrNull$iv = event.getChanges();
            boolean $i$f$fastFirstOrNull = false;
            List<PointerInputChange> $this$fastForEach$iv$iv = $this$fastFirstOrNull$iv;
            boolean $i$f$fastForEach = false;
            int n2 = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n2; ++index$iv$iv) {
                PointerInputChange item$iv$iv;
                PointerInputChange it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl7 = false;
                PointerInputChange it = it$iv;
                boolean bl8 = false;
                if (!internalPointerEvent.activeHoverEvent-0FcD4WY(it.getId-J3iCeTQ())) continue;
                pointerInputChange = it$iv;
                break block24;
            }
            pointerInputChange = null;
        }
        PointerInputChange activeHoverChange = pointerInputChange;
        if (activeHoverChange != null) {
            if (!isInBounds) {
                this.isIn = false;
            } else if (!this.isIn && (activeHoverChange.getPressed() || activeHoverChange.getPreviousPressed())) {
                LayoutCoordinates layoutCoordinates = this.coordinates;
                Intrinsics.checkNotNull((Object)layoutCoordinates);
                long size = layoutCoordinates.getSize-YbymL2g();
                boolean bl = this.isIn = !PointerEventKt.isOutOfBounds-O0kMr_c(activeHoverChange, size);
            }
            if (PointerEventType.equals-impl0(event.getType-7fucELk(), PointerEventType.Companion.getMove-7fucELk()) || PointerEventType.equals-impl0(event.getType-7fucELk(), PointerEventType.Companion.getEnter-7fucELk()) || PointerEventType.equals-impl0(event.getType-7fucELk(), PointerEventType.Companion.getExit-7fucELk())) {
                event.setType-EhbLWgg$ui(!this.hasEntered && this.isIn ? PointerEventType.Companion.getEnter-7fucELk() : (this.hasEntered && !this.isIn ? PointerEventType.Companion.getExit-7fucELk() : PointerEventType.Companion.getMove-7fucELk()));
            }
            if (PointerEventType.equals-impl0(event.getType-7fucELk(), PointerEventType.Companion.getEnter-7fucELk())) {
                this.hasEntered = true;
            }
            if (PointerEventType.equals-impl0(event.getType-7fucELk(), PointerEventType.Companion.getExit-7fucELk())) {
                this.hasEntered = false;
            }
        }
        boolean changed = childChanged || !PointerEventType.equals-impl0(event.getType-7fucELk(), PointerEventType.Companion.getMove-7fucELk()) || this.hasPositionChanged(this.pointerEvent, event);
        this.pointerEvent = event;
        return changed;
    }

    private final boolean hasPositionChanged(PointerEvent oldEvent, PointerEvent newEvent) {
        if (oldEvent == null || oldEvent.getChanges().size() != newEvent.getChanges().size()) {
            return true;
        }
        int n = newEvent.getChanges().size();
        for (int i2 = 0; i2 < n; ++i2) {
            PointerInputChange old2 = oldEvent.getChanges().get(i2);
            PointerInputChange current = newEvent.getChanges().get(i2);
            if (Offset.equals-impl0(old2.getPosition-F1C5BW0(), current.getPosition-F1C5BW0())) continue;
            return true;
        }
        return false;
    }

    private final void clearCache() {
        this.relevantChanges.clear();
        this.coordinates = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dispatchCancel() {
        void $this$dispatchForKind_u2d6rFNWt0$iv;
        Object it;
        Object this_$iv = this.getChildren();
        boolean $i$f$forEach = false;
        T[] content$iv = ((MutableVector)this_$iv).content;
        int size$iv = ((MutableVector)this_$iv).getSize();
        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
            it = (Node)content$iv[i$iv];
            boolean bl = false;
            ((Node)it).dispatchCancel();
        }
        this_$iv = this.modifierNode;
        boolean bl = false;
        int kind$iv = NodeKind.constructor-impl(16);
        boolean bl2 = false;
        MutableVector<Modifier.Node> stack$iv = null;
        Modifier.Node node$iv = null;
        node$iv = $this$dispatchForKind_u2d6rFNWt0$iv;
        while (node$iv != null) {
            if (node$iv instanceof PointerInputModifierNode) {
                it = (PointerInputModifierNode)((Object)node$iv);
                boolean bl3 = false;
                it.onCancelPointerInput();
            } else {
                Modifier.Node this_$iv$iv = node$iv;
                boolean bl4 = false;
                if ((this_$iv$iv.getKindSet$ui() & kind$iv) != 0 && node$iv instanceof DelegatingNode) {
                    int count$iv = 0;
                    DelegatingNode this_$iv$iv2 = (DelegatingNode)node$iv;
                    boolean $i$f$forEachImmediateDelegate$ui = false;
                    for (Modifier.Node node$iv$iv = this_$iv$iv2.getDelegate$ui(); node$iv$iv != null; node$iv$iv = node$iv$iv.getChild$ui()) {
                        Modifier.Node next$iv = node$iv$iv;
                        boolean bl5 = false;
                        Modifier.Node this_$iv$iv3 = next$iv;
                        $i$f$isKind-H91voCI$ui = false;
                        if (!((this_$iv$iv3.getKindSet$ui() & kind$iv) != 0)) continue;
                        if (++count$iv == 1) {
                            node$iv = next$iv;
                            continue;
                        }
                        MutableVector<Modifier.Node> mutableVector = stack$iv;
                        if (mutableVector == null) {
                            boolean $i$f$mutableVectorOf = false;
                            int capacity$iv$iv$iv = 16;
                            boolean $i$f$MutableVector = false;
                            mutableVector = new MutableVector<Modifier.Node>(new Modifier.Node[capacity$iv$iv$iv], 0);
                        }
                        stack$iv = mutableVector;
                        Modifier.Node theNode$iv = node$iv;
                        if (theNode$iv != null) {
                            MutableVector<Modifier.Node> mutableVector2 = stack$iv;
                            if (mutableVector2 != null) {
                                mutableVector2.add(theNode$iv);
                            }
                            node$iv = null;
                        }
                        MutableVector<Modifier.Node> mutableVector3 = stack$iv;
                        if (mutableVector3 == null) continue;
                        mutableVector3.add(next$iv);
                    }
                    if (count$iv == 1) continue;
                }
            }
            node$iv = DelegatableNodeKt.access$pop(stack$iv);
        }
    }

    public final void markIsIn() {
        this.isIn = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void cleanUpHits(@NotNull InternalPointerEvent internalPointerEvent) {
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        super.cleanUpHits(internalPointerEvent);
        PointerEvent pointerEvent = this.pointerEvent;
        if (pointerEvent == null) {
            return;
        }
        PointerEvent event = pointerEvent;
        List<PointerInputChange> $this$fastForEach$iv = event.getChanges();
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void this_$iv;
            boolean removePointerId;
            PointerInputChange item$iv;
            PointerInputChange change2 = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            boolean released = !change2.getPressed();
            boolean nonHoverEventStream = !internalPointerEvent.activeHoverEvent-0FcD4WY(change2.getId-J3iCeTQ());
            boolean outsideArea = !this.isIn;
            boolean bl2 = removePointerId = released && nonHoverEventStream || released && outsideArea;
            if (!removePointerId) continue;
            PointerIdArray pointerIdArray = this.pointerIds;
            long pointerId$iv = change2.getId-J3iCeTQ();
            boolean bl3 = false;
            this_$iv.remove(pointerId$iv);
        }
    }

    @Override
    public void cleanUpHover() {
        super.cleanUpHover();
        this.isIn = false;
    }

    @NotNull
    public String toString() {
        return "Node(modifierNode=" + this.modifierNode + ", children=" + this.getChildren() + ", pointerIds=" + this.pointerIds + ")";
    }
}

