/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.input.pointer.PointerEvent;
import androidx.compose.ui.input.pointer.PointerEventPass;
import androidx.compose.ui.input.pointer.PointerEventType;
import androidx.compose.ui.input.pointer.PointerIcon;
import androidx.compose.ui.input.pointer.PointerIconService;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNode;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNodeKt;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.DpTouchBoundsExpansion;
import androidx.compose.ui.node.PointerInputModifierNode;
import androidx.compose.ui.node.TouchBoundsExpansion;
import androidx.compose.ui.node.TraversableNode;
import androidx.compose.ui.node.TraversableNodeKt;
import androidx.compose.ui.platform.CompositionLocalsKt;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nPointerIcon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointerIcon.kt\nandroidx/compose/ui/input/pointer/HoverIconModifierNode\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,422:1\n103#2:423\n35#2,5:424\n104#2:429\n1#3:430\n*S KotlinDebug\n*F\n+ 1 PointerIcon.kt\nandroidx/compose/ui/input/pointer/HoverIconModifierNode\n*L\n253#1:423\n253#1:424,5\n253#1:429\n*E\n"})
public abstract class HoverIconModifierNode
extends Modifier.Node
implements CompositionLocalConsumerModifierNode,
PointerInputModifierNode,
TraversableNode {
    @Nullable
    private DpTouchBoundsExpansion dpTouchBoundsExpansion;
    @NotNull
    private PointerIcon icon;
    private boolean overrideDescendants;
    private boolean cursorInBoundsOfNode;
    public static final int $stable = 8;

    public HoverIconModifierNode(@NotNull PointerIcon icon2, boolean overrideDescendants, @Nullable DpTouchBoundsExpansion dpTouchBoundsExpansion) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        this.dpTouchBoundsExpansion = dpTouchBoundsExpansion;
        this.icon = icon2;
        this.overrideDescendants = overrideDescendants;
    }

    public /* synthetic */ HoverIconModifierNode(PointerIcon pointerIcon, boolean bl, DpTouchBoundsExpansion dpTouchBoundsExpansion, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            dpTouchBoundsExpansion = null;
        }
        this(pointerIcon, bl, dpTouchBoundsExpansion);
    }

    public final void setDpTouchBoundsExpansion(@Nullable DpTouchBoundsExpansion dpTouchBoundsExpansion) {
        this.dpTouchBoundsExpansion = dpTouchBoundsExpansion;
    }

    public final void setIcon(@NotNull PointerIcon value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (!Intrinsics.areEqual((Object)this.icon, (Object)value2)) {
            this.icon = value2;
            if (this.cursorInBoundsOfNode) {
                this.displayIconIfDescendantsDoNotHavePriority();
            }
        }
    }

    public final void setOverrideDescendants(boolean value2) {
        if (this.overrideDescendants != value2) {
            this.overrideDescendants = value2;
            if (this.overrideDescendants) {
                if (this.cursorInBoundsOfNode) {
                    this.displayIcon();
                }
            } else if (this.cursorInBoundsOfNode) {
                this.displayIconFromCurrentNodeOrDescendantsWithCursorInBounds();
            }
        }
    }

    @Nullable
    protected final PointerIconService getPointerIconService() {
        return (PointerIconService)CompositionLocalConsumerModifierNodeKt.currentValueOf(this, CompositionLocalsKt.getLocalPointerIconService());
    }

    @Override
    public void onPointerEvent-H0pRuoY(@NotNull PointerEvent pointerEvent, @NotNull PointerEventPass pass, long bounds) {
        Intrinsics.checkNotNullParameter((Object)pointerEvent, (String)"pointerEvent");
        Intrinsics.checkNotNullParameter((Object)((Object)pass), (String)"pass");
        if (pass == PointerEventPass.Main) {
            boolean bl;
            block6: {
                List<PointerInputChange> $this$fastAny$iv = pointerEvent.getChanges();
                boolean $i$f$fastAny = false;
                List<PointerInputChange> $this$fastForEach$iv$iv = $this$fastAny$iv;
                boolean $i$f$fastForEach = false;
                int n = ((Collection)$this$fastForEach$iv$iv).size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    PointerInputChange item$iv$iv;
                    PointerInputChange it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl2 = false;
                    PointerInputChange it = it$iv;
                    boolean bl3 = false;
                    if (!this.isRelevantPointerType-uerMTgs(it.getType-T8wyACA())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                if (PointerEventType.equals-impl0(pointerEvent.getType-7fucELk(), PointerEventType.Companion.getEnter-7fucELk())) {
                    this.onEnter();
                } else if (PointerEventType.equals-impl0(pointerEvent.getType-7fucELk(), PointerEventType.Companion.getExit-7fucELk())) {
                    this.onExit();
                }
            }
        }
    }

    private final void onEnter() {
        this.cursorInBoundsOfNode = true;
        this.displayIconIfDescendantsDoNotHavePriority();
    }

    private final void onExit() {
        if (this.cursorInBoundsOfNode) {
            this.cursorInBoundsOfNode = false;
            if (this.isAttached()) {
                this.displayIconFromAncestorNodeWithCursorInBoundsOrDefaultIcon();
            }
        }
    }

    @Override
    public void onCancelPointerInput() {
        this.onExit();
    }

    @Override
    public void onDetach() {
        this.onExit();
        super.onDetach();
    }

    @Override
    public long getTouchBoundsExpansion-RZrCHBk() {
        DpTouchBoundsExpansion dpTouchBoundsExpansion = this.dpTouchBoundsExpansion;
        return dpTouchBoundsExpansion != null ? dpTouchBoundsExpansion.roundToTouchBoundsExpansion-TW6G1oQ(DelegatableNodeKt.requireDensity(this)) : TouchBoundsExpansion.Companion.getNone-RZrCHBk();
    }

    public abstract boolean isRelevantPointerType-uerMTgs(int var1);

    public abstract void displayIcon(@Nullable PointerIcon var1);

    private final void displayIcon() {
        Object object = this.findOverridingAncestorNode();
        if (object == null || (object = ((HoverIconModifierNode)object).icon) == null) {
            object = this.icon;
        }
        Object iconToUse = object;
        this.displayIcon((PointerIcon)iconToUse);
    }

    private final void displayIconIfDescendantsDoNotHavePriority() {
        Ref.BooleanRef hasIconRightsOverDescendants = new Ref.BooleanRef();
        hasIconRightsOverDescendants.element = true;
        if (!this.overrideDescendants) {
            TraversableNodeKt.traverseDescendants((TraversableNode)this, arg_0 -> HoverIconModifierNode.displayIconIfDescendantsDoNotHavePriority$lambda$1(hasIconRightsOverDescendants, arg_0));
        }
        if (hasIconRightsOverDescendants.element) {
            this.displayIcon();
        }
    }

    private final HoverIconModifierNode findDescendantNodeWithCursorInBounds() {
        Ref.ObjectRef descendantNodeWithCursorInBounds = new Ref.ObjectRef();
        TraversableNodeKt.traverseDescendants((TraversableNode)this, arg_0 -> HoverIconModifierNode.findDescendantNodeWithCursorInBounds$lambda$2(descendantNodeWithCursorInBounds, arg_0));
        return (HoverIconModifierNode)descendantNodeWithCursorInBounds.element;
    }

    private final void displayIconFromCurrentNodeOrDescendantsWithCursorInBounds() {
        if (!this.cursorInBoundsOfNode) {
            return;
        }
        HoverIconModifierNode hoverIconModifierNode = null;
        hoverIconModifierNode = this;
        if (!this.overrideDescendants) {
            HoverIconModifierNode hoverIconModifierNode2 = this.findDescendantNodeWithCursorInBounds();
            if (hoverIconModifierNode2 != null) {
                HoverIconModifierNode it = hoverIconModifierNode2;
                boolean bl = false;
                hoverIconModifierNode = it;
            }
        }
        hoverIconModifierNode.displayIcon();
    }

    private final HoverIconModifierNode findOverridingAncestorNode() {
        Ref.ObjectRef hoverIconModifierNode = new Ref.ObjectRef();
        TraversableNodeKt.traverseAncestors((TraversableNode)this, arg_0 -> HoverIconModifierNode.findOverridingAncestorNode$lambda$4(hoverIconModifierNode, arg_0));
        return (HoverIconModifierNode)hoverIconModifierNode.element;
    }

    private final void displayIconFromAncestorNodeWithCursorInBoundsOrDefaultIcon() {
        Ref.ObjectRef hoverIconModifierNode = new Ref.ObjectRef();
        TraversableNodeKt.traverseAncestors((TraversableNode)this, arg_0 -> HoverIconModifierNode.displayIconFromAncestorNodeWithCursorInBoundsOrDefaultIcon$lambda$5(hoverIconModifierNode, arg_0));
        HoverIconModifierNode hoverIconModifierNode2 = (HoverIconModifierNode)hoverIconModifierNode.element;
        if (hoverIconModifierNode2 != null) {
            hoverIconModifierNode2.displayIcon();
        } else {
            this.displayIcon(null);
        }
    }

    private static final TraversableNode.Companion.TraverseDescendantsAction displayIconIfDescendantsDoNotHavePriority$lambda$1(Ref.BooleanRef $hasIconRightsOverDescendants, HoverIconModifierNode it) {
        TraversableNode.Companion.TraverseDescendantsAction traverseDescendantsAction;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.cursorInBoundsOfNode) {
            $hasIconRightsOverDescendants.element = false;
            traverseDescendantsAction = TraversableNode.Companion.TraverseDescendantsAction.CancelTraversal;
        } else {
            traverseDescendantsAction = TraversableNode.Companion.TraverseDescendantsAction.ContinueTraversal;
        }
        TraversableNode.Companion.TraverseDescendantsAction continueTraversal = traverseDescendantsAction;
        return continueTraversal;
    }

    private static final TraversableNode.Companion.TraverseDescendantsAction findDescendantNodeWithCursorInBounds$lambda$2(Ref.ObjectRef $descendantNodeWithCursorInBounds, HoverIconModifierNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TraversableNode.Companion.TraverseDescendantsAction actionForSubtreeOfCurrentNode = TraversableNode.Companion.TraverseDescendantsAction.ContinueTraversal;
        if (it.cursorInBoundsOfNode) {
            $descendantNodeWithCursorInBounds.element = it;
            if (it.overrideDescendants) {
                actionForSubtreeOfCurrentNode = TraversableNode.Companion.TraverseDescendantsAction.SkipSubtreeAndContinueTraversal;
            }
        }
        return actionForSubtreeOfCurrentNode;
    }

    private static final boolean findOverridingAncestorNode$lambda$4(Ref.ObjectRef $hoverIconModifierNode, HoverIconModifierNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.overrideDescendants && it.cursorInBoundsOfNode) {
            $hoverIconModifierNode.element = it;
        }
        return true;
    }

    private static final boolean displayIconFromAncestorNodeWithCursorInBoundsOrDefaultIcon$lambda$5(Ref.ObjectRef $hoverIconModifierNode, HoverIconModifierNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($hoverIconModifierNode.element == null && it.cursorInBoundsOfNode) {
            $hoverIconModifierNode.element = it;
        } else if ($hoverIconModifierNode.element != null && it.overrideDescendants && it.cursorInBoundsOfNode) {
            $hoverIconModifierNode.element = it;
        }
        return true;
    }
}

