/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathNode {
    private final boolean isCurve;
    private final boolean isQuad;

    private PathNode(boolean isCurve, boolean isQuad) {
        this.isCurve = isCurve;
        this.isQuad = isQuad;
    }

    public /* synthetic */ PathNode(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2, null);
    }

    public final boolean isCurve() {
        return this.isCurve;
    }

    public final boolean isQuad() {
        return this.isQuad;
    }

    public /* synthetic */ PathNode(boolean isCurve, boolean isQuad, DefaultConstructorMarker $constructor_marker) {
        this(isCurve, isQuad);
    }

    public static final class ArcTo
    extends PathNode {
        private final float horizontalEllipseRadius;
        private final float verticalEllipseRadius;
        private final float theta;
        private final boolean isMoreThanHalf;
        private final boolean isPositiveArc;
        private final float arcStartX;
        private final float arcStartY;

        public ArcTo(float horizontalEllipseRadius, float verticalEllipseRadius, float theta, boolean isMoreThanHalf, boolean isPositiveArc, float arcStartX, float arcStartY) {
            super(false, false, 3, null);
            this.horizontalEllipseRadius = horizontalEllipseRadius;
            this.verticalEllipseRadius = verticalEllipseRadius;
            this.theta = theta;
            this.isMoreThanHalf = isMoreThanHalf;
            this.isPositiveArc = isPositiveArc;
            this.arcStartX = arcStartX;
            this.arcStartY = arcStartY;
        }

        public final float getHorizontalEllipseRadius() {
            return this.horizontalEllipseRadius;
        }

        public final float getVerticalEllipseRadius() {
            return this.verticalEllipseRadius;
        }

        public final float getTheta() {
            return this.theta;
        }

        public final boolean isMoreThanHalf() {
            return this.isMoreThanHalf;
        }

        public final boolean isPositiveArc() {
            return this.isPositiveArc;
        }

        public final float getArcStartX() {
            return this.arcStartX;
        }

        public final float getArcStartY() {
            return this.arcStartY;
        }

        @NotNull
        public String toString() {
            return "ArcTo(horizontalEllipseRadius=" + this.horizontalEllipseRadius + ", verticalEllipseRadius=" + this.verticalEllipseRadius + ", theta=" + this.theta + ", isMoreThanHalf=" + this.isMoreThanHalf + ", isPositiveArc=" + this.isPositiveArc + ", arcStartX=" + this.arcStartX + ", arcStartY=" + this.arcStartY + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.horizontalEllipseRadius);
            result2 = result2 * 31 + Float.hashCode(this.verticalEllipseRadius);
            result2 = result2 * 31 + Float.hashCode(this.theta);
            result2 = result2 * 31 + Boolean.hashCode(this.isMoreThanHalf);
            result2 = result2 * 31 + Boolean.hashCode(this.isPositiveArc);
            result2 = result2 * 31 + Float.hashCode(this.arcStartX);
            result2 = result2 * 31 + Float.hashCode(this.arcStartY);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArcTo)) {
                return false;
            }
            ArcTo arcTo = (ArcTo)other;
            if (Float.compare(this.horizontalEllipseRadius, arcTo.horizontalEllipseRadius) != 0) {
                return false;
            }
            if (Float.compare(this.verticalEllipseRadius, arcTo.verticalEllipseRadius) != 0) {
                return false;
            }
            if (Float.compare(this.theta, arcTo.theta) != 0) {
                return false;
            }
            if (this.isMoreThanHalf != arcTo.isMoreThanHalf) {
                return false;
            }
            if (this.isPositiveArc != arcTo.isPositiveArc) {
                return false;
            }
            if (Float.compare(this.arcStartX, arcTo.arcStartX) != 0) {
                return false;
            }
            return Float.compare(this.arcStartY, arcTo.arcStartY) == 0;
        }
    }

    public static final class Close
    extends PathNode {
        @NotNull
        public static final Close INSTANCE = new Close();

        private Close() {
            super(false, false, 3, null);
        }
    }

    public static final class CurveTo
    extends PathNode {
        private final float x1;
        private final float y1;
        private final float x2;
        private final float y2;
        private final float x3;
        private final float y3;

        public CurveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            super(true, false, 2, null);
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.x3 = x3;
            this.y3 = y3;
        }

        public final float getX1() {
            return this.x1;
        }

        public final float getY1() {
            return this.y1;
        }

        public final float getX2() {
            return this.x2;
        }

        public final float getY2() {
            return this.y2;
        }

        public final float getX3() {
            return this.x3;
        }

        public final float getY3() {
            return this.y3;
        }

        @NotNull
        public String toString() {
            return "CurveTo(x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + ", x3=" + this.x3 + ", y3=" + this.y3 + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.x1);
            result2 = result2 * 31 + Float.hashCode(this.y1);
            result2 = result2 * 31 + Float.hashCode(this.x2);
            result2 = result2 * 31 + Float.hashCode(this.y2);
            result2 = result2 * 31 + Float.hashCode(this.x3);
            result2 = result2 * 31 + Float.hashCode(this.y3);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CurveTo)) {
                return false;
            }
            CurveTo curveTo = (CurveTo)other;
            if (Float.compare(this.x1, curveTo.x1) != 0) {
                return false;
            }
            if (Float.compare(this.y1, curveTo.y1) != 0) {
                return false;
            }
            if (Float.compare(this.x2, curveTo.x2) != 0) {
                return false;
            }
            if (Float.compare(this.y2, curveTo.y2) != 0) {
                return false;
            }
            if (Float.compare(this.x3, curveTo.x3) != 0) {
                return false;
            }
            return Float.compare(this.y3, curveTo.y3) == 0;
        }
    }

    public static final class HorizontalTo
    extends PathNode {
        private final float x;

        public HorizontalTo(float x) {
            super(false, false, 3, null);
            this.x = x;
        }

        public final float getX() {
            return this.x;
        }

        @NotNull
        public String toString() {
            return "HorizontalTo(x=" + this.x + ")";
        }

        public int hashCode() {
            return Float.hashCode(this.x);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HorizontalTo)) {
                return false;
            }
            HorizontalTo horizontalTo = (HorizontalTo)other;
            return Float.compare(this.x, horizontalTo.x) == 0;
        }
    }

    public static final class LineTo
    extends PathNode {
        private final float x;
        private final float y;

        public LineTo(float x, float y) {
            super(false, false, 3, null);
            this.x = x;
            this.y = y;
        }

        public final float getX() {
            return this.x;
        }

        public final float getY() {
            return this.y;
        }

        @NotNull
        public String toString() {
            return "LineTo(x=" + this.x + ", y=" + this.y + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.x);
            result2 = result2 * 31 + Float.hashCode(this.y);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LineTo)) {
                return false;
            }
            LineTo lineTo = (LineTo)other;
            if (Float.compare(this.x, lineTo.x) != 0) {
                return false;
            }
            return Float.compare(this.y, lineTo.y) == 0;
        }
    }

    public static final class MoveTo
    extends PathNode {
        private final float x;
        private final float y;

        public MoveTo(float x, float y) {
            super(false, false, 3, null);
            this.x = x;
            this.y = y;
        }

        public final float getX() {
            return this.x;
        }

        public final float getY() {
            return this.y;
        }

        @NotNull
        public String toString() {
            return "MoveTo(x=" + this.x + ", y=" + this.y + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.x);
            result2 = result2 * 31 + Float.hashCode(this.y);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MoveTo)) {
                return false;
            }
            MoveTo moveTo = (MoveTo)other;
            if (Float.compare(this.x, moveTo.x) != 0) {
                return false;
            }
            return Float.compare(this.y, moveTo.y) == 0;
        }
    }

    public static final class QuadTo
    extends PathNode {
        private final float x1;
        private final float y1;
        private final float x2;
        private final float y2;

        public QuadTo(float x1, float y1, float x2, float y2) {
            super(false, true, 1, null);
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public final float getX1() {
            return this.x1;
        }

        public final float getY1() {
            return this.y1;
        }

        public final float getX2() {
            return this.x2;
        }

        public final float getY2() {
            return this.y2;
        }

        @NotNull
        public String toString() {
            return "QuadTo(x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.x1);
            result2 = result2 * 31 + Float.hashCode(this.y1);
            result2 = result2 * 31 + Float.hashCode(this.x2);
            result2 = result2 * 31 + Float.hashCode(this.y2);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QuadTo)) {
                return false;
            }
            QuadTo quadTo = (QuadTo)other;
            if (Float.compare(this.x1, quadTo.x1) != 0) {
                return false;
            }
            if (Float.compare(this.y1, quadTo.y1) != 0) {
                return false;
            }
            if (Float.compare(this.x2, quadTo.x2) != 0) {
                return false;
            }
            return Float.compare(this.y2, quadTo.y2) == 0;
        }
    }

    public static final class ReflectiveCurveTo
    extends PathNode {
        private final float x1;
        private final float y1;
        private final float x2;
        private final float y2;

        public ReflectiveCurveTo(float x1, float y1, float x2, float y2) {
            super(true, false, 2, null);
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public final float getX1() {
            return this.x1;
        }

        public final float getY1() {
            return this.y1;
        }

        public final float getX2() {
            return this.x2;
        }

        public final float getY2() {
            return this.y2;
        }

        @NotNull
        public String toString() {
            return "ReflectiveCurveTo(x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.x1);
            result2 = result2 * 31 + Float.hashCode(this.y1);
            result2 = result2 * 31 + Float.hashCode(this.x2);
            result2 = result2 * 31 + Float.hashCode(this.y2);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReflectiveCurveTo)) {
                return false;
            }
            ReflectiveCurveTo reflectiveCurveTo = (ReflectiveCurveTo)other;
            if (Float.compare(this.x1, reflectiveCurveTo.x1) != 0) {
                return false;
            }
            if (Float.compare(this.y1, reflectiveCurveTo.y1) != 0) {
                return false;
            }
            if (Float.compare(this.x2, reflectiveCurveTo.x2) != 0) {
                return false;
            }
            return Float.compare(this.y2, reflectiveCurveTo.y2) == 0;
        }
    }

    public static final class ReflectiveQuadTo
    extends PathNode {
        private final float x;
        private final float y;

        public ReflectiveQuadTo(float x, float y) {
            super(false, true, 1, null);
            this.x = x;
            this.y = y;
        }

        public final float getX() {
            return this.x;
        }

        public final float getY() {
            return this.y;
        }

        @NotNull
        public String toString() {
            return "ReflectiveQuadTo(x=" + this.x + ", y=" + this.y + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.x);
            result2 = result2 * 31 + Float.hashCode(this.y);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReflectiveQuadTo)) {
                return false;
            }
            ReflectiveQuadTo reflectiveQuadTo = (ReflectiveQuadTo)other;
            if (Float.compare(this.x, reflectiveQuadTo.x) != 0) {
                return false;
            }
            return Float.compare(this.y, reflectiveQuadTo.y) == 0;
        }
    }

    public static final class RelativeArcTo
    extends PathNode {
        private final float horizontalEllipseRadius;
        private final float verticalEllipseRadius;
        private final float theta;
        private final boolean isMoreThanHalf;
        private final boolean isPositiveArc;
        private final float arcStartDx;
        private final float arcStartDy;

        public RelativeArcTo(float horizontalEllipseRadius, float verticalEllipseRadius, float theta, boolean isMoreThanHalf, boolean isPositiveArc, float arcStartDx, float arcStartDy) {
            super(false, false, 3, null);
            this.horizontalEllipseRadius = horizontalEllipseRadius;
            this.verticalEllipseRadius = verticalEllipseRadius;
            this.theta = theta;
            this.isMoreThanHalf = isMoreThanHalf;
            this.isPositiveArc = isPositiveArc;
            this.arcStartDx = arcStartDx;
            this.arcStartDy = arcStartDy;
        }

        public final float getHorizontalEllipseRadius() {
            return this.horizontalEllipseRadius;
        }

        public final float getVerticalEllipseRadius() {
            return this.verticalEllipseRadius;
        }

        public final float getTheta() {
            return this.theta;
        }

        public final boolean isMoreThanHalf() {
            return this.isMoreThanHalf;
        }

        public final boolean isPositiveArc() {
            return this.isPositiveArc;
        }

        public final float getArcStartDx() {
            return this.arcStartDx;
        }

        public final float getArcStartDy() {
            return this.arcStartDy;
        }

        @NotNull
        public String toString() {
            return "RelativeArcTo(horizontalEllipseRadius=" + this.horizontalEllipseRadius + ", verticalEllipseRadius=" + this.verticalEllipseRadius + ", theta=" + this.theta + ", isMoreThanHalf=" + this.isMoreThanHalf + ", isPositiveArc=" + this.isPositiveArc + ", arcStartDx=" + this.arcStartDx + ", arcStartDy=" + this.arcStartDy + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.horizontalEllipseRadius);
            result2 = result2 * 31 + Float.hashCode(this.verticalEllipseRadius);
            result2 = result2 * 31 + Float.hashCode(this.theta);
            result2 = result2 * 31 + Boolean.hashCode(this.isMoreThanHalf);
            result2 = result2 * 31 + Boolean.hashCode(this.isPositiveArc);
            result2 = result2 * 31 + Float.hashCode(this.arcStartDx);
            result2 = result2 * 31 + Float.hashCode(this.arcStartDy);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RelativeArcTo)) {
                return false;
            }
            RelativeArcTo relativeArcTo = (RelativeArcTo)other;
            if (Float.compare(this.horizontalEllipseRadius, relativeArcTo.horizontalEllipseRadius) != 0) {
                return false;
            }
            if (Float.compare(this.verticalEllipseRadius, relativeArcTo.verticalEllipseRadius) != 0) {
                return false;
            }
            if (Float.compare(this.theta, relativeArcTo.theta) != 0) {
                return false;
            }
            if (this.isMoreThanHalf != relativeArcTo.isMoreThanHalf) {
                return false;
            }
            if (this.isPositiveArc != relativeArcTo.isPositiveArc) {
                return false;
            }
            if (Float.compare(this.arcStartDx, relativeArcTo.arcStartDx) != 0) {
                return false;
            }
            return Float.compare(this.arcStartDy, relativeArcTo.arcStartDy) == 0;
        }
    }

    public static final class RelativeCurveTo
    extends PathNode {
        private final float dx1;
        private final float dy1;
        private final float dx2;
        private final float dy2;
        private final float dx3;
        private final float dy3;

        public RelativeCurveTo(float dx1, float dy1, float dx2, float dy2, float dx3, float dy3) {
            super(true, false, 2, null);
            this.dx1 = dx1;
            this.dy1 = dy1;
            this.dx2 = dx2;
            this.dy2 = dy2;
            this.dx3 = dx3;
            this.dy3 = dy3;
        }

        public final float getDx1() {
            return this.dx1;
        }

        public final float getDy1() {
            return this.dy1;
        }

        public final float getDx2() {
            return this.dx2;
        }

        public final float getDy2() {
            return this.dy2;
        }

        public final float getDx3() {
            return this.dx3;
        }

        public final float getDy3() {
            return this.dy3;
        }

        @NotNull
        public String toString() {
            return "RelativeCurveTo(dx1=" + this.dx1 + ", dy1=" + this.dy1 + ", dx2=" + this.dx2 + ", dy2=" + this.dy2 + ", dx3=" + this.dx3 + ", dy3=" + this.dy3 + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.dx1);
            result2 = result2 * 31 + Float.hashCode(this.dy1);
            result2 = result2 * 31 + Float.hashCode(this.dx2);
            result2 = result2 * 31 + Float.hashCode(this.dy2);
            result2 = result2 * 31 + Float.hashCode(this.dx3);
            result2 = result2 * 31 + Float.hashCode(this.dy3);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RelativeCurveTo)) {
                return false;
            }
            RelativeCurveTo relativeCurveTo = (RelativeCurveTo)other;
            if (Float.compare(this.dx1, relativeCurveTo.dx1) != 0) {
                return false;
            }
            if (Float.compare(this.dy1, relativeCurveTo.dy1) != 0) {
                return false;
            }
            if (Float.compare(this.dx2, relativeCurveTo.dx2) != 0) {
                return false;
            }
            if (Float.compare(this.dy2, relativeCurveTo.dy2) != 0) {
                return false;
            }
            if (Float.compare(this.dx3, relativeCurveTo.dx3) != 0) {
                return false;
            }
            return Float.compare(this.dy3, relativeCurveTo.dy3) == 0;
        }
    }

    public static final class RelativeHorizontalTo
    extends PathNode {
        private final float dx;

        public RelativeHorizontalTo(float dx) {
            super(false, false, 3, null);
            this.dx = dx;
        }

        public final float getDx() {
            return this.dx;
        }

        @NotNull
        public String toString() {
            return "RelativeHorizontalTo(dx=" + this.dx + ")";
        }

        public int hashCode() {
            return Float.hashCode(this.dx);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RelativeHorizontalTo)) {
                return false;
            }
            RelativeHorizontalTo relativeHorizontalTo = (RelativeHorizontalTo)other;
            return Float.compare(this.dx, relativeHorizontalTo.dx) == 0;
        }
    }

    public static final class RelativeLineTo
    extends PathNode {
        private final float dx;
        private final float dy;

        public RelativeLineTo(float dx, float dy) {
            super(false, false, 3, null);
            this.dx = dx;
            this.dy = dy;
        }

        public final float getDx() {
            return this.dx;
        }

        public final float getDy() {
            return this.dy;
        }

        @NotNull
        public String toString() {
            return "RelativeLineTo(dx=" + this.dx + ", dy=" + this.dy + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.dx);
            result2 = result2 * 31 + Float.hashCode(this.dy);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RelativeLineTo)) {
                return false;
            }
            RelativeLineTo relativeLineTo = (RelativeLineTo)other;
            if (Float.compare(this.dx, relativeLineTo.dx) != 0) {
                return false;
            }
            return Float.compare(this.dy, relativeLineTo.dy) == 0;
        }
    }

    public static final class RelativeMoveTo
    extends PathNode {
        private final float dx;
        private final float dy;

        public RelativeMoveTo(float dx, float dy) {
            super(false, false, 3, null);
            this.dx = dx;
            this.dy = dy;
        }

        public final float getDx() {
            return this.dx;
        }

        public final float getDy() {
            return this.dy;
        }

        @NotNull
        public String toString() {
            return "RelativeMoveTo(dx=" + this.dx + ", dy=" + this.dy + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.dx);
            result2 = result2 * 31 + Float.hashCode(this.dy);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RelativeMoveTo)) {
                return false;
            }
            RelativeMoveTo relativeMoveTo = (RelativeMoveTo)other;
            if (Float.compare(this.dx, relativeMoveTo.dx) != 0) {
                return false;
            }
            return Float.compare(this.dy, relativeMoveTo.dy) == 0;
        }
    }

    public static final class RelativeQuadTo
    extends PathNode {
        private final float dx1;
        private final float dy1;
        private final float dx2;
        private final float dy2;

        public RelativeQuadTo(float dx1, float dy1, float dx2, float dy2) {
            super(false, true, 1, null);
            this.dx1 = dx1;
            this.dy1 = dy1;
            this.dx2 = dx2;
            this.dy2 = dy2;
        }

        public final float getDx1() {
            return this.dx1;
        }

        public final float getDy1() {
            return this.dy1;
        }

        public final float getDx2() {
            return this.dx2;
        }

        public final float getDy2() {
            return this.dy2;
        }

        @NotNull
        public String toString() {
            return "RelativeQuadTo(dx1=" + this.dx1 + ", dy1=" + this.dy1 + ", dx2=" + this.dx2 + ", dy2=" + this.dy2 + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.dx1);
            result2 = result2 * 31 + Float.hashCode(this.dy1);
            result2 = result2 * 31 + Float.hashCode(this.dx2);
            result2 = result2 * 31 + Float.hashCode(this.dy2);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RelativeQuadTo)) {
                return false;
            }
            RelativeQuadTo relativeQuadTo = (RelativeQuadTo)other;
            if (Float.compare(this.dx1, relativeQuadTo.dx1) != 0) {
                return false;
            }
            if (Float.compare(this.dy1, relativeQuadTo.dy1) != 0) {
                return false;
            }
            if (Float.compare(this.dx2, relativeQuadTo.dx2) != 0) {
                return false;
            }
            return Float.compare(this.dy2, relativeQuadTo.dy2) == 0;
        }
    }

    public static final class RelativeReflectiveCurveTo
    extends PathNode {
        private final float dx1;
        private final float dy1;
        private final float dx2;
        private final float dy2;

        public RelativeReflectiveCurveTo(float dx1, float dy1, float dx2, float dy2) {
            super(true, false, 2, null);
            this.dx1 = dx1;
            this.dy1 = dy1;
            this.dx2 = dx2;
            this.dy2 = dy2;
        }

        public final float getDx1() {
            return this.dx1;
        }

        public final float getDy1() {
            return this.dy1;
        }

        public final float getDx2() {
            return this.dx2;
        }

        public final float getDy2() {
            return this.dy2;
        }

        @NotNull
        public String toString() {
            return "RelativeReflectiveCurveTo(dx1=" + this.dx1 + ", dy1=" + this.dy1 + ", dx2=" + this.dx2 + ", dy2=" + this.dy2 + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.dx1);
            result2 = result2 * 31 + Float.hashCode(this.dy1);
            result2 = result2 * 31 + Float.hashCode(this.dx2);
            result2 = result2 * 31 + Float.hashCode(this.dy2);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RelativeReflectiveCurveTo)) {
                return false;
            }
            RelativeReflectiveCurveTo relativeReflectiveCurveTo = (RelativeReflectiveCurveTo)other;
            if (Float.compare(this.dx1, relativeReflectiveCurveTo.dx1) != 0) {
                return false;
            }
            if (Float.compare(this.dy1, relativeReflectiveCurveTo.dy1) != 0) {
                return false;
            }
            if (Float.compare(this.dx2, relativeReflectiveCurveTo.dx2) != 0) {
                return false;
            }
            return Float.compare(this.dy2, relativeReflectiveCurveTo.dy2) == 0;
        }
    }

    public static final class RelativeReflectiveQuadTo
    extends PathNode {
        private final float dx;
        private final float dy;

        public RelativeReflectiveQuadTo(float dx, float dy) {
            super(false, true, 1, null);
            this.dx = dx;
            this.dy = dy;
        }

        public final float getDx() {
            return this.dx;
        }

        public final float getDy() {
            return this.dy;
        }

        @NotNull
        public String toString() {
            return "RelativeReflectiveQuadTo(dx=" + this.dx + ", dy=" + this.dy + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.dx);
            result2 = result2 * 31 + Float.hashCode(this.dy);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RelativeReflectiveQuadTo)) {
                return false;
            }
            RelativeReflectiveQuadTo relativeReflectiveQuadTo = (RelativeReflectiveQuadTo)other;
            if (Float.compare(this.dx, relativeReflectiveQuadTo.dx) != 0) {
                return false;
            }
            return Float.compare(this.dy, relativeReflectiveQuadTo.dy) == 0;
        }
    }

    public static final class RelativeVerticalTo
    extends PathNode {
        private final float dy;

        public RelativeVerticalTo(float dy) {
            super(false, false, 3, null);
            this.dy = dy;
        }

        public final float getDy() {
            return this.dy;
        }

        @NotNull
        public String toString() {
            return "RelativeVerticalTo(dy=" + this.dy + ")";
        }

        public int hashCode() {
            return Float.hashCode(this.dy);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RelativeVerticalTo)) {
                return false;
            }
            RelativeVerticalTo relativeVerticalTo = (RelativeVerticalTo)other;
            return Float.compare(this.dy, relativeVerticalTo.dy) == 0;
        }
    }

    public static final class VerticalTo
    extends PathNode {
        private final float y;

        public VerticalTo(float y) {
            super(false, false, 3, null);
            this.y = y;
        }

        public final float getY() {
            return this.y;
        }

        @NotNull
        public String toString() {
            return "VerticalTo(y=" + this.y + ")";
        }

        public int hashCode() {
            return Float.hashCode(this.y);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VerticalTo)) {
                return false;
            }
            VerticalTo verticalTo = (VerticalTo)other;
            return Float.compare(this.y, verticalTo.y) == 0;
        }
    }
}

