/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.colorspace.TransferParametersKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransferParameters {
    private final double gamma;
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    private final double e;
    private final double f;

    public TransferParameters(double gamma, double a, double b, double c, double d, double e, double f) {
        this.gamma = gamma;
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.e = e;
        this.f = f;
        if (Double.isNaN(this.a) || Double.isNaN(this.b) || Double.isNaN(this.c) || Double.isNaN(this.d) || Double.isNaN(this.e) || Double.isNaN(this.f) || Double.isNaN(this.gamma)) {
            throw new IllegalArgumentException("Parameters cannot be NaN");
        }
        if (!TransferParametersKt.access$isSpecialG(this.gamma)) {
            if (!(this.d >= 0.0) || !(this.d <= 1.0)) {
                throw new IllegalArgumentException("Parameter d must be in the range [0..1], was " + this.d);
            }
            if (this.d == 0.0 && (this.a == 0.0 || this.gamma == 0.0)) {
                throw new IllegalArgumentException("Parameter a or g is zero, the transfer function is constant");
            }
            if (this.d >= 1.0 && this.c == 0.0) {
                throw new IllegalArgumentException("Parameter c is zero, the transfer function is constant");
            }
            if ((this.a == 0.0 || this.gamma == 0.0) && this.c == 0.0) {
                throw new IllegalArgumentException("Parameter a or g is zero, and c is zero, the transfer function is constant");
            }
            if (this.c < 0.0) {
                throw new IllegalArgumentException("The transfer function must be increasing");
            }
            if (this.a < 0.0 || this.gamma < 0.0) {
                throw new IllegalArgumentException("The transfer function must be positive or increasing");
            }
        }
    }

    public /* synthetic */ TransferParameters(double d, double d2, double d3, double d4, double d5, double d6, double d7, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            d6 = 0.0;
        }
        if ((n & 0x40) != 0) {
            d7 = 0.0;
        }
        this(d, d2, d3, d4, d5, d6, d7);
    }

    public final double getGamma() {
        return this.gamma;
    }

    public final double getA() {
        return this.a;
    }

    public final double getB() {
        return this.b;
    }

    public final double getC() {
        return this.c;
    }

    public final double getD() {
        return this.d;
    }

    public final double getE() {
        return this.e;
    }

    public final double getF() {
        return this.f;
    }

    public final boolean isHLGish$ui_graphics() {
        return this.gamma == -3.0;
    }

    public final boolean isPQish$ui_graphics() {
        return this.gamma == -2.0;
    }

    @NotNull
    public String toString() {
        return "TransferParameters(gamma=" + this.gamma + ", a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + ", e=" + this.e + ", f=" + this.f + ")";
    }

    public int hashCode() {
        int result2 = Double.hashCode(this.gamma);
        result2 = result2 * 31 + Double.hashCode(this.a);
        result2 = result2 * 31 + Double.hashCode(this.b);
        result2 = result2 * 31 + Double.hashCode(this.c);
        result2 = result2 * 31 + Double.hashCode(this.d);
        result2 = result2 * 31 + Double.hashCode(this.e);
        result2 = result2 * 31 + Double.hashCode(this.f);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TransferParameters)) {
            return false;
        }
        TransferParameters transferParameters = (TransferParameters)other;
        if (Double.compare(this.gamma, transferParameters.gamma) != 0) {
            return false;
        }
        if (Double.compare(this.a, transferParameters.a) != 0) {
            return false;
        }
        if (Double.compare(this.b, transferParameters.b) != 0) {
            return false;
        }
        if (Double.compare(this.c, transferParameters.c) != 0) {
            return false;
        }
        if (Double.compare(this.d, transferParameters.d) != 0) {
            return false;
        }
        if (Double.compare(this.e, transferParameters.e) != 0) {
            return false;
        }
        return Double.compare(this.f, transferParameters.f) == 0;
    }
}

