/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.graphics.RenderEffect;
import androidx.compose.ui.graphics.SkiaTileMode_skikoKt;
import androidx.compose.ui.graphics.TileMode;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.FilterTileMode;
import org.jetbrains.skia.ImageFilter;

public final class BlurEffect
extends RenderEffect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final RenderEffect renderEffect;
    private final float radiusX;
    private final float radiusY;
    private final int edgeTreatment;
    private static final float BlurSigmaScale = 0.57735f;

    private BlurEffect(RenderEffect renderEffect, float radiusX, float radiusY, int edgeTreatment) {
        super(null);
        this.renderEffect = renderEffect;
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.edgeTreatment = edgeTreatment;
    }

    @Override
    @NotNull
    protected ImageFilter createImageFilter() {
        return this.renderEffect == null ? ImageFilter.Companion.makeBlur$default((ImageFilter.Companion)ImageFilter.Companion, (float)Companion.convertRadiusToSigma(this.radiusX), (float)Companion.convertRadiusToSigma(this.radiusY), (FilterTileMode)SkiaTileMode_skikoKt.toSkiaTileMode-0vamqd0(this.edgeTreatment), null, null, (int)24, null) : ImageFilter.Companion.makeBlur(Companion.convertRadiusToSigma(this.radiusX), Companion.convertRadiusToSigma(this.radiusY), SkiaTileMode_skikoKt.toSkiaTileMode-0vamqd0(this.edgeTreatment), this.renderEffect.asSkiaImageFilter(), null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BlurEffect)) {
            return false;
        }
        if (!(this.radiusX == ((BlurEffect)other).radiusX)) {
            return false;
        }
        if (!(this.radiusY == ((BlurEffect)other).radiusY)) {
            return false;
        }
        if (!TileMode.equals-impl0(this.edgeTreatment, ((BlurEffect)other).edgeTreatment)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.renderEffect, (Object)((BlurEffect)other).renderEffect);
    }

    public int hashCode() {
        RenderEffect renderEffect = this.renderEffect;
        int result2 = renderEffect != null ? renderEffect.hashCode() : 0;
        result2 = 31 * result2 + Float.hashCode(this.radiusX);
        result2 = 31 * result2 + Float.hashCode(this.radiusY);
        result2 = 31 * result2 + TileMode.hashCode-impl(this.edgeTreatment);
        return result2;
    }

    @NotNull
    public String toString() {
        return "BlurEffect(renderEffect=" + this.renderEffect + ", radiusX=" + this.radiusX + ", radiusY=" + this.radiusY + ", edgeTreatment=" + TileMode.toString-impl(this.edgeTreatment) + ")";
    }

    public /* synthetic */ BlurEffect(RenderEffect renderEffect, float radiusX, float radiusY, int edgeTreatment, DefaultConstructorMarker $constructor_marker) {
        this(renderEffect, radiusX, radiusY, edgeTreatment);
    }

    public static final class Companion {
        private Companion() {
        }

        public final float getBlurSigmaScale() {
            return BlurSigmaScale;
        }

        public final float convertRadiusToSigma(float radius) {
            return radius > 0.0f ? this.getBlurSigmaScale() * radius + 0.5f : 0.0f;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

