/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.collection.MutableObjectIntMap;
import androidx.collection.MutableObjectList;
import androidx.collection.MutableScatterMap;
import androidx.collection.MutableScatterSet;
import androidx.collection.ObjectIntMap;
import androidx.collection.ObjectList;
import androidx.collection.ScatterMap;
import androidx.collection.ScatterSet;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.DataSource;
import androidx.compose.runtime.DataSourceKt;
import androidx.compose.runtime.DerivedState;
import androidx.compose.runtime.DerivedStateObserver;
import androidx.compose.runtime.MutableTokenListPool;
import androidx.compose.runtime.ObserverHandle;
import androidx.compose.runtime.PreconditionsKt;
import androidx.compose.runtime.SnapshotMutationPolicy;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.SynchronizedObject;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.collection.ScatterSetWrapper;
import androidx.compose.runtime.collection.ScopeMap;
import androidx.compose.runtime.internal.Thread_jvmKt;
import androidx.compose.runtime.snapshots.ReaderKind;
import androidx.compose.runtime.snapshots.SnapshotKt;
import androidx.compose.runtime.snapshots.StateObjectImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.KotlinNothingValueException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSnapshotStateObserver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotStateObserver.kt\nandroidx/compose/runtime/snapshots/SnapshotStateObserver\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 Synchronization.desktop.kt\nandroidx/compose/runtime/platform/Synchronization_desktopKt\n+ 4 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 5 Preconditions.kt\nandroidx/compose/runtime/PreconditionsKt\n*L\n1#1,617:1\n188#1:627\n189#1:637\n192#1:668\n193#1:685\n192#1:686\n193#1:703\n188#1:704\n189#1:714\n1101#2:618\n1083#2,2:619\n21#3,5:621\n26#3:626\n26#3:628\n26#3:638\n26#3:647\n26#3:663\n26#3:669\n26#3:687\n26#3:705\n26#3:724\n26#3:733\n424#4,8:629\n424#4,8:639\n740#4,15:648\n740#4,15:670\n740#4,15:688\n424#4,8:706\n348#4,7:715\n641#4,2:722\n424#4,8:725\n34#5,4:664\n*S KotlinDebug\n*F\n+ 1 SnapshotStateObserver.kt\nandroidx/compose/runtime/snapshots/SnapshotStateObserver\n*L\n73#1:627\n73#1:637\n283#1:668\n283#1:685\n294#1:686\n294#1:703\n333#1:704\n333#1:714\n179#1:618\n179#1:619,2\n180#1:621,5\n67#1:626\n73#1:628\n188#1:638\n192#1:647\n227#1:663\n283#1:669\n294#1:687\n333#1:705\n87#1:724\n167#1:733\n73#1:629,8\n188#1:639,8\n192#1:648,15\n283#1:670,15\n294#1:688,15\n333#1:706,8\n344#1:715,7\n347#1:722,2\n91#1:725,8\n234#1:664,4\n*E\n"})
public final class SnapshotStateObserver {
    @NotNull
    private final Function1<Function0<Unit>, Unit> onChangedExecutor;
    @NotNull
    private final AtomicReference<Object> pendingChanges;
    private boolean sendingNotifications;
    @NotNull
    private final Function1<Set<? extends Object>, Unit> applyObserver;
    @NotNull
    private final Function1<Object, Boolean> readObserver;
    @NotNull
    private final MutableVector<ObservedScopeMap> observedScopeMaps;
    @NotNull
    private final SynchronizedObject observedScopeMapsLock;
    @Nullable
    private ObserverHandle applyUnsubscribe;
    private boolean isPaused;
    @Nullable
    private ObservedScopeMap currentMap;
    private long currentMapThreadId;
    public static final int $stable = 8;

    public SnapshotStateObserver(@NotNull Function1<? super Function0<Unit>, Unit> onChangedExecutor) {
        Intrinsics.checkNotNullParameter(onChangedExecutor, (String)"onChangedExecutor");
        this.onChangedExecutor = onChangedExecutor;
        this.pendingChanges = new AtomicReference<Object>(null);
        this.applyObserver = arg_0 -> SnapshotStateObserver.applyObserver$lambda$0(this, arg_0);
        this.readObserver = arg_0 -> SnapshotStateObserver.readObserver$lambda$7(this, arg_0);
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.observedScopeMaps = new MutableVector<ObservedScopeMap>(new ObservedScopeMap[capacity$iv$iv], 0);
        Object ref$iv = null;
        boolean $i$f$makeSynchronizedObject = false;
        this.observedScopeMapsLock = new SynchronizedObject();
        this.currentMapThreadId = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean drainChanges() {
        boolean bl;
        SynchronizedObject lock$iv = this.observedScopeMapsLock;
        boolean $i$f$synchronized = false;
        SynchronizedObject synchronizedObject = lock$iv;
        synchronized (synchronizedObject) {
            bl = false;
            bl = this.sendingNotifications;
        }
        if (bl) {
            return false;
        }
        boolean hasValues = false;
        while (this.removeChanges() != null) {
            SnapshotStateObserver this_$iv = this;
            boolean $i$f$forEachScopeMap = false;
            SynchronizedObject lock$iv$iv = this_$iv.observedScopeMapsLock;
            boolean $i$f$synchronized2 = false;
            SynchronizedObject synchronizedObject2 = lock$iv$iv;
            synchronized (synchronizedObject2) {
                boolean bl2 = false;
                MutableVector<ObservedScopeMap> this_$iv$iv = this_$iv.observedScopeMaps;
                boolean $i$f$forEach = false;
                T[] content$iv$iv = this_$iv$iv.content;
                int size$iv$iv = this_$iv$iv.getSize();
                for (int i$iv$iv = 0; i$iv$iv < size$iv$iv; ++i$iv$iv) {
                    Set<Object> notifications;
                    ObservedScopeMap scopeMap = (ObservedScopeMap)content$iv$iv[i$iv$iv];
                    boolean bl3 = false;
                    hasValues = scopeMap.recordInvalidation(notifications) || hasValues;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return hasValues;
    }

    private final void sendNotifications() {
        this.onChangedExecutor.invoke(() -> SnapshotStateObserver.sendNotifications$lambda$5(this));
    }

    private final void addChanges(Set<? extends Object> set2) {
        Collection collection;
        Collection collection2;
        Object old2;
        do {
            Object object;
            if ((object = (old2 = this.pendingChanges.get())) == null) {
                collection = set2;
                continue;
            }
            if (object instanceof Set) {
                Object[] objectArray = new Set[]{old2, set2};
                collection = CollectionsKt.listOf((Object[])objectArray);
                continue;
            }
            if (object instanceof List) {
                collection = CollectionsKt.plus((Collection)((Collection)old2), (Iterable)CollectionsKt.listOf(set2));
                continue;
            }
            this.report();
            throw new KotlinNothingValueException();
        } while (!this.pendingChanges.compareAndSet(old2, collection2 = collection));
    }

    private final Set<Object> removeChanges() {
        Set result2;
        Object v;
        Object old2;
        do {
            old2 = this.pendingChanges.get();
            result2 = null;
            v = null;
            Object object = old2;
            if (object == null) {
                return null;
            }
            if (object instanceof Set) {
                result2 = (Set)old2;
                v = null;
                continue;
            }
            if (object instanceof List) {
                result2 = (Set)((List)old2).get(0);
                v = ((List)old2).size() == 2 ? ((List)old2).get(1) : (((List)old2).size() > 2 ? ((List)old2).subList(1, ((List)old2).size()) : null);
                continue;
            }
            this.report();
            throw new KotlinNothingValueException();
        } while (!this.pendingChanges.compareAndSet(old2, v));
        return result2;
    }

    private final Void report() {
        ComposerKt.composeRuntimeError("Unexpected notification");
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void observeReads(@NotNull T scope2, @NotNull Function1<? super T, Unit> onValueChangedForScope, @NotNull Function0<Unit> block) {
        ObservedScopeMap observedScopeMap;
        Intrinsics.checkNotNullParameter(scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(onValueChangedForScope, (String)"onValueChangedForScope");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        SynchronizedObject lock$iv = this.observedScopeMapsLock;
        boolean $i$f$synchronized = false;
        SynchronizedObject synchronizedObject = lock$iv;
        synchronized (synchronizedObject) {
            boolean bl = false;
            observedScopeMap = this.ensureMap(onValueChangedForScope);
        }
        ObservedScopeMap scopeMap = observedScopeMap;
        boolean oldPaused = this.isPaused;
        ObservedScopeMap oldMap = this.currentMap;
        long oldThreadId = this.currentMapThreadId;
        if (oldThreadId != -1L) {
            boolean value$iv = oldThreadId == Thread_jvmKt.currentThreadId();
            boolean $i$f$requirePrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                PreconditionsKt.throwIllegalArgumentException("Detected multithreaded access to SnapshotStateObserver: previousThreadId=" + oldThreadId + "), currentThread={id=" + Thread_jvmKt.currentThreadId() + ", name=" + Thread_jvmKt.currentThreadName() + "}. Note that observation on multiple threads in layout/draw is not supported. Make sure your measure/layout/draw for each Owner (AndroidComposeView) is executed on the same thread.");
            }
        }
        try {
            this.isPaused = false;
            this.currentMap = scopeMap;
            this.currentMapThreadId = Thread_jvmKt.currentThreadId();
            scopeMap.observe(scope2, this.readObserver, block);
        }
        finally {
            this.currentMap = oldMap;
            this.isPaused = oldPaused;
            this.currentMapThreadId = oldThreadId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear(@NotNull Object scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        SnapshotStateObserver this_$iv = this;
        boolean $i$f$removeScopeMapIf = false;
        SynchronizedObject lock$iv$iv = this_$iv.observedScopeMapsLock;
        boolean $i$f$synchronized = false;
        SynchronizedObject synchronizedObject = lock$iv$iv;
        synchronized (synchronizedObject) {
            boolean bl = false;
            MutableVector<ObservedScopeMap> this_$iv$iv = this_$iv.observedScopeMaps;
            boolean $i$f$removeIf = false;
            int gap$iv$iv = 0;
            int size$iv$iv = this_$iv$iv.getSize();
            for (int i$iv$iv = 0; i$iv$iv < size$iv$iv; ++i$iv$iv) {
                ObservedScopeMap it = (ObservedScopeMap)this_$iv$iv.content[i$iv$iv];
                boolean bl2 = false;
                it.clearScopeObservations(scope2);
                if (!it.hasScopeObservations()) {
                    ++gap$iv$iv;
                    continue;
                }
                if (gap$iv$iv <= 0) continue;
                this_$iv$iv.content[i$iv$iv - gap$iv$iv] = this_$iv$iv.content[i$iv$iv];
            }
            ArraysKt.fill((Object[])this_$iv$iv.content, null, (int)(size$iv$iv - gap$iv$iv), (int)size$iv$iv);
            this_$iv$iv.setSize(size$iv$iv - gap$iv$iv);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearIf(@NotNull Function1<Object, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        SnapshotStateObserver this_$iv = this;
        boolean $i$f$removeScopeMapIf = false;
        SynchronizedObject lock$iv$iv = this_$iv.observedScopeMapsLock;
        boolean $i$f$synchronized = false;
        SynchronizedObject synchronizedObject = lock$iv$iv;
        synchronized (synchronizedObject) {
            boolean bl = false;
            MutableVector<ObservedScopeMap> this_$iv$iv = this_$iv.observedScopeMaps;
            boolean $i$f$removeIf = false;
            int gap$iv$iv = 0;
            int size$iv$iv = this_$iv$iv.getSize();
            for (int i$iv$iv = 0; i$iv$iv < size$iv$iv; ++i$iv$iv) {
                ObservedScopeMap scopeMap = (ObservedScopeMap)this_$iv$iv.content[i$iv$iv];
                boolean bl2 = false;
                scopeMap.removeScopeIf(predicate);
                if (!scopeMap.hasScopeObservations()) {
                    ++gap$iv$iv;
                    continue;
                }
                if (gap$iv$iv <= 0) continue;
                this_$iv$iv.content[i$iv$iv - gap$iv$iv] = this_$iv$iv.content[i$iv$iv];
            }
            ArraysKt.fill((Object[])this_$iv$iv.content, null, (int)(size$iv$iv - gap$iv$iv), (int)size$iv$iv);
            this_$iv$iv.setSize(size$iv$iv - gap$iv$iv);
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void start() {
        this.applyUnsubscribe = DataSource.Companion.registerInvalidator(this.applyObserver);
    }

    public final void stop() {
        block0: {
            ObserverHandle observerHandle = this.applyUnsubscribe;
            if (observerHandle == null) break block0;
            observerHandle.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        SnapshotStateObserver this_$iv = this;
        boolean $i$f$forEachScopeMap = false;
        SynchronizedObject lock$iv$iv = this_$iv.observedScopeMapsLock;
        boolean $i$f$synchronized = false;
        SynchronizedObject synchronizedObject = lock$iv$iv;
        synchronized (synchronizedObject) {
            boolean bl = false;
            MutableVector<ObservedScopeMap> this_$iv$iv = this_$iv.observedScopeMaps;
            boolean $i$f$forEach = false;
            T[] content$iv$iv = this_$iv$iv.content;
            int size$iv$iv = this_$iv$iv.getSize();
            for (int i$iv$iv = 0; i$iv$iv < size$iv$iv; ++i$iv$iv) {
                ObservedScopeMap scopeMap = (ObservedScopeMap)content$iv$iv[i$iv$iv];
                boolean bl2 = false;
                scopeMap.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final <T> ObservedScopeMap ensureMap(Function1<? super T, Unit> onChanged) {
        Object v0;
        block2: {
            MutableVector<ObservedScopeMap> this_$iv = this.observedScopeMaps;
            boolean $i$f$firstOrNull = false;
            T[] content$iv = this_$iv.content;
            int size$iv = this_$iv.getSize();
            for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                Object item$iv = content$iv[i$iv];
                ObservedScopeMap it = (ObservedScopeMap)item$iv;
                boolean bl = false;
                if (!(it.getOnChanged() == onChanged)) continue;
                v0 = item$iv;
                break block2;
            }
            v0 = null;
        }
        ObservedScopeMap scopeMap = v0;
        if (scopeMap == null) {
            Intrinsics.checkNotNull(onChanged, (String)"null cannot be cast to non-null type kotlin.Function1<kotlin.Any, kotlin.Unit>");
            ObservedScopeMap map2 = new ObservedScopeMap((Function1<Object, Unit>)((Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(onChanged, (int)1)));
            MutableVector<ObservedScopeMap> this_$iv = this.observedScopeMaps;
            boolean $i$f$plusAssign = false;
            this_$iv.add(map2);
            return map2;
        }
        return scopeMap;
    }

    private static final Unit applyObserver$lambda$0(SnapshotStateObserver this$0, Set applied) {
        Intrinsics.checkNotNullParameter((Object)applied, (String)"applied");
        this$0.addChanges(applied);
        if (this$0.drainChanges()) {
            this$0.sendNotifications();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit sendNotifications$lambda$5(SnapshotStateObserver this$0) {
        do {
            SynchronizedObject lock$iv = this$0.observedScopeMapsLock;
            boolean $i$f$synchronized = false;
            SynchronizedObject synchronizedObject = lock$iv;
            synchronized (synchronizedObject) {
                boolean bl = false;
                if (!this$0.sendingNotifications) {
                    this$0.sendingNotifications = true;
                    try {
                        MutableVector<ObservedScopeMap> this_$iv = this$0.observedScopeMaps;
                        boolean $i$f$forEach = false;
                        T[] content$iv = this_$iv.content;
                        int size$iv = this_$iv.getSize();
                        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                            ObservedScopeMap scopeMap = (ObservedScopeMap)content$iv[i$iv];
                            boolean bl2 = false;
                            scopeMap.notifyInvalidatedScopes();
                        }
                    }
                    finally {
                        this$0.sendingNotifications = false;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        } while (this$0.drainChanges());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean readObserver$lambda$7(SnapshotStateObserver this$0, Object state2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (!this$0.isPaused) {
            SynchronizedObject lock$iv = this$0.observedScopeMapsLock;
            boolean $i$f$synchronized = false;
            SynchronizedObject synchronizedObject = lock$iv;
            synchronized (synchronizedObject) {
                boolean bl2 = false;
                ObservedScopeMap observedScopeMap = this$0.currentMap;
                Intrinsics.checkNotNull((Object)observedScopeMap);
                observedScopeMap.recordRead(state2);
                Unit unit = Unit.INSTANCE;
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @SourceDebugExtension(value={"SMAP\nSnapshotStateObserver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotStateObserver.kt\nandroidx/compose/runtime/snapshots/SnapshotStateObserver$ObservedScopeMap\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 ObjectIntMap.kt\nandroidx/collection/ObjectIntMap\n+ 4 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n+ 5 StateObjectImpl.kt\nandroidx/compose/runtime/snapshots/ReaderKind$Companion\n+ 6 DerivedState.kt\nandroidx/compose/runtime/SnapshotStateKt__DerivedStateKt\n+ 7 DataSource.kt\nandroidx/compose/runtime/DataSource$Companion\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 9 ObjectList.kt\nandroidx/collection/MutableObjectList\n+ 10 ObjectList.kt\nandroidx/collection/ObjectList\n+ 11 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 12 ObjectIntMap.kt\nandroidx/collection/MutableObjectIntMap\n+ 13 ScatterMap.kt\nandroidx/collection/MutableScatterMap\n+ 14 ScatterMap.kt\nandroidx/collection/ScatterMap\n+ 15 ScatterSetWrapper.kt\nandroidx/compose/runtime/collection/ScatterSetWrapperKt\n+ 16 ScatterSet.kt\nandroidx/collection/ScatterSet\n+ 17 ScopeMap.kt\nandroidx/compose/runtime/collection/ScopeMap\n+ 18 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,617:1\n1101#2:618\n1083#2,2:619\n403#3,3:621\n367#3,6:624\n377#3,3:631\n380#3,2:635\n383#3,6:638\n406#3:644\n367#3,6:688\n377#3,3:695\n380#3,2:699\n383#3,6:705\n395#3,4:712\n367#3,6:716\n377#3,3:723\n380#3,9:727\n399#3:736\n395#3,4:752\n367#3,6:756\n377#3,3:763\n380#3,9:767\n399#3:776\n1399#4:630\n1270#4:634\n1399#4:694\n1270#4:698\n1399#4:722\n1270#4:726\n1399#4:744\n1270#4:748\n1399#4:762\n1270#4:766\n1399#4:800\n1270#4:804\n1399#4:824\n1270#4:828\n1399#4:847\n1270#4:851\n1399#4:890\n1270#4:894\n1399#4:926\n1270#4:930\n1399#4:964\n1270#4:968\n1399#4:987\n1270#4:991\n1399#4:1030\n1270#4:1034\n1399#4:1066\n1270#4:1070\n1399#4:1112\n1270#4:1116\n1399#4:1141\n1270#4:1145\n57#5:637\n57#5:645\n57#5:807\n402#6,4:646\n407#6:683\n408#6,2:685\n184#7,4:650\n188#7:660\n189#7,2:665\n191#7,4:668\n196#7:676\n195#7,4:677\n199#7:682\n1#8:654\n1#8:1119\n903#9,5:655\n287#10,4:661\n292#10:667\n329#10,4:672\n334#10:681\n44#11:684\n519#11:1087\n424#11,8:1088\n775#12:687\n777#12,4:701\n781#12:711\n842#13:737\n844#13:751\n845#13,3:777\n848#13:786\n329#14,6:738\n339#14,3:745\n342#14,2:749\n345#14,6:780\n41#15,3:787\n46#15:952\n48#15:1086\n231#16,3:790\n200#16,7:793\n211#16,3:801\n214#16,2:805\n231#16,3:814\n200#16,7:817\n211#16,3:825\n214#16,2:829\n231#16,3:837\n200#16,7:840\n211#16,3:848\n214#16,9:852\n234#16:861\n217#16,6:866\n234#16:872\n231#16,3:880\n200#16,7:883\n211#16,3:891\n214#16,9:895\n234#16:904\n231#16,3:916\n200#16,7:919\n211#16,3:927\n214#16,9:931\n234#16:940\n217#16,6:945\n234#16:951\n231#16,3:954\n200#16,7:957\n211#16,3:965\n214#16,2:969\n231#16,3:977\n200#16,7:980\n211#16,3:988\n214#16,9:992\n234#16:1001\n217#16,6:1006\n234#16:1012\n231#16,3:1020\n200#16,7:1023\n211#16,3:1031\n214#16,9:1035\n234#16:1044\n231#16,3:1056\n200#16,7:1059\n211#16,3:1067\n214#16,9:1071\n234#16:1080\n231#16,3:1102\n200#16,7:1105\n211#16,3:1113\n214#16,2:1117\n217#16,6:1120\n234#16:1126\n231#16,3:1131\n200#16,7:1134\n211#16,3:1142\n214#16,9:1146\n234#16:1155\n67#17,6:808\n67#17,6:831\n75#17,4:862\n75#17:873\n67#17,6:874\n75#17,4:905\n78#17:909\n67#17,6:910\n75#17,4:941\n67#17,6:971\n75#17,4:1002\n75#17:1013\n67#17,6:1014\n75#17,4:1045\n78#17:1049\n67#17,6:1050\n75#17,4:1081\n67#17,6:1096\n75#17,4:1127\n1863#18:953\n1864#18:1085\n*S KotlinDebug\n*F\n+ 1 SnapshotStateObserver.kt\nandroidx/compose/runtime/snapshots/SnapshotStateObserver$ObservedScopeMap\n*L\n382#1:618\n382#1:619,2\n448#1:621,3\n448#1:624,6\n448#1:631,3\n448#1:635,2\n448#1:638,6\n448#1:644\n492#1:688,6\n492#1:695,3\n492#1:699,2\n492#1:705,6\n504#1:712,4\n504#1:716,6\n504#1:723,3\n504#1:727,9\n504#1:736\n512#1:752,4\n512#1:756,6\n512#1:763,3\n512#1:767,9\n512#1:776\n448#1:630\n448#1:634\n492#1:694\n492#1:698\n504#1:722\n504#1:726\n509#1:744\n509#1:748\n512#1:762\n512#1:766\n549#1:800\n549#1:804\n556#1:824\n556#1:828\n568#1:847\n568#1:851\n568#1:890\n568#1:894\n579#1:926\n579#1:930\n556#1:964\n556#1:968\n568#1:987\n568#1:991\n568#1:1030\n568#1:1034\n579#1:1066\n579#1:1070\n597#1:1112\n597#1:1116\n612#1:1141\n612#1:1145\n450#1:637\n458#1:645\n550#1:807\n476#1:646,4\n476#1:683\n476#1:685,2\n477#1:650,4\n477#1:660\n477#1:665,2\n477#1:668,4\n477#1:676\n477#1:677,4\n477#1:682\n477#1:654\n477#1:655,5\n477#1:661,4\n477#1:667\n477#1:672,4\n477#1:681\n476#1:684\n585#1:1087\n586#1:1088,8\n492#1:687\n492#1:701,4\n492#1:711\n509#1:737\n509#1:751\n509#1:777,3\n509#1:786\n509#1:738,6\n509#1:745,3\n509#1:749,2\n509#1:780,6\n549#1:787,3\n549#1:952\n549#1:1086\n549#1:790,3\n549#1:793,7\n549#1:801,3\n549#1:805,2\n556#1:814,3\n556#1:817,7\n556#1:825,3\n556#1:829,2\n568#1:837,3\n568#1:840,7\n568#1:848,3\n568#1:852,9\n568#1:861\n556#1:866,6\n556#1:872\n568#1:880,3\n568#1:883,7\n568#1:891,3\n568#1:895,9\n568#1:904\n579#1:916,3\n579#1:919,7\n579#1:927,3\n579#1:931,9\n579#1:940\n549#1:945,6\n549#1:951\n556#1:954,3\n556#1:957,7\n556#1:965,3\n556#1:969,2\n568#1:977,3\n568#1:980,7\n568#1:988,3\n568#1:992,9\n568#1:1001\n556#1:1006,6\n556#1:1012\n568#1:1020,3\n568#1:1023,7\n568#1:1031,3\n568#1:1035,9\n568#1:1044\n579#1:1056,3\n579#1:1059,7\n579#1:1067,3\n579#1:1071,9\n579#1:1080\n597#1:1102,3\n597#1:1105,7\n597#1:1113,3\n597#1:1117,2\n597#1:1120,6\n597#1:1126\n612#1:1131,3\n612#1:1134,7\n612#1:1142,3\n612#1:1146,9\n612#1:1155\n556#1:808,6\n568#1:831,6\n568#1:862,4\n556#1:873\n568#1:874,6\n568#1:905,4\n556#1:909\n579#1:910,6\n579#1:941,4\n568#1:971,6\n568#1:1002,4\n556#1:1013\n568#1:1014,6\n568#1:1045,4\n556#1:1049\n579#1:1050,6\n579#1:1081,4\n597#1:1096,6\n597#1:1127,4\n549#1:953\n549#1:1085\n*E\n"})
    private static final class ObservedScopeMap {
        @NotNull
        private final Function1<Object, Unit> onChanged;
        @Nullable
        private Object currentScope;
        @Nullable
        private MutableObjectIntMap<Object> currentScopeReads;
        private int currentToken;
        @NotNull
        private final MutableScatterMap<Object, Object> valueToScopes;
        @NotNull
        private final MutableScatterMap<Object, MutableObjectIntMap<Object>> scopeToValues;
        @NotNull
        private final MutableScatterSet<Object> invalidated;
        @NotNull
        private final MutableVector<DerivedState<?>> statesToReread;
        @NotNull
        private final DerivedStateObserver derivedStateObserver;
        private int deriveStateScopeCount;
        @NotNull
        private final MutableScatterMap<Object, Object> dependencyToDerivedStates;
        @NotNull
        private final HashMap<DerivedState<?>, Object> recordedDerivedStateValues;

        public ObservedScopeMap(@NotNull Function1<Object, Unit> onChanged) {
            Intrinsics.checkNotNullParameter(onChanged, (String)"onChanged");
            this.onChanged = onChanged;
            this.currentToken = -1;
            this.valueToScopes = ScopeMap.constructor-impl$default(null, 1, null);
            this.scopeToValues = new MutableScatterMap(0, 1, null);
            this.invalidated = new MutableScatterSet(0, 1, null);
            boolean $i$f$mutableVectorOf = false;
            int capacity$iv$iv = 16;
            boolean $i$f$MutableVector = false;
            this.statesToReread = new MutableVector<DerivedState>(new DerivedState[capacity$iv$iv], 0);
            this.derivedStateObserver = new DerivedStateObserver(this){
                final /* synthetic */ ObservedScopeMap this$0;
                {
                    this.this$0 = $receiver;
                }

                public void start(DerivedState<?> derivedState) {
                    Intrinsics.checkNotNullParameter(derivedState, (String)"derivedState");
                    int n = ObservedScopeMap.access$getDeriveStateScopeCount$p(this.this$0);
                    ObservedScopeMap.access$setDeriveStateScopeCount$p(this.this$0, n + 1);
                }

                public void done(DerivedState<?> derivedState) {
                    Intrinsics.checkNotNullParameter(derivedState, (String)"derivedState");
                    int n = ObservedScopeMap.access$getDeriveStateScopeCount$p(this.this$0);
                    ObservedScopeMap.access$setDeriveStateScopeCount$p(this.this$0, n + -1);
                }
            };
            this.dependencyToDerivedStates = ScopeMap.constructor-impl$default(null, 1, null);
            this.recordedDerivedStateValues = new HashMap();
        }

        @NotNull
        public final Function1<Object, Unit> getOnChanged() {
            return this.onChanged;
        }

        /*
         * WARNING - void declaration
         */
        public final void recordRead(@NotNull Object value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Object object = this.currentScope;
            Intrinsics.checkNotNull((Object)object);
            Object scope2 = object;
            ObservedScopeMap observedScopeMap = this;
            Object object2 = value2;
            int n = this.currentToken;
            Object object3 = scope2;
            MutableObjectIntMap mutableObjectIntMap = this.currentScopeReads;
            if (mutableObjectIntMap == null) {
                void it;
                MutableObjectIntMap mutableObjectIntMap2;
                MutableObjectIntMap mutableObjectIntMap3 = mutableObjectIntMap2 = new MutableObjectIntMap(0, 1, null);
                Object object4 = object3;
                int n2 = n;
                Object object5 = object2;
                ObservedScopeMap observedScopeMap2 = observedScopeMap;
                boolean bl = false;
                this.currentScopeReads = it;
                this.scopeToValues.set(scope2, (Object)it);
                Unit unit = Unit.INSTANCE;
                observedScopeMap = observedScopeMap2;
                object2 = object5;
                n = n2;
                object3 = object4;
                mutableObjectIntMap = mutableObjectIntMap2;
            }
            observedScopeMap.recordRead(object2, n, object3, mutableObjectIntMap);
        }

        private final void recordRead(Object value2, int currentToken, Object currentScope, MutableObjectIntMap<Object> recordedValues) {
            if (this.deriveStateScopeCount > 0) {
                return;
            }
            int previousToken = recordedValues.put(value2, currentToken, -1);
            if (value2 instanceof DerivedState && previousToken != currentToken) {
                DerivedState.Record record = ((DerivedState)value2).getCurrentRecord();
                ((Map)this.recordedDerivedStateValues).put(value2, record.getCurrentValue());
                ObjectIntMap<Object> dependencies = record.getDependencies();
                MutableScatterMap<Object, Object> dependencyToDerivedStates = this.dependencyToDerivedStates;
                ScopeMap.removeScope-impl(dependencyToDerivedStates, value2);
                ObjectIntMap<Object> this_$iv = dependencies;
                boolean $i$f$forEachKey = false;
                Object[] k$iv = this_$iv.keys;
                ObjectIntMap<Object> this_$iv$iv = this_$iv;
                boolean $i$f$forEachIndexed = false;
                long[] m$iv$iv = this_$iv$iv.metadata;
                int lastIndex$iv$iv = m$iv$iv.length - 2;
                int i$iv$iv = 0;
                if (i$iv$iv <= lastIndex$iv$iv) {
                    while (true) {
                        long slot$iv$iv;
                        long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                        boolean $i$f$maskEmptyOrDeleted = false;
                        if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                            int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                            for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                                long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                                boolean $i$f$isFull = false;
                                if (value$iv$iv$iv < 128L) {
                                    int index$iv$iv;
                                    int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                                    boolean bl = false;
                                    Object dependency = k$iv[index$iv];
                                    boolean bl2 = false;
                                    if (dependency instanceof StateObjectImpl) {
                                        ReaderKind.Companion this_$iv2 = ReaderKind.Companion;
                                        boolean bl3 = false;
                                        ((StateObjectImpl)dependency).recordReadIn-h_f27i8$runtime(ReaderKind.constructor-impl(2));
                                    }
                                    ScopeMap.add-impl(dependencyToDerivedStates, dependency, value2);
                                }
                                slot$iv$iv >>= 8;
                            }
                            if (bitCount$iv$iv != 8) break;
                        }
                        if (i$iv$iv == lastIndex$iv$iv) break;
                        ++i$iv$iv;
                    }
                }
            }
            if (previousToken == -1) {
                if (value2 instanceof StateObjectImpl) {
                    ReaderKind.Companion this_$iv = ReaderKind.Companion;
                    boolean bl = false;
                    ((StateObjectImpl)value2).recordReadIn-h_f27i8$runtime(ReaderKind.constructor-impl(2));
                }
                ScopeMap.add-impl(this.valueToScopes, value2, currentScope);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void observe(@NotNull Object scope2, @NotNull Function1<Object, Boolean> readObserver, @NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
            Intrinsics.checkNotNullParameter(readObserver, (String)"readObserver");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Object previousScope = this.currentScope;
            MutableObjectIntMap<Object> previousReads = this.currentScopeReads;
            int previousToken = this.currentToken;
            this.currentScope = scope2;
            this.currentScopeReads = (MutableObjectIntMap)this.scopeToValues.get(scope2);
            if (this.currentToken == -1) {
                this.currentToken = Long.hashCode(SnapshotKt.currentSnapshot().getSnapshotId());
            }
            DerivedStateObserver observer$iv = this.derivedStateObserver;
            boolean $i$f$observeDerivedStateRecalculations = false;
            MutableVector<DerivedStateObserver> observers$iv = SnapshotStateKt.derivedStateObservers();
            try {
                void this_$iv$iv;
                Object object;
                observers$iv.add(observer$iv);
                boolean bl = false;
                DataSource.Companion this_$iv = DataSource.Companion;
                boolean $i$f$observe = false;
                ObjectList<DataSource<?, ?>> dataSources$iv = DataSourceKt.getRegisteredDataSources();
                MutableObjectList<Object> $this$observe_u24lambda_u244$iv = object = MutableTokenListPool.INSTANCE.acquire();
                boolean bl2 = false;
                MutableObjectList<Object> mutableObjectList = $this$observe_u24lambda_u244$iv;
                int capacity$iv$iv = dataSources$iv.getSize();
                boolean $i$f$ensureCapacity = false;
                Object[] oldContent$iv$iv = this_$iv$iv.content;
                if (oldContent$iv$iv.length < capacity$iv$iv) {
                    this_$iv$iv.resizeStorage(capacity$iv$iv, oldContent$iv$iv);
                }
                MutableObjectList<Object> previousObservations$iv = object;
                ObjectList<DataSource<?, ?>> this_$iv$iv2 = dataSources$iv;
                boolean $i$f$forEach = false;
                Object[] content$iv$iv = this_$iv$iv2.content;
                capacity$iv$iv = this_$iv$iv2._size;
                for (int i$iv$iv = 0; i$iv$iv < capacity$iv$iv; ++i$iv$iv) {
                    DataSource dataSource$iv = (DataSource)content$iv$iv[i$iv$iv];
                    boolean bl3 = false;
                    previousObservations$iv.add(dataSource$iv.startObservation(readObserver));
                }
                try {
                    object = block.invoke();
                }
                catch (Throwable throwable) {
                    ObjectList this_$iv$iv3 = (ObjectList)previousObservations$iv;
                    boolean $i$f$forEachReversedIndexed = false;
                    Object[] content$iv$iv2 = this_$iv$iv3.content;
                    int i$iv$iv = this_$iv$iv3._size - 1;
                    while (-1 < i$iv$iv) {
                        void previousObservation$iv;
                        Object index$iv = content$iv$iv2[i$iv$iv];
                        int index$iv2 = i$iv$iv--;
                        boolean bl4 = false;
                        Object object2 = dataSources$iv.get(index$iv2);
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type androidx.compose.runtime.DataSource<kotlin.Any?, *>");
                        DataSource dataSource$iv = (DataSource)object2;
                        dataSource$iv.endObservation(previousObservation$iv);
                    }
                    MutableTokenListPool.INSTANCE.release(previousObservations$iv);
                    throw throwable;
                }
                ObjectList this_$iv$iv4 = (ObjectList)previousObservations$iv;
                boolean $i$f$forEachReversedIndexed = false;
                Object[] content$iv$iv3 = this_$iv$iv4.content;
                int i$iv$iv = this_$iv$iv4._size - 1;
                while (-1 < i$iv$iv) {
                    void previousObservation$iv;
                    Object dataSource$iv = content$iv$iv3[i$iv$iv];
                    int index$iv = i$iv$iv--;
                    boolean bl5 = false;
                    Object object3 = dataSources$iv.get(index$iv);
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type androidx.compose.runtime.DataSource<kotlin.Any?, *>");
                    DataSource dataSource$iv2 = (DataSource)object3;
                    dataSource$iv2.endObservation(previousObservation$iv);
                }
                MutableTokenListPool.INSTANCE.release(previousObservations$iv);
            }
            finally {
                MutableVector<DerivedStateObserver> this_$iv$iv = observers$iv;
                boolean $i$f$getLastIndex = false;
                observers$iv.removeAt(this_$iv$iv.getSize() - 1);
            }
            Object object = this.currentScope;
            Intrinsics.checkNotNull((Object)object);
            this.clearObsoleteStateReads(object);
            this.currentScope = previousScope;
            this.currentScopeReads = previousReads;
            this.currentToken = previousToken;
        }

        /*
         * WARNING - void declaration
         */
        private final void clearObsoleteStateReads(Object scope2) {
            int currentToken = this.currentToken;
            MutableObjectIntMap<Object> mutableObjectIntMap = this.currentScopeReads;
            if (mutableObjectIntMap != null) {
                MutableObjectIntMap<Object> this_$iv = mutableObjectIntMap;
                boolean $i$f$removeIf = false;
                ObjectIntMap this_$iv$iv = (ObjectIntMap)this_$iv;
                boolean $i$f$forEachIndexed = false;
                int i$iv$iv = 0;
                long[] m$iv$iv = this_$iv$iv.metadata;
                int lastIndex$iv$iv = m$iv$iv.length - 2;
                if (i$iv$iv <= lastIndex$iv$iv) {
                    while (true) {
                        long slot$iv$iv;
                        long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                        boolean $i$f$maskEmptyOrDeleted = false;
                        if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                            int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                            for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                                long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                                boolean $i$f$isFull = false;
                                if (value$iv$iv$iv < 128L) {
                                    void token2;
                                    boolean bl;
                                    int index$iv$iv;
                                    int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                                    boolean bl2 = false;
                                    int n = this_$iv.values[index$iv];
                                    Object value2 = this_$iv.keys[index$iv];
                                    boolean bl3 = false;
                                    boolean willRemove = bl = token2 != currentToken;
                                    boolean bl4 = false;
                                    if (willRemove) {
                                        this.removeObservation(scope2, value2);
                                    }
                                    if (bl) {
                                        this_$iv.removeValueAt(index$iv);
                                    }
                                }
                                slot$iv$iv >>= 8;
                            }
                            if (bitCount$iv$iv != 8) break;
                        }
                        if (i$iv$iv == lastIndex$iv$iv) break;
                        ++i$iv$iv;
                    }
                }
            }
        }

        public final void clearScopeObservations(@NotNull Object scope2) {
            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
            MutableObjectIntMap mutableObjectIntMap = (MutableObjectIntMap)this.scopeToValues.remove(scope2);
            if (mutableObjectIntMap == null) {
                return;
            }
            MutableObjectIntMap recordedValues = mutableObjectIntMap;
            ObjectIntMap this_$iv = (ObjectIntMap)recordedValues;
            boolean $i$f$forEach = false;
            Object[] k$iv = this_$iv.keys;
            int[] v$iv = this_$iv.values;
            ObjectIntMap this_$iv$iv = this_$iv;
            boolean $i$f$forEachIndexed = false;
            int i$iv$iv = 0;
            long[] m$iv$iv = this_$iv$iv.metadata;
            int lastIndex$iv$iv = m$iv$iv.length - 2;
            if (i$iv$iv <= lastIndex$iv$iv) {
                while (true) {
                    long slot$iv$iv;
                    long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                    boolean $i$f$maskEmptyOrDeleted = false;
                    if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                        int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                        for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                            long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                            boolean $i$f$isFull = false;
                            if (value$iv$iv$iv < 128L) {
                                int index$iv$iv;
                                int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                                boolean bl = false;
                                int cfr_ignored_0 = v$iv[index$iv];
                                Object value2 = k$iv[index$iv];
                                boolean bl2 = false;
                                this.removeObservation(scope2, value2);
                            }
                            slot$iv$iv >>= 8;
                        }
                        if (bitCount$iv$iv != 8) break;
                    }
                    if (i$iv$iv == lastIndex$iv$iv) break;
                    ++i$iv$iv;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void removeScopeIf(@NotNull Function1<Object, Boolean> predicate) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            MutableScatterMap<Object, MutableObjectIntMap<Object>> this_$iv = this.scopeToValues;
            boolean $i$f$removeIf = false;
            ScatterMap this_$iv$iv = (ScatterMap)this_$iv;
            boolean $i$f$forEachIndexed = false;
            long[] m$iv$iv = this_$iv$iv.metadata;
            int lastIndex$iv$iv = m$iv$iv.length - 2;
            int i$iv$iv = 0;
            if (i$iv$iv <= lastIndex$iv$iv) {
                while (true) {
                    long slot$iv$iv;
                    long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                    boolean $i$f$maskEmptyOrDeleted = false;
                    if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                        int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                        for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                            long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                            boolean $i$f$isFull = false;
                            if (value$iv$iv$iv < 128L) {
                                int index$iv$iv;
                                int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                                boolean bl = false;
                                MutableObjectIntMap mutableObjectIntMap = (MutableObjectIntMap)this_$iv.values[index$iv];
                                Object scope2 = this_$iv.keys[index$iv];
                                boolean bl2 = false;
                                Object object = predicate.invoke(scope2);
                                boolean willRemove = (Boolean)object;
                                boolean bl3 = false;
                                if (willRemove) {
                                    void valueSet;
                                    ObjectIntMap this_$iv2 = (ObjectIntMap)valueSet;
                                    boolean $i$f$forEach = false;
                                    Object[] k$iv = this_$iv2.keys;
                                    int[] v$iv = this_$iv2.values;
                                    ObjectIntMap this_$iv$iv2 = this_$iv2;
                                    boolean $i$f$forEachIndexed2 = false;
                                    int i$iv$iv2 = 0;
                                    long[] m$iv$iv2 = this_$iv$iv2.metadata;
                                    int lastIndex$iv$iv2 = m$iv$iv2.length - 2;
                                    if (i$iv$iv2 <= lastIndex$iv$iv2) {
                                        while (true) {
                                            long slot$iv$iv2;
                                            long $this$maskEmptyOrDeleted$iv$iv$iv2 = slot$iv$iv2 = m$iv$iv2[i$iv$iv2];
                                            boolean $i$f$maskEmptyOrDeleted2 = false;
                                            if (($this$maskEmptyOrDeleted$iv$iv$iv2 & ($this$maskEmptyOrDeleted$iv$iv$iv2 ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                                                int bitCount$iv$iv2 = 8 - (~(i$iv$iv2 - lastIndex$iv$iv2) >>> 31);
                                                for (int j$iv$iv2 = 0; j$iv$iv2 < bitCount$iv$iv2; ++j$iv$iv2) {
                                                    long value$iv$iv$iv2 = slot$iv$iv2 & 0xFFL;
                                                    boolean $i$f$isFull2 = false;
                                                    if (value$iv$iv$iv2 < 128L) {
                                                        int index$iv$iv2;
                                                        int index$iv2 = index$iv$iv2 = (i$iv$iv2 << 3) + j$iv$iv2;
                                                        boolean bl4 = false;
                                                        int cfr_ignored_0 = v$iv[index$iv2];
                                                        Object value2 = k$iv[index$iv2];
                                                        boolean bl5 = false;
                                                        this.removeObservation(scope2, value2);
                                                    }
                                                    slot$iv$iv2 >>= 8;
                                                }
                                                if (bitCount$iv$iv2 != 8) break;
                                            }
                                            if (i$iv$iv2 == lastIndex$iv$iv2) break;
                                            ++i$iv$iv2;
                                        }
                                    }
                                }
                                if (((Boolean)object).booleanValue()) {
                                    this_$iv.removeValueAt(index$iv);
                                }
                            }
                            slot$iv$iv >>= 8;
                        }
                        if (bitCount$iv$iv != 8) break;
                    }
                    if (i$iv$iv == lastIndex$iv$iv) break;
                    ++i$iv$iv;
                }
            }
        }

        public final boolean hasScopeObservations() {
            return this.scopeToValues.isNotEmpty();
        }

        private final void removeObservation(Object scope2, Object value2) {
            ScopeMap.remove-impl(this.valueToScopes, value2, scope2);
            if (value2 instanceof DerivedState && !ScopeMap.contains-impl(this.valueToScopes, value2)) {
                ScopeMap.removeScope-impl(this.dependencyToDerivedStates, value2);
                this.recordedDerivedStateValues.remove(value2);
            }
        }

        public final void clear() {
            ScopeMap.clear-impl(this.valueToScopes);
            this.scopeToValues.clear();
            ScopeMap.clear-impl(this.dependencyToDerivedStates);
            this.recordedDerivedStateValues.clear();
        }

        public final boolean recordInvalidation(@NotNull Set<? extends Object> changes) {
            boolean hasValues;
            block91: {
                boolean bl;
                Object scope2;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                Object scope3;
                int index$iv$iv;
                int index$iv$iv$iv;
                boolean $i$f$isFull;
                long value$iv$iv$iv$iv;
                int j$iv$iv$iv;
                int bitCount$iv$iv$iv;
                boolean $i$f$maskEmptyOrDeleted;
                long $this$maskEmptyOrDeleted$iv$iv$iv$iv;
                long slot$iv$iv$iv;
                int lastIndex$iv$iv$iv;
                long[] m$iv$iv$iv;
                int i$iv$iv$iv;
                boolean $i$f$forEachIndex;
                ScatterSet this_$iv$iv$iv;
                Object[] elements$iv$iv;
                boolean $i$f$forEach;
                ScatterSet this_$iv$iv;
                Object value$iv;
                DerivedState key$iv;
                SnapshotMutationPolicy<Object> policy;
                Object previousValue;
                boolean bl5;
                DerivedState derivedState;
                boolean bl6;
                int index$iv$iv2;
                int index$iv$iv$iv2;
                boolean $i$f$isFull2;
                long value$iv$iv$iv$iv2;
                int j$iv$iv$iv2;
                int bitCount$iv$iv$iv2;
                boolean $i$f$maskEmptyOrDeleted2;
                long $this$maskEmptyOrDeleted$iv$iv$iv$iv2;
                long slot$iv$iv$iv2;
                int lastIndex$iv$iv$iv2;
                long[] m$iv$iv$iv2;
                int i$iv$iv$iv2;
                boolean $i$f$forEachIndex2;
                ScatterSet this_$iv$iv$iv2;
                Object[] elements$iv$iv2;
                boolean $i$f$forEach2;
                ScatterSet this_$iv$iv2;
                boolean bl7;
                Object value2;
                Object[] elements$iv$iv3;
                boolean $i$f$forEach3;
                Set<? extends Object> $this$fastForEach$iv;
                MutableScatterSet<Object> invalidated;
                MutableScatterMap<Object, Object> valueToScopes;
                HashMap<DerivedState<?>, Object> recordedDerivedStateValues;
                MutableScatterMap<Object, Object> dependencyToDerivedStates;
                block95: {
                    Intrinsics.checkNotNullParameter(changes, (String)"changes");
                    hasValues = false;
                    dependencyToDerivedStates = this.dependencyToDerivedStates;
                    recordedDerivedStateValues = this.recordedDerivedStateValues;
                    valueToScopes = this.valueToScopes;
                    invalidated = this.invalidated;
                    $this$fastForEach$iv = changes;
                    boolean $i$f$fastForEach = false;
                    if (!($this$fastForEach$iv instanceof ScatterSetWrapper)) break block95;
                    ScatterSet this_$iv$iv3 = ((ScatterSetWrapper)$this$fastForEach$iv).getSet$runtime();
                    $i$f$forEach3 = false;
                    elements$iv$iv3 = this_$iv$iv3.elements;
                    ScatterSet this_$iv$iv$iv3 = this_$iv$iv3;
                    boolean $i$f$forEachIndex3 = false;
                    int i$iv$iv$iv3 = 0;
                    long[] m$iv$iv$iv3 = this_$iv$iv$iv3.metadata;
                    int lastIndex$iv$iv$iv3 = m$iv$iv$iv3.length - 2;
                    if (i$iv$iv$iv3 > lastIndex$iv$iv$iv3) break block91;
                    while (true) {
                        block96: {
                            long slot$iv$iv$iv3;
                            long $this$maskEmptyOrDeleted$iv$iv$iv$iv3 = slot$iv$iv$iv3 = m$iv$iv$iv3[i$iv$iv$iv3];
                            boolean $i$f$maskEmptyOrDeleted3 = false;
                            if (($this$maskEmptyOrDeleted$iv$iv$iv$iv3 & ($this$maskEmptyOrDeleted$iv$iv$iv$iv3 ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) == -9187201950435737472L) break block96;
                            int bitCount$iv$iv$iv3 = 8 - (~(i$iv$iv$iv3 - lastIndex$iv$iv$iv3) >>> 31);
                            for (int j$iv$iv$iv3 = 0; j$iv$iv$iv3 < bitCount$iv$iv$iv3; ++j$iv$iv$iv3) {
                                block90: {
                                    block88: {
                                        Boolean bl8;
                                        Object value$iv2;
                                        block98: {
                                            block97: {
                                                int index$iv$iv$iv3;
                                                long value$iv$iv$iv$iv3 = slot$iv$iv$iv3 & 0xFFL;
                                                boolean $i$f$isFull3 = false;
                                                if (!(value$iv$iv$iv$iv3 < 128L)) break block90;
                                                int index$iv$iv3 = index$iv$iv$iv3 = (i$iv$iv$iv3 << 3) + j$iv$iv$iv3;
                                                boolean bl9 = false;
                                                value2 = elements$iv$iv3[index$iv$iv3];
                                                bl7 = false;
                                                if (!(value2 instanceof StateObjectImpl)) break block97;
                                                ReaderKind.Companion this_$iv = ReaderKind.Companion;
                                                boolean bl10 = false;
                                                if (!((StateObjectImpl)value2).isReadIn-h_f27i8$runtime(ReaderKind.constructor-impl(2))) break block90;
                                            }
                                            if (!ScopeMap.contains-impl(dependencyToDerivedStates, value2)) break block88;
                                            boolean bl11 = false;
                                            value$iv2 = dependencyToDerivedStates.get(value2);
                                            if (value$iv2 == null) break block88;
                                            if (!(value$iv2 instanceof MutableScatterSet)) break block98;
                                            this_$iv$iv2 = (ScatterSet)((MutableScatterSet)value$iv2);
                                            $i$f$forEach2 = false;
                                            elements$iv$iv2 = this_$iv$iv2.elements;
                                            this_$iv$iv$iv2 = this_$iv$iv2;
                                            $i$f$forEachIndex2 = false;
                                            i$iv$iv$iv2 = 0;
                                            m$iv$iv$iv2 = this_$iv$iv$iv2.metadata;
                                            lastIndex$iv$iv$iv2 = m$iv$iv$iv2.length - 2;
                                            if (i$iv$iv$iv2 > lastIndex$iv$iv$iv2) break block88;
                                            while (true) {
                                                $this$maskEmptyOrDeleted$iv$iv$iv$iv2 = slot$iv$iv$iv2 = m$iv$iv$iv2[i$iv$iv$iv2];
                                                $i$f$maskEmptyOrDeleted2 = false;
                                                if (($this$maskEmptyOrDeleted$iv$iv$iv$iv2 & ($this$maskEmptyOrDeleted$iv$iv$iv$iv2 ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                                                    bitCount$iv$iv$iv2 = 8 - (~(i$iv$iv$iv2 - lastIndex$iv$iv$iv2) >>> 31);
                                                    for (j$iv$iv$iv2 = 0; j$iv$iv$iv2 < bitCount$iv$iv$iv2; ++j$iv$iv$iv2) {
                                                        value$iv$iv$iv$iv2 = slot$iv$iv$iv2 & 0xFFL;
                                                        $i$f$isFull2 = false;
                                                        if (value$iv$iv$iv$iv2 < 128L) {
                                                            Boolean bl12;
                                                            index$iv$iv2 = index$iv$iv$iv2 = (i$iv$iv$iv2 << 3) + j$iv$iv$iv2;
                                                            bl6 = false;
                                                            derivedState = (DerivedState)elements$iv$iv2[index$iv$iv2];
                                                            bl5 = false;
                                                            Intrinsics.checkNotNull((Object)derivedState, (String)"null cannot be cast to non-null type androidx.compose.runtime.DerivedState<kotlin.Any?>");
                                                            previousValue = recordedDerivedStateValues.get(derivedState);
                                                            SnapshotMutationPolicy snapshotMutationPolicy = derivedState.getPolicy();
                                                            if (snapshotMutationPolicy == null) {
                                                                snapshotMutationPolicy = SnapshotStateKt.structuralEqualityPolicy();
                                                            }
                                                            if (!(policy = snapshotMutationPolicy).equivalent(derivedState.getCurrentRecord().getCurrentValue(), previousValue)) {
                                                                key$iv = derivedState;
                                                                bl3 = false;
                                                                value$iv = valueToScopes.get((Object)key$iv);
                                                                if (value$iv != null) {
                                                                    if (value$iv instanceof MutableScatterSet) {
                                                                        this_$iv$iv = (ScatterSet)((MutableScatterSet)value$iv);
                                                                        $i$f$forEach = false;
                                                                        elements$iv$iv = this_$iv$iv.elements;
                                                                        this_$iv$iv$iv = this_$iv$iv;
                                                                        $i$f$forEachIndex = false;
                                                                        i$iv$iv$iv = 0;
                                                                        m$iv$iv$iv = this_$iv$iv$iv.metadata;
                                                                        lastIndex$iv$iv$iv = m$iv$iv$iv.length - 2;
                                                                        if (i$iv$iv$iv <= lastIndex$iv$iv$iv) {
                                                                            while (true) {
                                                                                $this$maskEmptyOrDeleted$iv$iv$iv$iv = slot$iv$iv$iv = m$iv$iv$iv[i$iv$iv$iv];
                                                                                $i$f$maskEmptyOrDeleted = false;
                                                                                if (($this$maskEmptyOrDeleted$iv$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                                                                                    bitCount$iv$iv$iv = 8 - (~(i$iv$iv$iv - lastIndex$iv$iv$iv) >>> 31);
                                                                                    for (j$iv$iv$iv = 0; j$iv$iv$iv < bitCount$iv$iv$iv; ++j$iv$iv$iv) {
                                                                                        value$iv$iv$iv$iv = slot$iv$iv$iv & 0xFFL;
                                                                                        $i$f$isFull = false;
                                                                                        if (value$iv$iv$iv$iv < 128L) {
                                                                                            index$iv$iv = index$iv$iv$iv = (i$iv$iv$iv << 3) + j$iv$iv$iv;
                                                                                            bl2 = false;
                                                                                            scope3 = elements$iv$iv[index$iv$iv];
                                                                                            bl4 = false;
                                                                                            invalidated.add(scope3);
                                                                                            hasValues = true;
                                                                                        }
                                                                                        slot$iv$iv$iv >>= 8;
                                                                                    }
                                                                                    if (bitCount$iv$iv$iv != 8) break;
                                                                                }
                                                                                if (i$iv$iv$iv != lastIndex$iv$iv$iv) {
                                                                                    ++i$iv$iv$iv;
                                                                                    continue;
                                                                                }
                                                                                break;
                                                                            }
                                                                        }
                                                                    } else {
                                                                        scope3 = value$iv;
                                                                        bl4 = false;
                                                                        invalidated.add(scope3);
                                                                        hasValues = true;
                                                                    }
                                                                }
                                                                bl12 = Unit.INSTANCE;
                                                            } else {
                                                                bl12 = this.statesToReread.add(derivedState);
                                                            }
                                                        }
                                                        slot$iv$iv$iv2 >>= 8;
                                                    }
                                                    if (bitCount$iv$iv$iv2 != 8) break block88;
                                                }
                                                if (i$iv$iv$iv2 != lastIndex$iv$iv$iv2) {
                                                    ++i$iv$iv$iv2;
                                                    continue;
                                                }
                                                break block88;
                                                break;
                                            }
                                        }
                                        derivedState = (DerivedState)value$iv2;
                                        bl5 = false;
                                        previousValue = recordedDerivedStateValues.get(derivedState);
                                        SnapshotMutationPolicy snapshotMutationPolicy = derivedState.getPolicy();
                                        if (snapshotMutationPolicy == null) {
                                            snapshotMutationPolicy = SnapshotStateKt.structuralEqualityPolicy();
                                        }
                                        if (!(policy = snapshotMutationPolicy).equivalent(derivedState.getCurrentRecord().getCurrentValue(), previousValue)) {
                                            key$iv = derivedState;
                                            bl3 = false;
                                            value$iv = valueToScopes.get((Object)key$iv);
                                            if (value$iv != null) {
                                                if (value$iv instanceof MutableScatterSet) {
                                                    this_$iv$iv = (ScatterSet)((MutableScatterSet)value$iv);
                                                    $i$f$forEach = false;
                                                    elements$iv$iv = this_$iv$iv.elements;
                                                    this_$iv$iv$iv = this_$iv$iv;
                                                    $i$f$forEachIndex = false;
                                                    i$iv$iv$iv = 0;
                                                    m$iv$iv$iv = this_$iv$iv$iv.metadata;
                                                    lastIndex$iv$iv$iv = m$iv$iv$iv.length - 2;
                                                    if (i$iv$iv$iv <= lastIndex$iv$iv$iv) {
                                                        while (true) {
                                                            $this$maskEmptyOrDeleted$iv$iv$iv$iv = slot$iv$iv$iv = m$iv$iv$iv[i$iv$iv$iv];
                                                            $i$f$maskEmptyOrDeleted = false;
                                                            if (($this$maskEmptyOrDeleted$iv$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                                                                bitCount$iv$iv$iv = 8 - (~(i$iv$iv$iv - lastIndex$iv$iv$iv) >>> 31);
                                                                for (j$iv$iv$iv = 0; j$iv$iv$iv < bitCount$iv$iv$iv; ++j$iv$iv$iv) {
                                                                    value$iv$iv$iv$iv = slot$iv$iv$iv & 0xFFL;
                                                                    $i$f$isFull = false;
                                                                    if (value$iv$iv$iv$iv < 128L) {
                                                                        index$iv$iv = index$iv$iv$iv = (i$iv$iv$iv << 3) + j$iv$iv$iv;
                                                                        bl2 = false;
                                                                        scope3 = elements$iv$iv[index$iv$iv];
                                                                        bl4 = false;
                                                                        invalidated.add(scope3);
                                                                        hasValues = true;
                                                                    }
                                                                    slot$iv$iv$iv >>= 8;
                                                                }
                                                                if (bitCount$iv$iv$iv != 8) break;
                                                            }
                                                            if (i$iv$iv$iv != lastIndex$iv$iv$iv) {
                                                                ++i$iv$iv$iv;
                                                                continue;
                                                            }
                                                            break;
                                                        }
                                                    }
                                                } else {
                                                    scope3 = value$iv;
                                                    bl4 = false;
                                                    invalidated.add(scope3);
                                                    hasValues = true;
                                                }
                                            }
                                            bl8 = Unit.INSTANCE;
                                        } else {
                                            bl8 = this.statesToReread.add(derivedState);
                                        }
                                    }
                                    boolean bl13 = false;
                                    Object value$iv3 = valueToScopes.get(value2);
                                    if (value$iv3 != null) {
                                        if (value$iv3 instanceof MutableScatterSet) {
                                            this_$iv$iv2 = (ScatterSet)((MutableScatterSet)value$iv3);
                                            $i$f$forEach2 = false;
                                            elements$iv$iv2 = this_$iv$iv2.elements;
                                            this_$iv$iv$iv2 = this_$iv$iv2;
                                            $i$f$forEachIndex2 = false;
                                            i$iv$iv$iv2 = 0;
                                            m$iv$iv$iv2 = this_$iv$iv$iv2.metadata;
                                            lastIndex$iv$iv$iv2 = m$iv$iv$iv2.length - 2;
                                            if (i$iv$iv$iv2 <= lastIndex$iv$iv$iv2) {
                                                while (true) {
                                                    $this$maskEmptyOrDeleted$iv$iv$iv$iv2 = slot$iv$iv$iv2 = m$iv$iv$iv2[i$iv$iv$iv2];
                                                    $i$f$maskEmptyOrDeleted2 = false;
                                                    if (($this$maskEmptyOrDeleted$iv$iv$iv$iv2 & ($this$maskEmptyOrDeleted$iv$iv$iv$iv2 ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                                                        bitCount$iv$iv$iv2 = 8 - (~(i$iv$iv$iv2 - lastIndex$iv$iv$iv2) >>> 31);
                                                        for (j$iv$iv$iv2 = 0; j$iv$iv$iv2 < bitCount$iv$iv$iv2; ++j$iv$iv$iv2) {
                                                            value$iv$iv$iv$iv2 = slot$iv$iv$iv2 & 0xFFL;
                                                            $i$f$isFull2 = false;
                                                            if (value$iv$iv$iv$iv2 < 128L) {
                                                                index$iv$iv2 = index$iv$iv$iv2 = (i$iv$iv$iv2 << 3) + j$iv$iv$iv2;
                                                                bl6 = false;
                                                                scope2 = elements$iv$iv2[index$iv$iv2];
                                                                bl = false;
                                                                invalidated.add(scope2);
                                                                hasValues = true;
                                                            }
                                                            slot$iv$iv$iv2 >>= 8;
                                                        }
                                                        if (bitCount$iv$iv$iv2 != 8) break;
                                                    }
                                                    if (i$iv$iv$iv2 != lastIndex$iv$iv$iv2) {
                                                        ++i$iv$iv$iv2;
                                                        continue;
                                                    }
                                                    break;
                                                }
                                            }
                                        } else {
                                            scope2 = value$iv3;
                                            bl = false;
                                            invalidated.add(scope2);
                                            hasValues = true;
                                        }
                                    }
                                }
                                slot$iv$iv$iv3 >>= 8;
                            }
                            if (bitCount$iv$iv$iv3 != 8) break block91;
                        }
                        if (i$iv$iv$iv3 != lastIndex$iv$iv$iv3) {
                            ++i$iv$iv$iv3;
                            continue;
                        }
                        break block91;
                        break;
                    }
                }
                Iterable $this$forEach$iv$iv = $this$fastForEach$iv;
                $i$f$forEach3 = false;
                elements$iv$iv3 = $this$forEach$iv$iv.iterator();
                block10: while (elements$iv$iv3.hasNext()) {
                    block93: {
                        Boolean bl14;
                        Object value$iv4;
                        block99: {
                            Object element$iv$iv;
                            value2 = element$iv$iv = elements$iv$iv3.next();
                            bl7 = false;
                            if (value2 instanceof StateObjectImpl) {
                                ReaderKind.Companion this_$iv = ReaderKind.Companion;
                                boolean bl15 = false;
                                if (!((StateObjectImpl)value2).isReadIn-h_f27i8$runtime(ReaderKind.constructor-impl(2))) continue;
                            }
                            if (!ScopeMap.contains-impl(dependencyToDerivedStates, value2)) break block93;
                            boolean bl16 = false;
                            value$iv4 = dependencyToDerivedStates.get(value2);
                            if (value$iv4 == null) break block93;
                            if (!(value$iv4 instanceof MutableScatterSet)) break block99;
                            this_$iv$iv2 = (ScatterSet)((MutableScatterSet)value$iv4);
                            $i$f$forEach2 = false;
                            elements$iv$iv2 = this_$iv$iv2.elements;
                            this_$iv$iv$iv2 = this_$iv$iv2;
                            $i$f$forEachIndex2 = false;
                            i$iv$iv$iv2 = 0;
                            m$iv$iv$iv2 = this_$iv$iv$iv2.metadata;
                            lastIndex$iv$iv$iv2 = m$iv$iv$iv2.length - 2;
                            if (i$iv$iv$iv2 > lastIndex$iv$iv$iv2) break block93;
                            while (true) {
                                $this$maskEmptyOrDeleted$iv$iv$iv$iv2 = slot$iv$iv$iv2 = m$iv$iv$iv2[i$iv$iv$iv2];
                                $i$f$maskEmptyOrDeleted2 = false;
                                if (($this$maskEmptyOrDeleted$iv$iv$iv$iv2 & ($this$maskEmptyOrDeleted$iv$iv$iv$iv2 ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                                    bitCount$iv$iv$iv2 = 8 - (~(i$iv$iv$iv2 - lastIndex$iv$iv$iv2) >>> 31);
                                    for (j$iv$iv$iv2 = 0; j$iv$iv$iv2 < bitCount$iv$iv$iv2; ++j$iv$iv$iv2) {
                                        value$iv$iv$iv$iv2 = slot$iv$iv$iv2 & 0xFFL;
                                        $i$f$isFull2 = false;
                                        if (value$iv$iv$iv$iv2 < 128L) {
                                            Boolean bl17;
                                            index$iv$iv2 = index$iv$iv$iv2 = (i$iv$iv$iv2 << 3) + j$iv$iv$iv2;
                                            bl6 = false;
                                            derivedState = (DerivedState)elements$iv$iv2[index$iv$iv2];
                                            bl5 = false;
                                            Intrinsics.checkNotNull((Object)derivedState, (String)"null cannot be cast to non-null type androidx.compose.runtime.DerivedState<kotlin.Any?>");
                                            previousValue = recordedDerivedStateValues.get(derivedState);
                                            SnapshotMutationPolicy snapshotMutationPolicy = derivedState.getPolicy();
                                            if (snapshotMutationPolicy == null) {
                                                snapshotMutationPolicy = SnapshotStateKt.structuralEqualityPolicy();
                                            }
                                            if (!(policy = snapshotMutationPolicy).equivalent(derivedState.getCurrentRecord().getCurrentValue(), previousValue)) {
                                                key$iv = derivedState;
                                                bl3 = false;
                                                value$iv = valueToScopes.get((Object)key$iv);
                                                if (value$iv != null) {
                                                    if (value$iv instanceof MutableScatterSet) {
                                                        this_$iv$iv = (ScatterSet)((MutableScatterSet)value$iv);
                                                        $i$f$forEach = false;
                                                        elements$iv$iv = this_$iv$iv.elements;
                                                        this_$iv$iv$iv = this_$iv$iv;
                                                        $i$f$forEachIndex = false;
                                                        i$iv$iv$iv = 0;
                                                        m$iv$iv$iv = this_$iv$iv$iv.metadata;
                                                        lastIndex$iv$iv$iv = m$iv$iv$iv.length - 2;
                                                        if (i$iv$iv$iv <= lastIndex$iv$iv$iv) {
                                                            while (true) {
                                                                $this$maskEmptyOrDeleted$iv$iv$iv$iv = slot$iv$iv$iv = m$iv$iv$iv[i$iv$iv$iv];
                                                                $i$f$maskEmptyOrDeleted = false;
                                                                if (($this$maskEmptyOrDeleted$iv$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                                                                    bitCount$iv$iv$iv = 8 - (~(i$iv$iv$iv - lastIndex$iv$iv$iv) >>> 31);
                                                                    for (j$iv$iv$iv = 0; j$iv$iv$iv < bitCount$iv$iv$iv; ++j$iv$iv$iv) {
                                                                        value$iv$iv$iv$iv = slot$iv$iv$iv & 0xFFL;
                                                                        $i$f$isFull = false;
                                                                        if (value$iv$iv$iv$iv < 128L) {
                                                                            index$iv$iv = index$iv$iv$iv = (i$iv$iv$iv << 3) + j$iv$iv$iv;
                                                                            bl2 = false;
                                                                            scope3 = elements$iv$iv[index$iv$iv];
                                                                            bl4 = false;
                                                                            invalidated.add(scope3);
                                                                            hasValues = true;
                                                                        }
                                                                        slot$iv$iv$iv >>= 8;
                                                                    }
                                                                    if (bitCount$iv$iv$iv != 8) break;
                                                                }
                                                                if (i$iv$iv$iv != lastIndex$iv$iv$iv) {
                                                                    ++i$iv$iv$iv;
                                                                    continue;
                                                                }
                                                                break;
                                                            }
                                                        }
                                                    } else {
                                                        scope3 = value$iv;
                                                        bl4 = false;
                                                        invalidated.add(scope3);
                                                        hasValues = true;
                                                    }
                                                }
                                                bl17 = Unit.INSTANCE;
                                            } else {
                                                bl17 = this.statesToReread.add(derivedState);
                                            }
                                        }
                                        slot$iv$iv$iv2 >>= 8;
                                    }
                                    if (bitCount$iv$iv$iv2 != 8) break block93;
                                }
                                if (i$iv$iv$iv2 != lastIndex$iv$iv$iv2) {
                                    ++i$iv$iv$iv2;
                                    continue;
                                }
                                break block93;
                                break;
                            }
                        }
                        derivedState = (DerivedState)value$iv4;
                        bl5 = false;
                        previousValue = recordedDerivedStateValues.get(derivedState);
                        SnapshotMutationPolicy<Object> snapshotMutationPolicy = derivedState.getPolicy();
                        if (snapshotMutationPolicy == null) {
                            snapshotMutationPolicy = SnapshotStateKt.structuralEqualityPolicy();
                        }
                        if (!(policy = snapshotMutationPolicy).equivalent(derivedState.getCurrentRecord().getCurrentValue(), previousValue)) {
                            key$iv = derivedState;
                            bl3 = false;
                            value$iv = valueToScopes.get((Object)key$iv);
                            if (value$iv != null) {
                                if (value$iv instanceof MutableScatterSet) {
                                    this_$iv$iv = (ScatterSet)((MutableScatterSet)value$iv);
                                    $i$f$forEach = false;
                                    elements$iv$iv = this_$iv$iv.elements;
                                    this_$iv$iv$iv = this_$iv$iv;
                                    $i$f$forEachIndex = false;
                                    i$iv$iv$iv = 0;
                                    m$iv$iv$iv = this_$iv$iv$iv.metadata;
                                    lastIndex$iv$iv$iv = m$iv$iv$iv.length - 2;
                                    if (i$iv$iv$iv <= lastIndex$iv$iv$iv) {
                                        while (true) {
                                            $this$maskEmptyOrDeleted$iv$iv$iv$iv = slot$iv$iv$iv = m$iv$iv$iv[i$iv$iv$iv];
                                            $i$f$maskEmptyOrDeleted = false;
                                            if (($this$maskEmptyOrDeleted$iv$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                                                bitCount$iv$iv$iv = 8 - (~(i$iv$iv$iv - lastIndex$iv$iv$iv) >>> 31);
                                                for (j$iv$iv$iv = 0; j$iv$iv$iv < bitCount$iv$iv$iv; ++j$iv$iv$iv) {
                                                    value$iv$iv$iv$iv = slot$iv$iv$iv & 0xFFL;
                                                    $i$f$isFull = false;
                                                    if (value$iv$iv$iv$iv < 128L) {
                                                        index$iv$iv = index$iv$iv$iv = (i$iv$iv$iv << 3) + j$iv$iv$iv;
                                                        bl2 = false;
                                                        scope3 = elements$iv$iv[index$iv$iv];
                                                        bl4 = false;
                                                        invalidated.add(scope3);
                                                        hasValues = true;
                                                    }
                                                    slot$iv$iv$iv >>= 8;
                                                }
                                                if (bitCount$iv$iv$iv != 8) break;
                                            }
                                            if (i$iv$iv$iv != lastIndex$iv$iv$iv) {
                                                ++i$iv$iv$iv;
                                                continue;
                                            }
                                            break;
                                        }
                                    }
                                } else {
                                    scope3 = value$iv;
                                    bl4 = false;
                                    invalidated.add(scope3);
                                    hasValues = true;
                                }
                            }
                            bl14 = Unit.INSTANCE;
                        } else {
                            bl14 = this.statesToReread.add(derivedState);
                        }
                    }
                    boolean bl18 = false;
                    Object value$iv5 = valueToScopes.get(value2);
                    if (value$iv5 == null) continue;
                    if (value$iv5 instanceof MutableScatterSet) {
                        this_$iv$iv2 = (ScatterSet)((MutableScatterSet)value$iv5);
                        $i$f$forEach2 = false;
                        elements$iv$iv2 = this_$iv$iv2.elements;
                        this_$iv$iv$iv2 = this_$iv$iv2;
                        $i$f$forEachIndex2 = false;
                        i$iv$iv$iv2 = 0;
                        m$iv$iv$iv2 = this_$iv$iv$iv2.metadata;
                        lastIndex$iv$iv$iv2 = m$iv$iv$iv2.length - 2;
                        if (i$iv$iv$iv2 > lastIndex$iv$iv$iv2) continue;
                        while (true) {
                            $this$maskEmptyOrDeleted$iv$iv$iv$iv2 = slot$iv$iv$iv2 = m$iv$iv$iv2[i$iv$iv$iv2];
                            $i$f$maskEmptyOrDeleted2 = false;
                            if (($this$maskEmptyOrDeleted$iv$iv$iv$iv2 & ($this$maskEmptyOrDeleted$iv$iv$iv$iv2 ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                                bitCount$iv$iv$iv2 = 8 - (~(i$iv$iv$iv2 - lastIndex$iv$iv$iv2) >>> 31);
                                for (j$iv$iv$iv2 = 0; j$iv$iv$iv2 < bitCount$iv$iv$iv2; ++j$iv$iv$iv2) {
                                    value$iv$iv$iv$iv2 = slot$iv$iv$iv2 & 0xFFL;
                                    $i$f$isFull2 = false;
                                    if (value$iv$iv$iv$iv2 < 128L) {
                                        index$iv$iv2 = index$iv$iv$iv2 = (i$iv$iv$iv2 << 3) + j$iv$iv$iv2;
                                        bl6 = false;
                                        scope2 = elements$iv$iv2[index$iv$iv2];
                                        bl = false;
                                        invalidated.add(scope2);
                                        hasValues = true;
                                    }
                                    slot$iv$iv$iv2 >>= 8;
                                }
                                if (bitCount$iv$iv$iv2 != 8) continue block10;
                            }
                            if (i$iv$iv$iv2 == lastIndex$iv$iv$iv2) continue block10;
                            ++i$iv$iv$iv2;
                        }
                    }
                    scope2 = value$iv5;
                    bl = false;
                    invalidated.add(scope2);
                    hasValues = true;
                }
            }
            MutableVector<DerivedState<?>> this_$iv = this.statesToReread;
            boolean $i$f$isNotEmpty = false;
            if (this_$iv.getSize() != 0) {
                this_$iv = this.statesToReread;
                boolean $i$f$forEach = false;
                T[] content$iv = this_$iv.content;
                int size$iv = this_$iv.getSize();
                for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                    DerivedState it = (DerivedState)content$iv[i$iv];
                    boolean bl = false;
                    this.rereadDerivedState(it);
                }
                this.statesToReread.clear();
            }
            return hasValues;
        }

        /*
         * WARNING - void declaration
         */
        public final void rereadDerivedState(@NotNull DerivedState<?> derivedState) {
            Intrinsics.checkNotNullParameter(derivedState, (String)"derivedState");
            MutableScatterMap<Object, MutableObjectIntMap<Object>> scopeToValues = this.scopeToValues;
            int token2 = Long.hashCode(SnapshotKt.currentSnapshot().getSnapshotId());
            MutableScatterMap<Object, Object> arg0$iv = this.valueToScopes;
            boolean bl = false;
            Object value$iv = arg0$iv.get(derivedState);
            if (value$iv != null) {
                if (value$iv instanceof MutableScatterSet) {
                    ScatterSet this_$iv$iv = (ScatterSet)((MutableScatterSet)value$iv);
                    boolean $i$f$forEach = false;
                    Object[] elements$iv$iv = this_$iv$iv.elements;
                    ScatterSet this_$iv$iv$iv = this_$iv$iv;
                    boolean $i$f$forEachIndex = false;
                    int i$iv$iv$iv = 0;
                    long[] m$iv$iv$iv = this_$iv$iv$iv.metadata;
                    int lastIndex$iv$iv$iv = m$iv$iv$iv.length - 2;
                    if (i$iv$iv$iv <= lastIndex$iv$iv$iv) {
                        while (true) {
                            long slot$iv$iv$iv;
                            long $this$maskEmptyOrDeleted$iv$iv$iv$iv = slot$iv$iv$iv = m$iv$iv$iv[i$iv$iv$iv];
                            boolean $i$f$maskEmptyOrDeleted = false;
                            if (($this$maskEmptyOrDeleted$iv$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                                int bitCount$iv$iv$iv = 8 - (~(i$iv$iv$iv - lastIndex$iv$iv$iv) >>> 31);
                                for (int j$iv$iv$iv = 0; j$iv$iv$iv < bitCount$iv$iv$iv; ++j$iv$iv$iv) {
                                    long value$iv$iv$iv$iv = slot$iv$iv$iv & 0xFFL;
                                    boolean $i$f$isFull = false;
                                    if (value$iv$iv$iv$iv < 128L) {
                                        int index$iv$iv$iv;
                                        int index$iv$iv = index$iv$iv$iv = (i$iv$iv$iv << 3) + j$iv$iv$iv;
                                        boolean bl2 = false;
                                        Object scope2 = elements$iv$iv[index$iv$iv];
                                        boolean bl3 = false;
                                        ObservedScopeMap observedScopeMap = this;
                                        DerivedState<?> derivedState2 = derivedState;
                                        int n = token2;
                                        Object object = scope2;
                                        MutableObjectIntMap mutableObjectIntMap = (MutableObjectIntMap)scopeToValues.get(scope2);
                                        if (mutableObjectIntMap == null) {
                                            void it;
                                            MutableObjectIntMap mutableObjectIntMap2;
                                            MutableObjectIntMap mutableObjectIntMap3 = mutableObjectIntMap2 = new MutableObjectIntMap(0, 1, null);
                                            Object object2 = object;
                                            int n2 = n;
                                            DerivedState<?> derivedState3 = derivedState2;
                                            ObservedScopeMap observedScopeMap2 = observedScopeMap;
                                            boolean bl4 = false;
                                            scopeToValues.set(scope2, (Object)it);
                                            Unit unit = Unit.INSTANCE;
                                            observedScopeMap = observedScopeMap2;
                                            derivedState2 = derivedState3;
                                            n = n2;
                                            object = object2;
                                            mutableObjectIntMap = mutableObjectIntMap2;
                                        }
                                        observedScopeMap.recordRead(derivedState2, n, object, (MutableObjectIntMap<Object>)mutableObjectIntMap);
                                    }
                                    slot$iv$iv$iv >>= 8;
                                }
                                if (bitCount$iv$iv$iv != 8) break;
                            }
                            if (i$iv$iv$iv != lastIndex$iv$iv$iv) {
                                ++i$iv$iv$iv;
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    Object scope3 = value$iv;
                    boolean bl5 = false;
                    ObservedScopeMap observedScopeMap = this;
                    DerivedState<?> derivedState4 = derivedState;
                    int n = token2;
                    Object object = scope3;
                    MutableObjectIntMap mutableObjectIntMap = (MutableObjectIntMap)scopeToValues.get(scope3);
                    if (mutableObjectIntMap == null) {
                        MutableObjectIntMap mutableObjectIntMap4;
                        MutableObjectIntMap it = mutableObjectIntMap4 = new MutableObjectIntMap(0, 1, null);
                        Object object3 = object;
                        int n3 = n;
                        DerivedState<?> derivedState5 = derivedState4;
                        ObservedScopeMap observedScopeMap3 = observedScopeMap;
                        boolean bl6 = false;
                        scopeToValues.set(scope3, (Object)it);
                        Unit unit = Unit.INSTANCE;
                        observedScopeMap = observedScopeMap3;
                        derivedState4 = derivedState5;
                        n = n3;
                        object = object3;
                        mutableObjectIntMap = mutableObjectIntMap4;
                    }
                    observedScopeMap.recordRead(derivedState4, n, object, (MutableObjectIntMap<Object>)mutableObjectIntMap);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void notifyInvalidatedScopes() {
            void this_$iv;
            MutableScatterSet<Object> invalidated = this.invalidated;
            ScatterSet scatterSet = (ScatterSet)invalidated;
            Function1<Object, Unit> block$iv = this.onChanged;
            boolean $i$f$forEach = false;
            Object[] elements$iv = this_$iv.elements;
            void this_$iv$iv = this_$iv;
            boolean $i$f$forEachIndex = false;
            int i$iv$iv = 0;
            long[] m$iv$iv = this_$iv$iv.metadata;
            int lastIndex$iv$iv = m$iv$iv.length - 2;
            if (i$iv$iv <= lastIndex$iv$iv) {
                while (true) {
                    long slot$iv$iv;
                    long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                    boolean $i$f$maskEmptyOrDeleted = false;
                    if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                        int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                        for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                            long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                            boolean $i$f$isFull = false;
                            if (value$iv$iv$iv < 128L) {
                                int index$iv$iv;
                                int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                                boolean bl = false;
                                block$iv.invoke(elements$iv[index$iv]);
                            }
                            slot$iv$iv >>= 8;
                        }
                        if (bitCount$iv$iv != 8) break;
                    }
                    if (i$iv$iv == lastIndex$iv$iv) break;
                    ++i$iv$iv;
                }
            }
            invalidated.clear();
        }

        public static final /* synthetic */ int access$getDeriveStateScopeCount$p(ObservedScopeMap $this) {
            return $this.deriveStateScopeCount;
        }

        public static final /* synthetic */ void access$setDeriveStateScopeCount$p(ObservedScopeMap $this, int n) {
            $this.deriveStateScopeCount = n;
        }
    }
}

