/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.internal;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSnapshotThreadLocal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotThreadLocal.kt\nandroidx/compose/runtime/internal/ThreadMap\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,154:1\n12727#2,3:155\n*S KotlinDebug\n*F\n+ 1 SnapshotThreadLocal.kt\nandroidx/compose/runtime/internal/ThreadMap\n*L\n84#1:155,3\n*E\n"})
public final class ThreadMap {
    private final int size;
    @NotNull
    private final long[] keys;
    @NotNull
    private final Object[] values;
    public static final int $stable = 8;

    public ThreadMap(int size, @NotNull long[] keys, @NotNull Object[] values) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.size = size;
        this.keys = keys;
        this.values = values;
    }

    @Nullable
    public final Object get(long key) {
        int index = this.find(key);
        return index >= 0 ? this.values[index] : null;
    }

    public final boolean trySet(long key, @Nullable Object value2) {
        int index = this.find(key);
        if (index < 0) {
            return false;
        }
        this.values[index] = value2;
        return true;
    }

    @NotNull
    public final ThreadMap newWith(long key, @Nullable Object value2) {
        int size = this.size;
        Object[] $this$count$iv = this.values;
        boolean $i$f$count = false;
        int count$iv = 0;
        int n = $this$count$iv.length;
        for (int j = 0; j < n; ++j) {
            Object element$iv;
            Object it = element$iv = $this$count$iv[j];
            boolean bl = false;
            if (!(it != null)) continue;
            ++count$iv;
        }
        int newSize = count$iv + 1;
        long[] newKeys = new long[newSize];
        Object[] newValues = new Object[newSize];
        if (newSize > 1) {
            Object oldValue;
            int source;
            int dest = 0;
            for (source = 0; dest < newSize && source < size; ++source) {
                long oldKey = this.keys[source];
                oldValue = this.values[source];
                if (oldKey > key) {
                    newKeys[dest] = key;
                    newValues[dest] = value2;
                    ++dest;
                    break;
                }
                if (oldValue == null) continue;
                newKeys[dest] = oldKey;
                newValues[dest] = oldValue;
                ++dest;
            }
            if (source == size) {
                newKeys[newSize - 1] = key;
                newValues[newSize - 1] = value2;
            } else {
                while (dest < newSize) {
                    long oldKey = this.keys[source];
                    oldValue = this.values[source];
                    if (oldValue != null) {
                        newKeys[dest] = oldKey;
                        newValues[dest] = oldValue;
                        ++dest;
                    }
                    ++source;
                }
            }
        } else {
            newKeys[0] = key;
            newValues[0] = value2;
        }
        return new ThreadMap(newSize, newKeys, newValues);
    }

    private final int find(long key) {
        int high = this.size - 1;
        switch (high) {
            case -1: {
                return -1;
            }
            case 0: {
                return this.keys[0] == key ? 0 : (this.keys[0] > key ? -2 : -1);
            }
        }
        int low = 0;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this.keys[mid];
            long comparison = midVal - key;
            if (comparison < 0L) {
                low = mid + 1;
                continue;
            }
            if (comparison > 0L) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

