/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList;

import androidx.compose.runtime.external.kotlinx.collections.immutable.PersistentList;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.AbstractPersistentList;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.BufferIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.PersistentVector;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import androidx.compose.runtime.external.kotlinx.collections.immutable.internal.CommonFunctionsKt;
import androidx.compose.runtime.external.kotlinx.collections.immutable.internal.ListImplementation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nSmallPersistentVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmallPersistentVector.kt\nandroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector\n+ 2 extensions.kt\nandroidx/compose/runtime/external/kotlinx/collections/immutable/ExtensionsKt\n*L\n1#1,161:1\n41#2:162\n41#2:163\n*S KotlinDebug\n*F\n+ 1 SmallPersistentVector.kt\nandroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector\n*L\n48#1:162\n91#1:163\n*E\n"})
public final class SmallPersistentVector<E>
extends AbstractPersistentList<E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object[] buffer;
    public static final int $stable = 8;
    @NotNull
    private static final SmallPersistentVector EMPTY = new SmallPersistentVector(new Object[0]);

    public SmallPersistentVector(@NotNull Object[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        CommonFunctionsKt.assert(this.buffer.length <= 32);
    }

    public int getSize() {
        return this.buffer.length;
    }

    private final Object[] bufferOfSize(int size) {
        return new Object[size];
    }

    @Override
    @NotNull
    public PersistentList<E> add(E element) {
        if (this.size() < 32) {
            Object[] objectArray = Arrays.copyOf(this.buffer, this.size() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newBuffer = objectArray;
            newBuffer[this.size()] = element;
            return new SmallPersistentVector<E>(newBuffer);
        }
        Object[] tail = UtilsKt.presizedBufferWith(element);
        return new PersistentVector(this.buffer, tail, this.size() + 1, 0);
    }

    @Override
    @NotNull
    public PersistentList<E> addAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (this.size() + elements.size() <= 32) {
            Object[] objectArray = Arrays.copyOf(this.buffer, this.size() + elements.size());
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newBuffer = objectArray;
            int index = this.size();
            for (E element : elements) {
                newBuffer[index++] = element;
            }
            return new SmallPersistentVector<E>(newBuffer);
        }
        PersistentList $this$mutate$iv = this;
        boolean $i$f$mutate = false;
        PersistentList.Builder builder = $this$mutate$iv.builder();
        List it = builder;
        boolean bl = false;
        it.addAll(elements);
        return builder.build();
    }

    @Override
    @NotNull
    public PersistentList<E> removeAll(@NotNull Function1<? super E, Boolean> predicate) {
        PersistentList persistentList;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Object[] newBuffer = this.buffer;
        int newSize = this.size();
        boolean anyRemoved = false;
        int n = this.size();
        for (int index = 0; index < n; ++index) {
            Object element = this.buffer[index];
            if (((Boolean)predicate.invoke(element)).booleanValue()) {
                if (anyRemoved) continue;
                Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf(this.buffer, this.buffer.length), (String)"copyOf(...)");
                newSize = index;
                anyRemoved = true;
                continue;
            }
            if (!anyRemoved) continue;
            newBuffer[newSize++] = element;
        }
        int n2 = newSize;
        if (n2 == this.size()) {
            persistentList = this;
        } else if (n2 == 0) {
            persistentList = EMPTY;
        } else {
            Object[] objectArray = newBuffer;
            int n3 = 0;
            persistentList = new SmallPersistentVector<E>(ArraysKt.copyOfRange((Object[])objectArray, (int)n3, (int)newSize));
        }
        return persistentList;
    }

    @Override
    @NotNull
    public PersistentList<E> add(int index, E element) {
        ListImplementation.checkPositionIndex$runtime(index, this.size());
        if (index == this.size()) {
            return this.add(element);
        }
        if (this.size() < 32) {
            Object[] newBuffer = this.bufferOfSize(this.size() + 1);
            ArraysKt.copyInto$default((Object[])this.buffer, (Object[])newBuffer, (int)0, (int)0, (int)index, (int)6, null);
            ArraysKt.copyInto((Object[])this.buffer, (Object[])newBuffer, (int)(index + 1), (int)index, (int)this.size());
            newBuffer[index] = element;
            return new SmallPersistentVector<E>(newBuffer);
        }
        Object[] objectArray = Arrays.copyOf(this.buffer, this.buffer.length);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] root = objectArray;
        ArraysKt.copyInto((Object[])this.buffer, (Object[])root, (int)(index + 1), (int)index, (int)(this.size() - 1));
        root[index] = element;
        Object[] tail = UtilsKt.presizedBufferWith(this.buffer[31]);
        return new PersistentVector(root, tail, this.size() + 1, 0);
    }

    @Override
    @NotNull
    public PersistentList<E> removeAt(int index) {
        ListImplementation.checkElementIndex$runtime(index, this.size());
        if (this.size() == 1) {
            return EMPTY;
        }
        Object[] objectArray = Arrays.copyOf(this.buffer, this.size() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newBuffer = objectArray;
        ArraysKt.copyInto((Object[])this.buffer, (Object[])newBuffer, (int)index, (int)(index + 1), (int)this.size());
        return new SmallPersistentVector<E>(newBuffer);
    }

    @Override
    @NotNull
    public PersistentList.Builder<E> builder() {
        return new PersistentVectorBuilder(this, null, this.buffer, 0);
    }

    @Override
    public int indexOf(Object element) {
        return ArraysKt.indexOf((Object[])this.buffer, (Object)element);
    }

    @Override
    public int lastIndexOf(Object element) {
        return ArraysKt.lastIndexOf((Object[])this.buffer, (Object)element);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        ListImplementation.checkPositionIndex$runtime(index, this.size());
        return new BufferIterator<Object>(this.buffer, index, this.size());
    }

    @Override
    public E get(int index) {
        ListImplementation.checkElementIndex$runtime(index, this.size());
        return (E)this.buffer[index];
    }

    @Override
    @NotNull
    public PersistentList<E> set(int index, E element) {
        ListImplementation.checkElementIndex$runtime(index, this.size());
        Object[] objectArray = Arrays.copyOf(this.buffer, this.buffer.length);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newBuffer = objectArray;
        newBuffer[index] = element;
        return new SmallPersistentVector<E>(newBuffer);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SmallPersistentVector getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

