/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nMutableVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n*L\n1#1,1110:1\n1083#1,2:1111\n*S KotlinDebug\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n*L\n1101#1:1111,2\n*E\n"})
public final class MutableVectorKt {
    public static final void checkIndex(@NotNull List<?> $this$checkIndex, int index) {
        Intrinsics.checkNotNullParameter($this$checkIndex, (String)"<this>");
        int size = $this$checkIndex.size();
        if (index < 0 || index >= size) {
            MutableVectorKt.throwListIndexOutOfBoundsException(index, size);
        }
    }

    private static final void throwListIndexOutOfBoundsException(int index, int size) {
        throw new IndexOutOfBoundsException("Index " + index + " is out of bounds. The list has " + size + " elements.");
    }

    public static final void checkSubIndex(@NotNull List<?> $this$checkSubIndex, int fromIndex, int toIndex) {
        Intrinsics.checkNotNullParameter($this$checkSubIndex, (String)"<this>");
        if (fromIndex > toIndex) {
            MutableVectorKt.throwReversedIndicesException(fromIndex, toIndex);
        }
        if (fromIndex < 0) {
            MutableVectorKt.throwNegativeIndexException(fromIndex);
        }
        if (toIndex > $this$checkSubIndex.size()) {
            MutableVectorKt.throwOutOfRangeException(toIndex, $this$checkSubIndex.size());
        }
    }

    private static final void throwOutOfRangeException(int toIndex, int size) {
        throw new IndexOutOfBoundsException("toIndex (" + toIndex + ") is more than than the list size (" + size + ")");
    }

    private static final void throwNegativeIndexException(int fromIndex) {
        throw new IndexOutOfBoundsException("fromIndex (" + fromIndex + ") is less than 0.");
    }

    private static final void throwReversedIndicesException(int fromIndex, int toIndex) {
        throw new IllegalArgumentException("Indices are out of order. fromIndex (" + fromIndex + ") is greater than toIndex (" + toIndex + ").");
    }
}

