/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.GroupSourceInformation;
import androidx.compose.runtime.RelativeGroupPath;
import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.SlotTableGroup;
import androidx.compose.runtime.SourceInformationGroupPath;
import androidx.compose.runtime.SourceInformationSlotTableGroup;
import androidx.compose.runtime.tooling.CompositionGroup;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.KotlinNothingValueException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SourceInformationGroupIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,3963:1\n1#2:3964\n*E\n"})
final class SourceInformationGroupIterator
implements Iterator<CompositionGroup>,
KMappedMarker {
    @NotNull
    private final SlotTable table;
    private final int parent;
    @NotNull
    private final GroupSourceInformation group;
    @NotNull
    private final SourceInformationGroupPath path;
    private final int version;
    private int index;

    public SourceInformationGroupIterator(@NotNull SlotTable table, int parent, @NotNull GroupSourceInformation group, @NotNull SourceInformationGroupPath path2) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.table = table;
        this.parent = parent;
        this.group = group;
        this.path = path2;
        this.version = this.table.getVersion$runtime();
    }

    @Override
    public boolean hasNext() {
        boolean bl;
        ArrayList<Object> arrayList = this.group.getGroups();
        if (arrayList != null) {
            ArrayList<Object> it = arrayList;
            boolean bl2 = false;
            bl = this.index < it.size();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public CompositionGroup next() {
        CompositionGroup compositionGroup;
        Object group;
        Object object;
        ArrayList<Object> arrayList = this.group.getGroups();
        if (arrayList != null) {
            int n = this.index;
            this.index = n + 1;
            object = arrayList.get(n);
        } else {
            object = group = null;
        }
        if (group instanceof Anchor) {
            compositionGroup = new SlotTableGroup(this.table, ((Anchor)group).getLocation$runtime(), this.version);
        } else if (group instanceof GroupSourceInformation) {
            compositionGroup = new SourceInformationSlotTableGroup(this.table, this.parent, (GroupSourceInformation)group, new RelativeGroupPath(this.path, this.index - 1));
        } else {
            ComposerKt.composeRuntimeError("Unexpected group information structure");
            throw new KotlinNothingValueException();
        }
        return compositionGroup;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

