/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.collection.MutableIntObjectMap;
import androidx.collection.MutableIntSet;
import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.GroupIterator;
import androidx.compose.runtime.GroupSourceInformation;
import androidx.compose.runtime.PreconditionsKt;
import androidx.compose.runtime.SlotReader;
import androidx.compose.runtime.SlotTableKt;
import androidx.compose.runtime.SlotWriter;
import androidx.compose.runtime.SynchronizedObject;
import androidx.compose.runtime.tooling.CompositionData;
import androidx.compose.runtime.tooling.CompositionGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotTable\n+ 2 Synchronization.desktop.kt\nandroidx/compose/runtime/platform/Synchronization_desktopKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 5 Preconditions.kt\nandroidx/compose/runtime/PreconditionsKt\n+ 6 SlotTable.kt\nandroidx/compose/runtime/SlotTableKt\n+ 7 ListUtils.kt\nandroidx/compose/runtime/snapshots/ListUtilsKt\n*L\n1#1,3963:1\n158#1,7:4021\n174#1,4:4028\n179#1,3:4038\n21#2,5:3964\n26#2:4016\n1#3:3969\n1#3:4037\n4644#4,4:3970\n4644#4,4:3974\n4644#4,4:3978\n4644#4,4:3992\n4644#4,4:3996\n4644#4,4:4004\n4644#4,4:4008\n4644#4,4:4012\n34#5,4:3982\n34#5,4:4000\n34#5,4:4017\n49#5,4:4043\n49#5,4:4047\n34#5,4:4054\n34#5,4:4058\n34#5,4:4063\n34#5,4:4067\n49#5,4:4083\n49#5,4:4087\n49#5,4:4091\n49#5,4:4097\n49#5,4:4101\n49#5,4:4105\n49#5,4:4112\n49#5,4:4118\n49#5,4:4123\n49#5,4:4127\n49#5,4:4133\n34#5,4:4140\n34#5,4:4144\n3825#6,6:3986\n3698#6:4041\n3746#6:4042\n3726#6:4071\n3732#6:4072\n3689#6:4073\n3698#6:4074\n3672#6:4075\n3666#6:4076\n3669#6:4077\n3681#6:4078\n3777#6:4079\n3777#6:4080\n3777#6:4081\n3746#6:4082\n3777#6:4095\n3777#6:4096\n3666#6:4109\n3672#6:4110\n3681#6:4111\n3666#6:4116\n3669#6:4117\n3732#6:4122\n3708#6:4131\n3698#6:4132\n3777#6:4149\n34#7,5:4032\n34#7,3:4051\n38#7:4062\n34#7,3:4137\n38#7:4148\n*S KotlinDebug\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotTable\n*L\n346#1:4021,7\n382#1:4028,4\n382#1:4038,3\n123#1:3964,5\n268#1:4016\n382#1:4037\n202#1:3970,4\n203#1:3974,4\n219#1:3978,4\n226#1:3992,4\n237#1:3996,4\n254#1:4004,4\n255#1:4008,4\n265#1:4012,4\n220#1:3982,4\n238#1:4000,4\n294#1:4017,4\n493#1:4043,4\n500#1:4047,4\n509#1:4054,4\n512#1:4058,4\n533#1:4063,4\n534#1:4067,4\n434#1:4083,4\n439#1:4087,4\n442#1:4091,4\n448#1:4097,4\n451#1:4101,4\n453#1:4105,4\n458#1:4112,4\n462#1:4118,4\n471#1:4123,4\n476#1:4127,4\n481#1:4133,4\n521#1:4140,4\n522#1:4144,4\n221#1:3986,6\n399#1:4041\n418#1:4042\n588#1:4071\n593#1:4072\n596#1:4073\n599#1:4074\n605#1:4075\n612#1:4076\n613#1:4077\n615#1:4078\n660#1:4079\n661#1:4080\n667#1:4081\n433#1:4082\n446#1:4095\n447#1:4096\n455#1:4109\n456#1:4110\n457#1:4111\n461#1:4116\n462#1:4117\n469#1:4122\n480#1:4131\n481#1:4132\n589#1:4149\n384#1:4032,5\n507#1:4051,3\n507#1:4062\n518#1:4137,3\n518#1:4148\n*E\n"})
public final class SlotTable
implements CompositionData,
Iterable<CompositionGroup>,
KMappedMarker {
    @NotNull
    private int[] groups = new int[0];
    private int groupsSize;
    @NotNull
    private Object[] slots;
    private int slotsSize;
    private int readers;
    @NotNull
    private final SynchronizedObject lock;
    private boolean writer;
    private int version;
    @NotNull
    private ArrayList<Anchor> anchors;
    @Nullable
    private HashMap<Anchor, GroupSourceInformation> sourceInformationMap;
    @Nullable
    private MutableIntObjectMap<MutableIntSet> calledByMap;
    public static final int $stable = 8;

    public SlotTable() {
        int n = 0;
        Object[] objectArray = new Object[]{};
        SlotTable slotTable = this;
        while (n < 0) {
            int n2 = n++;
            objectArray[n2] = null;
        }
        slotTable.slots = objectArray;
        Object ref$iv = null;
        boolean $i$f$makeSynchronizedObject = false;
        this.lock = new SynchronizedObject();
        this.anchors = new ArrayList();
    }

    @NotNull
    public final int[] getGroups() {
        return this.groups;
    }

    public final int getGroupsSize() {
        return this.groupsSize;
    }

    @NotNull
    public final Object[] getSlots() {
        return this.slots;
    }

    public final int getSlotsSize() {
        return this.slotsSize;
    }

    public final boolean getWriter$runtime() {
        return this.writer;
    }

    public final int getVersion$runtime() {
        return this.version;
    }

    @NotNull
    public final ArrayList<Anchor> getAnchors$runtime() {
        return this.anchors;
    }

    @Nullable
    public final HashMap<Anchor, GroupSourceInformation> getSourceInformationMap$runtime() {
        return this.sourceInformationMap;
    }

    @Nullable
    public final MutableIntObjectMap<MutableIntSet> getCalledByMap$runtime() {
        return this.calledByMap;
    }

    public boolean isEmpty() {
        return this.groupsSize == 0;
    }

    @NotNull
    public final SlotReader openReader() {
        if (this.writer) {
            throw new IllegalStateException("Cannot read while a writer is pending".toString());
        }
        int n = this.readers;
        this.readers = n + 1;
        return new SlotReader(this);
    }

    @NotNull
    public final SlotWriter openWriter() {
        boolean value$iv = !this.writer;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Cannot start a writer when another writer is pending");
        }
        value$iv = this.readers <= 0;
        $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Cannot start a writer when a reader is pending");
        }
        this.writer = true;
        int n = this.version;
        this.version = n + 1;
        return new SlotWriter(this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Anchor anchor(int index) {
        Anchor anchor;
        void $this$getOrAdd$iv;
        boolean value$iv = !this.writer;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("use active SlotWriter to create an anchor location instead");
        }
        value$iv = 0 <= index ? index < this.groupsSize : false;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalArgumentException("Parameter index is out of range");
        }
        ArrayList<Anchor> value$iv2 = this.anchors;
        int effectiveSize$iv = this.groupsSize;
        boolean $i$f$getOrAdd = false;
        int location$iv = SlotTableKt.access$search((ArrayList)$this$getOrAdd$iv, index, effectiveSize$iv);
        if (location$iv < 0) {
            boolean bl = false;
            Anchor anchor$iv = new Anchor(index);
            $this$getOrAdd$iv.add(-(location$iv + 1), anchor$iv);
            anchor = anchor$iv;
        } else {
            Object e = $this$getOrAdd$iv.get(location$iv);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            anchor = (Anchor)e;
        }
        return anchor;
    }

    private final Anchor tryAnchor(int index) {
        boolean value$iv = !this.writer;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("use active SlotWriter to crate an anchor for location instead");
        }
        return (0 <= index ? index < this.groupsSize : false) ? SlotTableKt.access$find(this.anchors, index, this.groupsSize) : null;
    }

    public final int anchorIndex(@NotNull Anchor anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        boolean value$iv = !this.writer;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Use active SlotWriter to determine anchor location instead");
        }
        value$iv = anchor.getValid();
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalArgumentException("Anchor refers to a group that was removed");
        }
        return anchor.getLocation$runtime();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean ownsAnchor(@NotNull Anchor anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        if (!anchor.getValid()) return false;
        int it = SlotTableKt.access$search(this.anchors, anchor.getLocation$runtime(), this.groupsSize);
        boolean bl = false;
        if (it < 0) return false;
        if (!Intrinsics.areEqual((Object)this.anchors.get(it), (Object)anchor)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean groupContainsAnchor(int groupIndex, @NotNull Anchor anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        boolean value$iv = !this.writer;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Writer is active");
        }
        value$iv = 0 <= groupIndex ? groupIndex < this.groupsSize : false;
        $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Invalid group index");
        }
        if (!this.ownsAnchor(anchor)) return false;
        int n = groupIndex + SlotTableKt.access$groupSize(this.groups, groupIndex);
        int n2 = anchor.getLocation$runtime();
        if (groupIndex > n2) return false;
        if (n2 >= n) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close$runtime(@NotNull SlotReader reader2, @Nullable HashMap<Anchor, GroupSourceInformation> sourceInformationMap) {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        int value$iv = reader2.getTable$runtime() == this && this.readers > 0 ? 1 : 0;
        boolean $i$f$runtimeCheck = false;
        if (value$iv == 0) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Unexpected reader close()");
        }
        value$iv = this.readers;
        this.readers = value$iv + -1;
        if (sourceInformationMap != null) {
            SynchronizedObject lock$iv = this.lock;
            boolean $i$f$synchronized = false;
            SynchronizedObject synchronizedObject = lock$iv;
            synchronized (synchronizedObject) {
                boolean bl = false;
                HashMap<Anchor, GroupSourceInformation> thisMap = this.sourceInformationMap;
                if (thisMap != null) {
                    thisMap.putAll((Map<Anchor, GroupSourceInformation>)sourceInformationMap);
                } else {
                    this.sourceInformationMap = sourceInformationMap;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final void close$runtime(@NotNull SlotWriter writer2, @NotNull int[] groups, int groupsSize, @NotNull Object[] slots, int slotsSize, @NotNull ArrayList<Anchor> anchors, @Nullable HashMap<Anchor, GroupSourceInformation> sourceInformationMap, @Nullable MutableIntObjectMap<MutableIntSet> calledByMap) {
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)groups, (String)"groups");
        Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
        Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
        boolean value$iv = writer2.getTable$runtime() == this && this.writer;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalArgumentException("Unexpected writer close()");
        }
        this.writer = false;
        this.setTo$runtime(groups, groupsSize, slots, slotsSize, anchors, sourceInformationMap, calledByMap);
    }

    public final void setTo$runtime(@NotNull int[] groups, int groupsSize, @NotNull Object[] slots, int slotsSize, @NotNull ArrayList<Anchor> anchors, @Nullable HashMap<Anchor, GroupSourceInformation> sourceInformationMap, @Nullable MutableIntObjectMap<MutableIntSet> calledByMap) {
        Intrinsics.checkNotNullParameter((Object)groups, (String)"groups");
        Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
        Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
        this.groups = groups;
        this.groupsSize = groupsSize;
        this.slots = slots;
        this.slotsSize = slotsSize;
        this.anchors = anchors;
        this.sourceInformationMap = sourceInformationMap;
        this.calledByMap = calledByMap;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containsMark() {
        void $this$containsMark$iv;
        if (this.groupsSize <= 0) return false;
        int[] nArray = this.groups;
        int address$iv = 0;
        boolean $i$f$containsMark = false;
        if (($this$containsMark$iv[address$iv * 5 + 1] & 0x4000000) == 0) return false;
        return true;
    }

    @Nullable
    public final GroupSourceInformation sourceInformationOf(int group) {
        GroupSourceInformation groupSourceInformation;
        HashMap<Anchor, GroupSourceInformation> hashMap = this.sourceInformationMap;
        if (hashMap != null) {
            HashMap<Anchor, GroupSourceInformation> map2 = hashMap;
            boolean bl = false;
            Anchor anchor = this.tryAnchor(group);
            if (anchor != null) {
                Anchor anchor2 = anchor;
                boolean bl2 = false;
                groupSourceInformation = map2.get(anchor2);
            } else {
                groupSourceInformation = null;
            }
        } else {
            groupSourceInformation = null;
        }
        return groupSourceInformation;
    }

    public final void collectCalledByInformation() {
        this.calledByMap = new MutableIntObjectMap(0, 1, null);
    }

    public final void collectSourceInformation() {
        this.sourceInformationMap = new HashMap();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object slot$runtime(int group, int slotIndex) {
        int n;
        int start2 = SlotTableKt.access$slotAnchor(this.groups, group);
        if (group + 1 < this.groupsSize) {
            void $this$dataAnchor$iv;
            int[] nArray = this.groups;
            int address$iv = group + 1;
            boolean $i$f$dataAnchor = false;
            n = $this$dataAnchor$iv[address$iv * 5 + 4];
        } else {
            n = this.slots.length;
        }
        int end = n;
        int len = end - start2;
        boolean bl = 0 <= slotIndex ? slotIndex < len : false;
        if (bl) {
            return this.slots[start2 + slotIndex];
        }
        return Composer.Companion.getEmpty();
    }

    @Override
    @NotNull
    public Iterator<CompositionGroup> iterator() {
        return new GroupIterator(this, 0, this.groupsSize);
    }
}

